/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.item;

import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.weather_classic.WeatherClassic;
import net.weather_classic.global.tools.TornadoDestructionInfo;
import net.weather_classic.help.BP;
import net.weather_classic.help.Utils;
import net.weather_classic.item.WindCore;
import net.weather_classic.registry.WCEntities;
import net.weather_classic.registry.WCItems;
import net.weather_classic.storm.debris.DebrisEntity;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ShockwaveItem
extends class_1792 {
    private final int maxTime;
    private final WindCore.WindCoreLevel lvl;
    private final float velocity;

    public ShockwaveItem(class_1792.class_1793 settings, WindCore.WindCoreLevel lvl) {
        super(settings);
        this.lvl = lvl;
        switch (lvl) {
            case STAGE2: {
                this.maxTime = 8;
                this.velocity = 0.8f;
                break;
            }
            case STAGE3: {
                this.maxTime = 11;
                this.velocity = 1.0f;
                break;
            }
            case STAGE4: {
                this.maxTime = 14;
                this.velocity = 1.3f;
                break;
            }
            case STAGE5: {
                this.maxTime = 17;
                this.velocity = 1.7f;
                break;
            }
            default: {
                this.maxTime = 5;
                this.velocity = 0.2f;
            }
        }
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        textConsumer.accept((class_2561)this.getDescription().method_27692(switch (this.lvl) {
            case WindCore.WindCoreLevel.STAGE2 -> class_124.field_1054;
            case WindCore.WindCoreLevel.STAGE3 -> class_124.field_1065;
            case WindCore.WindCoreLevel.STAGE4 -> class_124.field_1061;
            case WindCore.WindCoreLevel.STAGE5 -> class_124.field_1079;
            default -> class_124.field_1068;
        }));
    }

    public class_5250 getDescription() {
        return class_2561.method_43471((String)(this.field_8014 + ".desc"));
    }

    public class_1269 method_7884(class_1838 context) {
        class_2680 state = context.method_8045().method_8320(context.method_8037());
        if (Utils.canPassThrough(state.method_26204())) {
            return class_1269.field_5814;
        }
        class_1657 user = context.method_8036();
        class_1799 itemStack = context.method_8041();
        user.method_6019(context.method_20287());
        Utils.playSound(null, context.method_8045(), user.method_24515(), class_3417.field_15197, class_3419.field_15248, 1.0f, 1.4f);
        this.setUsageTime(itemStack, this.maxTime);
        this.setPos(itemStack, context.method_8037());
        this.setStartPos(itemStack, context.method_8037());
        this.setAngle(itemStack, user.method_5828(1.0f).method_46409());
        if (context.method_8045().method_8608()) {
            for (int i = 0; i < 20; ++i) {
                context.method_8045().method_8406((class_2394)class_2398.field_11204, user.method_23322(5.0), user.method_23318() + 0.1, user.method_23325(5.0), 0.0, 0.4, 0.0);
            }
        }
        this.doDamage(context.method_8045(), itemStack, user);
        return class_1269.field_52422;
    }

    private void doDamage(class_1937 world, class_1799 stack, class_1657 player) {
        boolean invulnerable;
        int amount = 5;
        boolean bl = invulnerable = this.lvl.getByte() == 0 && stack.method_58657().method_57534().stream().anyMatch(p -> p.method_40225(class_1893.field_9119));
        if (!(world.method_8608() || invulnerable || player.method_68878())) {
            if (player != null) {
                class_174.field_1185.method_8960((class_3222)player, stack, amount);
            }
            stack.method_7974(stack.method_7919() + amount);
        }
        if (!world.method_8608() && stack.method_7919() >= stack.method_7936() - 5) {
            if (this.lvl.getByte() == 0) {
                class_1304 slot = class_1799.method_7973((class_1799)player.method_6047(), (class_1799)stack) ? class_1304.field_6173 : class_1304.field_6171;
                stack.method_7934(1);
                player.method_20235(stack.method_7909(), slot);
                return;
            }
            byte newLvl = (byte)(this.lvl.getByte() - 1);
            newLvl = (byte)class_3532.method_15340((int)newLvl, (int)0, (int)4);
            class_1799 newStack = WindCore.WindCoreLevel.getFromByte(newLvl).asShockwaveStack();
            class_1799 finalStack = stack.method_7972().method_56701((class_1935)newStack.method_7909(), 1);
            finalStack.method_57379(class_9334.field_50072, (Object)newStack.method_7936());
            finalStack.method_57379(class_9334.field_49629, (Object)0);
            stack.method_7934(1);
            player.method_31548().method_7394(finalStack);
        }
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        if (!(entity instanceof class_1657)) {
            return;
        }
        int islot = ((class_1657)entity).method_31548().method_7395(stack);
        int usageTime = this.getUsageTime(stack, (class_1657)entity, islot);
        class_2338 pos = this.getPos(stack);
        Vector3f angle = this.getAngle(stack);
        class_2338 start = this.getStartPos(stack);
        if (usageTime > 0) {
            if (pos == null || angle == null) {
                this.setUsageTime(stack, 0);
                return;
            }
            this.setUsageTime(stack, usageTime - 1);
            if (!world.method_8608()) {
                this.serverTick(world, (class_1309)entity, angle, start, pos, usageTime, stack);
            }
        } else if (pos != null || angle != null || start != null) {
            this.setPos(stack, Utils.effectivelyNull);
            this.setAngle(stack, null);
            this.setStartPos(stack, Utils.effectivelyNull);
        }
    }

    public void serverTick(class_3218 world, class_1309 entity, Vector3f rotationVec, class_2338 startingPos, class_2338 curPos, int curTime, class_1799 stack) {
        float distance;
        class_243 directionVec;
        class_243 startPosVec = startingPos.method_46558();
        class_243 nextPosVec = startPosVec.method_1019((directionVec = new class_243((double)rotationVec.x, (double)rotationVec.y, (double)rotationVec.z).method_1029()).method_1021((double)(distance = (float)(this.maxTime - curTime) * 2.0f)));
        class_2338 nextPos = class_2338.method_49638((class_2374)nextPosVec);
        if (nextPos.method_10264() < startingPos.method_10264()) {
            nextPos = BP.of(nextPos.method_10263(), startingPos.method_10264(), nextPos.method_10260());
        }
        boolean foundGround = false;
        int mD = entity.method_5715() ? 1 : 3;
        for (class_2338 next : class_2338.method_10097((class_2338)nextPos.method_10069(-2, 0, -2), (class_2338)nextPos.method_10069(2, 1, 2))) {
            DebrisEntity debris;
            class_2680 state;
            if (Utils.squaredDistanceXZ(entity.method_24515(), next) < (double)(mD * mD) || (state = world.method_8320(next)).method_26215() || !TornadoDestructionInfo.canWindCoreGrab(state, this.lvl.b < 3 ? WindCore.WindCoreLevel.STAGE3 : this.lvl) && !state.method_27852(class_2246.field_10362) && !state.method_27852(class_2246.field_10194)) continue;
            if (Utils.canPassThrough((class_1936)world, next.method_10084())) {
                foundGround = true;
                debris = DebrisEntity.createDebris(WCEntities.DEBRIS, entity, state, true, (class_1937)world);
                debris.method_5725(next, 0.0f, 0.0f);
                world.method_8649((class_1297)debris);
                debris.method_18800(0.0, this.velocity, 0.0);
                debris.setKnockbackInstead();
                debris.setDamageMultiplier(1.5);
                world.method_8501(next, class_2246.field_10124.method_9564());
                continue;
            }
            if (!Utils.canPassThrough((class_1936)world, next.method_10074())) continue;
            foundGround = true;
            debris = DebrisEntity.createDebris(WCEntities.DEBRIS, entity, state, true, (class_1937)world);
            debris.method_5725(next, 0.0f, 0.0f);
            world.method_8649((class_1297)debris);
            debris.method_18800(0.0, -this.velocity, 0.0);
            debris.setKnockbackInstead();
            debris.setDamageMultiplier(1.5);
            world.method_8501(next, class_2246.field_10124.method_9564());
        }
        if (curTime % 2 == 0 && foundGround) {
            Utils.playSound(null, (class_1937)world, nextPos, WeatherClassic.BLOCK_LAUNCHER, class_3419.field_15248, 2.0f, 0.2f + world.method_8409().method_43057());
        }
        this.setPos(stack, nextPos);
        if (!foundGround) {
            this.setUsageTime(stack, 0);
        }
    }

    public void setUsageTime(class_1799 stack, int time) {
        if (stack.method_58694(WCItems.I_USE_TIME) == null) {
            stack.method_57379(WCItems.I_USE_TIME, (Object)class_9279.method_57456((class_2487)new class_2487()));
        }
        ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463().method_10569("usage_time", time);
    }

    public int getUsageTime(class_1799 stack, class_1657 player, int islot) {
        int prevSlot;
        if (stack.method_58694(WCItems.I_USE_TIME) == null) {
            stack.method_57379(WCItems.I_USE_TIME, (Object)class_9279.method_57456((class_2487)new class_2487()));
        }
        if (islot != (prevSlot = ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463().method_68083("prev_slot", -1))) {
            ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463().method_10569("prev_slot", islot);
            return 0;
        }
        int p = ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463().method_68083("usage_time", 0);
        return p;
    }

    public void setPos(class_1799 stack, class_2338 pos) {
        if (stack.method_58694(WCItems.I_USE_TIME) == null) {
            stack.method_57379(WCItems.I_USE_TIME, (Object)class_9279.method_57456((class_2487)new class_2487()));
        }
        ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463().method_10544("pos", pos.method_10063());
    }

    public class_2338 getPos(class_1799 stack) {
        if (stack.method_58694(WCItems.I_USE_TIME) == null) {
            stack.method_57379(WCItems.I_USE_TIME, (Object)class_9279.method_57456((class_2487)new class_2487()));
        }
        long l = ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463().method_68080("pos", Utils.effectivelyNull.method_10063());
        return Utils.effectivelyNull.method_10063() == l ? null : class_2338.method_10092((long)l);
    }

    public void setStartPos(class_1799 stack, class_2338 pos) {
        if (stack.method_58694(WCItems.I_USE_TIME) == null) {
            stack.method_57379(WCItems.I_USE_TIME, (Object)class_9279.method_57456((class_2487)new class_2487()));
        }
        ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463().method_10544("start_pos", pos.method_10063());
    }

    public class_2338 getStartPos(class_1799 stack) {
        if (stack.method_58694(WCItems.I_USE_TIME) == null) {
            stack.method_57379(WCItems.I_USE_TIME, (Object)class_9279.method_57456((class_2487)new class_2487()));
        }
        long l = ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463().method_68080("start_pos", Utils.effectivelyNull.method_10063());
        return Utils.effectivelyNull.method_10063() == l ? null : class_2338.method_10092((long)l);
    }

    public void setAngle(class_1799 stack, Vector3f dir) {
        if (stack.method_58694(WCItems.I_USE_TIME) == null) {
            stack.method_57379(WCItems.I_USE_TIME, (Object)class_9279.method_57456((class_2487)new class_2487()));
        }
        class_2487 tag = ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463();
        if (dir == null) {
            tag.method_10548("yaw", 0.0f);
            tag.method_10548("pitch", 0.0f);
            tag.method_10548("roll", 0.0f);
            return;
        }
        tag.method_10548("pitch", dir.x);
        tag.method_10548("yaw", dir.y);
        tag.method_10548("roll", dir.z);
    }

    public Vector3f getAngle(class_1799 stack) {
        if (stack.method_58694(WCItems.I_USE_TIME) == null) {
            stack.method_57379(WCItems.I_USE_TIME, (Object)class_9279.method_57456((class_2487)new class_2487()));
        }
        class_2487 tag = ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463();
        float yaw = tag.method_66563("yaw", 0.0f);
        float pitch = tag.method_66563("pitch", 0.0f);
        float roll = tag.method_66563("roll", 0.0f);
        if (yaw == 0.0f && pitch == 0.0f && roll == 0.0f) {
            return null;
        }
        return new Vector3f(pitch, yaw, roll);
    }
}

