/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.particle.rotator.base;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.weather_classic.particle.StormParticle;
import net.weather_classic.particle.rotator.base.ParticleRotator;
import net.weather_classic.storm.TornadoStats;
import net.weather_classic.storm.source.ClientClusterParticleSource;
import net.weather_classic.storm.source.ClientTornadoParticleSource;
import net.weather_classic.storm.source.TornadoParticleSource;

@Environment(value=EnvType.CLIENT)
public abstract class StormParticleRotator
extends ParticleRotator {
    protected final TornadoParticleSource source;

    public StormParticleRotator(TornadoParticleSource source) {
        this.source = source;
    }

    @Override
    public void tick(StormParticle particle) {
        this.rotate(particle);
        if (this.isUsingTornadoList()) {
            ((ClientTornadoParticleSource)this.source).updateSource();
        } else if (this.isUsingClusterList()) {
            ((ClientClusterParticleSource)this.source).updateSource();
        }
    }

    public TornadoParticleSource getSource() {
        return this.source;
    }

    protected TornadoStats getStats() {
        return this.getSource().getStats();
    }

    protected class_243 getSourcePos() {
        return this.getSource().getEmitter();
    }

    protected boolean isUsingTornadoList() {
        return this.getSource() instanceof ClientTornadoParticleSource;
    }

    protected boolean isUsingClusterList() {
        return this.getSource() instanceof ClientClusterParticleSource;
    }
}

