/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8177;
import net.minecraft.class_9904;
import net.weather_classic.WeatherClassic;
import net.weather_classic.help.Utils;
import org.jetbrains.annotations.Nullable;

public class AdjustableCanopyBlock
extends class_2248
implements class_3737 {
    public static final MapCodec<AdjustableCanopyBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_8177.field_46534.fieldOf("block_set_type").forGetter(block -> block.blockSetType), (App)AdjustableCanopyBlock.method_54096()).apply((Applicative)instance, AdjustableCanopyBlock::new));
    public static final class_2746 OPEN = class_2741.field_12537;
    public static final class_2746 ZAXIS = class_2746.method_11825((String)"zaxis");
    public static final class_2746 INVERTED = class_2741.field_12501;
    public static final class_2758 STATUS = class_2758.method_11867((String)"link_status", (int)0, (int)2);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected static final class_265 CLOSED_SHAPE = class_2248.method_9541((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 PULLED_SHAPE_X = class_2248.method_9541((double)0.0, (double)14.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final class_265 PULLED_SHAPE_Z = class_2248.method_9541((double)7.0, (double)14.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    private final class_8177 blockSetType;

    public AdjustableCanopyBlock(class_8177 type, class_4970.class_2251 settings) {
        super(settings);
        this.blockSetType = type;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)ZAXIS, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)STATUS, (Comparable)Integer.valueOf(1))).method_11657((class_2769)INVERTED, (Comparable)Boolean.valueOf(true)));
    }

    public MapCodec<? extends AdjustableCanopyBlock> method_53969() {
        return CODEC;
    }

    protected float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return (Boolean)state.method_11654((class_2769)OPEN) != false ? 1.0f : 0.3f;
    }

    protected boolean method_9579(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)OPEN);
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return (Boolean)state.method_11654((class_2769)OPEN) == false ? CLOSED_SHAPE : ((Boolean)state.method_11654((class_2769)ZAXIS) != false ? PULLED_SHAPE_Z : PULLED_SHAPE_X);
    }

    protected boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
        return (Boolean)state.method_11654((class_2769)OPEN) == false ? true : class_2248.method_9614((class_265)state.method_26220(world, pos));
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        switch (type) {
            case field_48: {
                return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false && (Boolean)state.method_11654((class_2769)OPEN) != false;
            }
            case field_51: {
                return (Boolean)state.method_11654((class_2769)OPEN);
            }
        }
        return false;
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (!world.field_9236 && world.method_8510() % 10L == 0L && (double)world.method_8409().method_43057() < 0.2) {
            world.method_22352(pos, true);
            Utils.playSound(null, world, pos, WeatherClassic.WOOD_CANOPY_SWITCH, class_3419.field_15245, 0.6f, 1.0f + world.method_8409().method_43057() * 0.3f);
        }
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 axis = (class_2680)this.method_9564().method_11657((class_2769)ZAXIS, (Comparable)Boolean.valueOf(ctx.method_8038().method_10166() == class_2350.class_2351.field_11051));
        axis = ctx.method_8038() == class_2350.field_11039 || ctx.method_8038() == class_2350.field_11043 ? (class_2680)axis.method_11657((class_2769)INVERTED, (Comparable)Boolean.valueOf(true)) : (class_2680)axis.method_11657((class_2769)INVERTED, (Comparable)Boolean.valueOf(false));
        return axis;
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!this.method_9558(state, (class_4538)world, pos)) {
            if (!world.field_9236) {
                world.method_22352(pos, true);
            }
            return;
        }
        int s = (Integer)state.method_11654((class_2769)STATUS);
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(s == 1)), 3);
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        boolean zaxis = (Boolean)state.method_11654((class_2769)ZAXIS);
        class_2350[] ZD = new class_2350[]{class_2350.field_11043, class_2350.field_11035};
        class_2350[] XD = new class_2350[]{class_2350.field_11034, class_2350.field_11039};
        class_2350[] DIRS = zaxis ? ZD : XD;
        boolean support = false;
        block0: for (class_2350 dir : DIRS) {
            class_2338 offset;
            class_2680 cstate;
            if (support) break;
            for (int i = 1; i < 24 && ((cstate = world.method_8320(offset = pos.method_10079(dir, i))).method_26234((class_1922)world, offset) || cstate.method_26204() instanceof AdjustableCanopyBlock); ++i) {
                if (!cstate.method_26234((class_1922)world, offset)) continue;
                support = true;
                continue block0;
            }
        }
        return support;
    }

    protected void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (newState.method_27852(state.method_26204()) && newState.method_11654((class_2769)OPEN) != state.method_11654((class_2769)OPEN)) {
            Utils.playSound(null, world, pos, WeatherClassic.WOOD_CANOPY_SWITCH, class_3419.field_15245, 0.2f, 0.8f + world.method_8409().method_43057() * 0.3f);
        }
        super.method_9615(state, world, pos, newState, moved);
    }

    public class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 sourcePos, class_2680 neighborState, class_5819 random) {
        if (!this.method_9558(state, world, pos)) {
            tickView.method_64310(pos, state.method_26204(), 2);
            return state;
        }
        if (!world.method_8608()) {
            boolean zaxis = (Boolean)state.method_11654((class_2769)ZAXIS);
            int s = (Integer)state.method_11654((class_2769)STATUS);
            class_2680 sourceState = world.method_8320(sourcePos);
            if (s != 0 && sourceState.method_26204() instanceof AdjustableCanopyBlock && (zaxis && sourcePos.method_10263() == pos.method_10263() || !zaxis && sourcePos.method_10260() == pos.method_10260()) && sourcePos.method_10264() == pos.method_10264() && (Boolean)sourceState.method_11654((class_2769)ZAXIS) == zaxis && sourceState.method_11654((class_2769)OPEN) != state.method_11654((class_2769)OPEN)) {
                int update = s;
                int n = update = AdjustableCanopyBlock.isPulled(sourceState) ? 1 : 2;
                if (update != s) {
                    if (!tickView.method_8397().method_8674(pos, (Object)state.method_26204())) {
                        tickView.method_64310(pos, state.method_26204(), 3);
                    }
                    return (class_2680)state.method_11657((class_2769)STATUS, (Comparable)Integer.valueOf(update));
                }
                return state;
            }
        }
        return state;
    }

    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
        int s = (Integer)state.method_11654((class_2769)STATUS);
        boolean zaxis = (Boolean)state.method_11654((class_2769)ZAXIS);
        class_2350[] ZD = new class_2350[]{class_2350.field_11043, class_2350.field_11035};
        class_2350[] XD = new class_2350[]{class_2350.field_11034, class_2350.field_11039};
        class_2350[] DIRS = zaxis ? ZD : XD;
        boolean isEnd = false;
        for (class_2350 dir : DIRS) {
            class_2338 offset = pos.method_10093(dir);
            if (!world.method_8320(offset).method_26234((class_1922)world, offset)) continue;
            isEnd = true;
            break;
        }
        if (isEnd || s == 0) {
            boolean redstone = world.method_49803(pos);
            if (redstone) {
                if (s != 0) {
                    world.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)STATUS, (Comparable)Integer.valueOf(0))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false)));
                }
            } else if (s == 0) {
                world.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)STATUS, (Comparable)Integer.valueOf(1))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
    }

    public static boolean isLoosed(class_2680 state) {
        return (Integer)state.method_11654((class_2769)STATUS) == 2;
    }

    public static boolean isPulled(class_2680 state) {
        return (Integer)state.method_11654((class_2769)STATUS) == 1;
    }

    public static boolean isBase(class_2680 state) {
        return (Integer)state.method_11654((class_2769)STATUS) > 0;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{OPEN});
        builder.method_11667(new class_2769[]{ZAXIS});
        builder.method_11667(new class_2769[]{STATUS});
        builder.method_11667(new class_2769[]{WATERLOGGED});
        builder.method_11667(new class_2769[]{INVERTED});
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        class_2350 dir = this.adjustDirectionProperties((Boolean)state.method_11654((class_2769)ZAXIS), (Boolean)state.method_11654((class_2769)INVERTED), rotation);
        class_2680 axis = dir.method_10166() == class_2350.class_2351.field_11051 ? (class_2680)state.method_11657((class_2769)ZAXIS, (Comparable)Boolean.valueOf(true)) : (class_2680)state.method_11657((class_2769)ZAXIS, (Comparable)Boolean.valueOf(false));
        axis = dir == class_2350.field_11039 || dir == class_2350.field_11043 ? (class_2680)axis.method_11657((class_2769)INVERTED, (Comparable)Boolean.valueOf(true)) : (class_2680)axis.method_11657((class_2769)INVERTED, (Comparable)Boolean.valueOf(false));
        return axis;
    }

    private class_2350 adjustDirectionProperties(boolean zaxis, boolean negative, class_2470 structureRotation) {
        class_2350 dir = negative ? (zaxis ? class_2350.field_11043 : class_2350.field_11039) : (zaxis ? class_2350.field_11035 : class_2350.field_11034);
        switch (structureRotation) {
            case field_11463: {
                return dir.method_10170();
            }
            case field_11464: {
                return dir.method_10153();
            }
            case field_11465: {
                return dir.method_10160();
            }
        }
        return dir;
    }
}

