/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10225;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1275;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3954;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_747;
import net.weather_classic.WeatherClassic;
import net.weather_classic.block.entity.TurbineBlockEntity;
import net.weather_classic.block.screenhandler.TurbineScreenHandler;
import net.weather_classic.help.Utils;
import net.weather_classic.mixin.BlockWithEntityInvoker;
import net.weather_classic.registry.WCBlocks;
import org.jetbrains.annotations.Nullable;

public class TurbineBlock
extends class_2318
implements class_2343,
class_3954 {
    public static final MapCodec<TurbineBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TurbineBlock.method_54096(), (App)Codec.BOOL.fieldOf("weathered").forGetter(block -> block.weathered)).apply((Applicative)instance, TurbineBlock::new));
    public static final class_2746 ACTIVE = class_2746.method_11825((String)"active");
    public static final class_2758 RANGE;
    public static final class_2746 POWERED;
    private final boolean weathered;

    public TurbineBlock(class_4970.class_2251 settings, boolean weathered) {
        super(settings);
        this.weathered = weathered;
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(weathered))).method_11657((class_2769)RANGE, (Comparable)Integer.valueOf(weathered ? 1 : 0))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends TurbineBlock> method_53969() {
        return CODEC;
    }

    protected void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2586 blockEntity;
        if (newState.method_26204() instanceof TurbineBlock) {
            class_2586 blockEntity2;
            boolean valid2;
            boolean valid = state.method_11654((class_2769)ACTIVE) != newState.method_11654((class_2769)ACTIVE);
            boolean bl = valid2 = state.method_11654((class_2769)POWERED) != newState.method_11654((class_2769)POWERED) && (Boolean)newState.method_11654((class_2769)ACTIVE) != false;
            if ((valid || valid2) && (blockEntity2 = world.method_8321(pos)) instanceof TurbineBlockEntity) {
                TurbineBlockEntity turbine = (TurbineBlockEntity)blockEntity2;
                turbine.sendSoundUpdates();
            }
        }
        if (!newState.method_27852(WCBlocks.TURBINE) && (blockEntity = world.method_8321(pos)) instanceof TurbineBlockEntity) {
            TurbineBlockEntity turbine = (TurbineBlockEntity)blockEntity;
            turbine.getInventory().dropStacks();
        }
        super.method_9615(state, world, pos, newState, moved);
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TurbineBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return BlockWithEntityInvoker.invokeValidateTicker(type, WCBlocks.TURBINE_BLOCK_ENTITY, TurbineBlockEntity::tick);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (this.weathered || hit.method_17780() == state.method_11654((class_2769)field_10927)) {
            return class_1269.field_5814;
        }
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        player.method_17355(state.method_26196(world, pos));
        return class_1269.field_21466;
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        boolean active = (Boolean)state.method_11654((class_2769)ACTIVE);
        int val = (Integer)state.method_11654((class_2769)RANGE);
        if (val <= 0 && !active) {
            active = true;
        } else {
            ++val;
        }
        if (val > 2) {
            val = 0;
            active = false;
        }
        world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(active))).method_11657((class_2769)RANGE, (Comparable)Integer.valueOf(val)), 2);
        Utils.playSound(null, (class_1937)world, pos, WeatherClassic.TURBINE_CLICK, class_3419.field_15245, 0.8f, 1.1f);
    }

    public class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (!world.method_8608()) {
            boolean bl = world.method_49803(pos);
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof TurbineBlockEntity) {
                TurbineBlockEntity turbine = (TurbineBlockEntity)blockEntity;
                boolean currentStatus = turbine.isReceivingRedstonePower();
                if (bl && currentStatus != bl && !tickView.method_8397().method_8674(pos, (Object)state.method_26204())) {
                    tickView.method_64310(pos, state.method_26204(), 1);
                }
                turbine.setReceivingRedstonePower(bl);
            }
        }
        return state;
    }

    @Nullable
    protected class_3908 method_17454(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof TurbineBlockEntity) {
            TurbineBlockEntity turbine = (TurbineBlockEntity)blockEntity;
            class_2561 text = ((class_1275)blockEntity).method_5476();
            return new class_747((syncId, playerInventory, player) -> TurbineScreenHandler.create(syncId, playerInventory, (class_1263)turbine.getInventory()), text);
        }
        return null;
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)field_10927, (Comparable)ctx.method_7715().method_10153());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{ACTIVE});
        builder.method_11667(new class_2769[]{RANGE});
        builder.method_11667(new class_2769[]{field_10927});
        builder.method_11667(new class_2769[]{POWERED});
    }

    public class_1278 method_17680(class_2680 state, class_1936 world, class_2338 pos) {
        if (this.weathered) {
            return null;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof TurbineBlockEntity) {
            TurbineBlockEntity turbine = (TurbineBlockEntity)blockEntity;
            return turbine.getInventory();
        }
        return null;
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)field_10927, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)field_10927)));
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof TurbineBlockEntity) {
            TurbineBlockEntity t = (TurbineBlockEntity)be;
            t.getInventory().dropStacks();
        }
        return super.method_9576(world, pos, state, player);
    }

    static {
        POWERED = class_2741.field_12484;
        RANGE = class_2758.method_11867((String)"range", (int)0, (int)2);
    }
}

