/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.block.entity;

import com.mojang.serialization.Codec;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.weather_classic.WeatherClassic;
import net.weather_classic.block.StormInfuserBlock;
import net.weather_classic.config.CustomTornadoConfig;
import net.weather_classic.global.Global;
import net.weather_classic.help.Utils;
import net.weather_classic.item.ShockwaveItem;
import net.weather_classic.item.WindCore;
import net.weather_classic.registry.WCBlocks;
import net.weather_classic.registry.WCItems;
import net.weather_classic.storm.TornadoEntity;
import org.jetbrains.annotations.Nullable;

public class StormInfuserBlockEntity
extends class_2586 {
    private float displayRotation;
    private float prevDisplayRotation;
    private class_1799 stack = class_1799.field_8037;
    private boolean markForDecharge = false;
    private static final class_9279 C = class_9279.method_57456((class_2487)new class_2487());

    public StormInfuserBlockEntity(class_2338 pos, class_2680 state) {
        super(WCBlocks.STORM_INFUSER_BLOCK_ENTITY, pos, state);
    }

    public float getDisplayRotation() {
        return this.displayRotation;
    }

    public float getPreviousDisplayRotation() {
        return this.prevDisplayRotation;
    }

    private void rotateDisplay() {
        this.prevDisplayRotation = this.displayRotation;
        this.displayRotation = class_3532.method_15393((float)(this.displayRotation + 3.0f));
    }

    public void setStack(class_1799 stack) {
        if (stack == null) {
            return;
        }
        this.stack = stack;
        this.updateForClient();
        this.method_5431();
    }

    public void removeStack(@Nullable class_1657 player) {
        if (player != null) {
            player.method_7270(this.getChargedStack());
        }
        this.markForDecharge = true;
        this.stack = class_1799.field_8037;
        this.updateForClient();
        this.method_5431();
    }

    public void dropStack() {
        if (this.getStack().method_7960() || this.field_11863.field_9236) {
            return;
        }
        class_5819 random = this.field_11863.method_8409();
        class_243 pos = Utils.convertBlockPosToVec(this.method_11016());
        class_1542 item = new class_1542(class_1299.field_6052, this.method_10997());
        item.method_60949(pos, 0.0f, 0.0f);
        item.method_6979(this.getChargedStack());
        item.method_18800((double)(random.method_43057() * (float)(random.method_43056() ? -1 : 1)) * 0.1, 0.2, (double)(random.method_43057() * (float)(random.method_43056() ? -1 : 1)) * 0.1);
        this.field_11863.method_8649((class_1297)item);
        this.removeStack(null);
    }

    private class_1799 getChargedStack() {
        if (this.isCoreStack()) {
            return this.getChargedCoreStack();
        }
        if (this.isShockwaveStack()) {
            return this.getChargedShockwaveStack();
        }
        return this.stack;
    }

    private class_1799 getChargedCoreStack() {
        WindCore.WindCoreLevel coreLvl;
        int level = (Integer)this.method_11010().method_11654((class_2769)StormInfuserBlock.LEVEL) - 1;
        if ((level = class_3532.method_15340((int)level, (int)0, (int)4)) < (coreLvl = WindCore.WindCoreLevel.fromStack(this.stack)).getByte()) {
            this.stack.method_57379(WCItems.CORE_FLARE, null);
            return this.stack;
        }
        if (level == coreLvl.getByte()) {
            class_1799 newStack = coreLvl.asStack();
            class_1799 finalStack = newStack.method_7972();
            finalStack = this.stack.method_56701((class_1935)newStack.method_7909(), 1);
            finalStack.method_57379(WCItems.CORE_FLARE, null);
            finalStack.method_57379(class_9334.field_50072, (Object)newStack.method_7936());
            finalStack.method_57379(class_9334.field_49629, (Object)0);
            return finalStack;
        }
        class_1799 newStack = WindCore.WindCoreLevel.getFromByte((byte)level).asStack();
        class_1799 finalStack = newStack.method_7972();
        finalStack = this.stack.method_56701((class_1935)newStack.method_7909(), 1);
        finalStack.method_57379(WCItems.CORE_FLARE, null);
        finalStack.method_57379(class_9334.field_50072, (Object)newStack.method_7936());
        finalStack.method_57379(class_9334.field_49629, (Object)0);
        return finalStack;
    }

    private class_1799 getChargedShockwaveStack() {
        WindCore.WindCoreLevel coreLvl;
        int level = (Integer)this.method_11010().method_11654((class_2769)StormInfuserBlock.LEVEL) - 1;
        if ((level = class_3532.method_15340((int)level, (int)0, (int)4)) < (coreLvl = WindCore.WindCoreLevel.fromShockwaveStack(this.stack)).getByte()) {
            return this.stack;
        }
        if (level == coreLvl.getByte()) {
            class_1799 newStack = coreLvl.asShockwaveStack();
            class_1799 finalStack = newStack.method_7972();
            finalStack = this.stack.method_56701((class_1935)newStack.method_7909(), 1);
            finalStack.method_57379(class_9334.field_50072, (Object)newStack.method_7936());
            finalStack.method_57379(class_9334.field_49629, (Object)0);
            return finalStack;
        }
        class_1799 newStack = WindCore.WindCoreLevel.getFromByte((byte)level).asShockwaveStack();
        class_1799 finalStack = newStack.method_7972();
        finalStack = this.stack.method_56701((class_1935)newStack.method_7909(), 1);
        finalStack.method_57379(class_9334.field_50072, (Object)newStack.method_7936());
        finalStack.method_57379(class_9334.field_49629, (Object)0);
        return finalStack;
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public void updateForClient() {
        ((class_3218)this.field_11863).method_14178().method_14128(this.method_11016());
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        if (!this.stack.method_7960()) {
            view.method_71468("stack", class_1799.field_24671, (Object)this.stack);
        }
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        if (view.method_71426("updatingStackOnClient", (Codec)Codec.BOOL).isPresent()) {
            this.stack = class_1799.field_8037;
            view.method_71426("update_stack", class_1799.field_24671).ifPresent(stack -> {
                this.stack = stack;
            });
            return;
        }
        view.method_71426("stack", class_1799.field_24671).ifPresent(newStack -> {
            if (!class_1799.method_7973((class_1799)newStack, (class_1799)this.stack)) {
                this.stack = newStack;
            }
        });
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return (class_2487)class_156.method_654((Object)new class_2487(), nbt -> {
            nbt.method_10556("updatingStackOnClient", true);
            if (!this.stack.method_7960()) {
                nbt.method_67494("update_stack", class_1799.field_24671, (Object)this.stack);
            }
        });
    }

    private void spawnChargedParticles(int level) {
        level = class_3532.method_15340((int)level, (int)0, (int)4);
        this.field_11863.method_8406((class_2394)new class_2390(StormInfuserBlock.LEVEL_COLORS[level], 2.0f), (double)this.field_11867.method_10263() + 0.5 + (double)(this.field_11863.method_8409().method_43057() * (float)(this.field_11863.method_8409().method_43056() ? -1 : 1)), (double)this.field_11867.method_10264() + 0.2 + (double)this.field_11863.method_8409().method_43057(), (double)this.field_11867.method_10260() + 0.5 + (double)(this.field_11863.method_8409().method_43057() * (float)(this.field_11863.method_8409().method_43056() ? -1 : 1)), 0.0, 0.0, 0.0);
    }

    public boolean isShockwaveStack() {
        if (this.stack == null) {
            return false;
        }
        return this.stack.method_7909() instanceof ShockwaveItem;
    }

    public boolean isCoreStack() {
        if (this.stack == null) {
            return false;
        }
        return this.stack.method_7909() instanceof WindCore;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, StormInfuserBlockEntity block) {
        boolean charged = (Boolean)state.method_11654((class_2769)StormInfuserBlock.CHARGED);
        int level = (Integer)state.method_11654((class_2769)StormInfuserBlock.LEVEL);
        if (world.field_9236) {
            block.rotateDisplay();
            if (charged && (double)world.method_8409().method_43057() < 1.0 * ((double)level * 0.15)) {
                block.spawnChargedParticles(level - 1);
            }
        } else if (!block.getStack().method_7960()) {
            if (!charged) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)StormInfuserBlock.CHARGED, (Comparable)Boolean.valueOf(true)));
                Utils.playSound(null, world, pos, WeatherClassic.STORM_INFUSER_INSERT, class_3419.field_15245, 0.7f, 0.8f + world.method_8409().method_43057() / 3.0f);
                Utils.playSound(null, world, pos, class_3417.field_23116, class_3419.field_15245, 0.2f, 0.8f + world.method_8409().method_43057() / 3.0f);
                return;
            }
            if (world.method_8510() % 20L == 0L) {
                if (level > 1 && block.getStack().method_58694(WCItems.CORE_FLARE) == null && block.isCoreStack()) {
                    block.getStack().method_57379(WCItems.CORE_FLARE, (Object)C);
                    block.method_5431();
                    block.updateForClient();
                }
                if (!Global.activeTornadoes.isEmpty()) {
                    for (TornadoEntity tornado : Global.activeTornadoes) {
                        if (!tornado.isDestructiveStorm() || tornado.isSpout() || Utils.distanceXZ(tornado.method_24515(), pos) > 8.0 || Math.abs((double)pos.method_10264() - tornado.method_23320()) > 16.0 || tornado.getTornadoType() + 1 <= level) continue;
                        int tl = tornado.getTornadoType() + 1;
                        if (tl > 5) {
                            tl = CustomTornadoConfig.getPullType(false) + 1;
                        }
                        tl = class_3532.method_15340((int)tl, (int)1, (int)5);
                        class_2680 nState = (class_2680)state.method_11657((class_2769)StormInfuserBlock.LEVEL, (Comparable)Integer.valueOf(tl));
                        world.method_8501(pos, nState);
                        Utils.playSound(null, world, pos, (class_3414)class_3417.field_14896.comp_349(), class_3419.field_15245, 5.0f, 1.0f);
                        class_1538 le = new class_1538(class_1299.field_6112, world);
                        le.method_5725(pos.method_10084(), 0.0f, 0.0f);
                        world.method_8649((class_1297)le);
                        if (tl >= 5 && block.isCoreStack()) {
                            for (class_1657 player : Utils.getPlayersIn(world, new class_238(pos).method_1009(86.0, 64.0, 86.0))) {
                                WeatherClassic.STORM_INFUSE.trigger((class_3222)player, nState);
                            }
                        }
                        break;
                    }
                }
            }
        } else if (charged) {
            class_2680 deadState = (class_2680)state.method_11657((class_2769)StormInfuserBlock.CHARGED, (Comparable)Boolean.valueOf(false));
            if (block.markForDecharge && level > 1) {
                deadState = (class_2680)deadState.method_11657((class_2769)StormInfuserBlock.LEVEL, (Comparable)Integer.valueOf(1));
                Utils.playSound(null, world, pos, (class_3414)class_3417.field_23117.comp_349(), class_3419.field_15245, 1.0f, 1.2f + world.method_8409().method_43057() / 3.0f);
            }
            world.method_8501(pos, deadState);
            Utils.playSound(null, world, pos, WeatherClassic.STORM_INFUSER_INSERT, class_3419.field_15245, 0.7f, 0.3f + world.method_8409().method_43057() / 3.0f);
            return;
        }
    }
}

