/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3532;
import net.weather_classic.WeatherClassic;
import net.weather_classic.global.tools.TornadoDestructionInfo;

public class ModConfig {
    private static final Path configDir = FabricLoader.getInstance().getConfigDir().resolve("WeatherMod.json");
    public static boolean WARN_DUE_TO_OUTDATED_VERSION = false;
    public static final byte CUR_VER = 10;
    private static int maxTornadoes = 2;
    private static int maxDaysNoRain = 3;
    private static int maxDaysNoStorm = 5;
    private static int maxRainNoDownpour = 5;
    private static int rainChanceBase = 62;
    private static int stormChanceBase = 35;
    private static int rainWorsenChance = 10;
    private static byte tornadoDestructionLvl = (byte)2;
    private static boolean tornadoesBiasTowardsPlayers = true;
    private static boolean tornadoesExtraLongDuration = false;
    private static int tornadoFrequency = 37;
    private static int waterspoutFrequency = 50;
    private static boolean allowMultipleTornadoesSameStorm = false;
    private static int maxDebrisPerTornado = 50;
    private static int maxMobsPerTornado = 30;
    private static boolean terrariaReference = true;
    private static boolean severeStormLightningStrikesMobs = true;
    private static boolean severeStormLightningStrikesPlayers = true;
    private static byte tornadoesBiasIntensityLvl = 1;
    private static boolean forceChunkRemovalOnWorldLoad = true;
    private static int stormBecomeSevereStormChance = 77;
    private static int maxTornadoLoadDistance = 320;
    private static int apexOnlyChance = 30;
    private static int stageForceHighIfLongStormChance = 45;
    private static int stage2Chance = 72;
    private static int stage3ChanceIfNot2 = 80;
    private static int stage4ChanceIfNot3 = 75;
    private static int maxWindNoGale = 6;
    private static boolean tornadoCloudsPersistThroughBlocks = false;
    private static int cursedStormChance = 2;
    private static boolean cullTurbineSound = false;
    private static boolean forceDebrisVelocityUpdates = true;
    private static boolean enableCustomTornadoes = true;
    private static int passiveFirenadoChance = 1;
    private static boolean cullDebrisRendering = false;
    private static int tornadoDetectorRange = 172;
    private static boolean enableGale = true;
    private static boolean enableDownpour = true;
    private static int maxDebrisParticles = 500;
    private static boolean doFreezing = true;
    private static boolean debug = false;
    public static Map<String, TornadoDestructionInfo.BlockDestroyType> CUSTOM_BLOCK_LIST = new HashMap<String, TornadoDestructionInfo.BlockDestroyType>();

    public static int getMaxDebrisParticles() {
        return maxDebrisParticles;
    }

    public static boolean getFreezing() {
        return doFreezing;
    }

    public static boolean getEnableGale() {
        return enableGale;
    }

    public static int getTornadoDetectorRange() {
        return tornadoDetectorRange;
    }

    public static boolean getCullDebrisRendering() {
        return cullDebrisRendering;
    }

    public static boolean getEnableDownpour() {
        return enableDownpour;
    }

    public static int getPassiveFirenadoChance() {
        return passiveFirenadoChance;
    }

    public static boolean getEnableCustomTornadoes() {
        return enableCustomTornadoes;
    }

    public static boolean forceDebrisVelocityUpdates() {
        return forceDebrisVelocityUpdates;
    }

    public static boolean getCullTurbineSound() {
        return cullTurbineSound;
    }

    public static int getCursedStormChance() {
        return cursedStormChance;
    }

    public static boolean getTornadoCloudsPersistThroughBlocks() {
        return tornadoCloudsPersistThroughBlocks;
    }

    public static int getMaxWindNoGale() {
        return maxWindNoGale;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static int getApexOnlyChance() {
        return apexOnlyChance;
    }

    public static int getForceHighStageChanceIfLong() {
        return stageForceHighIfLongStormChance;
    }

    public static int getStage2Chance() {
        return stage2Chance;
    }

    public static int getStage3ChanceIfNot2() {
        return stage3ChanceIfNot2;
    }

    public static int getStage4ChanceIfNot3() {
        return stage4ChanceIfNot3;
    }

    public static int getMaxTornadoLoadDist() {
        return maxTornadoLoadDistance;
    }

    public static int getMaxTornadoes() {
        return maxTornadoes;
    }

    public static int getMaxDaysNoRain() {
        return maxDaysNoRain;
    }

    public static int getMaxDaysNoStorm() {
        return maxDaysNoStorm;
    }

    public static int getMaxRainDaysNoDownpour() {
        return maxRainNoDownpour;
    }

    public static int getRainChanceBase() {
        return rainChanceBase;
    }

    public static int getStormChanceBase() {
        return stormChanceBase;
    }

    public static int getRainWorsenChance() {
        return rainWorsenChance;
    }

    public static byte getTornadoDestructionLvl() {
        return tornadoDestructionLvl;
    }

    public static boolean getTornadoesBiasTowardsPlayers() {
        return tornadoesBiasTowardsPlayers;
    }

    public static boolean getTornadoesExtraLongDuration() {
        return tornadoesExtraLongDuration;
    }

    public static float getTornadoFrequency() {
        return (float)tornadoFrequency / 100.0f;
    }

    public static float getWaterspoutFrequency() {
        return (float)waterspoutFrequency / 100.0f;
    }

    public static boolean getAllowMultipleTornadoesSameStorm() {
        return allowMultipleTornadoesSameStorm;
    }

    public static int getMaxMobsPerTornado() {
        return maxMobsPerTornado;
    }

    public static int getMaxDebrisPerTornado() {
        return maxDebrisPerTornado;
    }

    public static boolean getTerrariaReference() {
        return terrariaReference;
    }

    public static boolean getSevereStormLightningStrikesMobs() {
        return severeStormLightningStrikesMobs;
    }

    public static boolean getSevereStormLightningStrikesPlayers() {
        return severeStormLightningStrikesPlayers;
    }

    public static byte getTornadoBiasIntensityLvl() {
        return tornadoesBiasIntensityLvl;
    }

    public static boolean getForceChunkRemovalOnWorldLoad() {
        return forceChunkRemovalOnWorldLoad;
    }

    public static int getSevereStormChance() {
        return stormBecomeSevereStormChance;
    }

    public static boolean loadConfig() throws IOException {
        boolean hadToCreate = false;
        File dataFile = configDir.toFile();
        if (!dataFile.exists()) {
            if (!dataFile.createNewFile()) {
                throw new IOException("CRITICAL ERROR: Could not create config for Weather Classic!");
            }
            ModConfig.saveDefaultConfig(dataFile);
            hadToCreate = true;
        }
        ModConfig.loadConfig(dataFile);
        return !hadToCreate;
    }

    private static void saveDefaultConfig(File dataFile) {
        Properties properties = new Properties();
        properties.setProperty("!WCV!", String.valueOf(10));
        properties.setProperty("Storm_maxTornadoes", String.valueOf(2));
        properties.setProperty("Weather_maxDaysNoRain", String.valueOf(3));
        properties.setProperty("Weather_maxDaysNoStorm", String.valueOf(5));
        properties.setProperty("Weather_maxRainNoDownpour", String.valueOf(5));
        properties.setProperty("Weather_maxWindNoGale", String.valueOf(6));
        properties.setProperty("Weather_baseRainChanceOutOf100", String.valueOf(62));
        properties.setProperty("Weather_baseStormChanceOutOf100", String.valueOf(35));
        properties.setProperty("Weather_rainWorsenChanceOutOf100", String.valueOf(10));
        properties.setProperty("Storm_tornadoDestructionLvl", String.valueOf(2));
        properties.setProperty("Storm_tornadoesBiasTowardsPlayers", String.valueOf(true));
        properties.setProperty("Storm_tornadoesExtraLongDuration", String.valueOf(false));
        properties.setProperty("Storm_tornadoFrequencyOutOf100", String.valueOf(37));
        properties.setProperty("Storm_waterspoutFrequencyOutOf100", String.valueOf(50));
        properties.setProperty("Storm_allowMultipleTornadoes", String.valueOf(false));
        properties.setProperty("Storm_maxMovingBlocksPerTornado", String.valueOf(50));
        properties.setProperty("Storm_maxMobsPerTornado", String.valueOf(30));
        properties.setProperty("Misc_terrariaReference", String.valueOf(true));
        properties.setProperty("Storm_lightningStrikesMobs", String.valueOf(true));
        properties.setProperty("Storm_lightningStrikesPlayers", String.valueOf(true));
        properties.setProperty("Storm_tornadoBiasIntensityLvl", String.valueOf(1));
        properties.setProperty("ALL_FORCE_CHUNKS_REMOVED_ON_WORLD_LOAD_DEBUG", String.valueOf(true));
        properties.setProperty("Weather_drownedAttackDuringDownpourChanceOutOf100", String.valueOf(22));
        properties.setProperty("Weather_severeStormChanceOutOf100", String.valueOf(77));
        properties.setProperty("Storm_maxTornadoLoadDistance_R", String.valueOf(320));
        properties.setProperty("Storm_maxDebrisParticles_R", String.valueOf(500));
        properties.setProperty("Storm_delayedTornadoChanceOutOf100", String.valueOf(30));
        properties.setProperty("Storm_forceHighStageIfLongChanceOutOf100", String.valueOf(50));
        properties.setProperty("debug_R", String.valueOf(false));
        properties.setProperty("Storm_tornadoCloudsPersistThroughBlocks_R", String.valueOf(false));
        properties.setProperty("Weather_cursedStormChanceOutOf100", String.valueOf(2));
        properties.setProperty("Misc_cullTurbineSound", String.valueOf(false));
        properties.setProperty("Misc_forceDebrisVelocityUpdates", String.valueOf(true));
        properties.setProperty("debug_enableCustomTornadoes_R", String.valueOf(true));
        properties.setProperty("Storm_passiveFirenadoChanceOutOf100", String.valueOf(1));
        properties.setProperty("Misc_cullDebrisRendering_R", String.valueOf(false));
        properties.setProperty("Misc_tornadoDetectorRange", String.valueOf(172));
        properties.setProperty("Weather_galeEnabled", String.valueOf(true));
        properties.setProperty("Weather_downpourEnabled", String.valueOf(true));
        properties.setProperty("Weather_doFreezing", String.valueOf(true));
        properties.setProperty("BlockListAdd_minecraft:barrier", "PROTECT");
        properties.setProperty("BlockListAdd_namespace:example_block", "RIP");
        properties.setProperty("BlockListAdd_namespace:example_block2", "BREAK");
        try (FileOutputStream output = new FileOutputStream(dataFile);){
            properties.store(output, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadConfig(File dataFile) {
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(dataFile);){
            properties.load(input);
            maxTornadoes = Integer.parseInt(properties.getProperty("Storm_maxTornadoes", "2"));
            maxDaysNoRain = Integer.parseInt(properties.getProperty("Weather_maxDaysNoRain", "3"));
            maxDaysNoStorm = Integer.parseInt(properties.getProperty("Weather_maxDaysNoStorm", "5"));
            maxRainNoDownpour = Integer.parseInt(properties.getProperty("Weather_maxRainNoDownpour", "5"));
            maxWindNoGale = Integer.parseInt(properties.getProperty("Weather_maxWindNoGale", "6"));
            enableGale = Boolean.parseBoolean(properties.getProperty("Weather_galeEnabled", "true"));
            enableDownpour = Boolean.parseBoolean(properties.getProperty("Weather_downpourEnabled", "true"));
            rainChanceBase = Integer.parseInt(properties.getProperty("Weather_baseRainChanceOutOf100", "62"));
            stormChanceBase = Integer.parseInt(properties.getProperty("Weather_baseStormChanceOutOf100", "35"));
            rainWorsenChance = Integer.parseInt(properties.getProperty("Weather_rainWorsenChanceOutOf100", "10"));
            tornadoDestructionLvl = Byte.parseByte(properties.getProperty("Storm_tornadoDestructionLvl", "2"));
            tornadoesBiasTowardsPlayers = Boolean.parseBoolean(properties.getProperty("Storm_tornadoesBiasTowardsPlayers", "true"));
            tornadoesExtraLongDuration = Boolean.parseBoolean(properties.getProperty("Storm_tornadoesExtraLongDuration", "false"));
            tornadoFrequency = Integer.parseInt(properties.getProperty("Storm_tornadoFrequencyOutOf100", "37"));
            waterspoutFrequency = Integer.parseInt(properties.getProperty("Storm_waterspoutFrequencyOutOf100", "50"));
            allowMultipleTornadoesSameStorm = Boolean.parseBoolean(properties.getProperty("Storm_allowMultipleTornadoes", "false"));
            maxDebrisPerTornado = Integer.parseInt(properties.getProperty("Storm_maxMovingBlocksPerTornado", "50"));
            maxMobsPerTornado = Integer.parseInt(properties.getProperty("Storm_maxMobsPerTornado", "30"));
            terrariaReference = Boolean.parseBoolean(properties.getProperty("Misc_terrariaReference", "true"));
            severeStormLightningStrikesMobs = Boolean.parseBoolean(properties.getProperty("Storm_lightningStrikesMobs", "true"));
            severeStormLightningStrikesPlayers = Boolean.parseBoolean(properties.getProperty("Storm_lightningStrikesPlayers", "true"));
            tornadoesBiasIntensityLvl = Byte.parseByte(properties.getProperty("Storm_tornadoBiasIntensityLvl", "1"));
            forceChunkRemovalOnWorldLoad = Boolean.parseBoolean(properties.getProperty("ALL_FORCE_CHUNKS_REMOVED_ON_WORLD_LOAD_DEBUG", "true"));
            stormBecomeSevereStormChance = Integer.parseInt(properties.getProperty("Weather_severeStormChanceOutOf100", "77"));
            maxTornadoLoadDistance = Integer.parseInt(properties.getProperty("Storm_maxTornadoLoadDistance_R", "320"));
            apexOnlyChance = Integer.parseInt(properties.getProperty("Storm_delayedTornadoChanceOutOf100", "30"));
            stageForceHighIfLongStormChance = Integer.parseInt(properties.getProperty("Storm_forceHighStageIfLongChanceOutOf100", "50"));
            tornadoCloudsPersistThroughBlocks = Boolean.parseBoolean(properties.getProperty("Storm_tornadoCloudsPersistThroughBlocks_R", "false"));
            cursedStormChance = Integer.parseInt(properties.getProperty("Weather_cursedStormChanceOutOf100", "2"));
            cullTurbineSound = Boolean.parseBoolean(properties.getProperty("Misc_cullTurbineSound", "false"));
            forceDebrisVelocityUpdates = Boolean.parseBoolean(properties.getProperty("Misc_forceDebrisVelocityUpdates", "true"));
            enableCustomTornadoes = Boolean.parseBoolean(properties.getProperty("debug_enableCustomTornadoes_R", "true"));
            passiveFirenadoChance = Integer.parseInt(properties.getProperty("Storm_passiveFirenadoChanceOutOf100", "1"));
            cullDebrisRendering = Boolean.parseBoolean(properties.getProperty("Misc_cullDebrisRendering_R", "false"));
            tornadoDetectorRange = Integer.parseInt(properties.getProperty("Misc_tornadoDetectorRange", "172"));
            maxDebrisParticles = Integer.parseInt(properties.getProperty("Storm_maxDebrisParticles_R", "500"));
            doFreezing = Boolean.parseBoolean(properties.getProperty("Weather_doFreezing", "true"));
            debug = Boolean.parseBoolean(properties.getProperty("debug_R", "false"));
            maxTornadoes = class_3532.method_15340((int)maxTornadoes, (int)0, (int)10);
            maxDaysNoRain = class_3532.method_15340((int)maxDaysNoRain, (int)0, (int)20);
            maxDaysNoStorm = class_3532.method_15340((int)maxDaysNoStorm, (int)0, (int)20);
            maxRainNoDownpour = class_3532.method_15340((int)maxRainNoDownpour, (int)0, (int)20);
            maxWindNoGale = class_3532.method_15340((int)maxWindNoGale, (int)0, (int)20);
            rainChanceBase = class_3532.method_15340((int)rainChanceBase, (int)0, (int)100);
            stormChanceBase = class_3532.method_15340((int)stormChanceBase, (int)0, (int)100);
            rainWorsenChance = class_3532.method_15340((int)rainWorsenChance, (int)0, (int)100);
            tornadoDestructionLvl = (byte)class_3532.method_15340((int)tornadoDestructionLvl, (int)0, (int)2);
            waterspoutFrequency = class_3532.method_15340((int)waterspoutFrequency, (int)0, (int)100);
            tornadoFrequency = class_3532.method_15340((int)tornadoFrequency, (int)0, (int)100);
            maxDebrisPerTornado = class_3532.method_15340((int)maxDebrisPerTornado, (int)0, (int)300);
            maxMobsPerTornado = class_3532.method_15340((int)maxMobsPerTornado, (int)0, (int)100);
            tornadoesBiasIntensityLvl = (byte)class_3532.method_15340((int)tornadoesBiasIntensityLvl, (int)0, (int)2);
            stormBecomeSevereStormChance = class_3532.method_15340((int)stormBecomeSevereStormChance, (int)0, (int)100);
            maxTornadoLoadDistance = class_3532.method_15340((int)maxTornadoLoadDistance, (int)256, (int)512);
            apexOnlyChance = class_3532.method_15340((int)apexOnlyChance, (int)0, (int)100);
            stageForceHighIfLongStormChance = class_3532.method_15340((int)stageForceHighIfLongStormChance, (int)0, (int)100);
            stage2Chance = class_3532.method_15340((int)stage2Chance, (int)0, (int)100);
            stage3ChanceIfNot2 = class_3532.method_15340((int)stage3ChanceIfNot2, (int)0, (int)100);
            stage4ChanceIfNot3 = class_3532.method_15340((int)stage4ChanceIfNot3, (int)0, (int)100);
            cursedStormChance = class_3532.method_15340((int)cursedStormChance, (int)0, (int)100);
            passiveFirenadoChance = class_3532.method_15340((int)passiveFirenadoChance, (int)0, (int)100);
            tornadoDetectorRange = class_3532.method_15340((int)tornadoDetectorRange, (int)16, (int)512);
            String prefix = "BlockListAdd_";
            List matchingKeys = properties.stringPropertyNames().stream().filter(k -> k.startsWith(prefix)).collect(Collectors.toList());
            for (String key : matchingKeys) {
                String value = properties.getProperty(key);
                String blockId = key.substring(prefix.length());
                TornadoDestructionInfo.BlockDestroyType type = null;
                switch (value) {
                    case "RIP": {
                        type = TornadoDestructionInfo.BlockDestroyType.RIP;
                        break;
                    }
                    case "ONLY_RIP": {
                        type = TornadoDestructionInfo.BlockDestroyType.MUST_RIP;
                        break;
                    }
                    case "RARE_RIP": {
                        type = TornadoDestructionInfo.BlockDestroyType.RARE_RIP;
                        break;
                    }
                    case "BREAK": {
                        type = TornadoDestructionInfo.BlockDestroyType.BREAK;
                        break;
                    }
                    case "PROTECT": {
                        type = TornadoDestructionInfo.BlockDestroyType.PROTECT;
                    }
                }
                WeatherClassic.LOGGER.info("Added Custom Block Info for: " + blockId);
                if (type == null) continue;
                CUSTOM_BLOCK_LIST.put(blockId, type);
            }
            WARN_DUE_TO_OUTDATED_VERSION = ModConfig.containsOutdatedInfo(properties);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean containsOutdatedInfo(Properties p) {
        return !p.containsKey("!WCV!") || Byte.parseByte(p.getProperty("!WCV!")) != 10;
    }
}

