/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.entity.breezling;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5362;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8949;
import net.minecraft.class_9749;
import net.weather_classic.entity.breezling.WindManipulator;
import net.weather_classic.global.Global;
import net.weather_classic.global.Wind;
import net.weather_classic.help.BP;
import net.weather_classic.help.Utils;
import net.weather_classic.registry.WCParticles;

public class BreezlingEntity
extends class_1308
implements WindManipulator {
    private final class_1937 world;
    private class_2338 goalPos = null;
    private float flyYaw = this.method_36454();
    private float prevFlyYaw = this.field_5982;
    private int noLosTicks = 0;
    private short chargeUpTicks = 0;
    private boolean charging = false;
    private int ticksUntilWhirlSound = 0;
    float windBodyScale = 1.0f;
    float prevWindBodyScale = 1.0f;
    private boolean isIndoors = false;
    private static final class_5362 EXPLOSION_BEHAVIOR = new class_9749(true, true, Optional.of(Float.valueOf(1.22f)), class_7923.field_41175.method_46733(class_3481.field_49051).map(Function.identity()));

    public BreezlingEntity(class_1299<? extends class_1308> entityType, class_1937 world) {
        super(entityType, world);
        this.world = world;
        this.field_6194 = 2;
    }

    public void method_5711(byte status) {
        if (status == 58) {
            this.charging = true;
        } else {
            super.method_5711(status);
        }
    }

    public void method_5773() {
        block35: {
            block31: {
                block33: {
                    block34: {
                        class_1657 player;
                        block32: {
                            boolean oos;
                            if (!this.method_5740() && !this.method_5869()) {
                                this.method_5875(true);
                            }
                            super.method_5773();
                            if (this.ticksUntilWhirlSound <= 0) {
                                this.playWhirlSound();
                            }
                            this.ticksUntilWhirlSound = this.ticksUntilWhirlSound == 0 ? this.field_5974.method_39332(1, 60) : this.ticksUntilWhirlSound - 1;
                            this.updateAngles();
                            if (this.world.method_8608()) break block31;
                            if (this.field_6012 % 120 == 0) {
                                boolean bl = this.isIndoors = !Wind.isOutsideInWindArea((class_1297)this, this.world);
                            }
                            if (this.method_5968() == null) break block32;
                            if (!this.method_6057((class_1297)this.method_5968())) {
                                ++this.noLosTicks;
                            } else if (this.noLosTicks > 0) {
                                --this.noLosTicks;
                            }
                            boolean bl = oos = this.noLosTicks > 200;
                            if (Utils.inInvalidMode((class_1297)this.method_5968()) || oos || this.method_5869()) {
                                this.method_5980(null);
                                return;
                            }
                            if (this.charging) {
                                if (this.chargeUpTicks == 45) {
                                    Utils.playSound((class_1297)this, this.world, this.method_24515(), class_3417.field_47724, class_3419.field_15251, 2.0f, 1.5f);
                                }
                                short s = this.chargeUpTicks;
                                this.chargeUpTicks = (short)(s + 1);
                                if (s > 50) {
                                    boolean close;
                                    if (this.chargeUpTicks == 55) {
                                        Utils.playSound((class_1297)this, this.world, this.method_24515(), class_3417.field_47196, class_3419.field_15251, 2.0f, 1.5f);
                                    }
                                    this.goalPos = this.method_5968().method_24515();
                                    if (this.chargeUpTicks > 100) {
                                        Utils.playSound(null, this.world, this.method_24515(), class_3417.field_47198, class_3419.field_15251, 2.0f, 1.2f);
                                        this.chargeUpTicks = 0;
                                        this.charging = false;
                                        this.goalPos = null;
                                        return;
                                    }
                                    boolean bl2 = close = Utils.distanceXYZ(this.method_19538(), Utils.convertBlockPosToVec(this.goalPos)) < 1.2;
                                    if (close || this.field_5976 || this.field_5992) {
                                        Utils.playSound(null, this.world, this.method_24515(), (class_3414)class_3417.field_49049.comp_349(), class_3419.field_15251, 1.0f, 1.2f);
                                        this.chargeUpTicks = 0;
                                        this.charging = false;
                                        this.goalPos = null;
                                        this.world.method_8454((class_1297)this, null, EXPLOSION_BEHAVIOR, (double)this.method_24515().method_10263() + 0.5, (double)this.method_24515().method_10264() + 0.5, (double)this.method_24515().method_10260() + 0.5, 1.0f, false, class_1937.class_7867.field_51779, (class_2394)class_2398.field_49139, (class_2394)class_2398.field_49140, (class_6880)class_3417.field_49044);
                                        return;
                                    }
                                } else {
                                    if (this.goalPos != null) {
                                        this.goalPos = null;
                                    }
                                    Utils.lookAtVec((class_1297)this, this.method_5968().method_33571(), 30.0f, 30.0f);
                                    this.method_5988().method_35111((class_1297)this.method_5968());
                                }
                            } else if (Utils.distanceXYZ(this.method_5968().method_24515(), this.method_24515()) > 8.0 && this.method_6057((class_1297)this.method_5968()) || this.isIndoors && this.field_6012 % 40 == 0) {
                                this.beginCharge();
                            } else if (this.goalPos != null) {
                                if (Utils.distanceXYZ(this.method_19538(), Utils.convertBlockPosToVec(this.goalPos)) < 1.2) {
                                    this.goalPos = null;
                                    return;
                                }
                                if (Utils.isVelocityZero((class_1297)this) && this.field_6012 % 40 == 0) {
                                    this.beginCharge();
                                    return;
                                }
                            } else {
                                this.goalPos = this.getRandomGoalPos(this.method_5968().method_24515(), 24, false, true);
                            }
                            break block33;
                        }
                        if (this.charging) {
                            this.charging = false;
                        }
                        if (this.noLosTicks > 0) {
                            this.noLosTicks = 0;
                        }
                        if (this.field_6012 % 40 == 0 && !this.method_5869() && (player = this.world.method_8604(this.method_23317(), this.method_23318(), this.method_23321(), this.method_45325(class_5134.field_23717), p -> !Utils.inInvalidMode(p) && this.method_6057((class_1297)p))) != null) {
                            this.method_5980((class_1309)player);
                            this.chargeUpTicks = 0;
                            return;
                        }
                        this.chargeUpTicks = 0;
                        if (this.goalPos == null) break block34;
                        if (!(Utils.distanceXYZ(this.method_19538(), Utils.convertBlockPosToVec(this.goalPos)) < 1.2) && this.field_6012 % 120 != 0) break block33;
                        this.goalPos = null;
                        if (!Utils.isVelocityZero((class_1297)this)) break block33;
                        Utils.setVelocityY((class_1297)this, -0.1);
                        break block33;
                    }
                    if (this.field_6012 % (this.isIndoors ? 120 : 10) == 0) {
                        if (this.field_5974.method_43048(4) != 0) {
                            return;
                        }
                        class_2338 center = this.method_24515();
                        for (int i = 0; i < 3; ++i) {
                            this.goalPos = this.getRandomGoalPos(center, 16, Utils.isTooHighFromGround(this.world, this.method_24515(), this.maxHeightFromGround()), false);
                            if (this.goalPos != null) break;
                        }
                    }
                }
                this.handleMovement();
                break block35;
            }
            this.prevWindBodyScale = this.windBodyScale;
            if (this.charging) {
                this.chargeUpTicks = (short)(this.chargeUpTicks + 1);
                this.windBodyScale = this.chargeUpTicks <= 40 ? 1.0f + (float)this.chargeUpTicks / 80.0f : (this.chargeUpTicks <= 55 ? 2.0f - (float)(this.chargeUpTicks - 55) / 5.0f : 1.0f);
                this.windBodyScale = Math.min(this.windBodyScale, 1.5f);
                if (this.chargeUpTicks > 60) {
                    this.charging = false;
                    this.chargeUpTicks = 0;
                }
            }
            if (this.field_6012 % 5 == 0) {
                this.world.method_8406((class_2394)WCParticles.WIND_PARTICLE, this.method_23322(2.0), this.method_23318() - 0.25 + (double)this.field_5974.method_43057(), this.method_23325(2.0), 0.0, 302.0, 0.0);
            }
        }
    }

    private void beginCharge() {
        this.charging = true;
        Utils.playSound(null, this.world, this.method_24515(), class_3417.field_47192, class_3419.field_15251, 2.0f, 1.2f);
        this.world.method_8421((class_1297)this, (byte)58);
    }

    private boolean isCharging() {
        return this.chargeUpTicks > 50 && this.method_5968() != null;
    }

    private void updateAngles() {
        this.prevFlyYaw = this.flyYaw = Utils.wrapAngleAround(this.flyYaw, this.method_5791());
        this.prevFlyYaw = Utils.wrapAngleAround(this.prevFlyYaw, this.flyYaw);
        this.flyYaw += (this.method_5791() - this.flyYaw) * 0.6f;
    }

    private void handleMovement() {
        if (this.goalPos == null) {
            return;
        }
        if (this.method_5869()) {
            if (this.method_5740()) {
                this.method_5875(false);
            }
            return;
        }
        class_243 center = Utils.convertBlockPosToVec(this.goalPos);
        Utils.lookAtVec((class_1297)this, center, 30.0f, 30.0f);
        double rads = Math.toRadians(this.flyYaw + 90.0f);
        double vx = Math.cos(rads) * this.method_45325(class_5134.field_23720) * (double)(this.isCharging() ? 4 : 1);
        double vz = Math.sin(rads) * this.method_45325(class_5134.field_23720) * (double)(this.isCharging() ? 4 : 1);
        double yVel = this.isCharging() ? 0.25 : 0.12;
        double vy = 0.0;
        if (this.method_23318() < center.method_10214() - 0.4) {
            vy = yVel;
            if (this.method_23318() < center.method_10214() - 2.0) {
                vy *= 2.0;
            }
        } else if (this.method_23318() > center.method_10214() + 0.4) {
            vy = -yVel;
            if (this.method_23318() > center.method_10214() + 2.0) {
                vy *= 2.0;
            }
        }
        this.method_18800(vx, vy, vz);
    }

    private class_2338 getRandomGoalPos(class_2338 center, int range, boolean goToGround, boolean goFar) {
        if (this.isIndoors) {
            range /= 2;
        }
        for (int i = 0; i < (this.isIndoors ? 20 : 10); ++i) {
            int dx = center.method_10263() + this.field_5974.method_43048(range) * (this.field_5974.method_43056() ? -1 : 1);
            int dy = center.method_10264() + this.field_5974.method_43048(range / 3) * (this.field_5974.method_43056() ? -1 : 1);
            int dz = center.method_10260() + this.field_5974.method_43048(range) * (this.field_5974.method_43056() ? -1 : 1);
            class_2338 pos = BP.of(dx, dy, dz);
            if (goFar && Utils.distanceXYZ(center, pos) < 8.0 && i < 8 && !this.isIndoors || goToGround && (double)pos.method_10264() >= this.method_23318() || !Utils.canSeePosDirectOnlyAir((class_1297)this, pos) || !Utils.canPassThrough((class_1936)this.world, pos)) continue;
            return pos;
        }
        return null;
    }

    public int maxHeightFromGround() {
        return 12;
    }

    public float getWindBodyScale(float tickDelta) {
        if (this.method_5869()) {
            return 0.0f;
        }
        return class_3532.method_16439((float)tickDelta, (float)this.prevWindBodyScale, (float)this.windBodyScale);
    }

    public void playWhirlSound() {
        float f = 1.0f + 0.4f * this.field_5974.method_43057();
        float g = 0.8f + 0.2f * this.field_5974.method_43057();
        this.method_37908().method_55116((class_1297)this, class_3417.field_47723, this.method_5634(), g, f);
    }

    @Override
    public class_243 getManipulationPosition() {
        return this.method_33571();
    }

    @Override
    public boolean isValid() {
        return !this.method_31481();
    }

    @Override
    public boolean isBreeze() {
        return true;
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        if (source == world.method_48963().method_48827()) {
            return false;
        }
        if (source.method_5529() != null) {
            if (source.method_5529() instanceof BreezlingEntity || source.method_5529() instanceof class_8949) {
                return false;
            }
            if (source.method_5529().method_5709() && (double)this.field_5974.method_43057() < 0.33) {
                this.method_5980((class_1309)source.method_5529());
            }
        }
        return super.method_64397(world, source, amount);
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
        this.field_6017 = 0.0;
    }

    protected class_3414 method_6002() {
        return class_3417.field_47199;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_47200;
    }

    protected class_3414 method_5994() {
        return class_3417.field_47194;
    }

    public float method_6017() {
        return (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.5f;
    }

    public boolean method_5747(double fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public int method_5978() {
        return 180;
    }

    public int method_20240() {
        return this.isIndoors ? 35 : 20;
    }

    public boolean method_5979(class_1936 world, class_3730 spawnReason) {
        return spawnReason != class_3730.field_16469 || world.method_18467(BreezlingEntity.class, this.method_5829().method_1009(36.0, 24.0, 36.0)).size() <= (world.method_8407() == class_1267.field_5807 ? 5 : 3);
    }

    public static boolean canSpawn(class_1299<BreezlingEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        if (Global.wind == null) {
            return false;
        }
        if (Global.wind.getWorld() == world && !Global.wind.gusty()) {
            return false;
        }
        return random.method_43057() < 0.75f;
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    protected boolean method_23734() {
        return true;
    }

    public boolean method_6054() {
        return true;
    }

    protected boolean method_27071() {
        return true;
    }

    public boolean isAngryAt(class_1657 player) {
        return true;
    }

    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801 && this.method_23734()) {
            this.method_31472();
        } else if (!this.method_5947() && !this.method_17326()) {
            class_1657 entity = this.method_37908().method_18460((class_1297)this, -1.0);
            if (entity != null) {
                int forceDespawnRange;
                int j;
                double d = entity.method_5858((class_1297)this);
                if (d > (double)(j = (forceDespawnRange = 64) * forceDespawnRange) && this.method_5974(d)) {
                    this.method_31472();
                }
                int despawnRange = 26;
                int l = despawnRange * despawnRange;
                if (this.field_6278 > 600 && this.field_5974.method_43048(800) == 0 && d > (double)l && this.method_5974(d)) {
                    this.method_31472();
                } else if (d < (double)l) {
                    this.field_6278 = 0;
                }
            }
        } else {
            this.field_6278 = 0;
        }
    }

    @Override
    public byte getFXIndex() {
        return 0;
    }
}

