/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.entity.flying_fish;

import com.mojang.serialization.Codec;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5761;
import net.weather_classic.global.Global;
import net.weather_classic.help.BP;
import net.weather_classic.help.Materials;
import net.weather_classic.help.Utils;
import net.weather_classic.registry.WCItems;

public class FlyingFishEntity
extends class_1480
implements class_5761 {
    private final class_1937 world;
    private class_2338 goalPos = null;
    private float flyYaw = this.method_36454();
    private float prevFlyYaw = this.field_5982;
    private int noLosTicks = 0;
    private int stillTicks;
    private boolean hopper;
    private float followOffset = 0.0f;
    private int attackCooldown = 0;
    private final byte START_FLIGHT = (byte)70;
    private final byte END_FLIGHT = (byte)71;
    private static final class_2940<Boolean> FROM_BUCKET = class_2945.method_12791(FlyingFishEntity.class, (class_2941)class_2943.field_13323);

    public FlyingFishEntity(class_1299<? extends class_1480> entityType, class_1937 world) {
        super(entityType, world);
        this.world = world;
        this.stillTicks = 50;
        this.hopper = true;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(FROM_BUCKET, (Object)false);
    }

    public boolean isTouchingAnyWater() {
        if (this.world.field_9236) {
            return this.method_5721();
        }
        return this.method_5799() || this.method_55667().method_27852(class_2246.field_10422) || this.world.method_8419() && Global.weather.isDownpour() && this.world.method_8598(class_2902.class_2903.field_13203, this.method_24515()).method_10264() <= this.method_31478();
    }

    protected void method_6673(class_3218 world, int air) {
        if (this.method_5805() && !this.isTouchingAnyWater()) {
            this.method_5855(air - 1);
            if (this.method_5669() == -20) {
                this.method_5855(0);
                this.method_64397(world, this.method_48923().method_48824(), 2.0f);
            }
        } else {
            this.method_5855(300);
        }
    }

    public void method_5773() {
        super.method_5773();
        this.updateAngles();
        if (!this.world.field_9236) {
            if (this.hopper && this.method_5740()) {
                this.method_5875(false);
            } else if (!this.hopper && !this.method_5740()) {
                this.method_5875(true);
            }
            if (this.hopper) {
                if (this.goalPos != null || this.stillTicks > 0 || this.method_5968() != null) {
                    this.goalPos = null;
                    this.stillTicks = 0;
                    this.method_5980(null);
                }
                if (this.field_6012 % 30 == 0 && !this.isTouchingAnyWater() && this.method_24828()) {
                    this.method_18799(this.method_18798().method_1031((double)((this.field_5974.method_43057() * 3.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.field_5974.method_43057() * 3.0f - 1.0f) * 0.05f)));
                    this.method_24830(false);
                    this.field_6007 = true;
                    this.method_56078(this.getFlopSound());
                }
                if (this.field_6012 % 80 == 0) {
                    class_1657 player = this.world.method_18460((class_1297)this, 8.0);
                    if (player != null && !Utils.inInvalidMode((class_1297)player)) {
                        Utils.lookAtVec((class_1297)this, player.method_33571(), 80.0f, 15.0f);
                    }
                    if (this.isTouchingAnyWater() && !Utils.isTooHighFromGround(this.world, this.method_24515(), this.maxHeightFromGround())) {
                        this.goalPos = this.getRandomGoalPos(this.method_24515(), 8);
                        if (this.goalPos != null || player != null) {
                            this.world.method_8421((class_1297)this, (byte)70);
                            this.hopper = false;
                        }
                    }
                }
                return;
            }
            if (this.goalPos != null) {
                this.handleMovement();
            }
            boolean tooHigh = false;
            if (this.field_6012 % 40 == 0 && Utils.isTooHighFromGround(this.world, this.method_24515(), this.maxHeightFromGround())) {
                tooHigh = true;
            }
            if (Utils.isVelocityZero((class_1297)this) || !this.isTouchingAnyWater() || tooHigh) {
                if (this.stillTicks++ > 40 || tooHigh) {
                    if (this.goalPos != null && this.isTouchingAnyWater() && !tooHigh) {
                        class_243 vec = this.method_33571().method_1020(Utils.convertBlockPosToVec(this.goalPos)).method_1029().method_1021(-0.5);
                        this.method_18799(vec);
                    } else {
                        this.world.method_8421((class_1297)this, (byte)71);
                        this.hopper = true;
                    }
                    return;
                }
            } else if (this.stillTicks > 0) {
                this.stillTicks = 0;
            }
            if (this.method_5968() != null) {
                boolean tooFar;
                if (!this.method_6057((class_1297)this.method_5968())) {
                    ++this.noLosTicks;
                } else if (this.noLosTicks > 0) {
                    --this.noLosTicks;
                }
                boolean oos = this.noLosTicks > 100;
                boolean bl = tooFar = this.field_6012 % 100 == 0 && Utils.distanceXYZ(this.method_24515(), this.method_5968().method_24515()) > this.method_45325(class_5134.field_23717) * 1.5;
                if (Utils.inInvalidMode((class_1297)this.method_5968()) || oos || !this.world.method_8419() || this.world.method_8407() == class_1267.field_5801 || tooFar) {
                    this.method_5980(null);
                    return;
                }
                if (this.goalPos == null || Utils.distanceXYZ(this.method_5968().method_24515(), this.goalPos) > 2.0) {
                    this.goalPos = this.method_5968().method_24515();
                }
                if (this.attackCooldown > 0) {
                    --this.attackCooldown;
                }
                if (Utils.distanceXYZ(this.method_33571(), this.method_5968().method_33571()) < 1.2 && this.attackCooldown <= 0 && this.method_6057((class_1297)this.method_5968()) && !Utils.inInvalidMode((class_1297)this)) {
                    this.method_6121((class_3218)this.world, (class_1297)this.method_5968());
                    this.attackCooldown = 30;
                }
            } else {
                class_1657 player;
                if (this.noLosTicks > 0) {
                    this.noLosTicks = 0;
                }
                if (this.field_6012 % 40 == 0 && this.world.method_8419() && this.world.method_8407() != class_1267.field_5801 && (player = this.world.method_8604(this.method_23317(), this.method_23318(), this.method_23321(), this.method_45325(class_5134.field_23717), p -> !Utils.inInvalidMode(p) && this.method_6057((class_1297)p))) != null) {
                    this.method_5980((class_1309)player);
                    return;
                }
                if (this.goalPos != null) {
                    if (Utils.distanceXYZ(this.method_19538(), Utils.convertBlockPosToVec(this.goalPos)) < 1.2 || this.field_6012 % 120 == 0) {
                        this.goalPos = null;
                    }
                } else if (this.field_6012 % 10 == 0) {
                    this.goalPos = this.getRandomGoalPos(this.method_24515(), 8);
                }
            }
        }
    }

    private void updateAngles() {
        this.prevFlyYaw = this.flyYaw = Utils.wrapAngleAround(this.flyYaw, this.method_5791());
        this.prevFlyYaw = Utils.wrapAngleAround(this.prevFlyYaw, this.flyYaw);
        this.flyYaw += (this.method_5791() - this.flyYaw) * 0.6f;
    }

    private void handleMovement() {
        if (this.field_6012 % (this.field_5976 ? 20 : 80) == 0) {
            this.followOffset = this.method_5968() != null ? this.field_5974.method_43057() * 1.5f : 0.0f;
        }
        class_243 center = Utils.convertBlockPosToVec(this.goalPos);
        Utils.lookAtVec((class_1297)this, center, 30.0f, 15.0f);
        double rads = Math.toRadians(this.flyYaw + 90.0f);
        double vx = Math.cos(rads) * this.method_45325(class_5134.field_23720) * (this.method_5799() ? 1.2 : 1.0);
        double vz = Math.sin(rads) * this.method_45325(class_5134.field_23720) * (this.method_5799() ? 1.2 : 1.0);
        double vy = this.method_23318() < center.method_10214() + (double)this.followOffset - 0.4 ? 0.12 : (this.method_23318() > center.method_10214() + (double)this.followOffset + 0.4 ? -0.12 : 0.0);
        this.method_18800(vx, vy, vz);
    }

    private class_2338 getRandomGoalPos(class_2338 center, int range) {
        for (int i = 0; i < 10; ++i) {
            int dz;
            int dy;
            int dx = center.method_10263() + this.field_5974.method_43048(range) * (this.field_5974.method_43056() ? -1 : 1);
            class_2338 pos = BP.of(dx, dy = center.method_10264() + this.field_5974.method_43048(range / 3) * (this.field_5974.method_43056() ? -1 : 1), dz = center.method_10260() + this.field_5974.method_43048(range) * (this.field_5974.method_43056() ? -1 : 1));
            if (Utils.isTooHighFromGround(this.world, pos, this.maxHeightFromGround()) || !Utils.canSeePosDirect((class_1297)this, pos) || (!Utils.canPassThrough((class_1936)this.world, pos) || !this.world.method_8520(pos)) && !Materials.isWater(this.world.method_8320(pos))) continue;
            return pos;
        }
        return center.method_10084();
    }

    public int maxHeightFromGround() {
        return 10;
    }

    public void method_5711(byte status) {
        if (status == 70) {
            this.hopper = false;
        } else if (status == 71) {
            this.hopper = true;
        } else {
            super.method_5711(status);
        }
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        if (source == world.method_48963().method_48827() && !this.hopper) {
            return false;
        }
        return super.method_64397(world, source, amount);
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
        if (!this.hopper) {
            this.field_6017 = 0.0;
        }
        super.method_5623(heightDifference, onGround, state, landedPosition);
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    public boolean method_5979(class_1936 world, class_3730 spawnReason) {
        class_2338 pos = this.method_24515();
        int i = world.method_8615();
        int j = i - 13;
        boolean water = pos.method_10264() >= j && pos.method_10264() <= i && world.method_8316(pos.method_10074()).method_15767(class_3486.field_15517) && world.method_8320(pos.method_10084()).method_27852(class_2246.field_10382);
        return water;
    }

    public int method_5945() {
        return 2;
    }

    protected class_3414 method_5994() {
        return class_3417.field_15083;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15123;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14638;
    }

    protected class_3414 getFlopSound() {
        return class_3417.field_14563;
    }

    public class_1309.class_6823 method_39760() {
        return new class_1309.class_6823(class_3417.field_14638, class_3417.field_14563);
    }

    public boolean method_6453() {
        return (Boolean)this.field_6011.method_12789(FROM_BUCKET);
    }

    public void method_6454(boolean fromBucket) {
        this.field_6011.method_12778(FROM_BUCKET, (Object)fromBucket);
    }

    public void method_6455(class_1799 stack) {
        class_5761.method_35167((class_1308)this, (class_1799)stack);
    }

    public void method_35170(class_2487 nbt) {
        class_5761.method_35168((class_1308)this, (class_2487)nbt);
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)WCItems.FLYING_FISH_BUCKET);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        return class_5761.method_35169((class_1657)player, (class_1268)hand, (class_1309)this).orElse(super.method_5992(player, hand));
    }

    public class_3414 method_35171() {
        return class_3417.field_14568;
    }

    public boolean method_17326() {
        return super.method_17326() || this.method_6453();
    }

    public boolean method_5974(double distanceSquared) {
        return !this.method_6453() && !this.method_16914();
    }

    public void method_5652(class_11372 nbt) {
        super.method_5652(nbt);
        nbt.method_71472("FromBucket", this.method_6453());
    }

    public void method_5749(class_11368 nbt) {
        super.method_5749(nbt);
        nbt.method_71426("FromBucket", (Codec)Codec.BOOL).ifPresent(b -> this.method_6454((boolean)b));
    }

    public boolean isHopping() {
        return this.hopper;
    }
}

