/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.global;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5838;
import net.minecraft.class_6017;
import net.minecraft.server.MinecraftServer;
import net.weather_classic.config.ModConfig;
import net.weather_classic.entity.breezling.WindManipulator;
import net.weather_classic.global.GlobalSoundManager;
import net.weather_classic.global.Weather;
import net.weather_classic.global.Wind;
import net.weather_classic.global.tools.WeatherEventProbabilityCalculator;
import net.weather_classic.help.Utils;
import net.weather_classic.item.WindCore;
import net.weather_classic.mixin.ServerWorldAccessor;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.clusters.StormClusterPE;
import net.weather_classic.storm.debris.DebrisEntity;
import org.joml.Vector3f;

public class Global {
    public static List<TornadoEntity> activeTornadoes = new ArrayList<TornadoEntity>();
    public static Set<class_1923> forcedTornadoChunks = new HashSet<class_1923>();
    public static GlobalSoundManager serverSoundManager = null;
    public static Wind wind = null;
    public static Weather weather = null;
    private static int timeSinceLastPlayerJoined = 0;
    private static long systemMilisecondsForSounds;
    private static int globalForecastCooldown;
    private static byte globalForecast;
    private static short forecastMessages;
    private static byte customTornadoSwitchType;
    public static List<StormClusterPE> activeClusters;
    public static Set<DebrisEntity> movingBlocks;

    public static void incrementTimeFactors(MinecraftServer server, int ticks) {
        if ((float)ticks % server.method_54833().method_54748() == 0.0f) {
            systemMilisecondsForSounds += 1000L;
        }
        if (forecastMessages > 0 && server.method_3780() % 300 == 0) {
            forecastMessages = (short)(forecastMessages - 1);
        }
        if (timeSinceLastPlayerJoined < 300 && ++timeSinceLastPlayerJoined >= 300) {
            Global.tryWarnAboutOutdatedConfig(server);
        }
        if (globalForecastCooldown > 0) {
            --globalForecastCooldown;
        }
    }

    public static void tryWarnAboutOutdatedConfig(MinecraftServer server) {
        if (ModConfig.WARN_DUE_TO_OUTDATED_VERSION) {
            server.method_3760().method_14571().forEach(p -> p.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cOutdated config file detected for Tornado Mod Classic. Please delete the existing file or rename it to allow a new config file to generate!")));
        }
    }

    public static void sendForecastMessage(List<class_1657> players, String translatable) {
        forecastMessages = (short)(forecastMessages + 1);
        for (class_1657 player : players) {
            player.method_7353((class_2561)class_2561.method_43471((String)("forecast.weather_classic." + translatable)), false);
        }
    }

    public static boolean canSendForecastMessage() {
        return forecastMessages < 7;
    }

    public static long getCurrentMilisecondsInMod() {
        return systemMilisecondsForSounds;
    }

    public static boolean playerRecentlyJoined() {
        return timeSinceLastPlayerJoined < 300;
    }

    public static void markPlayerJoined() {
        timeSinceLastPlayerJoined = 0;
    }

    public static int getPlayerJoinTime() {
        return timeSinceLastPlayerJoined;
    }

    public static boolean invalidGlobals(class_3218 world) {
        return serverSoundManager == null || wind == null || weather == null || wind.getWorld() != world || serverSoundManager.getWorld() != world || weather.getWorld() != world;
    }

    public static void setupGlobals(class_3218 world) {
        Global.markPlayerJoined();
        wind = new Wind(world);
        serverSoundManager = new GlobalSoundManager((class_1937)world);
        weather = new Weather(world);
        forecastMessages = 0;
        globalForecast = 0;
        globalForecastCooldown = 0;
        systemMilisecondsForSounds = 0L;
        customTornadoSwitchType = 0;
        activeClusters.clear();
    }

    public static void setGlobalForecastCooldown(int time) {
        globalForecastCooldown = time;
    }

    public static int getGlobalForecastCooldown() {
        return globalForecastCooldown;
    }

    public static byte getGlobalForecast() {
        return globalForecast;
    }

    public static void setGlobalForecast(byte value) {
        globalForecast = value;
    }

    public static byte retrieveGlobalForecast(class_1937 world, class_2338 pos) {
        byte current;
        if (globalForecastCooldown <= 0) {
            byte b = WeatherEventProbabilityCalculator.getLocalForecastAsByte(world, pos);
            if (b < 0) {
                return b;
            }
            globalForecast = b;
            int cooldown = world.method_8409().method_39332(4286, 10357);
            Global.setGlobalForecastCooldown(cooldown);
        }
        if ((current = WeatherEventProbabilityCalculator.getForecastForCurrentEvent(world, pos)) > -2) {
            return current;
        }
        if (globalForecast == 2 || globalForecast == 1) {
            boolean rain;
            boolean bl = rain = ((class_1959)world.method_23753(pos).comp_349()).method_48162(pos, world.method_8615()) != class_1959.class_1963.field_9383;
            if (globalForecast == 2 && !rain) {
                return globalForecast;
            }
            if (globalForecast == 1 && rain) {
                return globalForecast;
            }
            return (byte)(globalForecast == 2 && rain ? 1 : (globalForecast == 1 && !rain ? 2 : 1));
        }
        return globalForecast;
    }

    public static void forceChunksForTornadoSpawn(class_3218 world, TornadoEntity entity, class_1923 pos) {
        forcedTornadoChunks.add(pos);
        Global.addTornado(entity);
        world.method_17988(pos.field_9181, pos.field_9180, true);
        Global.normalizeTornadoChunks(world);
    }

    public static boolean forceChunksForTornado(class_3218 world, class_1923 cpos, boolean removed, boolean useLarge) {
        if (removed || !Global.canSetForced(cpos)) {
            return false;
        }
        forcedTornadoChunks.add(cpos);
        world.method_17988(cpos.field_9181, cpos.field_9180, true);
        if (useLarge) {
            for (int xx = -1; xx <= 1; ++xx) {
                for (int zz = -1; zz <= 1; ++zz) {
                    class_1923 ccc;
                    if (xx == 0 && zz == 0 || forcedTornadoChunks.contains(ccc = new class_1923(cpos.field_9181 + xx, cpos.field_9180 + zz))) continue;
                    forcedTornadoChunks.add(ccc);
                    world.method_17988(cpos.field_9181 + xx, cpos.field_9180 + zz, true);
                }
            }
        }
        Global.normalizeTornadoChunks(world);
        return true;
    }

    public static void normalizeTornadoChunks(class_3218 world) {
        HashSet<class_1923> nList = new HashSet<class_1923>();
        forcedTornadoChunks.stream().forEach(cpos -> {
            boolean stormWithin = activeTornadoes.stream().anyMatch(p -> {
                class_1923 cc = p.method_31476();
                return Math.abs(cc.field_9181 - cpos.field_9181) <= 1 && Math.abs(cc.field_9180 - cpos.field_9180) <= 1;
            });
            boolean clusterWithin = activeClusters.stream().anyMatch(p -> {
                class_1923 cc = p.getChunkPos();
                return Math.abs(cc.field_9181 - cpos.field_9181) <= 1 && Math.abs(cc.field_9180 - cpos.field_9180) <= 1;
            });
            if (!stormWithin && !clusterWithin) {
                world.method_17988(cpos.field_9181, cpos.field_9180, false);
            } else {
                nList.add((class_1923)cpos);
            }
        });
        forcedTornadoChunks = nList;
    }

    private static boolean canSetForced(class_1923 chunkPos) {
        return !forcedTornadoChunks.contains(chunkPos);
    }

    public static void removeTornado(TornadoEntity entity) {
        if (activeTornadoes.contains(entity)) {
            activeTornadoes.remove(entity);
        }
    }

    public static void addTornado(TornadoEntity entity) {
        if (!activeTornadoes.contains(entity)) {
            activeTornadoes.add(entity);
        }
    }

    public static void removeCluster(StormClusterPE entity) {
        if (activeClusters.contains(entity)) {
            activeClusters.remove(entity);
        }
    }

    public static void addCluster(StormClusterPE entity) {
        if (!activeClusters.contains(entity)) {
            activeClusters.add(entity);
        }
    }

    public static boolean overMaxTornadoes() {
        return activeTornadoes.size() > ModConfig.getMaxTornadoes();
    }

    public static boolean maxTornadoesReached() {
        return activeTornadoes.size() >= ModConfig.getMaxTornadoes();
    }

    public static boolean tornadoActive() {
        return activeTornadoes.size() > 0;
    }

    public static boolean dispelAllTornadoes() {
        for (TornadoEntity t : activeTornadoes) {
            if (t.getDying() || t.method_37908().method_8608()) continue;
            t.method_5768((class_3218)t.method_37908());
        }
        return !activeTornadoes.isEmpty();
    }

    public static boolean killAllStorms() {
        for (TornadoEntity tornadoEntity : activeTornadoes) {
            tornadoEntity.killStorm();
        }
        for (StormClusterPE stormClusterPE : activeClusters) {
            stormClusterPE.killStorm();
        }
        return !activeTornadoes.isEmpty() || !activeClusters.isEmpty();
    }

    public static StormClusterPE getClosestCluster(class_2338 pos) {
        int closest = Integer.MAX_VALUE;
        StormClusterPE cluster = null;
        for (StormClusterPE t : activeClusters) {
            int dist = (int)Utils.distanceXYZ(pos, t.getBlockPos());
            if (dist >= closest) continue;
            closest = dist;
            cluster = t;
        }
        return cluster;
    }

    public static StormClusterPE getClosestClusterNoTornado(class_2338 pos) {
        int closest = Integer.MAX_VALUE;
        StormClusterPE cluster = null;
        for (StormClusterPE t : activeClusters) {
            int dist;
            if (Global.doesClusterHaveTornado(t) || (dist = (int)Utils.distanceXYZ(pos, t.getBlockPos())) >= closest) continue;
            closest = dist;
            cluster = t;
        }
        return cluster;
    }

    public static boolean doesClusterHaveTornado(StormClusterPE cluster) {
        return activeTornadoes.stream().anyMatch(p -> p.getBoundCluster() != null && p.getBoundCluster().getId().equals(cluster.getId()));
    }

    public static TornadoEntity getClosestTornado(class_243 vec) {
        int closest = Integer.MAX_VALUE;
        TornadoEntity tornado = null;
        for (TornadoEntity t : activeTornadoes) {
            int dist = (int)Utils.distanceXYZ(vec, t.method_19538());
            if (dist >= closest) continue;
            closest = dist;
            tornado = t;
        }
        return tornado;
    }

    public static TornadoEntity getClosestTornado(class_2338 pos) {
        int closest = Integer.MAX_VALUE;
        TornadoEntity tornado = null;
        for (TornadoEntity t : activeTornadoes) {
            int dist = (int)Utils.distanceXYZ(pos, t.method_24515());
            if (dist >= closest) continue;
            closest = dist;
            tornado = t;
        }
        return tornado;
    }

    public static TornadoEntity getClosestOtherTornado(TornadoEntity ent) {
        int closest = Integer.MAX_VALUE;
        TornadoEntity tornado = null;
        for (TornadoEntity t : activeTornadoes) {
            int dist;
            if (t == ent || (dist = (int)Utils.distanceXYZ(ent.method_19538(), t.method_19538())) >= closest) continue;
            closest = dist;
            tornado = t;
        }
        return tornado;
    }

    public static void messageServer(String message, class_3218 world) {
        for (class_1657 player : world.method_18456()) {
            player.method_7353((class_2561)class_2561.method_43470((String)message), false);
        }
    }

    public static List<class_3222> getGlobalPlayers(class_3218 world) {
        return world.method_8503().method_3760().method_14571();
    }

    public static void setRaining(class_3218 globalWorld) {
        globalWorld.method_27910(0, Global.processDuration(globalWorld, class_3218.field_41750), true, false);
    }

    public static void setThundering(class_3218 globalWorld) {
        globalWorld.method_27910(0, Global.processDuration(globalWorld, class_3218.field_41751), true, true);
    }

    public static void setClear(class_3218 globalWorld) {
        globalWorld.method_27910(Global.processDuration(globalWorld, class_3218.field_41749), 0, false, false);
    }

    private static int processDuration(class_3218 world, class_6017 provider) {
        return provider.method_35008(world.method_8409());
    }

    public static boolean playersSkippingNight(class_3218 world) {
        if (!world.method_64395().method_8355(class_1928.field_19396)) {
            return false;
        }
        int i = world.method_64395().method_8356(class_1928.field_28357);
        class_5838 manager = ((ServerWorldAccessor)world).getSleepManager();
        return manager.method_33812(i) && manager.method_33813(i, world.method_18456());
    }

    public static Vector3f getGlobalWindVector() {
        double radians = Math.toRadians(wind.getWindAngle() + 90);
        double moveX = (double)wind.getWindStrength() * Math.cos(radians);
        double moveZ = (double)wind.getWindStrength() * Math.sin(radians);
        Vector3f vec = new Vector3f((float)moveX, 0.0f, (float)moveZ);
        return vec;
    }

    public static class_243 getGlobalWindVectorForPosition(class_243 ref) {
        TornadoEntity ent;
        if (!activeTornadoes.isEmpty() && (ent = Global.getClosestTornado(ref)) != null) {
            class_243 vec = ent.method_33571().method_1020(ref).method_1029().method_18805((double)0.057f, 0.0, (double)0.057f);
            return vec;
        }
        double radians = Math.toRadians(wind.getWindAngle() + 90);
        double moveX = (double)wind.getWindStrength() * Math.cos(radians);
        double moveZ = (double)wind.getWindStrength() * Math.sin(radians);
        class_243 vec = new class_243((double)((float)moveX), 0.0, (double)((float)moveZ));
        return vec;
    }

    public static WindManipulator getBreezeForManipulation(class_1937 world, class_2338 pos) {
        List entities = world.method_8333(null, new class_238(pos).method_1009(2.0, 2.0, 2.0), p -> p instanceof WindManipulator && !p.method_31747());
        if (!entities.isEmpty()) {
            return (WindManipulator)entities.get(0);
        }
        return null;
    }

    public static WindManipulator getPlayerForManipulation(class_1937 world, class_243 particle) {
        class_1657 player = world.method_8604(particle.field_1352, particle.field_1351, particle.field_1350, 16.0, p -> Utils.canSeeVec(world, particle, p.method_33571()));
        if (player != null && player.method_6030().method_7909() instanceof WindCore && player.method_6115() && Math.abs(player.method_23320() - particle.field_1351) < 5.0) {
            return (WindManipulator)player;
        }
        return null;
    }

    public static WindManipulator getPlayerForManipulation(class_1937 world, class_2338 pos) {
        class_1657 player = world.method_8604((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 16.0, p -> Utils.canSeePos(world, p.method_33571(), pos));
        if (player != null && player.method_6030().method_7909() instanceof WindCore && player.method_6115() && Math.abs(player.method_23320() - (double)pos.method_10264()) < 5.0) {
            return (WindManipulator)player;
        }
        return null;
    }

    public static byte getCustomTornadoSwitchType() {
        return customTornadoSwitchType;
    }

    public static void setCustomTornadoSwitchType(byte b) {
        customTornadoSwitchType = b;
    }

    public static List<TornadoEntity> getAllActiveCustomTornadoes() {
        if (activeTornadoes.isEmpty()) {
            return List.of();
        }
        return activeTornadoes.stream().filter(p -> p.getTornadoType() == 5).toList();
    }

    static {
        globalForecastCooldown = 0;
        globalForecast = 0;
        forecastMessages = 0;
        customTornadoSwitchType = 0;
        activeClusters = new ArrayList<StormClusterPE>();
        movingBlocks = new HashSet<DebrisEntity>();
    }
}

