/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.global;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5544;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.weather_classic.WeatherClassic;
import net.weather_classic.block.PuddleBlock;
import net.weather_classic.config.CustomTornadoConfig;
import net.weather_classic.config.ModConfig;
import net.weather_classic.entity.flying_fish.FlyingFishEntity;
import net.weather_classic.entity.waddler.WaddlerEntity;
import net.weather_classic.global.Global;
import net.weather_classic.global.IGlobal;
import net.weather_classic.global.Wind;
import net.weather_classic.global.tools.TornadoReviver;
import net.weather_classic.global.tools.WeatherEventProbabilityCalculator;
import net.weather_classic.global.tools.WeatherExecutor;
import net.weather_classic.help.MutableTriplet;
import net.weather_classic.help.Utils;
import net.weather_classic.mixin.ServerWorldAccessor;
import net.weather_classic.networking.WCNetworkServer;
import net.weather_classic.registry.WCBlocks;
import net.weather_classic.registry.WCEntities;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.TornadoStats;
import net.weather_classic.storm.clusters.StormClusterPE;

public class Weather
implements IGlobal {
    private final class_3218 world;
    private boolean prevDownpour = false;
    private boolean downpour = false;
    private boolean wasRaining;
    private int daysSinceDownpour = 0;
    private boolean force = false;
    private boolean currentStorm;
    private int daysSinceStorm = 0;
    private int daysSinceRain = 0;
    private int stormTicks = 0;
    private WeatherExecutor we = null;
    private short severeStormTransitionTicks = 0;
    private short prevSevereStormTransitionTicks = 0;
    private short downpourTransitionTicks = 0;
    private short prevDownpourTransitionTicks = 0;
    private boolean wasSevereStorm = false;
    private int stormThreshold;
    private boolean tornadoTokenUsed = false;
    private List<TornadoReviver> revivers = new ArrayList<TornadoReviver>();
    private byte prevStormStage = 0;
    private byte stormStage = 0;
    private short[] stormStageProfile = new short[3];
    private boolean stormDying = false;
    private MutableTriplet<Pair<Integer, Short>, Boolean, Float> stagnationData = null;
    private boolean forceWeatherUpdates = false;
    private byte stageGoal = 0;
    private int totalRainTimeForStorm;
    private double stageGoalPercentageThreshold;
    private boolean usingDumbStormIntensity = false;
    private float dumbStormIntensityIncChance;
    private boolean apexOnly = false;
    private boolean cursed = false;
    private boolean manualStageAdjustment = false;

    public Weather(class_3218 world) {
        this.world = world;
        this.wasRaining = world.method_8419();
        this.currentStorm = world.method_8546();
        this.updateStormThreshold(false);
        this.updateStormStageProfile();
    }

    public void tick() {
        if (this.forceWeatherUpdates) {
            this.forceWeatherUpdates = false;
        }
        if (!this.revivers.isEmpty()) {
            Iterator<TornadoReviver> iterator = this.revivers.iterator();
            while (iterator.hasNext()) {
                TornadoReviver next = iterator.next();
                next.update();
                if (!next.isDone()) continue;
                iterator.remove();
            }
        }
        if (this.we != null) {
            if (this.world.method_8419() && !this.we.isDone()) {
                this.we = null;
                return;
            }
            this.we.update();
            if (this.we.isDone()) {
                this.we = this.we.shouldWorsen() ? new WeatherExecutor(this.world, WeatherExecutor.WeatherToExecute.THUNDER, Optional.of(3600 + this.world.method_8409().method_43048(5000))) : null;
            }
        }
        this.updateDownpourStatusByDay();
        if (this.downpour) {
            if (this.downpourTransitionTicks < 50) {
                this.downpourTransitionTicks = (short)(this.downpourTransitionTicks + 1);
            }
        } else if (this.downpourTransitionTicks > 0) {
            this.downpourTransitionTicks = (short)(this.downpourTransitionTicks - 1);
        }
        this.updateStormIntensity();
        this.updateRainAndStormStatusByDay(Global.playersSkippingNight(this.world));
        if (this.world.method_8510() % 50L == 0L) {
            if (CustomTornadoConfig.getSpawnPercent() > 0.0f && CustomTornadoConfig.getWeatherEventType() <= 3 && !this.isSevereStorm()) {
                switch (CustomTornadoConfig.getWeatherEventType()) {
                    case 1: {
                        if (!this.world.method_8419() || this.world.method_8546() || this.isDownpour()) break;
                        this.tickTornadoSpawning(TornadoStats.Type.STAGEX.getByte(), 10, 4);
                        break;
                    }
                    case 2: {
                        if (!this.isDownpour() || this.world.method_8546()) break;
                        this.tickTornadoSpawning(TornadoStats.Type.STAGEX.getByte(), 10, 4);
                        break;
                    }
                    case 3: {
                        if (!this.isStormStage2() || this.isStormStage2Severe()) break;
                        this.tickTornadoSpawning(TornadoStats.Type.STAGEX.getByte(), 10, 4);
                        break;
                    }
                    default: {
                        if (!Global.wind.isGale() || this.world.method_8419() || this.world.method_8546()) break;
                        this.tickTornadoSpawning(TornadoStats.Type.STAGEX.getByte(), 10, 4);
                    }
                }
            }
            if (this.cursed && !TornadoEntity.invalidForDemon((class_1937)this.world)) {
                this.tickTornadoSpawning(TornadoStats.Type.fromSevereStormStage((byte)1), 12, 6);
            } else if (this.isSevereStorm()) {
                this.tickTornadoSpawning(TornadoStats.Type.fromSevereStormStage(this.stormStage), 12, 6);
            } else if (this.world.method_8419() && !this.world.method_8546() && Global.wind.gusty()) {
                this.tickTornadoSpawning(TornadoStats.Type.SPOUT.getByte(), 8, 1);
            }
        }
        if (this.world.method_18456().isEmpty()) {
            return;
        }
        if (this.downpour && this.world.method_8510() % 40L == 0L && this.world.method_8409().method_43048(4) == 0) {
            this.populateRainPuddles();
        }
    }

    private void updateStormIntensity() {
        if (!this.shouldTransitionToSevereStorm() && this.severeStormTransitionTicks > 0) {
            this.severeStormTransitionTicks = (short)(this.severeStormTransitionTicks - 1);
        }
        if (!this.world.method_8546()) {
            if (this.currentStorm) {
                this.endStorm();
            } else if (this.stormStage > 0) {
                this.stormStage = 0;
            }
            return;
        }
        if (!this.currentStorm) {
            this.startStorm();
        }
        if (this.shouldTransitionToSevereStorm() && this.severeStormTransitionTicks < 50) {
            this.severeStormTransitionTicks = (short)(this.severeStormTransitionTicks + 1);
        }
        if (this.isStormStage5() && Global.getCustomTornadoSwitchType() == 1) {
            Global.setCustomTornadoSwitchType((byte)0);
            WCNetworkServer.forceBigUpdate();
        }
        this.stormStage = (byte)(this.stormTicks > this.stormStageProfile[2] ? 3 : (this.stormTicks > this.stormStageProfile[1] ? 2 : (this.stormTicks > this.stormStageProfile[0] ? 1 : 0)));
        if (this.stormDying) {
            if (this.stormTicks > 0) {
                if (this.apexOnly || this.world.method_8510() % 2L == 0L) {
                    --this.stormTicks;
                }
            } else {
                Global.setClear(this.world);
            }
        } else if (!this.isStagnating()) {
            this.increaseTicks();
        }
        if (this.world.method_8510() % 100L == 0L) {
            if (this.isStagnating()) {
                if (this.world.method_8409().method_43057() < this.stagnationData.getC().floatValue()) {
                    this.stagnationData = null;
                }
            } else {
                boolean beginStagnate;
                boolean bl = beginStagnate = this.world.method_8409().method_43057() < 0.015f || this.stormTicks > class_3218.field_41751.method_35011();
                if (!this.isSevereStorm()) {
                    beginStagnate = false;
                }
                if (beginStagnate) {
                    this.stagnate();
                }
            }
            if (ModConfig.getSevereStormLightningStrikesPlayers()) {
                for (class_1657 class_16572 : this.getRandomPlayers(3)) {
                    if (class_16572.method_59922().method_43057() > Weather.getSevereStormLightningAggressionForFloat() || Utils.isTooHighFromGround((class_1937)this.world, class_16572.method_24515(), 3) || Utils.inInvalidMode((class_1297)class_16572) || !this.world.method_8520(class_16572.method_24515()) || class_16572.method_5799()) continue;
                    class_2338 pos = class_16572.method_24515();
                    int y = pos.method_10264();
                    if ((double)this.world.method_8409().method_43057() < 0.3) {
                        pos = pos.method_10079(Utils.randomHorizontal(this.world.field_9229), this.world.method_8409().method_43048(5));
                        pos = this.world.method_8409().method_43056() ? pos.method_10079(Utils.randomHorizontal(this.world.field_9229), this.world.method_8409().method_43048(5)) : pos;
                        y = this.world.method_8598(class_2902.class_2903.field_13197, pos).method_10264();
                        pos = new class_2338(pos.method_10263(), y + 1, pos.method_10260());
                    }
                    if (Math.abs(class_16572.method_24515().method_10264() - y) > 16) continue;
                    class_1538 lightningEntity = (class_1538)class_1299.field_6112.method_5883((class_1937)this.world, class_3730.field_16459);
                    lightningEntity.method_29495(class_243.method_24955((class_2382)pos));
                    lightningEntity.method_29498(false);
                    this.world.method_8649((class_1297)lightningEntity);
                    break;
                }
            }
            if (this.world.method_8510() % 200L == 0L) {
                if (this.isStormStage5()) {
                    this.world.method_18456().forEach(p -> WeatherClassic.WEATHER_ENCOUNTERED.trigger((class_3222)p, this.getStormStage()));
                }
                if (this.cursed && this.world.field_9229.method_43048(3) == 0 && !TornadoEntity.invalidForDemon((class_1937)this.world)) {
                    this.getRandomPlayers(1).forEach(p -> {
                        if (!p.method_7325()) {
                            WeatherClassic.curseWithStormFury((class_1309)p, true);
                        }
                    });
                }
            }
        }
    }

    public byte getRandomWeightedStormStageGoal() {
        if (this.world.method_8409().method_43057() < (float)ModConfig.getStage2Chance() / 100.0f) {
            return -1;
        }
        if (this.world.method_8409().method_43057() < (float)ModConfig.getStage3ChanceIfNot2() / 100.0f) {
            return 0;
        }
        if (this.world.method_8409().method_43057() < (float)ModConfig.getStage4ChanceIfNot3() / 100.0f) {
            return 1;
        }
        return 2;
    }

    private void increaseTicks() {
        int goalToReach;
        if (!this.isSevereStorm()) {
            ++this.stormTicks;
            return;
        }
        if (this.usingDumbStormIntensity) {
            if (this.world.method_8510() % 400L == 0L) {
                // empty if block
            }
            if (this.world.method_8409().method_43057() < this.dumbStormIntensityIncChance) {
                ++this.stormTicks;
            }
            return;
        }
        int rainTimeLeft = this.getCurrentRainTime();
        int totalRainTime = this.totalRainTimeForStorm;
        int ticks = this.stormTicks;
        int n = goalToReach = this.stageGoal < 0 ? this.stormStageProfile[0] - 100 : this.stormStageProfile[this.stageGoal] + 300;
        if (this.stormTicks >= goalToReach) {
            this.usingDumbStormIntensity = true;
            return;
        }
        double percentageThreshold = this.stageGoalPercentageThreshold;
        int timeThreshold = (int)Math.ceil((double)totalRainTime * (percentageThreshold / 100.0));
        timeThreshold = Math.min(timeThreshold, (double)this.dumbStormIntensityIncChance >= 0.5 ? 12800 : 6400);
        if (this.world.method_8510() % 100L == 0L) {
            // empty if block
        }
        if (rainTimeLeft > timeThreshold) {
            int totalAllowedTicks = goalToReach - ticks;
            int timeUntilThreshold = Math.max(1, rainTimeLeft - timeThreshold);
            byte add = (byte)((this.stageGoal > 0 ? this.stormThreshold % 2 == 0 : false) ? 1 : 0);
            if (this.stageGoal < 0) {
                add = (byte)(totalRainTime > 10000 ? 7 : 4);
            }
            int tickRate = Math.max(1, timeUntilThreshold / Math.max(1, totalAllowedTicks)) + add;
            int inc = 1;
            if (timeUntilThreshold < 2000 && totalAllowedTicks > 1200) {
                inc = 2;
            }
            if (this.world.method_8510() % (long)tickRate == 0L) {
                this.stormTicks += inc;
            }
            return;
        }
        this.usingDumbStormIntensity = true;
    }

    private void stagnate() {
        short s = (short)(200 + this.world.method_8409().method_43048(700));
        float breakFree = 0.2f;
        this.stagnationData = MutableTriplet.of(Pair.of((Object)this.stormTicks, (Object)s), this.world.method_8409().method_43056(), Float.valueOf(breakFree));
    }

    public List<class_3222> getRandomPlayers(int size) {
        List newList = this.world.method_18456();
        Collections.shuffle(newList);
        return newList.subList(0, Math.min(newList.size(), size));
    }

    private void tickTornadoSpawning(byte type, int range, int minChunksDist) {
        float prob;
        boolean cursedAndSpawn;
        if (this.world.method_8510() % 1000L != 0L || Global.maxTornadoesReached() || this.tornadoTokenUsed) {
            return;
        }
        boolean spout = type <= 0;
        boolean manualProb = type >= 5 && CustomTornadoConfig.getWeatherEventType() <= 3;
        float i = this.getStormIntensity();
        boolean bl = cursedAndSpawn = this.cursed && !TornadoEntity.invalidForDemon((class_1937)this.world);
        if (!(spout || manualProb || cursedAndSpawn)) {
            float intensityTH;
            float f = this.isStormStage2Severe() ? 0.5f : (intensityTH = this.isStormStage5() ? 1.05f : 0.25f);
            if (this.apexOnly) {
                intensityTH += 0.3f;
                if (this.isStormStage5()) {
                    intensityTH = 1.08f;
                }
            }
            if (i < intensityTH) {
                return;
            }
        }
        float rarityInc = this.isStormDying() ? (ModConfig.getAllowMultipleTornadoesSameStorm() ? 0.55f : 0.77f) : (manualProb ? 0.33f : (this.isStormStage2Severe() ? 0.11f : 0.22f));
        byte accurateStageGoal = (byte)(this.stageGoal + 1);
        if (accurateStageGoal > this.stormStage && !manualProb) {
            rarityInc = 0.7f;
            rarityInc = accurateStageGoal > this.stormStage + 2 ? (float)((double)rarityInc + 0.25) : (accurateStageGoal > this.stormStage + 1 ? (rarityInc += 0.2f) : (rarityInc += 0.12f));
            if (this.isStagnating()) {
                return;
            }
        }
        rarityInc = class_3532.method_15363((float)rarityInc, (float)0.0f, (float)1.0f);
        if (cursedAndSpawn) {
            rarityInc = 0.0f;
        }
        if (this.world.method_8409().method_43057() < rarityInc) {
            return;
        }
        float f = manualProb || CustomTornadoConfig.getWeatherEventType() == 8 && this.isStage6() ? CustomTornadoConfig.getSpawnPercent() : (prob = spout ? ModConfig.getWaterspoutFrequency() : ModConfig.getTornadoFrequency());
        if (Global.tornadoActive()) {
            if (!(spout || manualProb || ModConfig.getAllowMultipleTornadoesSameStorm())) {
                this.tornadoTokenUsed = true;
                return;
            }
            prob = (float)((double)prob * 0.5);
        }
        if (this.world.method_8409().method_43057() < prob) {
            boolean replaceWithCustom = false;
            if (type < 5 && CustomTornadoConfig.getWeatherEventType() > 3 && CustomTornadoConfig.getSpawnPercent() > 0.0f) {
                switch (CustomTornadoConfig.getWeatherEventType()) {
                    case 4: {
                        if (!this.isStormStage2Severe()) break;
                        replaceWithCustom = this.world.method_8409().method_43057() < CustomTornadoConfig.getSpawnPercent();
                        break;
                    }
                    case 5: {
                        if (!this.isStormStage3()) break;
                        replaceWithCustom = this.world.method_8409().method_43057() < CustomTornadoConfig.getSpawnPercent();
                        break;
                    }
                    case 6: {
                        if (!this.isStormStage4()) break;
                        replaceWithCustom = this.world.method_8409().method_43057() < CustomTornadoConfig.getSpawnPercent();
                        break;
                    }
                    case 7: {
                        if (!this.isStormStage5()) break;
                        replaceWithCustom = this.world.method_8409().method_43057() < CustomTornadoConfig.getSpawnPercent();
                        break;
                    }
                    case 8: {
                        if (!this.isStage6()) break;
                        replaceWithCustom = true;
                    }
                }
            }
            boolean demon = false;
            if (cursedAndSpawn) {
                type = 1;
                demon = true;
                replaceWithCustom = false;
            }
            this.trySpawnTornado(range, minChunksDist, replaceWithCustom ? TornadoStats.Type.STAGEX.getByte() : type, this.getRandomPlayers(4), true, demon);
        }
    }

    public boolean isStagnating() {
        return this.stagnationData != null;
    }

    public void forceTornado(UUID id) {
        class_1657 player = this.world.method_18470(id);
        if (player == null || player.method_37908().method_27983() != class_1937.field_25179 || !(player instanceof class_3222)) {
            return;
        }
        ArrayList players = Lists.newArrayList((Object[])new class_3222[]{(class_3222)player});
        if (!Global.maxTornadoesReached()) {
            boolean spawned = false;
            if (CustomTornadoConfig.getSpawnPercent() > 0.0f && CustomTornadoConfig.getWeatherEventType() <= 3 && !this.isSevereStorm()) {
                switch (CustomTornadoConfig.getWeatherEventType()) {
                    case 1: {
                        if (!this.world.method_8419() || this.world.method_8546() || this.isDownpour()) break;
                        this.trySpawnTornado(10, 4, TornadoStats.Type.STAGEX.getByte(), players, false, false);
                        spawned = true;
                        break;
                    }
                    case 2: {
                        if (!this.isDownpour() || this.world.method_8546()) break;
                        this.trySpawnTornado(10, 4, TornadoStats.Type.STAGEX.getByte(), players, false, false);
                        spawned = true;
                        break;
                    }
                    case 3: {
                        if (!this.world.method_8546() || this.isSevereStorm()) break;
                        this.trySpawnTornado(10, 4, TornadoStats.Type.STAGEX.getByte(), players, false, false);
                        spawned = true;
                        break;
                    }
                    default: {
                        if (!Global.wind.isGale() || this.world.method_8419() || this.world.method_8546()) break;
                        this.trySpawnTornado(10, 4, TornadoStats.Type.STAGEX.getByte(), players, false, false);
                        spawned = true;
                    }
                }
            }
            if (spawned) {
                return;
            }
            if (this.isSevereStorm()) {
                boolean replaceWithCustom = false;
                if (CustomTornadoConfig.getWeatherEventType() > 3 && CustomTornadoConfig.getSpawnPercent() > 0.0f) {
                    switch (CustomTornadoConfig.getWeatherEventType()) {
                        case 4: {
                            if (!this.isStormStage2Severe()) break;
                            replaceWithCustom = this.world.method_8409().method_43057() < CustomTornadoConfig.getSpawnPercent();
                            break;
                        }
                        case 5: {
                            if (!this.isStormStage3()) break;
                            replaceWithCustom = this.world.method_8409().method_43057() < CustomTornadoConfig.getSpawnPercent();
                            break;
                        }
                        case 6: {
                            if (!this.isStormStage4()) break;
                            replaceWithCustom = this.world.method_8409().method_43057() < CustomTornadoConfig.getSpawnPercent();
                            break;
                        }
                        case 7: {
                            if (!this.isStormStage5()) break;
                            replaceWithCustom = this.world.method_8409().method_43057() < CustomTornadoConfig.getSpawnPercent();
                            break;
                        }
                        case 8: {
                            if (!this.isStage6()) break;
                            replaceWithCustom = true;
                        }
                    }
                }
                this.trySpawnTornado(10, 4, replaceWithCustom ? TornadoStats.Type.STAGEX.getByte() : TornadoStats.Type.fromSevereStormStage(this.stormStage), players, false, false);
            } else if (this.world.method_8419() && !this.world.method_8546()) {
                this.trySpawnTornado(8, 1, TornadoStats.Type.SPOUT.getByte(), players, false, false);
            } else {
                this.trySpawnTornado(10, 4, TornadoStats.Type.STAGE2.getByte(), players, false, false);
            }
        }
    }

    public boolean trySpawnTornado(int range, int minChunksDist, byte type, List<class_3222> list, boolean affectStormStage, boolean demon) {
        for (class_1657 class_16572 : list) {
            StormClusterPE cluster;
            class_1923 cpos = class_16572.method_31476();
            ArrayList<class_1923> validChunks = new ArrayList<class_1923>();
            for (int xx = cpos.field_9181 - range; xx < cpos.field_9181 + range; ++xx) {
                for (int zz = cpos.field_9180 - range; zz < cpos.field_9180 + range; ++zz) {
                    int height;
                    boolean valid;
                    class_1923 c = new class_1923(xx, zz);
                    if (Utils.distanceXZ(cpos.method_8323(), c.method_8323()) < (double)(16 * minChunksDist) || !(valid = this.validBiomeOrRegion(type, c.method_33943(height = this.world.method_8598(class_2902.class_2903.field_13197, c.method_33943(128)).method_10264() - 1)))) continue;
                    validChunks.add(c);
                }
            }
            if (validChunks.isEmpty()) continue;
            class_1923 chosen = (class_1923)validChunks.get(this.world.method_8409().method_43048(validChunks.size()));
            int height = this.world.method_8598(class_2902.class_2903.field_13197, chosen.method_33943(128)).method_10264();
            class_2338 pos = chosen.method_33943(height);
            StormClusterPE c = null;
            if (!Global.activeClusters.isEmpty() && !demon && (cluster = Global.getClosestClusterNoTornado(pos)) != null) {
                c = cluster;
                if (type == TornadoStats.Type.STAGE2.getByte()) {
                    type = TornadoStats.Type.STAGE3.getByte();
                }
            }
            TornadoEntity storm = new TornadoEntity(TornadoEntity.getEntityTypeFrom(type), (class_1937)this.world);
            Global.forceChunksForTornadoSpawn(this.world, storm, chosen);
            storm.method_5725(pos, 0.0f, 0.0f);
            if (storm.getStats().hasDemons && demon) {
                storm.asDemon();
            } else if (c != null) {
                storm.method_5725(c.getBlockPos(), 0.0f, 0.0f);
                storm.bindToCluster(c);
            }
            this.world.method_8649((class_1297)storm);
            if (affectStormStage && this.isSevereStorm()) {
                this.stormDying = this.world.method_8409().method_43057() < this.tornadoCauseStormToDieChance();
                this.buffStormTimeSlightly();
            }
            return true;
        }
        return false;
    }

    public float tornadoCauseStormToDieChance() {
        return ModConfig.getAllowMultipleTornadoesSameStorm() ? 0.65f : 0.8f;
    }

    private boolean validBiomeOrRegion(byte tornado, class_2338 pos) {
        boolean customWithReq;
        boolean spout = tornado <= 0;
        boolean bl = customWithReq = tornado >= 5 && CustomTornadoConfig.getBiomeLockType() > 0;
        if (!spout && !customWithReq) {
            return true;
        }
        boolean water = this.world.method_8320(pos).method_27852(class_2246.field_10382);
        if (spout) {
            return water;
        }
        class_6880 biome = this.world.method_23753(pos);
        switch (CustomTornadoConfig.getBiomeLockType()) {
            case 1: {
                return Utils.isBiomeForest((class_6880<class_1959>)biome);
            }
            case 2: {
                return ((class_5321)biome.method_40230().get()).method_29177().method_12832().contains("plains");
            }
            case 3: {
                return ((class_5321)biome.method_40230().get()).method_29177().method_12832().contains("desert") || ((class_5321)biome.method_40230().get()).method_29177().method_12832().contains("badlands");
            }
            case 4: {
                return biome.method_40220(class_6908.field_36512) || ((class_5321)biome.method_40230().get()).method_29177().method_12832().contains("windswept");
            }
            case 5: {
                return water;
            }
        }
        return true;
    }

    private void updateRainAndStormStatusByDay(boolean force) {
        if (this.world.method_8510() % 24000L == 0L || force) {
            if (force) {
                Global.setGlobalForecastCooldown(0);
            }
            if (this.we == null) {
                class_5819 r;
                boolean thunder = false;
                if (!this.world.method_8546()) {
                    ++this.daysSinceStorm;
                    r = this.world.method_8409();
                    thunder = WeatherEventProbabilityCalculator.shouldStorm((class_1937)this.world, r, this.daysSinceStorm, false);
                    if (thunder) {
                        this.sendStorm(Optional.empty(), false);
                    }
                    if ((double)this.world.method_8409().method_43057() < 0.03 && this.world.method_8407() != class_1267.field_5801) {
                        for (class_1657 class_16572 : this.getRandomPlayers(3)) {
                            if (class_16572.method_31478() > 50 || Wind.isOutsideInWindArea((class_1297)class_16572, (class_1937)this.world)) continue;
                            Iterator iterator = class_2338.method_10097((class_2338)class_16572.method_24515().method_10069(24, 6, 24), (class_2338)class_16572.method_24515().method_10069(-24, -6, -24)).iterator();
                            boolean end = false;
                            while (iterator.hasNext()) {
                                class_2338 next = (class_2338)iterator.next();
                                if (Utils.canPassThrough((class_1936)this.world, next.method_10074()) || !Utils.canPassThrough((class_1936)this.world, next) || !Utils.canPassThrough((class_1936)this.world, next.method_10084()) || Utils.canSeeFair((class_1297)class_16572, next) || Wind.isOutsideInWindArea(new class_243((double)next.method_10263() + 0.5, (double)next.method_10264() + 0.5, (double)next.method_10260() + 0.5), (class_1937)this.world)) continue;
                                WaddlerEntity wad = new WaddlerEntity(WCEntities.WADDLER, (class_1937)this.world);
                                wad.method_5725(next, 0.0f, 0.0f);
                                this.world.method_8649((class_1297)wad);
                                end = true;
                                break;
                            }
                            if (!end) continue;
                            break;
                        }
                    }
                }
                if (!thunder && !this.world.method_8419()) {
                    ++this.daysSinceRain;
                    r = this.world.method_8409();
                    boolean rain = WeatherEventProbabilityCalculator.shouldRain(r, this.daysSinceRain);
                    if (rain) {
                        this.sendRain(r.method_43057() < (float)ModConfig.getRainWorsenChance() / 100.0f);
                        if ((double)r.method_43057() < 0.1) {
                            this.daysSinceStorm = 0;
                        }
                    }
                }
            }
        }
    }

    public WeatherExecutor.WeatherToExecute getWeatherExecutor() {
        return this.we != null ? this.we.getWeather() : null;
    }

    public boolean isSevereStorm() {
        return this.severeStormTransitionTicks > 0;
    }

    public boolean isSevereStormTransitioning() {
        return this.prevSevereStormTransitionTicks != this.severeStormTransitionTicks;
    }

    private boolean shouldTransitionToSevereStorm() {
        return this.stormTicks > this.stormThreshold;
    }

    public int getStormTicks() {
        return this.stormTicks;
    }

    public int getStormThreshold() {
        return this.stormThreshold;
    }

    public int getDaysSinceStorm() {
        return this.daysSinceStorm;
    }

    public int getDaysSinceRain() {
        return this.daysSinceRain;
    }

    public boolean isStorming() {
        return this.currentStorm;
    }

    public byte getStormStage() {
        return this.stormStage;
    }

    public boolean isStormStage3() {
        return this.stormStage == 1;
    }

    public boolean isStormStage4() {
        return this.stormStage == 2;
    }

    public boolean isStormStage5() {
        return this.stormStage >= 3;
    }

    public boolean isStormStage2() {
        return this.stormStage <= 0 && this.world.method_8546();
    }

    public boolean isStormStage2Severe() {
        return this.stormStage <= 0 && this.world.method_8546() && this.isSevereStorm();
    }

    public boolean isGreaterStormStage() {
        return this.stormStage > 0;
    }

    public boolean isStormDying() {
        return this.stormDying;
    }

    public int getTotalRainTimeForStorm() {
        return this.totalRainTimeForStorm;
    }

    public boolean isUsingDumbStormIntensity() {
        return this.usingDumbStormIntensity;
    }

    public double getStormStageGoalPercentageThreshold() {
        return this.stageGoalPercentageThreshold;
    }

    public boolean isApexOnlyOn() {
        return this.apexOnly;
    }

    public boolean isCursedStorm() {
        return this.cursed;
    }

    public float getStormIntensity() {
        float ticks;
        float total;
        if (!this.isSevereStorm() || !this.world.method_8546()) {
            total = this.stormThreshold;
            ticks = this.stormTicks;
        } else if (this.isStormStage2Severe()) {
            total = this.stormStageProfile[this.stormStage] - this.stormThreshold;
            ticks = this.stormTicks - this.stormThreshold;
        } else if (this.isStormStage5()) {
            total = this.stormStageProfile[2];
            ticks = this.stormTicks;
        } else {
            total = this.stormStageProfile[this.stormStage] - this.stormStageProfile[this.stormStage - 1];
            ticks = this.stormTicks - this.stormStageProfile[this.stormStage - 1];
        }
        return class_3532.method_15363((float)(ticks / total), (float)0.0f, (float)(this.isStormStage5() ? 3.0f : 1.0f));
    }

    private void endStorm() {
        Global.setClear(this.world);
        this.currentStorm = false;
        this.stormTicks = 0;
        this.tornadoTokenUsed = false;
        this.stormStage = 0;
        this.stormDying = false;
        this.stagnationData = null;
        this.updateStormThreshold(false);
        this.updateStormStageProfile();
        this.forceWeatherUpdates = true;
        this.totalRainTimeForStorm = 0;
        this.usingDumbStormIntensity = false;
        WCNetworkServer.forceBigUpdate();
    }

    private void startStorm() {
        this.currentStorm = true;
        this.daysSinceStorm = 0;
        this.tornadoTokenUsed = false;
        if (this.we != null) {
            this.we = null;
        }
        this.forceWeatherUpdates = true;
        WCNetworkServer.forceBigUpdate();
    }

    public void updateStormThreshold(boolean force) {
        int max = class_3218.field_41751.method_35011();
        if (this.world.method_8409().method_43057() > (float)ModConfig.getSevereStormChance() / 100.0f && !force) {
            this.stormThreshold = max + 100;
            return;
        }
        float minStage15Percent = 0.03f;
        float maxStage15Percent = 0.35f;
        float stage15Percent = minStage15Percent + (maxStage15Percent - minStage15Percent) * this.world.field_9229.method_43057();
        int val = (int)((float)max * stage15Percent);
        val = Math.max(0, val);
        this.stormThreshold = val + ModConfig.getMaxTornadoLoadDist();
    }

    private void updateStormStageProfile() {
        int total = 5000;
        int threshold = this.stormThreshold;
        class_5819 rand = this.world.field_9229;
        float minStage2Percent = 0.3f;
        float maxStage2Percent = 0.4f;
        float stage2Percent = minStage2Percent + (maxStage2Percent - minStage2Percent) * rand.method_43057();
        float remainingAfterStage2 = 1.0f - stage2Percent;
        float minStage3Percent = 0.3f * remainingAfterStage2;
        float maxStage3Percent = 0.6f * remainingAfterStage2;
        float stage3Percent = minStage3Percent + (maxStage3Percent - minStage3Percent) * rand.method_43057();
        float remainingAfterStage3 = 1.0f - stage3Percent;
        float minStage4Percent = 0.3f * remainingAfterStage3;
        float maxStage4Percent = 0.7f * remainingAfterStage3;
        float stage4Percent = minStage4Percent + (maxStage4Percent - minStage4Percent) * rand.method_43057();
        short stage3Limit = (short)((float)threshold + (float)total * stage2Percent);
        short stage4Limit = (short)((float)stage3Limit + (float)total * stage3Percent);
        short stage5Limit = (short)((float)stage4Limit + (float)total * stage4Percent);
        this.stormStageProfile[0] = stage3Limit;
        this.stormStageProfile[1] = stage4Limit;
        this.stormStageProfile[2] = stage5Limit;
        this.stageGoal = this.getRandomWeightedStormStageGoal();
        float minDumbInc = 0.1f;
        float maxDumbInc = 0.3f;
        this.stageGoalPercentageThreshold = 20 + this.world.method_8409().method_43048(40);
        this.dumbStormIntensityIncChance = minDumbInc + (maxDumbInc - minDumbInc) * rand.method_43057();
        this.apexOnly = this.world.method_8409().method_43057() < 0.33f;
        this.cursed = this.curseNextStorm();
    }

    private boolean curseNextStorm() {
        return this.world.method_8409().method_43057() < (float)ModConfig.getCursedStormChance() / 100.0f;
    }

    public short[] getStormStageProfile() {
        return this.stormStageProfile;
    }

    public byte getCurrentStageGoal() {
        return this.stageGoal;
    }

    public void sendStorm(Optional<Integer> time, boolean forceStorm) {
        if (this.world.method_8546()) {
            return;
        }
        if (this.we != null && (!forceStorm || this.we.isDone() || this.we.getWeather() == WeatherExecutor.WeatherToExecute.THUNDER)) {
            return;
        }
        this.currentStorm = false;
        this.we = new WeatherExecutor(this.world, WeatherExecutor.WeatherToExecute.THUNDER, time);
    }

    private void sendRain(boolean worsen) {
        if (this.we != null || this.world.method_8419()) {
            return;
        }
        this.we = new WeatherExecutor(this.world, WeatherExecutor.WeatherToExecute.RAIN, Optional.empty());
        if (worsen) {
            this.we = this.we.worsen();
        }
    }

    private void updateDownpourStatusByDay() {
        if (this.world.method_8419() != this.wasRaining) {
            if (this.world.method_8419()) {
                this.daysSinceRain = 0;
                if (this.we != null && this.we.getWeather() == WeatherExecutor.WeatherToExecute.RAIN) {
                    this.we = null;
                }
            }
            if (this.force) {
                this.daysSinceDownpour = 0;
                this.wasRaining = this.world.method_8419();
                this.force = false;
                return;
            }
            if (this.downpour) {
                if (this.world.method_8419()) {
                    this.daysSinceDownpour = 0;
                } else {
                    this.daysSinceDownpour = 0;
                    this.downpour = false;
                }
            } else if (this.world.method_8419()) {
                ++this.daysSinceDownpour;
                class_5819 r = this.world.method_8409();
                boolean startDownpour = WeatherEventProbabilityCalculator.shouldDownpour(r, this.daysSinceDownpour);
                if (startDownpour) {
                    this.daysSinceDownpour = 0;
                    if (ModConfig.getEnableDownpour()) {
                        this.downpour = true;
                    }
                }
            }
            this.wasRaining = this.world.method_8419();
            WCNetworkServer.forceBigUpdate();
        }
    }

    private void populateRainPuddles() {
        if (this.world.method_18456().isEmpty()) {
            return;
        }
        class_1657 player = (class_1657)this.world.method_18456().get(this.world.method_8409().method_43048(this.world.method_18456().size()));
        class_1923 cpos = player.method_31476();
        ArrayList<class_1923> surroundingChunks = new ArrayList<class_1923>();
        for (int xx = cpos.field_9181 - 2; xx < cpos.field_9181 + 2; ++xx) {
            for (int zz = cpos.field_9180 - 2; zz < cpos.field_9180 + 2; ++zz) {
                class_1923 c = new class_1923(xx, zz);
                if (c.equals((Object)cpos)) continue;
                surroundingChunks.add(c);
            }
        }
        ArrayList<class_1923> chosenChunks = new ArrayList<class_1923>();
        if (!surroundingChunks.isEmpty()) {
            class_1923 chosen = (class_1923)surroundingChunks.remove(this.world.method_8409().method_43048(surroundingChunks.size()));
            if (this.world.method_8393(chosen.field_9181, chosen.field_9180)) {
                chosenChunks.add(chosen);
            }
        }
        if ((double)this.world.method_8409().method_43057() < 0.321) {
            chosenChunks.add(cpos);
        }
        for (class_1923 c : chosenChunks) {
            this.populatePuddlesOrSnow(player, c, 2);
        }
    }

    private void populatePuddlesOrSnow(class_1657 player, class_1923 cpos, int addCount) {
        int i;
        class_2680 puddle = WCBlocks.PUDDLE.method_9564();
        class_2818 chunk = this.world.method_8497(cpos.field_9181, cpos.field_9180);
        ArrayList<class_2338> viablePositions = new ArrayList<class_2338>();
        ArrayList<class_2338> viableSnowPositions = new ArrayList<class_2338>();
        int startX = cpos.method_8326();
        int startZ = cpos.method_8328();
        int totalBlocks = 0;
        int puddles = 0;
        int inc = this.world.method_8409().method_43048(2) == 0 ? 3 : 2;
        class_2338.class_2339 mutable = cpos.method_8323().method_25503();
        for (int xx = 0; xx < 16 && xx <= 16; xx += inc) {
            for (int zz = 0; zz < 16 && zz <= 16; zz += inc) {
                int x = startX + xx;
                int z = startZ + zz;
                int y = chunk.method_12005(class_2902.class_2903.field_13197, x, z) + 1;
                mutable.method_10103(x, y, z);
                boolean snow = Utils.hasSnow((class_1937)this.world, (class_2338)mutable);
                if (snow) {
                    class_2680 st = this.world.method_8320((class_2338)mutable);
                    if (!(st.method_26204() instanceof class_2488) || (Integer)st.method_11654((class_2769)class_2488.field_11518) >= 7) continue;
                    ++totalBlocks;
                    viableSnowPositions.add(mutable.method_10062());
                    continue;
                }
                class_2248 aboveBlock = this.world.method_8320((class_2338)mutable).method_26204();
                boolean replaceableRisk = PuddleBlock.replaceableBlocks.contains(aboveBlock);
                boolean erode = aboveBlock.method_9564().method_26164(class_3481.field_20341);
                if ((puddle.method_26184((class_4538)this.world, (class_2338)mutable) || replaceableRisk || erode) && this.world.method_8520((class_2338)mutable) && PuddleBlock.validBelow((class_4538)this.world, this.world.method_8320(mutable.method_10074()), mutable.method_10074())) {
                    ++totalBlocks;
                    viablePositions.add(mutable.method_10062());
                    continue;
                }
                if (this.world.method_8320(mutable.method_10074()).method_26204() != puddle.method_26204() || ++puddles <= 16) continue;
                return;
            }
        }
        if (totalBlocks <= 0) {
            return;
        }
        for (i = 0; i < addCount + 2 && !viableSnowPositions.isEmpty(); ++i) {
            class_2338 pos = (class_2338)viableSnowPositions.remove(this.world.method_8409().method_43048(viableSnowPositions.size()));
            class_2680 state = this.world.method_8320(pos);
            int l = (Integer)state.method_11654((class_2769)class_2488.field_11518);
            this.world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(Math.min(8, l + 1))));
        }
        for (i = 0; i < addCount && !viablePositions.isEmpty(); ++i) {
            boolean noPlayer;
            class_2338 pos = (class_2338)viablePositions.remove(this.world.method_8409().method_43048(viablePositions.size()));
            class_2680 pState = this.world.method_8320(pos);
            boolean replace = PuddleBlock.replaceableBlocks.contains(pState.method_26204()) || pState.method_26204() instanceof class_5544;
            boolean erode = pState.method_26164(class_3481.field_20341);
            if (replace) {
                class_2248.method_9497((class_2680)pState, (class_1937)this.world, (class_2338)pos);
            } else if (erode) {
                this.world.method_8501(pos, class_2246.field_10124.method_9564());
                if (!this.world.method_8320(pos.method_10074()).method_27852(class_2246.field_10362) || !((double)this.world.field_9229.method_43057() < 0.4)) break;
                this.world.method_8501(pos.method_10074(), class_2246.field_37576.method_9564());
                break;
            }
            class_2680 pc = puddle;
            double d = this.world.method_8409().method_43057();
            double d2 = this.isSevereStorm() ? (double)0.2f : 0.05;
            if (d < d2) {
                pc = (class_2680)pc.method_11657((class_2769)PuddleBlock.FLOOD_DIST, (Comparable)Integer.valueOf(1));
            }
            this.world.method_8652(pos, pc, 2);
            this.world.method_64310(pos, pc.method_26204(), 5);
            boolean spawn = this.world.method_64395().method_8355(class_1928.field_19390);
            if (!ModConfig.getTerrariaReference() || !((double)this.world.field_9229.method_43057() < 0.03) || !spawn) continue;
            boolean clearEnoughOfFish = this.world.method_8333(null, new class_238(pos).method_1014(16.0), p -> p.method_5864() == WCEntities.FLYING_FISH).size() < 3;
            boolean bl = noPlayer = this.world.method_18459((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 16.0, false) == null;
            if (!clearEnoughOfFish || !noPlayer) continue;
            FlyingFishEntity fish = new FlyingFishEntity(WCEntities.FLYING_FISH, (class_1937)this.world);
            fish.method_5725(pos, 0.0f, 0.0f);
            this.world.method_8649((class_1297)fish);
            for (int f = 0; f < 30; ++f) {
                this.world.method_65096((class_2394)(this.world.field_9229.method_43057() < 0.4f ? class_2398.field_11241 : class_2398.field_11202), (double)((float)pos.method_10263() + this.world.field_9229.method_43057()), (double)((float)pos.method_10264() + this.world.field_9229.method_43057()), (double)((float)pos.method_10260() + this.world.field_9229.method_43057()), 0, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean isDownpour() {
        return this.downpourTransitionTicks > 0;
    }

    public int getDaysSinceDownpour() {
        return this.daysSinceDownpour;
    }

    public boolean isDownpourTransitioning() {
        return this.prevDownpourTransitionTicks != this.downpourTransitionTicks;
    }

    public void forceStormTransitionTicks(short t) {
        this.severeStormTransitionTicks = t;
    }

    public void setSevereStorm(boolean b, byte stage) {
        if (this.isSevereStormTransitioning()) {
            return;
        }
        if (b && !this.world.method_8546()) {
            Global.setThundering(this.world);
            if (stage > 2) {
                this.usingDumbStormIntensity = true;
            }
        }
        if (!b) {
            this.stormTicks = 0;
        } else {
            this.stormDying = false;
            this.tornadoTokenUsed = false;
            if (this.stormThreshold >= class_3218.field_41751.method_35011()) {
                this.updateStormThreshold(true);
                this.updateStormStageProfile();
            }
            if (this.stagnationData != null) {
                this.stagnationData.updateC(Float.valueOf(1.0f));
            }
            if (this.isSevereStorm()) {
                this.usingDumbStormIntensity = true;
            }
            switch (stage) {
                case 3: {
                    this.stormTicks = this.stormStageProfile[0] + 100;
                    break;
                }
                case 4: {
                    this.stormTicks = this.stormStageProfile[1] + 100;
                    break;
                }
                case 5: {
                    this.stormTicks = this.stormStageProfile[2] + 100;
                    break;
                }
                default: {
                    this.stormTicks = this.stormThreshold + 100;
                }
            }
            this.manualStageAdjustment = stage != this.stormStage + 2;
        }
        WCNetworkServer.sendWeatherStatusPacket(this.world);
    }

    public void toggleIllusoryStage6(boolean on) {
        this.stormTicks = on ? this.stormStageProfile[2] + 1200 : this.stormStageProfile[2] + 100;
        WCNetworkServer.sendStormIntensityPacket(this.world);
    }

    public void setDownpour(boolean b) {
        if (this.isDownpourTransitioning()) {
            return;
        }
        if (b && !this.world.method_8419()) {
            Global.setRaining(this.world);
            this.force = true;
        }
        this.downpour = b;
        if (b) {
            this.daysSinceDownpour = 0;
        }
        WCNetworkServer.sendWeatherStatusPacket(this.world);
    }

    public void updateDownpourData(boolean downpour, int daysDP, int daysR) {
        this.setDownpour(downpour);
        this.daysSinceDownpour = daysDP;
        this.daysSinceRain = daysR;
    }

    public void updateStormData(boolean storming, int days, int ticks, WeatherExecutor.WeatherToExecute exec, short[] profile, int threshold, byte stageG, boolean dying, int totalRainTime, double stageGoalPercentThreshold, boolean dumbIntensity, boolean apexOnly, boolean cursed, int skippedStorms) {
        this.manualStageAdjustment = true;
        this.currentStorm = storming;
        this.daysSinceStorm = days;
        this.stormTicks = ticks;
        this.stormThreshold = threshold;
        this.stormDying = dying;
        this.stageGoal = stageG;
        this.totalRainTimeForStorm = totalRainTime;
        this.stageGoalPercentageThreshold = stageGoalPercentThreshold;
        this.usingDumbStormIntensity = dumbIntensity;
        this.apexOnly = apexOnly;
        this.cursed = cursed;
        if (exec != null) {
            this.we = new WeatherExecutor(this.world, exec, Optional.of(this.world.method_8409().method_43048(9000)));
        }
        if (profile != null) {
            this.stormStageProfile = profile;
        }
    }

    public boolean changedWeatherState() {
        boolean changed;
        boolean bl = changed = this.prevDownpour != this.downpour || this.wasSevereStorm != this.isSevereStorm() || this.isSevereStormTransitioning() || this.isDownpourTransitioning() || this.prevStormStage != this.stormStage || this.forceWeatherUpdates();
        if (this.prevDownpour != this.downpour) {
            this.prevDownpour = this.downpour;
        }
        if (this.prevDownpourTransitionTicks != this.downpourTransitionTicks) {
            this.prevDownpourTransitionTicks = this.downpourTransitionTicks;
            if (this.downpourTransitionTicks == 50 || this.downpourTransitionTicks == 0) {
                WCNetworkServer.forceBigUpdate();
            }
        }
        if (this.prevSevereStormTransitionTicks != this.severeStormTransitionTicks) {
            this.prevSevereStormTransitionTicks = this.severeStormTransitionTicks;
        }
        if (this.wasSevereStorm != this.isSevereStorm()) {
            this.wasSevereStorm = this.isSevereStorm();
            WCNetworkServer.forceBigUpdate();
            if (this.wasSevereStorm) {
                int total = this.totalRainTimeForStorm = this.addTimeToSevereStorm();
                byte goal = this.stageGoal;
                byte initGoal = this.stageGoal;
                float forceHighStageChance = (float)ModConfig.getForceHighStageChanceIfLong() / 100.0f;
                if (total > 14000) {
                    if (goal < 1 && this.world.method_8409().method_43057() < forceHighStageChance) {
                        goal = (byte)((double)this.world.method_8409().method_43057() < 0.6 ? 1 : 2);
                    }
                } else if (total > 12000) {
                    if (goal < 1 && this.world.method_8409().method_43057() < forceHighStageChance - 0.15f) {
                        goal = (byte)((double)this.world.method_8409().method_43057() < 0.7 ? 1 : 2);
                    }
                } else if (total > 10000) {
                    if (goal < 0 && this.world.method_8409().method_43057() < forceHighStageChance) {
                        goal = (byte)((double)this.world.method_8409().method_43057() < 0.15 ? 1 : 0);
                    }
                } else if (total < 9000 && goal > 1 && (double)this.world.method_8409().method_43057() < 0.8) {
                    goal = (byte)(this.world.method_8409().method_43056() ? -1 : 0);
                }
                if (initGoal < 0 && (double)this.world.method_8409().method_43057() < 0.1) {
                    goal = initGoal;
                }
                this.stageGoal = goal;
                if ((double)this.world.method_8409().method_43057() < 0.12 && this.stageGoal < 0) {
                    this.dumbStormIntensityIncChance = 0.5f;
                    this.stageGoalPercentageThreshold = 60.0;
                }
            }
        }
        if (this.prevStormStage != this.stormStage) {
            WCNetworkServer.forceBigUpdate();
            boolean downwards = this.prevStormStage > this.stormStage;
            this.prevStormStage = this.stormStage;
            if (this.stagnationData != null) {
                this.stagnationData.updateC(Float.valueOf(1.0f));
            }
            if (!this.manualStageAdjustment) {
                switch (this.stormStage) {
                    case 1: {
                        if (downwards) {
                            this.stormTicks = this.stormStageProfile[1] - 100;
                            break;
                        }
                        this.stormTicks = this.stormStageProfile[0] + 100;
                        break;
                    }
                    case 2: {
                        if (downwards) {
                            this.stormTicks = this.stormStageProfile[2] - 100;
                            break;
                        }
                        this.stormTicks = this.stormStageProfile[1] + 100;
                        break;
                    }
                    case 3: {
                        this.stormTicks = this.stormStageProfile[2] + 100;
                    }
                }
            }
            this.manualStageAdjustment = false;
        }
        return changed;
    }

    private int addTimeToSevereStorm() {
        int currentTime = ((ServerWorldAccessor)this.world).getWorldProperties().method_145();
        if (currentTime < 6400) {
            int boost = (double)this.world.method_8409().method_43057() < 0.25 ? 8000 : 6800;
            currentTime += 1200 + this.world.method_8409().method_43048(boost);
        }
        ((ServerWorldAccessor)this.world).getWorldProperties().method_173(currentTime);
        ((ServerWorldAccessor)this.world).getWorldProperties().method_164(currentTime);
        return currentTime;
    }

    private void buffStormTimeSlightly() {
        int currentTime = ((ServerWorldAccessor)this.world).getWorldProperties().method_145();
        ((ServerWorldAccessor)this.world).getWorldProperties().method_173(currentTime += 1200 + this.world.method_8409().method_43048(2200));
        ((ServerWorldAccessor)this.world).getWorldProperties().method_164(currentTime);
    }

    public boolean forceWeatherUpdates() {
        return this.forceWeatherUpdates;
    }

    public int getCurrentRainTime() {
        if (!this.world.method_8546()) {
            return 0;
        }
        return ((ServerWorldAccessor)this.world).getWorldProperties().method_190();
    }

    @Override
    public class_1937 getWorld() {
        return this.world;
    }

    public static float downpourMovementSpeedMultiplier(boolean slowedInBlizzard) {
        return slowedInBlizzard ? 0.5f : 0.75f;
    }

    public short getSevereStormTransitionTicks() {
        return this.severeStormTransitionTicks;
    }

    public short getDownpourTransitionTicks() {
        return this.downpourTransitionTicks;
    }

    public void addTornadoReviver(TornadoReviver reviver) {
        if (!reviver.isOn()) {
            ArrayList<TornadoReviver> replace = new ArrayList<TornadoReviver>();
            for (TornadoReviver r2 : this.revivers) {
                if (r2.getID() != reviver.getID()) continue;
                replace.add(r2);
            }
            replace.forEach(r -> this.revivers.remove(r));
            this.revivers.add(reviver);
            return;
        }
        if (!this.revivers.contains(reviver)) {
            this.revivers.add(reviver);
        }
    }

    public List<TornadoReviver> getRevivers() {
        return this.revivers;
    }

    public static int getSevereStormLightningAggressionForInt() {
        return Global.weather.stormStage == 3 ? 80 : (Global.weather.stormStage == 2 ? 120 : 180);
    }

    public static float getSevereStormLightningAggressionForFloat() {
        return Global.weather.stormStage == 3 ? 0.08f : (Global.weather.stormStage == 2 ? 0.04f : 0.02f);
    }

    public static int getLightningStrikeChanceForStage() {
        switch (Global.weather.stormStage) {
            case 1: {
                return 70000;
            }
            case 2: {
                return 50000;
            }
            case 3: {
                return 30000;
            }
        }
        return 90000;
    }

    public boolean isStage6() {
        return this.world.method_8546() && this.isStormStage5() && (double)this.getStormIntensity() > 1.1;
    }

    public void forceCluster(UUID id) {
    }

    public void spawnClusterAt(class_2338 pos, float str, int time) {
    }
}

