/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.global.client;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.weather_classic.entity.breezling.WindManipulator;
import net.weather_classic.global.Global;
import net.weather_classic.global.client.config.ClientCustomTornadoConfig;
import net.weather_classic.help.Utils;
import net.weather_classic.item.core_related.SimpleParticleSource;
import net.weather_classic.networking.client.WCNetworkClient;
import net.weather_classic.storm.source.TornadoParticleSource;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ClientGlobal {
    public static Map<UUID, TornadoParticleSource> activeTornadoSources = new HashMap<UUID, TornadoParticleSource>();
    public static Map<UUID, TornadoParticleSource> activeClusterSources = new HashMap<UUID, TornadoParticleSource>();
    public static Map<UUID, SimpleParticleSource> activeCoreTornadoSources = new HashMap<UUID, SimpleParticleSource>();
    public static float windAngle = 0.0f;
    public static float windStrength = 0.0f;
    public static boolean windy = false;
    public static boolean gusty = false;
    public static boolean downpour = false;
    public static boolean severeStorm = false;
    public static short severeStormTransitionTicks = 0;
    public static short downpourTransitionTicks = 0;
    public static byte stormStage = 0;
    public static boolean stormDying = false;
    public static float stormIntensity = 0.0f;
    public static int rainTime = 0;
    public static boolean gale = false;
    public static short galeTransitionTicks = 0;
    public static boolean ghastlyGale = false;
    public static class_5321<class_1937> CURRENT_WORLD_KEY = null;
    public static boolean clientOutdoors = false;
    public static byte customTornadoSwitchType = 0;
    public static int windGustTime = 0;
    public static final float heavyPrecipitationSize = 2.5f;
    public static float precipitationSize = 1.0f;
    public static float prevPrecipitationSize = 1.0f;
    public static float snowSpeed = 512.0f;

    public static void tickWeatherFX() {
        prevPrecipitationSize = precipitationSize;
        if (downpour) {
            if (precipitationSize < 2.5f) {
                precipitationSize += 0.01f;
            }
            if (snowSpeed > 64.0f) {
                snowSpeed = 64.0f;
            }
        } else {
            if (precipitationSize > 1.0f) {
                precipitationSize -= 0.01f;
            }
            if (snowSpeed < 512.0f) {
                snowSpeed = 512.0f;
            }
        }
    }

    public static boolean isTornadoActive() {
        return !activeTornadoSources.isEmpty();
    }

    public static boolean isClusterActive() {
        return !activeClusterSources.isEmpty();
    }

    public static TornadoParticleSource getClosestTornado(class_243 position) {
        long closest = Integer.MAX_VALUE;
        TornadoParticleSource closestSource = null;
        for (UUID id : activeTornadoSources.keySet()) {
            class_243 vec = activeTornadoSources.get(id).getEmitter();
            long dist = (int)Utils.squaredDistanceTo(position, vec);
            if (dist >= closest) continue;
            closest = dist;
            closestSource = activeTornadoSources.get(id);
        }
        return closestSource;
    }

    public static TornadoParticleSource getClosestTornado(double x, double y, double z, int within) {
        long closest = Integer.MAX_VALUE;
        TornadoParticleSource closestSource = null;
        for (UUID id : activeTornadoSources.keySet()) {
            class_243 vec = activeTornadoSources.get(id).getEmitter();
            long dist = (int)Utils.squaredDistanceTo(x, y, z, vec);
            if (dist >= closest) continue;
            closest = dist;
            closestSource = activeTornadoSources.get(id);
        }
        return within != -1 && closest > (long)(within * within) ? null : closestSource;
    }

    public static TornadoParticleSource getClosestCluster(double x, double y, double z, int within) {
        long closest = Integer.MAX_VALUE;
        TornadoParticleSource closestSource = null;
        for (UUID id : activeClusterSources.keySet()) {
            class_243 vec = activeClusterSources.get(id).getEmitter();
            long dist = (int)Utils.squaredDistanceTo(x, y, z, vec);
            if (dist >= closest) continue;
            closest = dist;
            closestSource = activeClusterSources.get(id);
        }
        return within != -1 && closest > (long)(within * within) ? null : closestSource;
    }

    public static Vector3f getWindMovementVectorForParticle(class_638 world, class_243 particle, @Nullable WindManipulator m, boolean checkForManipulation) {
        class_243 closestTornado;
        TornadoParticleSource source;
        WindManipulator manipulationPos;
        WindManipulator windManipulator = !checkForManipulation ? null : (manipulationPos = m == null ? Global.getPlayerForManipulation((class_1937)world, particle) : m);
        if (manipulationPos != null) {
            class_243 v = manipulationPos.getManipulationPosition().method_1020(particle).method_1029();
            Vector3f vec = new Vector3f((float)v.field_1352 * 0.06f, 0.012f, (float)v.field_1350 * 0.06f);
            return vec.mul(2.0f);
        }
        if (world.method_27983() != class_1937.field_25179) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        if (!activeTornadoSources.isEmpty() && particle != null && (source = ClientGlobal.getClosestTornado(particle)) != null && (closestTornado = source.getEmitter()) != null) {
            class_243 v = closestTornado.method_1020(particle).method_1029();
            Vector3f vec = new Vector3f((float)v.field_1352 * 0.06f, 0.012f, (float)v.field_1350 * 0.06f);
            return vec;
        }
        double radians = Math.toRadians(windAngle + 90.0f);
        double moveX = (double)windStrength * Math.cos(radians);
        double moveZ = (double)windStrength * Math.sin(radians);
        double yFall = -0.012f;
        Vector3f vec = new Vector3f((float)moveX, (float)yFall, (float)moveZ);
        return vec;
    }

    public static void renderEventFX(class_2394 effect, class_310 client, int particleCount) {
        class_638 world = client.field_1687;
        if (world == null) {
            return;
        }
        class_5819 random = world.field_9229;
        class_243 camera = client.field_1773.method_19418().method_19326();
        int l = 5;
        int x = (int)camera.field_1352;
        int y = (int)camera.field_1351 + 12;
        int z = (int)camera.field_1350;
        class_2338.class_2339 pos = new class_2338(x, y, z).method_25503();
        for (int i = 0; i < particleCount; ++i) {
            int xx = x + random.method_43048(2 * l + 1) - l;
            int zz = z + random.method_43048(2 * l + 1) - l;
            pos.method_10103(xx, y, zz);
            double dx = x - xx;
            double dz = z - zz;
            double dist = Math.sqrt(dx * dx + dz * dz);
            if (dist < 2.0 || !world.method_8520((class_2338)pos) || !world.method_8320((class_2338)pos).method_26215()) continue;
            client.field_1713.method_3056(effect, (double)((float)xx + random.method_43057()), (double)y, (double)((float)zz + random.method_43057()), 0.0, 0.0, 0.0);
        }
    }

    public static int getSevereStormSkyColor(int startColor) {
        if (severeStormTransitionTicks <= 0) {
            return startColor;
        }
        int endColor = 6779267;
        if (severeStormTransitionTicks >= 50) {
            return ClientGlobal.getSkyColorForStages(endColor);
        }
        return Utils.interpolateColor(startColor, endColor, severeStormTransitionTicks, 50);
    }

    public static int getSevereStormFogColor(int startColor) {
        if (severeStormTransitionTicks <= 0) {
            return startColor;
        }
        int endColor = 8228255;
        if (severeStormTransitionTicks >= 50) {
            return ClientGlobal.getFogColorForStages(endColor);
        }
        return Utils.interpolateColor(startColor, endColor, severeStormTransitionTicks, 50);
    }

    private static int getSkyColorForStages(int basic) {
        switch (stormStage) {
            case 1: {
                return 4214112;
            }
            case 2: {
                return 1910060;
            }
            case 3: {
                return 856080;
            }
        }
        return basic;
    }

    private static int getFogColorForStages(int basic) {
        if (WCNetworkClient.hasNightVision) {
            return basic;
        }
        switch (stormStage) {
            case 2: {
                return 6781058;
            }
            case 3: {
                return 4214112;
            }
        }
        return basic;
    }

    public static int getDownpourFogColor(int startColor) {
        if (downpourTransitionTicks <= 0) {
            return startColor;
        }
        int endColor = 8691386;
        if (downpourTransitionTicks >= 50) {
            return endColor;
        }
        return Utils.interpolateColor(startColor, endColor, downpourTransitionTicks, 50);
    }

    public static int getGaleAndClusterSkyColor(int startColor) {
        int color = startColor;
        if (galeTransitionTicks > 0) {
            int endColor = 10136257;
            color = Utils.interpolateColor(startColor, endColor, galeTransitionTicks, 80);
        }
        if (WCNetworkClient.closestCluster != null && class_310.method_1551().method_1560() != null) {
            int stormColor = 9412271;
            float dist = (float)Utils.squaredDistanceXZ(class_310.method_1551().method_1560().method_33571(), WCNetworkClient.closestCluster.getEmitter());
            float maxDist = 7396.0f;
            float minDist = 1024.0f;
            dist = class_3532.method_15363((float)dist, (float)minDist, (float)maxDist);
            float t = 1.0f - (dist - minDist) / (maxDist - minDist);
            return Utils.interpolateColorT(color, stormColor, t);
        }
        return color;
    }

    public static int getGaleFogColor(int startColor) {
        if (galeTransitionTicks <= 0) {
            return startColor;
        }
        int endColor = 0x9E9E9E;
        if (galeTransitionTicks >= 80) {
            return endColor;
        }
        return Utils.interpolateColor(startColor, endColor, galeTransitionTicks, 80);
    }

    public static float getSkyLightAdjustment() {
        float clusterIfApplicable;
        float d = 1.0f;
        if (severeStorm) {
            float f = stormStage == 0 ? 0.85f : (stormStage == 1 ? 0.75f : (d = stormStage == 2 ? 0.65f : 0.55f));
        }
        if (gale) {
            d = class_3532.method_16439((float)((float)galeTransitionTicks / 50.0f), (float)d, (float)0.3f);
        }
        if ((clusterIfApplicable = ClientGlobal.getLocalizedSkyDarkeningForCluster(d)) != -1.0f) {
            d = clusterIfApplicable;
        }
        return d;
    }

    private static float getLocalizedSkyDarkeningForCluster(float d) {
        if (WCNetworkClient.closestCluster == null || class_310.method_1551().method_1560() == null) {
            return -1.0f;
        }
        float dist = (float)Utils.squaredDistanceXZ(class_310.method_1551().method_1560().method_33571(), WCNetworkClient.closestCluster.getEmitter());
        float maxDist = 7396.0f;
        float minDist = 1024.0f;
        dist = class_3532.method_15363((float)dist, (float)minDist, (float)maxDist);
        float t = 1.0f - (dist - minDist) / (maxDist - minDist);
        return class_3532.method_16439((float)t, (float)d, (float)0.2f);
    }

    public static Vector3f getDefaultTornadoParticleColor(TornadoParticleSource source, class_5819 random, boolean forCloud) {
        Vector3f color;
        if (source.isDemon()) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        if (source.getTornadoType() >= 5 && ClientCustomTornadoConfig.getColorOverride() && (!forCloud || ClientCustomTornadoConfig.getCloudColorOverride())) {
            color = ClientCustomTornadoConfig.getColors();
        } else {
            float randomFloat = random.method_43057() * 0.3f;
            float baseBright = 0.85f;
            float finalBright = Math.min(1.0f, baseBright + randomFloat);
            color = new Vector3f(finalBright, finalBright, finalBright);
            if (source.isCellDemon()) {
                color = color.sub(0.3f, 0.3f, 0.3f);
            }
        }
        return forCloud ? color.sub(0.05f, 0.05f, 0.05f) : color;
    }
}

