/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.particle.rotator;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.weather_classic.global.client.ClientGlobal;
import net.weather_classic.global.client.config.ClientCustomTornadoConfig;
import net.weather_classic.particle.StormParticle;
import net.weather_classic.particle.clouds.StormCloudParticle;
import net.weather_classic.particle.rotator.base.StormParticleRotator;
import net.weather_classic.storm.source.TornadoParticleSource;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class StormCloudParticleRotator
extends StormParticleRotator {
    public StormCloudParticleRotator(TornadoParticleSource source) {
        super(source);
    }

    @Override
    protected void rotate(StormParticle particle) {
        if (!particle.isDead()) {
            if (this.isUsingTornadoList()) {
                this.spinAsCloudsForTornado(particle);
            } else {
                this.spinAsCloudsForCluster(particle);
            }
        }
    }

    private void spinAsCloudsForTornado(StormParticle particle) {
        float f;
        float f1;
        double d1 = this.getSourcePos().method_10216() - particle.getX();
        double d2 = this.getSourcePos().method_10215() - particle.getZ();
        for (f1 = f = (float)(Math.atan2(d2, d1) * 180.0 / Math.PI) - 90.0f; f1 < -180.0f; f1 += 360.0f) {
        }
        while (f1 >= 180.0f) {
            f1 -= 360.0f;
        }
        double grab = 2.0 + (double)((float)particle.getAge() / 75.0f);
        f1 = (float)((double)f1 + (75.0 + grab - 0.4));
        float f3 = (float)Math.cos(-f1 * 0.01745329f - (float)Math.PI);
        float f4 = (float)Math.sin(-f1 * 0.01745329f - (float)Math.PI);
        float f5 = 0.055f;
        float moveX = f3 * f5;
        float moveZ = f4 * f5;
        particle.motionX += (double)(-moveX);
        particle.motionZ += (double)moveZ;
        particle.motionY = 0.0;
    }

    private void spinAsCloudsForCluster(StormParticle part) {
        StormCloudParticle particle = (StormCloudParticle)part;
        float strength = this.source.getStrength();
        float min = 0.003751f;
        float max = 0.05731f;
        float str = Math.max(0.0f, Math.min(1.0f, strength));
        float f5 = min + (max - min) * str;
        if (particle.getClusterStrength() != strength) {
            particle.setClusterStrength(strength);
        }
        if (particle.freezeOutwardMotion) {
            if (strength <= 0.7f && particle.angleX == 0.0f) {
                particle.method_3085();
                return;
            }
            double centerX = this.getSourcePos().method_10216();
            double centerZ = this.getSourcePos().method_10215();
            double dx = particle.getX() - centerX;
            double dz = particle.getZ() - centerZ;
            double radius = Math.sqrt(dx * dx + dz * dz);
            double angle = Math.atan2(dz, dx);
            float f = (float)(angle * 180.0 / Math.PI) - 90.0f;
            particle.prevAngleY = particle.angleY;
            particle.angleY = f;
            double rotationSpeed = f5 / 3.0f;
            double targetX = centerX + radius * Math.cos(angle += rotationSpeed);
            double targetZ = centerZ + radius * Math.sin(angle);
            particle.motionX = targetX - particle.getX();
            particle.motionZ = targetZ - particle.getZ();
        } else {
            float f;
            float f1;
            double d1 = this.getSourcePos().method_10216() - particle.getX();
            double d2 = this.getSourcePos().method_10215() - particle.getZ();
            for (f1 = f = (float)(Math.atan2(d2, d1) * 180.0 / Math.PI) - 90.0f; f1 < -180.0f; f1 += 360.0f) {
            }
            while (f1 >= 180.0f) {
                f1 -= 360.0f;
            }
            double grab = 2.0 + (double)((float)particle.getAge() / 75.0f);
            f1 = (float)((double)f1 + (75.0 + grab - 0.4));
            float f3 = (float)Math.cos(-f1 * 0.01745329f - (float)Math.PI);
            float f4 = (float)Math.sin(-f1 * 0.01745329f - (float)Math.PI);
            float moveX = f3 * f5;
            float moveZ = f4 * f5;
            if (this.shouldConvertToWall(particle, strength)) {
                this.convertParticleToWall(particle, strength);
            }
            particle.motionX += (double)(-moveX);
            particle.motionZ += (double)moveZ;
        }
        if (particle.motionY > 0.0) {
            particle.motionY -= (double)0.1f;
            if (particle.motionY < 0.0) {
                particle.motionY = 0.0;
            }
        } else if (particle.motionY < 0.0) {
            particle.motionY += (double)0.1f;
            if (particle.motionY > 0.0) {
                particle.motionY = 0.0;
            }
        }
    }

    private void convertParticleToWall(StormCloudParticle particle, float strength) {
        if (particle.id % 9 == 0) {
            particle.angleX = 0.0f;
            float maxSize = 8.0f;
            float minSize = 4.0f;
            float str = Math.max(0.7f, Math.min(1.0f, strength));
            float t = (str - 0.7f) / 0.3f;
            float size = minSize + (maxSize - minSize) * t;
            particle.setScale(particle.getScale() + size);
            if (size > 8.0f) {
                particle.motionY = -1.0f - particle.getWorld().method_8409().method_43057();
            }
            float c = strength > 0.9f ? 0.2f : 0.1f;
            particle.method_3084(particle.getRed() - c, particle.getGreen() - c, particle.getBlue() - c);
            particle.method_3077(particle.method_3082() - 75);
        }
        particle.freezeOutwardMotion = true;
    }

    private boolean shouldConvertToWall(StormCloudParticle particle, float strength) {
        float d;
        if (particle.getClusterStrength() <= 0.7f) {
            return false;
        }
        float maxDiv = 2.7f;
        float minDiv = 1.2f;
        float str = Math.max(0.7f, Math.min(1.0f, strength));
        float t = (str - 0.7f) / 0.3f;
        float div = d = minDiv + (maxDiv - minDiv) * t;
        return (float)particle.getAge() > (float)particle.method_3082() / div;
    }

    private short getAgeForClusterStrength() {
        float strength = this.getSource().getStrength();
        int maxAge = 500;
        int minAge = 600;
        float str = Math.max(0.0f, Math.min(1.0f, strength));
        float age = (float)minAge + (float)(maxAge - minAge) * (1.0f - str);
        return (short)age;
    }

    private float getColorSubForClusterStrength() {
        float strength = this.getSource().getStrength();
        float maxColorSub = 0.15f;
        float minColorSub = 0.05f;
        float str = Math.max(0.0f, Math.min(1.0f, strength));
        float color = minColorSub + (maxColorSub - minColorSub) * str;
        return color;
    }

    @Override
    public void prepare(StormParticle particle, boolean cluster) {
        if (cluster) {
            short age = this.getAgeForClusterStrength();
            particle.method_3077(age + particle.getWorld().method_8409().method_43048(75));
            Vector3f colors = ClientGlobal.getDefaultTornadoParticleColor(this.source, particle.getWorld().method_8409(), true);
            float color = this.getColorSubForClusterStrength();
            particle.method_3084(colors.x - color, colors.y - color, colors.z - color);
            ((StormCloudParticle)particle).setClusterStrength(this.source.getStrength());
        } else {
            byte t = this.source.getTornadoType();
            int age = 850;
            if (t == 5 && (double)ClientCustomTornadoConfig.getScaling() <= 0.65) {
                age = 400;
            }
            particle.method_3077(age + particle.getWorld().method_8409().method_43048(75));
            Vector3f colors = ClientGlobal.getDefaultTornadoParticleColor(this.source, particle.getWorld().method_8409(), true);
            particle.method_3084(colors.x, colors.y, colors.z);
        }
    }
}

