/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.storm;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.weather_classic.block.AdjustableCanopyBlock;
import net.weather_classic.block.PuddleBlock;
import net.weather_classic.config.CustomTornadoConfig;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.global.tools.TornadoDestructionInfo;
import net.weather_classic.help.Materials;
import net.weather_classic.help.MutableQuad;
import net.weather_classic.help.OneOrBoth;
import net.weather_classic.help.Utils;
import net.weather_classic.networking.WCNetworkServer;
import net.weather_classic.registry.WCBlocks;
import net.weather_classic.registry.WCEntities;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.debris.DebrisEntity;

public class TornadoRipper {
    private final TornadoEntity tornado;
    private final class_1937 world;
    private boolean isBeyondLoadedRange = false;
    private static final Pair<Float, Float> NONE = Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    private static final class_2680 PUDDLE_FLOOD = (class_2680)WCBlocks.PUDDLE.method_9564().method_11657((class_2769)PuddleBlock.FLOOD_DIST, (Comparable)Integer.valueOf(1));
    private boolean farOut = false;
    private boolean playerNearbyForRipping = true;
    private int protectedAreaTime = 0;

    public TornadoRipper(TornadoEntity torn) {
        this.tornado = torn;
        this.world = torn.method_37908();
    }

    public void tick() {
        boolean wideDestruction;
        boolean lvl2 = this.tornado.getTornadoType() >= 5 && CustomTornadoConfig.getDestructionLvlOverride() > -1 ? CustomTornadoConfig.getDestructionLvlOverride() > 1 : ModConfig.getTornadoDestructionLvl() > 1;
        boolean demon = this.tornado.isDemon();
        RipType ripType = this.tornado.getStats().ripType;
        byte type = this.tornado.getTornadoType();
        if (demon || this.tornado.isPassiveFirenado() || type == 5 && CustomTornadoConfig.getRipType(true) == 6) {
            if (this.tornado.field_6012 % (demon ? 10 : 60) != 0) {
                return;
            }
            if (demon && !this.tornado.isCloseToPlayer()) {
                return;
            }
            for (class_2338 pos : class_2338.method_25996((class_2338)this.tornado.method_24515().method_10086(4), (int)7, (int)5, (int)7)) {
                if ((double)this.world.method_8409().method_43057() < 0.8 || Utils.distanceXYZ(pos, this.tornado.method_24515()) > 5.0 && (double)this.world.method_8409().method_43057() < 0.8 || !this.world.method_8320(pos).method_26215() || this.world.method_8320(pos.method_10074()).method_26215()) continue;
                this.world.method_8501(pos, class_2246.field_10036.method_9564());
            }
            return;
        }
        if (this.tornado.isSpout()) {
            if (this.tornado.field_6012 % 20 == 0) {
                int numberToCheck = 20;
                class_2338 pos = this.tornado.method_24515();
                short range = this.tornado.getStats().pathSize;
                class_2338.class_2339 mut = pos.method_25503();
                int successes = 0;
                for (int i = 0; i < numberToCheck; ++i) {
                    int x = pos.method_10263() + this.tornado.method_59922().method_43048(2 * range + 1) - range;
                    int y = pos.method_10264() + this.tornado.method_59922().method_43048(9) - 4;
                    int z = pos.method_10260() + this.tornado.method_59922().method_43048(2 * range + 1) - range;
                    mut.method_10103(x, y, z);
                    boolean farm = this.world.method_8320(mut.method_10074()).method_27852(class_2246.field_10362);
                    if (PUDDLE_FLOOD.method_26184((class_4538)this.world, (class_2338)mut) || farm) {
                        if (farm) {
                            boolean skip = false;
                            for (int d = 1; d < 15; ++d) {
                                class_2680 uState = this.world.method_8320(mut.method_10086(d));
                                if (!(uState.method_26204() instanceof AdjustableCanopyBlock) || ((Boolean)uState.method_11654((class_2769)AdjustableCanopyBlock.OPEN)).booleanValue()) continue;
                                skip = true;
                                break;
                            }
                            if (skip) continue;
                            this.world.method_8501(mut.method_10074(), class_2246.field_37576.method_9564());
                        }
                        this.world.method_8501((class_2338)mut, PUDDLE_FLOOD);
                        if (this.world.method_8409().method_43057() < 0.5f) {
                            this.world.method_64310((class_2338)mut, PUDDLE_FLOOD.method_26204(), 5);
                        }
                        ++successes;
                    }
                    if (successes > 3) break;
                }
            }
            return;
        }
        if (this.protectedAreaTime > 0) {
            --this.protectedAreaTime;
        }
        if (!this.tornado.getPrevChunkPos().equals((Object)this.tornado.method_31476()) || this.tornado.field_6012 % 60 == 0) {
            this.isBeyondLoadedRange = this.checkIfBeyondLoadedRange();
            this.playerNearbyForRipping = !this.isBeyondLoadedRange && this.tornado.method_37908().method_8604(this.tornado.method_23317(), this.tornado.method_23318(), this.tornado.method_23321(), 224.0, null) != null;
        }
        if (this.tornado.field_6012 % ((wideDestruction = ripType.shouldUseWideDestruction()) ? 2 : 5) == 0 && this.world.method_8409().method_43048(wideDestruction ? 1 : 3) == 0) {
            int grabDistSquared = this.tornado.getStats().grabDistance * this.tornado.getStats().grabDistance;
            short ps = (short)((float)this.tornado.getStats().pathSize * (wideDestruction ? 1.5f : 1.0f));
            double pathSizeSquared = ps * ps;
            if (wideDestruction) {
                boolean custom;
                class_2338 offsetPos = this.tornado.method_24515();
                if (!this.isBeyondLoadedRange) {
                    int od = 16 + this.tornado.method_59922().method_43048(ripType == RipType.STAGE5 ? 32 : 8);
                    offsetPos = this.tornado.method_24515().method_10079(Utils.randomHorizontal(this.tornado.method_59922()), od);
                    if ((double)this.tornado.method_59922().method_43057() < 0.2) {
                        offsetPos.method_10079(Utils.randomHorizontal(this.tornado.method_59922()), ripType == RipType.STAGE5 ? 32 : 16);
                    }
                    if (this.tornado.method_59922().method_43057() < 0.5371f) {
                        offsetPos = this.tornado.method_24515();
                    }
                }
                int pathSize = (int)((float)this.tornado.getStats().pathSize * (1.5f + this.tornado.method_59922().method_43057() * 0.3f));
                int num = ripType == RipType.STAGE5 ? 700 : 450;
                boolean bl = custom = type == 5;
                if (custom) {
                    boolean wide;
                    boolean bl2 = wide = CustomTornadoConfig.getRipType(true) == 5;
                    if (wide) {
                        num = 650;
                    }
                }
                if (this.isBeyondLoadedRange()) {
                    num = (short)(num - 50);
                }
                for (class_2338 pos : class_2338.method_27156((class_5819)this.tornado.method_59922(), (int)num, (int)(offsetPos.method_10263() - pathSize), (int)(offsetPos.method_10264() - 3), (int)(offsetPos.method_10260() - pathSize), (int)(offsetPos.method_10263() + pathSize), (int)(offsetPos.method_10264() + pathSize / 2), (int)(offsetPos.method_10260() + pathSize))) {
                    boolean close;
                    MutableQuad<TornadoDestructionInfo.BlockDestroyType, class_2680, OneOrBoth<class_2680, TornadoDestructionInfo.BlockDestroyType>, Boolean> interact;
                    class_2680 state = this.world.method_8320(pos);
                    if (state.method_26215() || this.isBeyondLoadedRange && !Global.forcedTornadoChunks.contains(new class_1923(pos)) || (interact = TornadoDestructionInfo.getInteractType(state, TornadoEntity.getTornadoTypeFrom(type))) == null) continue;
                    if (interact.getA() == TornadoDestructionInfo.BlockDestroyType.PROTECT && this.tornado.getRipper().protectedAreaTime <= 0) {
                        this.protectedAreaTime = 80;
                        continue;
                    }
                    double distXZ = Utils.squaredDistanceXZ(pos, offsetPos);
                    boolean farOut = false;
                    boolean bl3 = close = distXZ <= pathSizeSquared;
                    if (!close) {
                        farOut = ripType.tryFar(this.tornado, lvl2);
                    }
                    if (!close && !farOut) continue;
                    Pair<Float, Float> rips = ripType.getRipChances(this.tornado, lvl2, pos, distXZ);
                    if (distXZ > (double)grabDistSquared) {
                        rips = NONE;
                    }
                    Pair<Float, Float> breaks = ripType.getDestroyChances(this.tornado, lvl2, pos, distXZ);
                    float failedAndDestroyChance = ripType.getDestroyFromFailChance(this.tornado, lvl2, pos);
                    Pair<Float, Float> replaces = ripType.getReplaceChances(this.tornado, lvl2, pos, distXZ);
                    this.rip(pos, rips, failedAndDestroyChance, breaks, replaces, interact);
                }
            } else {
                boolean outGrab;
                boolean bl = outGrab = this.world.method_8409().method_43048(3) == 0;
                int hdist = outGrab ? (ripType == RipType.STAGE3 ? 4 : 5 + this.tornado.method_59922().method_43048(3)) : 2;
                int ydist = ripType == RipType.STAGE3 ? 3 : 5;
                int totalYDist = this.tornado.getStats().pathSize * ydist;
                Iterator iterator = class_2338.method_25996((class_2338)this.tornado.method_24515().method_10086(totalYDist / 2), (int)(this.tornado.getStats().pathSize * hdist), (int)totalYDist, (int)(this.tornado.getStats().pathSize * hdist)).iterator();
                double farThresholdSquared = this.tornado.getStats().pathSize * 2;
                farThresholdSquared *= farThresholdSquared;
                while (iterator.hasNext()) {
                    MutableQuad<TornadoDestructionInfo.BlockDestroyType, class_2680, OneOrBoth<class_2680, TornadoDestructionInfo.BlockDestroyType>, Boolean> interact;
                    double distXZ;
                    class_2338 pos = (class_2338)iterator.next();
                    class_2680 state = this.world.method_8320(pos);
                    if (pos.method_10264() < this.tornado.method_31478() - 3 || state.method_26215() || (distXZ = Utils.squaredDistanceXZ(pos, this.tornado.method_24515())) > farThresholdSquared && this.tornado.method_59922().method_43048(5) != 0 || this.isBeyondLoadedRange() && !Global.forcedTornadoChunks.contains(new class_1923(pos)) || (interact = TornadoDestructionInfo.getInteractType(state, TornadoEntity.getTornadoTypeFrom(type))) == null) continue;
                    if (interact.getA() == TornadoDestructionInfo.BlockDestroyType.PROTECT && this.tornado.getRipper().protectedAreaTime <= 0) {
                        this.protectedAreaTime = 80;
                        continue;
                    }
                    boolean close = !outGrab && distXZ < pathSizeSquared;
                    boolean farOut = ripType.tryFar(this.tornado, lvl2);
                    if (!farOut && !close) continue;
                    Pair<Float, Float> rips = ripType.getRipChances(this.tornado, lvl2, pos, distXZ);
                    if (distXZ > (double)grabDistSquared) {
                        rips = NONE;
                    }
                    Pair<Float, Float> breaks = ripType.getDestroyChances(this.tornado, lvl2, pos, distXZ);
                    float failedAndDestroyChance = ripType.getDestroyFromFailChance(this.tornado, lvl2, pos);
                    Pair<Float, Float> replaces = ripType.getReplaceChances(this.tornado, lvl2, pos, distXZ);
                    this.rip(pos, rips, failedAndDestroyChance, breaks, replaces, interact);
                }
            }
        }
        if (!this.tornado.isDestructiveStorm() || this.tornado.getDying() || this.tornado.getSpawning()) {
            return;
        }
        if (this.tornado.field_6012 % 5 == 0) {
            ripType.destroyWithinFunnel(this.tornado);
        }
    }

    public boolean canBlockSeeTornado(class_2338 start) {
        for (int i = 0; i < 8; ++i) {
            class_2338 pos = this.tornado.method_24515().method_10086(5 * i);
            if (!Utils.canSolidPositionSee(this.world, start, pos)) continue;
            return true;
        }
        return false;
    }

    public void rip(class_2338 pos, Pair<Float, Float> ripProbs, float destroyProbIfFailRip, Pair<Float, Float> destroyProbs, Pair<Float, Float> replaceProbs, MutableQuad<TornadoDestructionInfo.BlockDestroyType, class_2680, OneOrBoth<class_2680, TornadoDestructionInfo.BlockDestroyType>, Boolean> info) {
        class_2680 state = info.getB();
        if (info.getD().booleanValue() && this.protectedAreaTime <= 0) {
            this.protectedAreaTime = 20;
        }
        if (info.getA().isRip()) {
            float prob = (info.getA() == TornadoDestructionInfo.BlockDestroyType.RARE_RIP ? (Float)ripProbs.getSecond() : (Float)ripProbs.getFirst()).floatValue();
            float m = 1.0f;
            float x = ModConfig.getMaxDebrisPerTornado();
            if (x >= 70.0f) {
                m = Math.max(1.2f, Math.min(4.0f, 1.2f + 2.5f * (x - 70.0f) / 100.0f));
                if (info.getA() == TornadoDestructionInfo.BlockDestroyType.RARE_RIP) {
                    m = 1.2f;
                }
            }
            prob *= m;
            if (info.getA() != TornadoDestructionInfo.BlockDestroyType.RARE_RIP && this.protectedAreaTime > 0 && !Materials.isAggregate(state) && !this.world.method_8311(pos.method_10084())) {
                prob *= this.protectedAreaTime > 20 ? 0.0f : 0.25f;
                destroyProbIfFailRip *= this.protectedAreaTime > 20 ? 0.0f : 0.25f;
            }
            if (!this.isBeyondLoadedRange() && this.playerNearbyForRipping && (state.method_27852(WCBlocks.TORNADO_DISPELLER) || this.world.field_9229.method_43057() < prob && !this.tornado.getRotator().maxDebrisReached())) {
                if (state.method_28501().stream().anyMatch(p -> p.method_11902() == class_2756.class)) {
                    this.world.method_22352(pos, TornadoDestructionInfo.shouldStateDrop(state));
                    return;
                }
                if (!state.method_26227().method_15769() && state instanceof class_3737) {
                    state = (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
                }
                DebrisEntity debris = DebrisEntity.createDebris(WCEntities.DEBRIS, this.tornado, pos, state, true);
                debris.method_5725(pos, 0.0f, 0.0f);
                this.world.method_8649((class_1297)debris);
                if (this.tornado.getRotator() != null) {
                    this.tornado.getRotator().getDebris().add(debris);
                }
                this.dealWithBamboo(pos);
                this.world.method_8501(pos, class_2246.field_10124.method_9564());
            } else {
                float f = this.world.method_8409().method_43057();
                float f2 = info.getA() == TornadoDestructionInfo.BlockDestroyType.RARE_RIP ? prob * 3.0f : destroyProbIfFailRip;
                if (f < f2 && !state.method_27852(WCBlocks.TORNADO_DISPELLER) && info.getA() != TornadoDestructionInfo.BlockDestroyType.MUST_RIP) {
                    this.dealWithBamboo(pos);
                    if ((double)this.world.method_8409().method_43057() < 0.3) {
                        this.world.method_22352(pos, false);
                    } else {
                        float p2;
                        int totalTornadoes = Global.activeTornadoes.size();
                        float f3 = totalTornadoes > 3 ? 0.05f : (totalTornadoes > 2 ? 0.1f : (p2 = totalTornadoes > 1 ? 0.2f : 0.4f));
                        if (ModConfig.getCullDebrisRendering()) {
                            p2 = (float)((double)p2 / 1.5);
                        }
                        if (this.world.method_8409().method_43057() < p2) {
                            WCNetworkServer.forceDebrisParticlesWithin((class_3218)this.world, 212, pos, class_2248.method_9507((class_2680)state));
                        }
                        this.world.method_8501(pos, class_2246.field_10124.method_9564());
                    }
                } else {
                    OneOrBoth<class_2680, TornadoDestructionInfo.BlockDestroyType> rData = TornadoDestructionInfo.getReplaceableState(state, TornadoEntity.getTornadoTypeFrom(this.tornado.getTornadoType()), ModConfig.getTornadoDestructionLvl());
                    if (rData != null) {
                        info.updateA(rData.getAdditional());
                        info.updateC(rData);
                        this.rip(pos, (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)), 0.0f, (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)), replaceProbs, info);
                        return;
                    }
                }
            }
        } else if (info.getA().isBreak()) {
            float prob = (info.getA() == TornadoDestructionInfo.BlockDestroyType.BREAK ? (Float)destroyProbs.getFirst() : (Float)destroyProbs.getSecond()).floatValue();
            if (this.protectedAreaTime > 0) {
                prob *= this.protectedAreaTime > 20 ? 0.35f : 0.75f;
            }
            if (this.world.method_8409().method_43057() < prob) {
                this.dealWithBamboo(pos);
                if (TornadoDestructionInfo.shouldStateDrop(state)) {
                    this.world.method_22352(pos, true);
                    return;
                }
                this.world.method_22352(pos, false);
                return;
            }
        } else if (info.getA().isReplace() && info.getC() != null) {
            class_2680 replaceable;
            float prob = (info.getA() == TornadoDestructionInfo.BlockDestroyType.REPLACE ? (Float)replaceProbs.getFirst() : (Float)replaceProbs.getSecond()).floatValue();
            if (this.world.field_9229.method_43057() < prob && (replaceable = info.getC().get(this.tornado.method_59922())) != null) {
                if (ModConfig.getTornadoDestructionLvl() < 2 && this.tornado.getStats().ripType.shouldUseWideDestruction() && replaceable.method_27852(class_2246.field_10253)) {
                    double d = this.tornado.method_59922().method_43057();
                    double d2 = this.tornado.getStats().ripType == RipType.STAGE5 ? 0.023 : 0.0115;
                    if (d < d2) {
                        replaceable = class_2246.field_10124.method_9564();
                        WCNetworkServer.forceDebrisParticlesWithin((class_3218)this.world, 212, pos, class_2248.method_9507((class_2680)state));
                    }
                }
                this.world.method_8501(pos, replaceable);
                if ((double)this.world.field_9229.method_43057() < 0.2) {
                    class_3414 event;
                    Object object = Materials.isLog(info.getB()) ? class_3417.field_14675 : (event = Materials.isBricks(info.getB()) ? class_3417.field_21076 : null);
                    if (event != null) {
                        Utils.playSound(null, this.world, pos, event, class_3419.field_15245, 0.8f + this.tornado.method_59922().method_43057() * 0.2f, 1.5f + this.tornado.method_59922().method_43057() / 3.0f);
                    }
                }
            }
        }
    }

    private void dealWithBamboo(class_2338 pos) {
        class_2680 upState = this.world.method_8320(pos.method_10084());
        class_2338.class_2339 mut = pos.method_25503();
        if (upState.method_27852(class_2246.field_10211)) {
            for (int i = 1; i < 12; ++i) {
                mut.method_33098(pos.method_10264() + i);
                if (!this.world.method_8320((class_2338)mut).method_27852(class_2246.field_10211)) break;
                this.world.method_22352((class_2338)mut, false);
            }
        }
    }

    public boolean checkIfBeyondLoadedRange() {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        int viewDistance = this.world.method_8503().method_3760().method_14568();
        class_2338 core = this.tornado.method_31476().method_33943(this.tornado.method_31478());
        if (this.isPosTooFar(core, viewDistance)) {
            this.farOut = true;
            return true;
        }
        this.farOut = false;
        class_2338 east = core.method_10079(class_2350.field_11034, 16);
        class_2338 west = core.method_10079(class_2350.field_11039, 16);
        class_2338 north = core.method_10079(class_2350.field_11043, 16);
        class_2338 south = core.method_10079(class_2350.field_11035, 16);
        class_2338 southeast = south.method_10079(class_2350.field_11034, 16);
        class_2338 southwest = south.method_10079(class_2350.field_11039, 16);
        class_2338 northeast = north.method_10079(class_2350.field_11034, 16);
        class_2338 northwest = north.method_10079(class_2350.field_11039, 16);
        positions.add(east);
        positions.add(west);
        positions.add(south);
        positions.add(north);
        positions.add(northeast);
        positions.add(northwest);
        positions.add(southeast);
        positions.add(southwest);
        for (class_2338 pos : positions) {
            if (!this.isPosTooFar(pos, viewDistance)) continue;
            return true;
        }
        return false;
    }

    private boolean isPosTooFar(class_2338 pos, int viewDistance) {
        class_2791 chunk = this.world.method_22350(pos);
        class_2338 c = chunk.method_12004().method_33943(0);
        class_1657 player = this.world.method_8604((double)c.method_10263(), (double)c.method_10264(), (double)c.method_10260(), -1.0, null);
        if (player == null) {
            return true;
        }
        int dist = (int)Utils.distanceXZ(chunk.method_12004().field_9181, chunk.method_12004().field_9180, player.method_31476().field_9181, player.method_31476().field_9180);
        if (dist <= 2) {
            return false;
        }
        return dist > viewDistance;
    }

    public boolean isBeyondLoadedRange() {
        return this.isBeyondLoadedRange;
    }

    public boolean isFarOut() {
        return this.farOut;
    }

    public static enum RipType {
        NONE,
        STAGE2,
        STAGE3,
        STAGE4,
        STAGE5;


        public static RipType fromByte(byte b) {
            switch (b) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return STAGE2;
                }
                case 2: {
                    return STAGE3;
                }
                case 3: {
                    return STAGE4;
                }
                case 4: {
                    return STAGE5;
                }
            }
            return STAGE2;
        }

        public byte asByte() {
            switch (this.ordinal()) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
            }
            return 1;
        }

        public boolean shouldUseWideDestruction() {
            return this == STAGE4 || this == STAGE5;
        }

        public Pair<Float, Float> getRipChances(TornadoEntity entity, boolean lvl2, class_2338 pos, double distSq) {
            switch (this.ordinal()) {
                case 1: {
                    if (distSq > 25.0) {
                        return Pair.of((Object)Float.valueOf(0.3f), (Object)Float.valueOf(0.02f));
                    }
                    if (lvl2) {
                        return Pair.of((Object)Float.valueOf(0.08f), (Object)Float.valueOf(0.01f));
                    }
                    return Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.01f));
                }
                case 2: {
                    if (lvl2) {
                        if (distSq > 36.0) {
                            return Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.015f));
                        }
                        return Pair.of((Object)Float.valueOf(0.03f), (Object)Float.valueOf(0.015f));
                    }
                    if (distSq > 36.0) {
                        return Pair.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.015f));
                    }
                    return Pair.of((Object)Float.valueOf(0.08f), (Object)Float.valueOf(0.015f));
                }
                case 3: {
                    if (lvl2) {
                        return Pair.of((Object)Float.valueOf(0.05f), (Object)Float.valueOf(0.025f));
                    }
                    return Pair.of((Object)Float.valueOf(0.3f), (Object)Float.valueOf(0.025f));
                }
                case 4: {
                    if (lvl2) {
                        return Pair.of((Object)Float.valueOf(0.05f), (Object)Float.valueOf(0.04f));
                    }
                    return Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.05f));
                }
            }
            return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        }

        public float getDestroyFromFailChance(TornadoEntity entity, boolean lvl2, class_2338 pos) {
            switch (this.ordinal()) {
                case 1: {
                    if (lvl2) {
                        return 0.7f;
                    }
                    return 0.45f;
                }
                case 2: {
                    if (pos.method_10264() > entity.method_31478() + 3) {
                        return 0.25f;
                    }
                    return 0.15f;
                }
                case 3: {
                    return lvl2 ? 0.2f : 0.3f;
                }
                case 4: {
                    return lvl2 ? 0.25f : 0.3f;
                }
            }
            return 0.0f;
        }

        public Pair<Float, Float> getDestroyChances(TornadoEntity entity, boolean lvl2, class_2338 pos, double distSq) {
            switch (this.ordinal()) {
                case 1: {
                    if (lvl2) {
                        return Pair.of((Object)Float.valueOf(0.8f), (Object)Float.valueOf(0.03f));
                    }
                    return Pair.of((Object)Float.valueOf(0.7f), (Object)Float.valueOf(0.03f));
                }
                case 2: {
                    if (lvl2) {
                        return Pair.of((Object)Float.valueOf(0.75f), (Object)Float.valueOf(0.05f));
                    }
                    return Pair.of((Object)Float.valueOf(0.7f), (Object)Float.valueOf(0.05f));
                }
                case 3: {
                    if (lvl2) {
                        return Pair.of((Object)Float.valueOf(0.65f), (Object)Float.valueOf(0.08f));
                    }
                    return Pair.of((Object)Float.valueOf(0.55f), (Object)Float.valueOf(0.08f));
                }
                case 4: {
                    if (lvl2) {
                        return Pair.of((Object)Float.valueOf(0.6f), (Object)Float.valueOf(0.1f));
                    }
                    return Pair.of((Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.1f));
                }
            }
            return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        }

        public Pair<Float, Float> getReplaceChances(TornadoEntity entity, boolean lvl2, class_2338 pos, double distSq) {
            switch (this.ordinal()) {
                case 1: {
                    if (lvl2) {
                        return Pair.of((Object)Float.valueOf(0.27f), (Object)Float.valueOf(0.008f));
                    }
                    if (distSq < 4.0) {
                        return Pair.of((Object)Float.valueOf(0.8f), (Object)Float.valueOf(0.006f));
                    }
                    return Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.005f));
                }
                case 2: {
                    if (lvl2) {
                        return Pair.of((Object)Float.valueOf(0.18f), (Object)Float.valueOf(0.008f));
                    }
                    return Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.005f));
                }
                case 3: {
                    if (lvl2) {
                        return Pair.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.06f));
                    }
                    return Pair.of((Object)Float.valueOf(0.35f), (Object)Float.valueOf(0.03f));
                }
                case 4: {
                    if (lvl2) {
                        return Pair.of((Object)Float.valueOf(0.3f), (Object)Float.valueOf(0.1f));
                    }
                    return Pair.of((Object)Float.valueOf(0.45f), (Object)Float.valueOf(0.08f));
                }
            }
            return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        }

        public boolean tryFar(TornadoEntity entity, boolean lvl2) {
            switch (this.ordinal()) {
                case 1: {
                    return entity.method_59922().method_43048(5) == 0;
                }
                case 2: {
                    return entity.method_59922().method_43048(2) == 0;
                }
                case 3: {
                    return entity.method_59922().method_43048(4) == 0;
                }
                case 4: {
                    return entity.method_59922().method_43048(3) == 0;
                }
            }
            return false;
        }

        public void destroyWithinFunnel(TornadoEntity ent) {
            boolean customSmall;
            boolean bl = customSmall = ent.getTornadoType() == 5 && CustomTornadoConfig.getScaling() <= 0.55f;
            if (ent.isDemon() || customSmall) {
                return;
            }
            boolean narrow = ent.getTornadoType() == 5 && CustomTornadoConfig.getRipType(true) == 7;
            switch (this.ordinal()) {
                case 1: {
                    this.destroyWithinFunnel(ent, ent.method_37908(), ent.method_24515().method_10086(32), narrow ? 8 : 16, narrow ? 10 : 30, (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.01f)), (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.55f), (Object)Float.valueOf(0.01f)), (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.18f), (Object)Float.valueOf(0.01f)), 0.35f);
                    break;
                }
                case 2: {
                    this.destroyWithinFunnel(ent, ent.method_37908(), ent.method_24515().method_10086(32), 28, 60, (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.01f)), (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.65f), (Object)Float.valueOf(0.01f)), (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.18f), (Object)Float.valueOf(0.005f)), 0.45f);
                    break;
                }
                case 3: {
                    this.destroyWithinFunnel(ent, ent.method_37908(), ent.method_24515().method_10086(32), 32, 90, (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.1f), (Object)Float.valueOf(0.01f)), (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.65f), (Object)Float.valueOf(0.02f)), (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.003f)), 0.55f);
                    break;
                }
                case 4: {
                    this.destroyWithinFunnel(ent, ent.method_37908(), ent.method_24515().method_10086(32), 42, 100, (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.05f), (Object)Float.valueOf(0.008f)), (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.7f), (Object)Float.valueOf(0.03f)), (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.001f)), 0.65f);
                    break;
                }
            }
        }

        private void destroyWithinFunnel(TornadoEntity tornado, class_1937 world, class_2338 center, int dist, int count, Pair<Float, Float> ripProbs, Pair<Float, Float> destroyProbs, Pair<Float, Float> replaceProbs, float totalProb) {
            int maxAdd = 64;
            int max = tornado.method_31478() + maxAdd;
            int min = tornado.method_31478() + (this.shouldUseWideDestruction() ? 3 : tornado.getStats().pathSize * 5 - 5);
            Iterator it = class_2338.method_34848((class_5819)tornado.method_59922(), (int)count, (class_2338)center, (int)dist).iterator();
            while (it.hasNext()) {
                class_2338.class_2339 pos = ((class_2338)it.next()).method_25503();
                if (pos.method_10264() < min) continue;
                if (pos.method_10264() > max) {
                    pos.method_33098(max - tornado.method_59922().method_43048(maxAdd));
                }
                if (tornado.getStats().ripType.shouldUseWideDestruction() && pos.method_10264() < tornado.method_31478() + 10 && Utils.distanceXZ((class_2338)pos, tornado.method_24515()) > (double)(tornado.getStats().pathSize + 3)) continue;
                class_2338.class_2339 op = pos.method_25503();
                for (int xx = -1; xx <= 1; ++xx) {
                    block2: for (int yy = -1; yy <= 2; ++yy) {
                        for (int zz = -1; zz <= 1; ++zz) {
                            MutableQuad<TornadoDestructionInfo.BlockDestroyType, class_2680, OneOrBoth<class_2680, TornadoDestructionInfo.BlockDestroyType>, Boolean> interact;
                            if (tornado.method_59922().method_43057() > totalProb) continue;
                            op.method_10103(pos.method_10263() + xx, pos.method_10264() + yy, pos.method_10260() + zz);
                            class_2680 s = world.method_8320((class_2338)op);
                            if (s.method_26215() || (interact = TornadoDestructionInfo.getInteractType(s, TornadoEntity.getTornadoTypeFrom(tornado.getTornadoType()))) == null) continue;
                            if (interact.getA() == TornadoDestructionInfo.BlockDestroyType.PROTECT && tornado.getRipper().protectedAreaTime <= 0) {
                                tornado.getRipper().protectedAreaTime = 80;
                                continue;
                            }
                            if (tornado.getRipper().isBeyondLoadedRange() && !new class_1923((class_2338)op).equals((Object)tornado.method_31476())) continue block2;
                            Pair ripProbss = ripProbs;
                            if (interact.getA().isRip() && !tornado.getRipper().canBlockSeeTornado((class_2338)op)) {
                                ripProbss = Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
                            }
                            tornado.getRipper().rip((class_2338)op, ripProbss, 1.0f, destroyProbs, replaceProbs, interact);
                        }
                    }
                }
            }
        }
    }
}

