/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.storm.debris;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2358;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.weather_classic.block.TornadoDispellerBlock;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.global.tools.TornadoDestructionInfo;
import net.weather_classic.help.BP;
import net.weather_classic.help.Materials;
import net.weather_classic.help.Utils;
import net.weather_classic.item.core_related.DebrisManipulator;
import net.weather_classic.moving_block.IMovingBlockState;
import net.weather_classic.registry.WCBlocks;
import net.weather_classic.registry.WCEntities;
import net.weather_classic.storm.TornadoEntity;

public class DebrisEntity
extends class_1676
implements IMovingBlockState {
    public final class_1937 world;
    private UUID tornadoHost = null;
    private boolean isDispeller;
    private boolean forceCollide = false;
    private double damageMultiplier = 1.0;
    private boolean doDebrisImpact = false;
    private float roll = 0.0f;
    private float lastRoll = 0.0f;
    private boolean doKnockbackInsteadOfDamage = false;
    private boolean worm = false;
    public DebrisEntity[] segments = null;
    private boolean segment = false;
    private float fakeYaw = 0.0f;
    private float fakePitch = 0.0f;
    private float prevFakeYaw = 0.0f;
    private float prevFakePitch = 0.0f;
    private DebrisEntity wormHead = null;
    private class_2338 targetPosition = null;
    private byte wormLength = 0;
    private final float rotationSpeed;
    public static final class_2940<Integer> BLOCK = class_2945.method_12791(DebrisEntity.class, (class_2941)class_2943.field_13327);

    public DebrisEntity(class_1299<? extends class_1676> entityType, class_1937 world) {
        super(entityType, world);
        this.world = world;
        this.method_5803(true);
        this.rotationSpeed = 14.0f + (float)world.field_9229.method_43048(8);
    }

    public static DebrisEntity createDebris(class_1299<? extends class_1676> entityType, class_1309 owner, class_2680 block, boolean spinning, class_1937 world) {
        DebrisEntity debris = new DebrisEntity(entityType, world);
        debris.setBlockState(block);
        debris.method_5660(spinning);
        debris.method_7432((class_1297)owner);
        debris.isDispeller = block.method_27852(WCBlocks.TORNADO_DISPELLER);
        return debris;
    }

    public static DebrisEntity createDebris(class_1299<? extends class_1676> entityType, TornadoEntity tornado, class_2338 pos, class_2680 block, boolean spinning) {
        DebrisEntity debris = new DebrisEntity(entityType, tornado.method_37908());
        debris.setBlockState(block);
        debris.method_5660(spinning);
        if (tornado != null) {
            debris.setTornadoHost(tornado.method_5667());
            debris.method_7432((class_1297)tornado);
        }
        debris.isDispeller = block.method_27852(WCBlocks.TORNADO_DISPELLER);
        return debris;
    }

    public void setAsWorm() {
        this.worm = true;
        this.world.method_8421((class_1297)this, (byte)51);
        this.method_5875(true);
        this.wormLength = (byte)(4 + this.field_5974.method_43048(12));
        if (this.field_5974.method_43048(20) == 0) {
            this.wormLength = (byte)(this.wormLength + this.field_5974.method_43048(12));
        }
    }

    public void disconnectFromHead() {
        this.wormHead = null;
    }

    private void tickSegments() {
        float diminishY = 1.0f;
        boolean failedToLoadSegments = false;
        for (int i = 0; i < this.wormLength; ++i) {
            DebrisEntity leader;
            if (this.segments[i] == null) continue;
            if (this.segments[i].method_31481()) {
                failedToLoadSegments = true;
                break;
            }
            DebrisEntity debrisEntity = leader = i == 0 ? this : this.segments[i - 1];
            if (leader == null) {
                failedToLoadSegments = true;
                break;
            }
            double followX = leader.method_23317();
            double followY = leader.method_23318();
            double followZ = leader.method_23321();
            float pitchThreshold = 10.0f;
            if (this.method_36455() > pitchThreshold || this.method_36455() < -pitchThreshold) {
                diminishY = (float)((double)diminishY + 1.7);
                float clam = this.method_36455() / 50.0f;
                clam = class_3532.method_15363((float)clam, (float)-1.8f, (float)1.8f);
                followY += (double)(clam / diminishY);
            }
            float angle = (leader.method_36454() + 180.0f) * 3.141593f / 180.0f;
            double align = 0.05 + 1.0 / (double)(i + 1) * 0.5;
            float pitchRad = (float)Math.toRadians(leader.method_36455());
            double straightX = -Math.cos(pitchRad) * (double)class_3532.method_15374((float)angle) * align;
            double straightZ = Math.cos(pitchRad) * (double)class_3532.method_15362((float)angle) * align;
            double forwardY = Math.sin(pitchRad) * align;
            class_243 dif = new class_243(this.segments[i].method_23317() - followX, this.segments[i].method_23318() - followY, this.segments[i].method_23321() - followZ);
            dif = dif.method_1029();
            dif = dif.method_1031(straightX, forwardY, straightZ);
            dif = dif.method_1029();
            double s = this.distanceForSeg();
            double destX = followX + s * dif.field_1352;
            double destY = followY + s * dif.field_1351;
            double destZ = followZ + s * dif.field_1350;
            this.segments[i].method_5808(destX, destY, destZ, this.segments[i].method_36455(), this.segments[i].method_36454());
            this.segments[i].field_6007 = true;
            Utils.lookAtVec((class_1297)this.segments[i], leader.method_19538(), 90.0f, 90.0f);
        }
        if (failedToLoadSegments) {
            this.method_31472();
        }
    }

    private float distanceForSeg() {
        return 2.0f;
    }

    public boolean isWorm() {
        return this.worm;
    }

    public boolean isSegmentOfWorm() {
        return this.segment;
    }

    public void method_5711(byte status) {
        super.method_5711(status);
        if (status == 55) {
            this.doKnockbackInsteadOfDamage = true;
        } else if (status == 51) {
            this.worm = true;
        } else if (status == 49) {
            this.segment = true;
        }
    }

    public void doWormAI() {
        if (this.wormLength <= 0) {
            this.method_31472();
            return;
        }
        if (this.segments != null) {
            this.tickSegments();
        } else {
            this.segments = new DebrisEntity[this.wormLength];
        }
        if (this.field_6012 % 40 == 0) {
            int noBody = -1;
            for (int i = 0; i < this.wormLength; ++i) {
                if (this.segments[i] != null) continue;
                noBody = i;
                break;
            }
            if (noBody > -1) {
                class_1309 lo;
                class_1297 class_12972 = this.method_24921();
                this.segments[noBody] = DebrisEntity.createDebris(WCEntities.DEBRIS, class_12972 instanceof class_1309 ? (lo = (class_1309)class_12972) : null, this.getBlockState(), false, this.world);
                this.segments[noBody].method_5725(noBody == 0 || this.segments[noBody - 1] == null ? this.method_24515() : this.segments[noBody - 1].method_24515(), 0.0f, 0.0f);
                this.segments[noBody].method_5875(true);
                this.segments[noBody].segment = true;
                this.segments[noBody].method_5728(this.field_5974.method_43056());
                this.segments[noBody].wormHead = this;
                this.segments[noBody].setDamageMultiplier(1.1);
                this.world.method_8649((class_1297)this.segments[noBody]);
                this.world.method_8421((class_1297)this.segments[noBody], (byte)49);
            }
            if (this.field_6012 > 1200 + this.field_5974.method_43048(2000)) {
                this.method_31472();
            }
        }
    }

    private class_2338 getRandomTargetPos(class_2338 center, int range) {
        for (int i = 0; i < 20; ++i) {
            int dz;
            int dy;
            int dx = center.method_10263() + this.field_5974.method_43048(range) * (this.field_5974.method_43056() ? -1 : 1);
            class_2338 pos = BP.of(dx, dy = center.method_10264() + this.field_5974.method_43048(range / 2) * (this.field_5974.method_43056() ? -1 : 1), dz = center.method_10260() + this.field_5974.method_43048(range) * (this.field_5974.method_43056() ? -1 : 1));
            if (!Utils.isTooHighFromGround(this.world, pos, 2) || !Utils.canSeePosDirectOnlyAir((class_1297)this, pos) || !Utils.canPassThrough((class_1936)this.world, pos)) continue;
            return pos;
        }
        return null;
    }

    public void method_5773() {
        super.method_5773();
        if (this.world.method_8608() || !(this.method_24921() instanceof TornadoEntity) && this.tornadoHost == null || this.field_6012 > 700) {
            this.tickM();
        }
    }

    public void tickM() {
        this.lastRoll = this.roll;
        if (this.worm || this.segment) {
            if (this.worm) {
                if (!this.world.method_8608()) {
                    this.doWormAI();
                    if (this.targetPosition == null) {
                        this.targetPosition = this.getRandomTargetPos(this.method_24515(), 15);
                        if (this.targetPosition == null) {
                            this.method_31472();
                        }
                    } else {
                        class_243 vec = this.targetPosition.method_46558();
                        this.method_18799(this.method_33571().method_1020(vec).method_1029().method_1021(-0.15));
                        this.method_5702(class_2183.class_2184.field_9851, vec);
                        if (Utils.squaredDistanceTo(this.method_19538(), vec) < 4.0) {
                            this.targetPosition = null;
                        }
                    }
                }
            } else if (!this.world.method_8608() && (this.wormHead == null || this.wormHead.method_31481() || this.field_6012 % 10 == 0 && !this.method_55667().method_26215())) {
                this.method_5875(false);
                this.segment = false;
                this.method_18800(this.field_5974.method_43057() * (float)(this.field_5974.method_43056() ? -1 : 1), this.field_5974.method_43057() * (float)(this.field_5974.method_43056() ? -1 : 1), this.field_5974.method_43057() * (float)(this.field_5974.method_43056() ? -1 : 1));
            }
            if (this.world.method_8608()) {
                this.prevFakePitch = this.fakePitch;
                this.prevFakeYaw = this.fakeYaw;
                this.fakePitch += 16.0f;
                if (this.fakePitch > 360.0f) {
                    this.fakePitch = 0.0f;
                }
                this.fakeYaw += 16.0f;
                if (this.fakeYaw > 360.0f) {
                    this.fakeYaw = 0.0f;
                }
            }
        } else if (this.targetPosition != null && Utils.squaredDistanceTo(this.targetPosition.method_46558(), this.method_33571()) < 4.840000000000001) {
            this.blockifyAt(this.targetPosition);
            return;
        }
        this.travel(this.method_18798());
        boolean water = this.method_5869();
        if (water) {
            if (this.damageMultiplier > 1.0) {
                this.setDamageMultiplier(1.0);
            }
            Utils.setVelocityY((class_1297)this, TornadoDestructionInfo.isProtectiveBlock(this.getBlockState()) ? (double)-0.4f : -0.3);
            if (this.isDispeller() && !this.world.field_9236) {
                TornadoDispellerBlock.dispel((class_3218)this.world, this.method_24515(), false);
                this.method_5650(class_1297.class_5529.field_26999);
                return;
            }
        }
        if (!this.method_5715() || this.doDebrisImpact || this.doKnockbackInsteadOfDamage) {
            this.checkCollideWithEntities(this.damageMultiplier > 1.0 || this.doKnockbackInsteadOfDamage);
        }
        if (!this.field_5960) {
            this.handleCollision();
        } else if (this.field_6012 > 5) {
            this.field_5960 = false;
        }
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_1657) {
            DebrisManipulator data;
            class_1657 player = (class_1657)class_12972;
            if (!this.world.field_9236 && (data = (DebrisManipulator)player).getManipulatingDebris() != this && this.method_5740()) {
                this.method_5875(false);
            }
        }
        if (this.shouldSpin()) {
            if (this.field_6012 % 20 == 0) {
                this.doDebrisImpact = this.world.method_18460((class_1297)this, 24.0) != null;
            }
            this.method_36456(this.method_36454() + this.rotationSpeed);
            this.roll += this.rotationSpeed / 2.0f;
            if (this.method_5628() % 3 == 0) {
                this.method_36457(this.method_36455() + this.rotationSpeed / 2.0f);
            }
        }
        if (!this.world.method_8608()) {
            if (this.field_6012 > 700 && (this.tornadoHost != null || this.method_24921() instanceof TornadoEntity)) {
                this.method_31472();
            }
            if (this.isWorm() || this.isSegmentOfWorm()) {
                this.field_6007 = true;
            }
        }
    }

    public float getLerpedFakeYaw(float delta) {
        return class_3532.method_17821((float)delta, (float)this.prevFakeYaw, (float)this.fakeYaw);
    }

    public float getLerpedFakePitch(float delta) {
        return class_3532.method_17821((float)delta, (float)this.prevFakePitch, (float)this.fakePitch);
    }

    public float getLerpedRoll(float delta) {
        return class_3532.method_17821((float)delta, (float)this.lastRoll, (float)this.roll);
    }

    public float method_61415(float delta) {
        return class_3532.method_17821((float)delta, (float)this.field_5982, (float)this.method_36454());
    }

    public float method_61414(float delta) {
        return class_3532.method_17821((float)delta, (float)this.field_6004, (float)this.method_36455());
    }

    public void setKnockbackInstead() {
        this.doKnockbackInsteadOfDamage = true;
        this.world.method_8421((class_1297)this, (byte)55);
        this.method_5728(this.field_5974.method_43056());
    }

    public void setDamageMultiplier(double d) {
        this.damageMultiplier = d;
    }

    public void checkCollideWithEntities(boolean force) {
        List entities;
        boolean movingFast;
        boolean bl = force || (this.getTornadoHost() != null ? !Utils.isVelocityZero((class_1297)this) : this.method_60478().method_1033() > 1.0) ? true : (movingFast = false);
        if (movingFast && !(entities = this.world.method_8333((class_1297)this, this.method_5829().method_1014(1.0), p -> p.method_5709())).isEmpty()) {
            for (class_1297 ent : entities) {
                if (force && ent == this.method_24921() && !this.doKnockbackInsteadOfDamage || this.world.field_9236) continue;
                if (this.doKnockbackInsteadOfDamage) {
                    if (ent.method_24828()) {
                        ent.method_18800(this.method_18798().field_1352 * this.damageMultiplier, this.method_18798().field_1351 * this.damageMultiplier, this.method_18798().field_1350 * this.damageMultiplier);
                        if (ent.method_31747()) {
                            ent.field_6037 = true;
                        }
                        this.doKnockbackInsteadOfDamage = false;
                    }
                    this.doDebrisImpact = false;
                    continue;
                }
                ent.method_64397((class_3218)this.world, this.world.method_48963().method_48798((class_1297)(this.method_24921() != null ? this.method_24921() : this)), 8.0f * (float)this.damageMultiplier);
                if (!(this.getBlockState().method_26204() instanceof class_2358)) continue;
                ent.method_5639(10.0f);
            }
        }
    }

    private void handleCollision() {
        if (!this.world.field_9236 && this.field_6012 > (this.shouldSpin() ? 40 : 10) && (this.field_5976 || this.field_5992 || this.forceCollide)) {
            class_2350 validDir = null;
            for (class_2350 dir : class_2350.values()) {
                if (Utils.canPassThrough((class_1936)this.world, this.method_24515().method_10093(dir))) continue;
                validDir = dir;
                break;
            }
            if (validDir != null || this.forceCollide) {
                if (this.getBlockState() != null) {
                    if (this.getBlockState().method_27852(class_2246.field_10375)) {
                        this.createTntExplosion();
                    } else if (!this.isDispeller()) {
                        class_2338 placePos = this.method_24515();
                        if (!Utils.canPassThrough((class_1936)this.world, placePos)) {
                            if (this.method_59922().method_43057() < 0.25f) {
                                this.world.method_22352(placePos, this.shouldBreakBlockOnImpact(placePos));
                            } else if (!Utils.canPassThrough((class_1936)this.world, placePos.method_10084())) {
                                this.world.method_22352(placePos.method_10084(), this.shouldBreakBlockOnImpact(placePos));
                            } else {
                                placePos = placePos.method_10084();
                            }
                        }
                        if (placePos != null) {
                            if (!this.world.method_8320(placePos).method_26215() && Utils.canPassThrough((class_1936)this.world, placePos)) {
                                this.world.method_22352(placePos, this.shouldBreakBlockOnImpact(placePos));
                            }
                            this.world.method_8501(placePos, this.getBlockState());
                            Utils.playSound(null, this.world, placePos, this.getBlockState().method_26231().method_10598(), this.method_5634(), 1.0f, 1.0f);
                        }
                    } else if (this.tornadoHost != null) {
                        Global.activeTornadoes.forEach(p -> {
                            if (p.method_5667().equals(this.tornadoHost)) {
                                p.dispel();
                                for (int i = 0; i < 5; ++i) {
                                    ((class_3218)this.world).method_65096((class_2394)class_2398.field_11221, (double)((float)this.method_31477() + this.field_5974.method_43057()), this.method_23318() + 0.5, (double)((float)this.method_31479() + this.field_5974.method_43057()), 0, 0.0, 0.0, 0.0, 0.0);
                                }
                                return;
                            }
                        });
                    } else {
                        TornadoDispellerBlock.dispel((class_3218)this.world, this.method_24515(), false);
                    }
                    this.method_31472();
                }
            } else if (Utils.isVelocityZero((class_1297)this) && this.method_24828()) {
                this.method_5814((double)this.method_31477() + 0.5, this.method_23318(), (double)this.method_31479() + 0.5);
            }
        }
    }

    public void setBiasedBlockifyPosition(class_2338 p) {
        this.targetPosition = p;
    }

    public void blockifyAt(class_2338 pos) {
        this.world.method_8501(pos, this.getBlockState());
        Utils.playSound(null, this.world, pos, this.getBlockState().method_26231().method_10598(), this.method_5634(), 1.0f, 1.0f);
        this.method_31472();
    }

    private boolean shouldBreakBlockOnImpact(class_2338 pos) {
        return !Materials.isAggregate(this.world.method_8320(pos)) && !Materials.isStone(this.world.method_8320(pos));
    }

    public boolean shouldSpin() {
        return this.method_5715() && !this.method_5799() && !Utils.isVelocityZero((class_1297)this);
    }

    private void createTntExplosion() {
        this.method_37908().method_55117((class_1297)this, class_1927.method_55108((class_1937)this.method_37908(), (class_1297)this), null, this.method_23317(), this.method_23323(0.0625), this.method_23321(), 4.0f, false, class_1937.class_7867.field_40891);
    }

    protected void method_7454(class_3966 entityHitResult) {
    }

    public boolean method_26958(class_1297 entity) {
        return super.method_5863() && !entity.field_5960;
    }

    public void method_5697(class_1297 entity) {
    }

    public boolean method_30949(class_1297 other) {
        if (other instanceof TornadoEntity || other instanceof IMovingBlockState) {
            return false;
        }
        return other.method_30948((class_1297)this) && !this.method_5794(other);
    }

    public void method_5982() {
        class_1657 entity = this.method_37908().method_8604(this.method_23317(), this.method_23318(), this.method_23321(), 256.0, null);
        if (entity != null) {
            return;
        }
        this.method_31472();
    }

    public void setBlockState(class_2680 state) {
        this.method_5841().method_12778(BLOCK, (Object)class_2248.method_9507((class_2680)state));
    }

    public class_2680 getBlockState() {
        return class_2248.method_9531((int)((Integer)this.method_5841().method_12789(BLOCK)));
    }

    public void setTornadoHost(UUID tornado) {
        this.tornadoHost = tornado;
    }

    public UUID getTornadoHost() {
        return this.tornadoHost;
    }

    public boolean method_5640(double distance) {
        int dist = ModConfig.getCullDebrisRendering() ? 60 : 128;
        return distance < (double)(dist * dist);
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        return source == world.method_48963().method_48829() || source == world.method_48963().method_51847() ? super.method_64397(world, source, amount) : false;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(BLOCK, (Object)class_2248.method_9507((class_2680)class_2246.field_10566.method_9564()));
    }

    public class_3419 method_5634() {
        return class_3419.field_15245;
    }

    public void method_5749(class_11368 nbt) {
        super.method_5749(nbt);
        if (!this.world.field_9236) {
            nbt.method_71426("blockID", (Codec)Codec.INT).ifPresent(i -> this.setBlockState(class_2248.method_9531((int)i)));
            nbt.method_71426("tornadoBound", (Codec)Codec.BOOL).ifPresent(i -> this.method_31472());
        }
    }

    public void method_5652(class_11372 nbt) {
        if (!this.world.field_9236) {
            nbt.method_71465("blockID", ((Integer)this.field_6011.method_12789(BLOCK)).intValue());
            if (this.tornadoHost != null && Global.activeTornadoes.stream().anyMatch(p -> p.method_5667().equals(this.tornadoHost))) {
                nbt.method_71472("tornadoBound", true);
            }
        }
        super.method_5652(nbt);
    }

    public void method_18800(double x, double y, double z) {
        this.method_18799(new class_243(x, y, z));
    }

    public void travel(class_243 vel) {
        if (!this.worm && !this.segment) {
            float f;
            class_2338 blockPos = this.method_23314();
            float p = this.method_37908().method_8320(blockPos).method_26204().method_9499();
            float f2 = this.method_24828() ? p * 0.91f : (f = this.doKnockbackInsteadOfDamage ? 0.95f : 0.91f);
            if (this.method_5740()) {
                f = 1.0f;
            }
            double vv = vel.field_1351;
            if (!this.method_5740()) {
                vel = new class_243(vel.field_1352, (vv -= 0.08) * 0.96, vel.field_1350);
            }
            this.method_18800(vel.field_1352 * (double)f, vel.field_1351, vel.field_1350 * (double)f);
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    public boolean isDispeller() {
        return this.isDispeller;
    }

    public void forceCollide() {
        this.forceCollide = true;
        this.field_6012 = 50;
    }
}

