/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.weather_classic.WeatherClassic;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.global.tools.WeatherEventProbabilityCalculator;

public class UpdateConfigCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"weather_mod").requires(source -> source.method_9259(4))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"config").then(class_2170.method_9247((String)"update").executes(ctx -> UpdateConfigCommand.executeUpdate((CommandContext<class_2168>)ctx)))).then(class_2170.method_9247((String)"preview_weather_probabilities").executes(ctx -> UpdateConfigCommand.executeTestWeather((CommandContext<class_2168>)ctx)))).then(class_2170.method_9247((String)"preview_storm_stage_probabilities").executes(ctx -> UpdateConfigCommand.executeTestStages((CommandContext<class_2168>)ctx)))));
    }

    private static int executeUpdate(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (ModConfig.WARN_DUE_TO_OUTDATED_VERSION) {
            Global.tryWarnAboutOutdatedConfig(source.method_9211());
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7cGame restart required after updating config versions."), false);
            return 1;
        }
        boolean present = true;
        try {
            present = ModConfig.loadConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        WeatherClassic.SPOUT_CONFIG.reinit(false);
        WeatherClassic.STAGE2_CONFIG.reinit(false);
        WeatherClassic.STAGE3_CONFIG.reinit(false);
        WeatherClassic.STAGE4_CONFIG.reinit(false);
        WeatherClassic.STAGE5_CONFIG.reinit(false);
        WeatherClassic.STAGEX_CONFIG.reinit(false);
        if (present) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a72Updated config on server!"), false);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"No config found! Created new file."), false);
        }
        return 1;
    }

    private static int executeTestStages(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (ModConfig.WARN_DUE_TO_OUTDATED_VERSION) {
            Global.tryWarnAboutOutdatedConfig(source.method_9211());
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7cGame restart required after updating config versions."), false);
            return 1;
        }
        UpdateConfigCommand.testStages(source);
        return 1;
    }

    private static void testStages(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"\u00a72PROBABILITY TEST:"), false);
        class_3218 world = source.method_9225();
        for (int t = 0; t < 8; ++t) {
            int goal;
            int initGoal = goal = Global.weather.getRandomWeightedStormStageGoal();
            int total = class_3218.field_41751.method_35008(world.method_8409());
            if (total < 6400) {
                total += 1200 + world.method_8409().method_43048(6400);
            }
            float forceHighStageChance = (float)ModConfig.getForceHighStageChanceIfLong() / 100.0f;
            if (total > 14000) {
                if (goal < 1 && world.method_8409().method_43057() < forceHighStageChance) {
                    goal = (byte)((double)world.method_8409().method_43057() < 0.6 ? 1 : 2);
                }
            } else if (total > 12000) {
                if (goal < 1 && world.method_8409().method_43057() < forceHighStageChance - 0.15f) {
                    goal = (byte)((double)world.method_8409().method_43057() < 0.7 ? 1 : 2);
                }
            } else if (total > 10000) {
                if (goal < 0 && world.method_8409().method_43057() < forceHighStageChance) {
                    goal = (byte)((double)world.method_8409().method_43057() < 0.15 ? 1 : 0);
                }
            } else if (total < 9000 && goal > 1 && (double)world.method_8409().method_43057() < 0.8) {
                goal = (byte)(world.method_8409().method_43056() ? -1 : 0);
            }
            if (initGoal < 0 && (double)world.method_8409().method_43057() < 0.1) {
                goal = initGoal;
            }
            if (world.method_8409().method_43057() > (float)ModConfig.getSevereStormChance() / 100.0f) {
                goal = -2;
            }
            int j = t;
            source.method_9226(() -> UpdateConfigCommand.lambda$testStages$9(j, switch (goal) {
                case -2 -> "STAGE1";
                case -1 -> "\u00a7eSTAGE2";
                case 0 -> "\u00a76STAGE3";
                case 1 -> "\u00a7cSTAGE4";
                default -> "\u00a74STAGE5";
            }), false);
        }
        source.method_9226(() -> class_2561.method_43470((String)"\u00a72REPEAT COMMAND FOR MORE EXAMPLES"), false);
    }

    private static int executeTestWeather(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (ModConfig.WARN_DUE_TO_OUTDATED_VERSION) {
            Global.tryWarnAboutOutdatedConfig(source.method_9211());
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7cGame restart required after updating config versions."), false);
            return 1;
        }
        UpdateConfigCommand.testWeather(source);
        return 1;
    }

    private static void testWeather(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"\u00a72PROBABILITY TEST:"), false);
        class_3218 world = source.method_9225();
        int daysStorm = 0;
        int daysRain = 0;
        int downpourDays = 0;
        for (int i = 0; i < 8; ++i) {
            int j = i;
            ++downpourDays;
            boolean thunder = WeatherEventProbabilityCalculator.shouldStorm((class_1937)world, world.field_9229, ++daysStorm, true);
            boolean rain = WeatherEventProbabilityCalculator.shouldRain(world.field_9229, ++daysRain);
            if (thunder) {
                source.method_9226(() -> class_2561.method_43470((String)("Day " + j + ": \u00a75THUNDER")), false);
                daysStorm = 0;
                daysRain = 0;
                continue;
            }
            if (rain) {
                boolean dp = WeatherEventProbabilityCalculator.shouldDownpour(world.method_8409(), downpourDays);
                if (dp) {
                    downpourDays = 0;
                    source.method_9226(() -> class_2561.method_43470((String)("Day " + j + ": \u00a79HEAVY")), false);
                } else {
                    source.method_9226(() -> class_2561.method_43470((String)("Day " + j + ": \u00a73RAIN")), false);
                }
                daysRain = 0;
                if (!((double)world.method_8409().method_43057() < 0.1)) continue;
                daysStorm = 0;
                continue;
            }
            source.method_9226(() -> class_2561.method_43470((String)("Day " + j + ": NONE")), false);
        }
        source.method_9226(() -> class_2561.method_43470((String)"\u00a72REPEAT COMMAND FOR MORE EXAMPLES"), false);
    }

    private static /* synthetic */ class_2561 lambda$testStages$9(int j, String stage) {
        return class_2561.method_43470((String)("Storm " + j + ": " + stage));
    }
}

