/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.gui.handled;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3929;
import net.minecraft.class_3936;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_465;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.weather_classic.WeatherClassic;
import net.weather_classic.block.TurbineBlock;
import net.weather_classic.block.entity.TurbineBlockEntity;
import net.weather_classic.block.screenhandler.TurbineScreenHandler;
import net.weather_classic.gui.ButtonWidgetBuilder;
import net.weather_classic.networking.client.WCNetworkClient;
import net.weather_classic.registry.WCBlocks;

@Environment(value=EnvType.CLIENT)
public class TurbineScreen
extends class_465<TurbineScreenHandler>
implements class_3936<TurbineScreenHandler> {
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"weather_classic", (String)"textures/gui/turbine_screen.png");
    private static final class_2960 INVENTORY = class_2960.method_60656((String)"textures/gui/container/generic_54.png");
    private static final class_2960 ABSORBTION_LVL = class_2960.method_60655((String)"weather_classic", (String)"textures/gui/turbine_absorbtion_lvl.png");
    private final int rows;
    private class_2338 turbinePos = null;
    private class_2680 turbine = null;
    private TurbineBlockEntity turbineEnt = null;
    private byte updateDataTicks = 0;

    public TurbineScreen(TurbineScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.rows = handler.getRows();
        this.field_2779 = 114 + this.rows * 18;
        this.field_25270 = this.field_2779 - 94;
    }

    protected void method_25426() {
        this.method_37067();
        super.method_25426();
        int fixedX = this.field_22789 / 2 - 25;
        int fixedY = this.field_22790 / 2 - 48;
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(fixedX, fixedY, 24, 16, (class_2561)class_2561.method_43470((String)""), buttonWidgetX -> {
            if (this.turbinePos == null || this.turbine == null) {
                return;
            }
            WCNetworkClient.sendTurbineStatePayload(this.turbinePos, (byte)(((Boolean)this.turbine.method_11654((class_2769)TurbineBlock.ACTIVE)).booleanValue() ? ((Integer)this.turbine.method_11654((class_2769)TurbineBlock.RANGE) >= 2 ? -1 : (Integer)this.turbine.method_11654((class_2769)TurbineBlock.RANGE) + 1) : 0));
            this.updateDataTicks = 1;
        }));
        class_746 player = this.field_22787.field_1724;
        class_638 world = this.field_22787.field_1687;
        class_243 rotationVector = player.method_5828(1.0f);
        class_243 eyePosition = player.method_5836(1.0f);
        class_243 targetPosition = eyePosition.method_1019(rotationVector.method_1021(64.0));
        class_3965 hitResult = world.method_17742(new class_3959(eyePosition, targetPosition, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockHit = hitResult;
            class_2680 state = world.method_8320(blockHit.method_17777());
            if (state.method_27852(WCBlocks.TURBINE)) {
                this.turbinePos = blockHit.method_17777();
                this.turbine = state;
                class_2586 be = world.method_8321(this.turbinePos);
                if (be instanceof TurbineBlockEntity) {
                    TurbineBlockEntity tbe;
                    this.turbineEnt = tbe = (TurbineBlockEntity)be;
                }
            } else {
                this.method_25419();
            }
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.turbine == null) {
            return;
        }
        int fixedX = this.field_22789 / 2 - 22;
        int fixedY = this.field_22790 / 2 - 44;
        boolean active = (Boolean)this.turbine.method_11654((class_2769)TurbineBlock.ACTIVE);
        byte num = (byte)(active ? (Integer)this.turbine.method_11654((class_2769)TurbineBlock.RANGE) + 1 : 0);
        boolean hasPower = (Boolean)this.turbine.method_11654((class_2769)TurbineBlock.POWERED);
        context.method_25303(this.field_22793, (hasPower ? (active ? "" : "\u00a77") : "\u00a78") + (num == 1 ? "LOW" : (num == 2 ? "MED" : (num == 3 ? "FAR" : "OFF"))), fixedX, fixedY, -1);
        this.method_2380(context, mouseX, mouseY);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        if (this.turbineEnt == null || this.turbine == null) {
            return;
        }
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        int imageSize = 256;
        context.method_25290(class_10799.field_56883, TEXTURE, i, j - 1, 0.0f, 0.0f, this.field_2792, this.rows * 18 + 20, imageSize, imageSize);
        context.method_25290(class_10799.field_56883, INVENTORY, i, j + this.rows * 18 + 17, 0.0f, 126.0f, this.field_2792, 96, imageSize, imageSize);
        byte indicator = (Boolean)this.turbine.method_11654((class_2769)TurbineBlock.POWERED) != false ? this.turbineEnt.getAbsorbtionIndicator() : (byte)0;
        int val = 10;
        byte max = (byte)Math.min(Math.abs(indicator), 3);
        for (byte b = 0; b < max; b = (byte)(b + 1)) {
            val = (byte)(val + 8);
        }
        context.method_25290(class_10799.field_56883, ABSORBTION_LVL, i, j + 9, 0.0f, (float)val, this.field_2792, 7, imageSize, imageSize);
    }

    private void updateTurbineData() {
        class_638 world = this.field_22787.field_1687;
        if (this.turbinePos == null || this.turbine == null || this.turbineEnt == null) {
            this.method_25419();
        }
        if (world.method_8320(this.turbinePos).method_26204() instanceof TurbineBlock) {
            this.turbine = world.method_8320(this.turbinePos);
            this.updateDataTicks = 0;
        } else {
            this.method_25419();
        }
    }

    protected void method_37432() {
        if (this.turbinePos == null || this.turbine == null) {
            this.method_25419();
        }
        if (this.updateDataTicks > 0) {
            byte by = this.updateDataTicks;
            this.updateDataTicks = (byte)(by + 1);
            if (by > 2) {
                this.updateTurbineData();
            }
        }
        if (this.field_22787.field_1687.method_8510() % 10L == 0L && this.updateDataTicks <= 0) {
            this.updateDataTicks = 1;
        }
    }

    public static void registerAsHandled() {
        class_3929.method_17542(WeatherClassic.TURBINE_HANDLER, TurbineScreen::new);
    }
}

