/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.item;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1428;
import net.minecraft.class_1452;
import net.minecraft.class_1453;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.weather_classic.WeatherClassic;
import net.weather_classic.entity.breezling.WindManipulator;
import net.weather_classic.entity.waddler.WaddlerEntity;
import net.weather_classic.global.Wind;
import net.weather_classic.global.tools.TornadoDestructionInfo;
import net.weather_classic.help.BP;
import net.weather_classic.help.Utils;
import net.weather_classic.item.core_related.DebrisManipulator;
import net.weather_classic.item.core_related.TornadoSummoner;
import net.weather_classic.misc.ItemEntityWindStateAccess;
import net.weather_classic.networking.WCNetworkServer;
import net.weather_classic.registry.WCEntities;
import net.weather_classic.registry.WCItems;
import net.weather_classic.registry.WCParticles;
import net.weather_classic.storm.debris.DebrisEntity;

public class WindCore
extends class_1792 {
    private final WindCoreLevel lvl;
    private static final class_2960 BASE_WIND_MANIPULATION_MODIFIER_ID = class_2960.method_60655((String)"weather_classic", (String)"base_wind_manipulation");
    private static final class_2960 BASE_SUMMON_VORTEX_MODIFIER_ID = class_2960.method_60655((String)"weather_classic", (String)"base_summon_vortex");

    public WindCore(class_1792.class_1793 settings, WindCoreLevel lvl) {
        super(settings);
        this.lvl = lvl;
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        textConsumer.accept((class_2561)this.getDescription().method_27692(switch (this.lvl.ordinal()) {
            case 1 -> class_124.field_1054;
            case 2 -> class_124.field_1065;
            case 3 -> class_124.field_1061;
            case 4 -> class_124.field_1079;
            default -> class_124.field_1068;
        }));
    }

    public class_5250 getDescription() {
        return class_2561.method_43471((String)(this.field_8014 + ".desc"));
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        user.method_6019(hand);
        Utils.playSound(null, world, user.method_24515(), WeatherClassic.WIND_GUST, class_3419.field_15248, 1.0f, 1.4f);
        return class_1269.field_21466;
    }

    public boolean method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657) {
            boolean invulnerable;
            class_1657 player = (class_1657)user;
            DebrisManipulator data = (DebrisManipulator)player;
            if (data.getManipulatingDebris() != null) {
                data.getManipulatingDebris().method_5875(false);
            }
            data.setManipulatingDebris(null);
            TornadoSummoner data2 = (TornadoSummoner)player;
            if (data2.getTornadoPosition() != null) {
                WCNetworkServer.sendWindCorePacket((class_3218)world, player.method_5667(), data2.getTornadoPosition(), (byte)-1);
                data2.dissipateTornado();
            }
            int maxDamage = 20;
            int maxCharge = this.method_7881(stack, user);
            int amount = Math.max(1, Math.min(maxDamage, (maxCharge - remainingUseTicks) * maxDamage / maxCharge));
            boolean bl = invulnerable = this.lvl.getByte() == 0 && stack.method_58657().method_57534().stream().anyMatch(p -> p.method_40225(class_1893.field_9119));
            if (!(world.method_8608() || invulnerable || player.method_68878())) {
                if (player != null) {
                    class_174.field_1185.method_8960((class_3222)player, stack, amount);
                }
                stack.method_7974(stack.method_7919() + amount);
            }
            if (!world.method_8608() && stack.method_7919() >= stack.method_7936() - 5) {
                Utils.playSound(null, world, user.method_24515(), WeatherClassic.BLOCK_LAUNCHER, class_3419.field_15248, 2.0f, 1.0f + world.method_8409().method_43057() / 3.0f);
                for (int windCount = 0; windCount < 20; ++windCount) {
                    double tryY = player.method_23318() + (double)(world.method_8409().method_43057() * 2.0f);
                    ((class_3218)world).method_65096((class_2394)class_2398.field_50252, player.method_23322(1.5), tryY, player.method_23325(1.5), 0, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.lvl.getByte() == 0) {
                    class_1304 slot = class_1799.method_7973((class_1799)user.method_6047(), (class_1799)stack) ? class_1304.field_6173 : class_1304.field_6171;
                    stack.method_7934(1);
                    player.method_20235(stack.method_7909(), slot);
                    return true;
                }
                byte newLvl = (byte)(this.lvl.getByte() - 1);
                newLvl = (byte)class_3532.method_15340((int)newLvl, (int)0, (int)4);
                class_1799 newStack = WindCoreLevel.getFromByte(newLvl).asStack();
                class_1799 finalStack = stack.method_7972().method_56701((class_1935)newStack.method_7909(), 1);
                finalStack.method_57379(class_9334.field_50072, (Object)newStack.method_7936());
                finalStack.method_57379(class_9334.field_49629, (Object)0);
                stack.method_7934(1);
                player.method_31548().method_7394(finalStack);
            }
            return true;
        }
        return super.method_7840(stack, world, user, remainingUseTicks);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            if (!world.method_8608()) {
                boolean forceUpdate;
                boolean stage5;
                boolean repellingInTornadoMode;
                if (remainingUseTicks < 10) {
                    player.method_7357().method_62835(stack, 120);
                    player.method_6075();
                    Utils.playSound(null, world, user.method_24515(), class_3417.field_47196, class_3419.field_15248, 1.0f, 0.4f + world.method_8409().method_43057() / 3.0f);
                    return;
                }
                class_5819 random = world.method_8409();
                boolean sneaking = player.method_5715();
                boolean mainHand = class_1799.method_7984((class_1799)stack, (class_1799)player.method_6047());
                boolean bl = repellingInTornadoMode = !this.lvl.isGravityGun() && !mainHand && sneaking;
                if (player.field_6012 % 8 == 0) {
                    Utils.playSound(null, world, player.method_24515(), WeatherClassic.WIND_GUST, class_3419.field_15248, 0.2f, (repellingInTornadoMode ? 0.5f : 1.0f) + random.method_43057() / 3.0f);
                    class_2338 inFrontPos = BP.of(Utils.getOffsetVecForRotation((class_1297)player, 7.0f, 0.0f, 0.0f, true));
                    for (int windCount = 0; windCount < this.lvl.getByte() + 1; ++windCount) {
                        double tryX = (float)inFrontPos.method_10263() + (float)(1 + random.method_43048(5)) * random.method_43057() * (float)(random.method_43056() ? -1 : 1);
                        double tryZ = (float)inFrontPos.method_10260() + (float)(1 + random.method_43048(5)) * random.method_43057() * (float)(random.method_43056() ? -1 : 1);
                        double tryY = (double)inFrontPos.method_10264() + 0.5 + (double)((float)random.method_43048(4) * random.method_43057());
                        class_243 v = player.method_19538().method_1031(0.0, 0.8, 0.0).method_1020(new class_243(tryX, tryY, tryZ)).method_1029();
                        ((class_3218)world).method_65096((class_2394)WCParticles.WIND_PARTICLE, tryX, tryY, tryZ, 0, v.field_1352, v.field_1351, v.field_1350, 0.8);
                    }
                }
                if (this.lvl.isGravityGun() || mainHand) {
                    this.tickGravityGun(world, player, random, stack);
                    return;
                }
                TornadoSummoner data = (TornadoSummoner)player;
                boolean bl2 = stage5 = this.lvl == WindCoreLevel.STAGE5;
                if (data.getTornadoPosition() != null) {
                    boolean formed;
                    int radius;
                    class_243 pos = data.getTornadoPosition();
                    if (player.field_6012 % 10 == 0 && !sneaking) {
                        class_2338 tPos = BP.of(pos);
                        boolean fireAspect = stack.method_58657().method_57534().stream().anyMatch(p -> p.method_40225(class_1893.field_9124));
                        if (fireAspect && world.method_8320(tPos.method_10074()).method_26215()) {
                            world.method_8501(tPos.method_10074(), class_2246.field_10036.method_9564());
                        }
                    }
                    int height = stage5 ? 4 : 3;
                    int n = radius = stage5 ? 10 : 6;
                    if (sneaking) {
                        radius /= 2;
                    }
                    boolean bl3 = formed = this.method_7881(stack, (class_1309)player) - remainingUseTicks > 10;
                    if (formed) {
                        boolean special = ((WindManipulator)player).getFXIndex() > 0;
                        List entities = world.method_8333((class_1297)player, new class_238(pos.field_1352 - (double)radius, pos.field_1351 - (double)height, pos.field_1350 - (double)radius, pos.field_1352 + (double)radius, pos.field_1351 + (double)height, pos.field_1350 + (double)radius), p -> !Utils.inInvalidMode(p) && !Utils.isPet(p) && !Utils.isWindImmuneMob(p));
                        for (class_1297 entity : entities) {
                            double velXZ;
                            double velY;
                            if (special) {
                                byte index = ((WindManipulator)player).getFXIndex();
                                if (index == 1 && entity instanceof class_1452) {
                                    WaddlerEntity waddler = new WaddlerEntity(WCEntities.WADDLER, world);
                                    waddler.method_60949(entity.method_19538(), entity.method_36454(), entity.method_36455());
                                    world.method_8649((class_1297)waddler);
                                    entity.method_31472();
                                    world.method_18456().forEach(p -> p.method_7353((class_2561)class_2561.method_43470((String)"\u00a7dA WADDLER HAS BEEN CONJURED"), false));
                                    Utils.playSound(null, world, entity.method_24515(), class_3417.field_14792, class_3419.field_15251, 5.0f, 1.0f);
                                } else if (index == 3 && entity instanceof class_1428) {
                                    class_1453 parrot = new class_1453(class_1299.field_6104, world);
                                    parrot.method_60949(entity.method_19538(), entity.method_36454(), entity.method_36455());
                                    world.method_8649((class_1297)parrot);
                                    entity.method_31472();
                                    world.method_18456().forEach(p -> p.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cBICORNICLOPSE\u00a7f \u00a7ahas just transformed a CHICKEN into a PARROT like some SICK FREAK!"), false));
                                    Utils.playSound(null, world, entity.method_24515(), class_3417.field_15058, class_3419.field_15251, 5.0f, 0.2f + world.method_8409().method_43057());
                                }
                            }
                            if (entity instanceof DebrisEntity || entity instanceof class_1540) continue;
                            double distXZ = Utils.distanceXZ(entity.method_19538(), pos);
                            double d = sneaking ? (double)0.2f : (velY = stage5 ? (double)0.15f : (double)0.1f);
                            if (distXZ > 2.0) {
                                velY = 0.0;
                            }
                            double d2 = velXZ = stage5 ? (double)0.3f : (double)0.1f;
                            if (sneaking) {
                                velXZ *= -1.0;
                            }
                            double xx = 0.0;
                            double zz = 0.0;
                            if (entity.method_23317() > pos.method_10216()) {
                                xx = -velXZ;
                            } else if (entity.method_23317() < pos.method_10216()) {
                                xx = velXZ;
                            }
                            if (entity.method_23321() > pos.method_10215()) {
                                zz = -velXZ;
                            } else if (entity.method_23321() < pos.method_10215()) {
                                zz = velXZ;
                            }
                            entity.method_5762(xx, velY, zz);
                            if (entity.method_31747()) {
                                entity.field_6037 = true;
                            }
                            if (stage5) continue;
                            entity.field_6017 = 0.0;
                        }
                    }
                    if (player.field_6012 % 110 == 0 && !sneaking) {
                        world.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, WeatherClassic.TORNADO_WIND_DIRECTIONAL, class_3419.field_15248, 0.57f, 1.1f + random.method_43057() * 0.4f);
                    }
                    for (int i = 0; i < 3; ++i) {
                        float radiusMult = stage5 ? 1.0f : 0.6f;
                        ((class_3218)world).method_65096((class_2394)WCParticles.WIND_CORE_TORNADO_PARTICLE, pos.method_10216() + (double)(random.method_43057() * (random.method_43056() ? -radiusMult : radiusMult)), pos.method_10214() + 0.2, pos.method_10215() + (double)(random.method_43057() * (random.method_43056() ? -radiusMult : radiusMult)), 0, 0.0, 0.0, 0.0, 0.0);
                    }
                    if (stage5 || random.method_43048(3) == 0) {
                        float windRadius = radius;
                        double px = pos.method_10216() + (double)(random.method_43057() * (random.method_43056() ? -windRadius : windRadius));
                        double pz = pos.method_10215() + (double)(random.method_43057() * (random.method_43056() ? -windRadius : windRadius));
                        class_243 v = new class_243(px, 0.0, pz).method_1020(pos).method_1029().method_1021(-10.0);
                        ((class_3218)world).method_65096((class_2394)(stage5 && random.method_43057() < 0.25f ? class_2398.field_11237 : class_2398.field_11251), px, pos.method_10214() + (double)(2.0f * random.method_43057()), pz, 0, v.field_1352, 0.1, v.field_1350, 0.5);
                    }
                    if (sneaking) {
                        data.setTornadoPosition(player.method_19538().method_1031(0.0, 0.2, 0.0));
                        if (player.field_6012 % 5 == 0) {
                            WCNetworkServer.sendWindCorePacket((class_3218)world, player.method_5667(), data.getTornadoPosition(), this.getWindCoreInfo(sneaking, stage5));
                        }
                        return;
                    }
                } else if (player.method_5715()) {
                    if (data.getTornadoPosition() == null) {
                        data.setTornadoPosition(player.method_19538().method_1031(0.0, 0.2, 0.0));
                    }
                    return;
                }
                class_243 rotationVector = player.method_5828(1.0f);
                class_243 eyePosition = player.method_5836(1.0f);
                class_243 endPoint = eyePosition.method_1019(rotationVector.method_1021(24.0));
                class_3965 hitResult = world.method_17742(new class_3959(eyePosition, endPoint, class_3959.class_3960.field_17559, class_3959.class_242.field_1347, (class_1297)player));
                boolean bl4 = forceUpdate = world.method_8510() % 30L == 0L;
                if (hitResult.method_17783() == class_239.class_240.field_1332) {
                    boolean changed = false;
                    class_3965 blockHit = hitResult;
                    class_243 bp = blockHit.method_17784();
                    if (blockHit.method_17780() == class_2350.field_11036 || Utils.canPassThrough(world.method_8320(blockHit.method_17777().method_10084()).method_26204())) {
                        if (player.field_6012 % 10 == 0) {
                            ((class_3218)world).method_65096((class_2394)class_2398.field_11204, bp.method_10216(), bp.method_10214() + 0.2, bp.method_10215(), 0, 0.0, 0.0, 0.0, 0.0);
                        }
                        if (data.getTornadoPosition() == null) {
                            data.setTornadoPosition(bp);
                            WCNetworkServer.sendWindCorePacket((class_3218)world, player.method_5667(), data.getTornadoPosition(), this.getWindCoreInfo(sneaking, stage5));
                        } else {
                            class_2338 tornadoPos;
                            class_243 currentPos = data.getTornadoPosition();
                            class_243 targetPos = bp;
                            double alpha = stage5 ? (double)0.02f : (double)0.01f;
                            double newX = currentPos.method_10216() + (targetPos.method_10216() - currentPos.method_10216()) * alpha;
                            double newY = currentPos.method_10214() + (targetPos.method_10214() + 0.2 - currentPos.method_10214()) * alpha;
                            double newZ = currentPos.method_10215() + (targetPos.method_10215() - currentPos.method_10215()) * alpha;
                            class_243 v = new class_243(newX, newY, newZ);
                            if (!data.getTornadoPosition().equals((Object)v)) {
                                data.setTornadoPosition(new class_243(newX, newY, newZ));
                                changed = true;
                            }
                            if (world.method_8320(tornadoPos = BP.of(data.getTornadoPosition())).method_51367() && !Utils.canPassThrough((class_1936)world, tornadoPos.method_10084())) {
                                player.method_7357().method_62835(stack, 120);
                                player.method_6075();
                                Utils.playSound(null, world, user.method_24515(), class_3417.field_47196, class_3419.field_15248, 1.0f, 0.4f + world.method_8409().method_43057() / 3.0f);
                            }
                        }
                        if (player.field_6012 % 5 == 0 && changed) {
                            WCNetworkServer.sendWindCorePacket((class_3218)world, player.method_5667(), data.getTornadoPosition(), this.getWindCoreInfo(sneaking, stage5));
                        }
                    }
                } else if (forceUpdate) {
                    WCNetworkServer.sendWindCorePacket((class_3218)world, player.method_5667(), data.getTornadoPosition(), this.getWindCoreInfo(sneaking, stage5));
                }
            }
        }
    }

    private byte getWindCoreInfo(boolean sneaking, boolean stage5) {
        if (stage5) {
            return (byte)(sneaking ? 3 : 1);
        }
        return (byte)(sneaking ? 2 : 0);
    }

    private void tickGravityGun(class_1937 world, class_1657 player, class_5819 random, class_1799 stack) {
        DebrisManipulator data = (DebrisManipulator)player;
        class_243 rotationVector = player.method_5828(1.0f);
        class_243 eyePosition = player.method_5836(1.0f);
        if (data.getManipulatingDebris() != null) {
            DebrisEntity debris = data.getManipulatingDebris();
            if (Utils.inInvalidMode((class_1297)debris) || debris.method_5869()) {
                data.setManipulatingDebris(null);
                return;
            }
            class_2400 particle = class_2398.field_50252;
            if (((WindManipulator)player).getFXIndex() != 0) {
                switch (((WindManipulator)player).getFXIndex()) {
                    case 1: {
                        particle = new class_2390(-65536, 0.8f);
                        break;
                    }
                    case 2: {
                        particle = new class_2390(-16711936, 0.7f);
                        break;
                    }
                    case 3: {
                        particle = new class_2390(7864150, 0.7f);
                    }
                }
            }
            for (int windCount = 0; windCount < 3; ++windCount) {
                double tryY = debris.method_23318() + (double)random.method_43057();
                ((class_3218)world).method_65096((class_2394)particle, debris.method_23322(1.5), tryY, debris.method_23325(1.5), 0, 0.0, 0.0, 0.0, 0.0);
            }
            debris.method_5875(true);
            double distance = !player.method_5715() ? 2.0 : 20.0;
            class_243 targetPosition = eyePosition.method_1019(rotationVector.method_1021(distance));
            class_243 currentPosition = debris.method_19538();
            class_243 distToTarget = targetPosition.method_1020(currentPosition);
            double maxSpeed = player.method_5715() ? this.lvl.getBlockLaunchMultiplier() : 1.0;
            double dampingFactor = Math.min(1.0, distToTarget.method_1033() / 8.0);
            class_243 velocity = distToTarget.method_1029().method_1021(maxSpeed * dampingFactor);
            if (!debris.method_5740()) {
                velocity = velocity.method_1031(0.0, 0.08, 0.0);
            }
            debris.method_18800(velocity.field_1352, velocity.field_1351, velocity.field_1350);
            if (player.method_5715()) {
                class_2338 positionO;
                debris.setDamageMultiplier(this.lvl.getBlockDamageMultiplier());
                debris.checkCollideWithEntities(true);
                data.setManipulatingDebris(null);
                player.method_7357().method_62835(stack, 10);
                player.method_6075();
                Utils.playSound(null, world, player.method_24515(), WeatherClassic.BLOCK_LAUNCHER, class_3419.field_15248, 1.0f, 1.4f);
                Utils.playSound(null, world, player.method_24515(), class_3417.field_47195, class_3419.field_15248, 1.0f, 1.0f);
                for (int windCount = 0; windCount < 3; ++windCount) {
                    double tryY = debris.method_23318() + (double)random.method_43057();
                    ((class_3218)world).method_65096((class_2394)class_2398.field_47494, debris.method_23322(1.5), tryY, debris.method_23325(1.5), 0, 0.0, 0.0, 0.0, 0.0);
                }
                class_243 farPos = eyePosition.method_1019(rotationVector.method_1021(this.lvl.b > 2 ? 24.0 : 16.0));
                class_3965 result = world.method_17742(new class_3959(player.method_33571(), farPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
                if (result.method_17783() == class_239.class_240.field_1332 && Utils.canPassThrough((class_1936)world, positionO = result.method_17777().method_10093(result.method_17780()))) {
                    debris.setBiasedBlockifyPosition(positionO);
                }
            }
            return;
        }
        class_243 endPoint = eyePosition.method_1019(rotationVector.method_1021(this.lvl.b > 2 ? 24.0 : 16.0));
        List<class_2338> bps = Utils.getBlockPosLine(world, player.method_24515(), BP.of(endPoint), 0.5f);
        for (class_2338 pos : bps) {
            List ents = world.method_8333((class_1297)player, new class_238(pos).method_1014(1.0), p -> !Utils.inInvalidMode(p) && (p.method_5709() || p instanceof ItemEntityWindStateAccess || p instanceof DebrisEntity) && !Utils.isWindImmuneMob(p));
            for (class_1297 ent : ents) {
                if (ent instanceof DebrisEntity) {
                    class_1657 pp;
                    DebrisManipulator curData;
                    class_1297 class_12972;
                    DebrisEntity deb = (DebrisEntity)ent;
                    if (deb.method_5869() || this.lvl.b < 3 || deb.method_24921() != null && (class_12972 = deb.method_24921()) instanceof class_1657 && (curData = (DebrisManipulator)(pp = (class_1657)class_12972)).getManipulatingDebris() == deb) continue;
                    deb.method_5660(false);
                    if (deb.getTornadoHost() != null) {
                        deb.setTornadoHost(null);
                    }
                    deb.method_7432((class_1297)player);
                    data.setManipulatingDebris(deb);
                    Utils.playSound(null, world, player.method_24515(), class_3417.field_47194, class_3419.field_15248, 1.0f, 0.7f);
                    continue;
                }
                if (ent instanceof ItemEntityWindStateAccess) {
                    ItemEntityWindStateAccess item = (ItemEntityWindStateAccess)ent;
                    item.enableTurbineMotion();
                    ent.method_60491(ent.method_33571().method_1020(player.method_33571()).method_1029().method_1021(-0.1));
                    continue;
                }
                if (!(player.method_5858(ent) > 4.0)) continue;
                class_243 vv = player.method_33571().method_1020(ent.method_33571()).method_1029().method_1021(this.lvl.getMobPullMultiplier(ent));
                ent.method_18800(vv.field_1352, this.lvl.canLiftMob(ent) ? vv.field_1351 / 1.5 : ent.method_18798().field_1351, vv.field_1350);
                if (!ent.method_31747()) continue;
                ent.field_6037 = true;
            }
        }
        if (player.field_6012 % 20 != 0) {
            return;
        }
        class_3965 hitResult = world.method_17742(new class_3959(eyePosition, endPoint, class_3959.class_3960.field_17559, class_3959.class_242.field_1347, (class_1297)player));
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            boolean windInteract;
            class_3965 blockHit = hitResult;
            class_2680 state = world.method_8320(blockHit.method_17777());
            boolean bl = windInteract = this.lvl.getByte() > 2 ? Wind.windInteractableStrong(state) : Wind.windInteractableWeak(state);
            if (windInteract) {
                if (!world.method_8608()) {
                    Utils.windChargeInteract((class_3218)world, blockHit.method_17777(), state);
                }
                return;
            }
            if (player.method_5715()) {
                return;
            }
            if (TornadoDestructionInfo.canWindCoreGrab(state, this.lvl)) {
                if (state.method_28501().stream().anyMatch(p -> p.method_11902() == class_2756.class)) {
                    return;
                }
                if (!state.method_26227().method_15769()) {
                    state = (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
                }
                DebrisEntity debris = DebrisEntity.createDebris(WCEntities.DEBRIS, (class_1309)player, state, false, world);
                debris.method_5725(blockHit.method_17777(), 0.0f, 0.0f);
                world.method_8649((class_1297)debris);
                world.method_8501(blockHit.method_17777(), class_2246.field_10124.method_9564());
                data.setManipulatingDebris(debris);
                Utils.playSound(null, world, player.method_24515(), class_3417.field_47194, class_3419.field_15248, 1.0f, 0.7f);
                return;
            }
        }
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, class_1304 slot) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (!world.method_8608() && !(player.method_5998(player.method_6058()).method_7909() instanceof WindCore)) {
                TornadoSummoner data2;
                DebrisManipulator data = (DebrisManipulator)player;
                if (data.getManipulatingDebris() != null) {
                    data.setManipulatingDebris(null);
                }
                if ((data2 = (TornadoSummoner)player).getTornadoPosition() != null) {
                    WCNetworkServer.sendWindCorePacket(world, player.method_5667(), data2.getTornadoPosition(), (byte)-1);
                    data2.dissipateTornado();
                }
            }
        }
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 400;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public static class_9285 createAttributeModifiers(int lvl) {
        class_9285.class_9286 b = class_9285.method_57480();
        if (lvl > 3) {
            b.method_57487(WCItems.SUMMON_VORTEX, new class_1322(BASE_SUMMON_VORTEX_MODIFIER_ID, lvl == 4 ? 1.0 : 2.0, class_1322.class_1323.field_6328), class_9274.field_49218);
        }
        return b.method_57487(WCItems.WIND_MANIPULATION, new class_1322(BASE_WIND_MANIPULATION_MODIFIER_ID, (double)lvl, class_1322.class_1323.field_6328), class_9274.field_49216).method_57486();
    }

    public static enum WindCoreLevel {
        STAGE1(0),
        STAGE2(1),
        STAGE3(2),
        STAGE4(3),
        STAGE5(4);

        final byte b;

        private WindCoreLevel(int b) {
            this.b = (byte)b;
        }

        public byte getByte() {
            return this.b;
        }

        public static WindCoreLevel getFromByte(byte b) {
            switch (b) {
                case 1: {
                    return STAGE2;
                }
                case 2: {
                    return STAGE3;
                }
                case 3: {
                    return STAGE4;
                }
                case 4: {
                    return STAGE5;
                }
            }
            return STAGE1;
        }

        public static WindCoreLevel fromStack(class_1799 stack) {
            if (stack.method_31574(WCItems.WIND_CORE_1)) {
                return STAGE1;
            }
            if (stack.method_31574(WCItems.WIND_CORE_2)) {
                return STAGE2;
            }
            if (stack.method_31574(WCItems.WIND_CORE_3)) {
                return STAGE3;
            }
            if (stack.method_31574(WCItems.WIND_CORE_4)) {
                return STAGE4;
            }
            if (stack.method_31574(WCItems.WIND_CORE_5)) {
                return STAGE5;
            }
            return null;
        }

        public class_1799 asStack() {
            switch (this.ordinal()) {
                case 1: {
                    return new class_1799((class_1935)WCItems.WIND_CORE_2);
                }
                case 2: {
                    return new class_1799((class_1935)WCItems.WIND_CORE_3);
                }
                case 3: {
                    return new class_1799((class_1935)WCItems.WIND_CORE_4);
                }
                case 4: {
                    return new class_1799((class_1935)WCItems.WIND_CORE_5);
                }
            }
            return new class_1799((class_1935)WCItems.WIND_CORE_1);
        }

        public boolean isGravityGun() {
            return this.getByte() < 3;
        }

        public double getBlockDamageMultiplier() {
            switch (this.ordinal()) {
                case 2: {
                    return 1.2;
                }
                case 3: {
                    return 1.5;
                }
                case 4: {
                    return 2.0;
                }
            }
            return 1.0;
        }

        public double getBlockLaunchMultiplier() {
            switch (this.ordinal()) {
                case 1: {
                    return 1.0;
                }
                case 2: {
                    return 2.0;
                }
                case 3: {
                    return 2.5;
                }
                case 4: {
                    return 3.0;
                }
            }
            return 0.0;
        }

        public boolean canLiftMob(class_1297 ent) {
            switch (this.ordinal()) {
                case 2: {
                    return ent.method_17681() < 1.0f && (double)ent.method_17682() < 1.3;
                }
                case 3: {
                    return (double)ent.method_17681() < 1.4 && (double)ent.method_17682() < 2.2;
                }
                case 4: {
                    return (double)ent.method_17681() < 2.5 && (double)ent.method_17682() < 3.7;
                }
                case 1: {
                    return (double)ent.method_17681() < 0.75 && ent.method_17682() < 1.0f;
                }
            }
            return false;
        }

        public double getMobPullMultiplier(class_1297 ent) {
            double baseMult = switch (this.ordinal()) {
                case 1 -> 0.25;
                case 2 -> (double)0.35f;
                case 3 -> (double)0.45f;
                case 4 -> (double)0.55f;
                default -> (double)0.2f;
            };
            boolean edited = false;
            if ((double)ent.method_17681() > 1.8) {
                baseMult -= (double)0.3f;
                edited = true;
            } else if ((double)ent.method_17681() > 1.2) {
                baseMult -= (double)0.15f;
                edited = true;
            } else if ((double)ent.method_17681() > 0.8) {
                baseMult -= (double)0.05f;
                edited = true;
            }
            if (!edited) {
                if ((double)ent.method_17682() > 2.5) {
                    baseMult -= (double)0.2f;
                } else if ((double)ent.method_17682() > 1.8) {
                    baseMult -= (double)0.1f;
                }
            }
            baseMult = Math.max(baseMult, 0.0);
            return baseMult;
        }

        public static WindCoreLevel fromShockwaveStack(class_1799 stack) {
            if (stack.method_31574(WCItems.SHOCKWAVE_ITEM_1)) {
                return STAGE1;
            }
            if (stack.method_31574(WCItems.SHOCKWAVE_ITEM_2)) {
                return STAGE2;
            }
            if (stack.method_31574(WCItems.SHOCKWAVE_ITEM_3)) {
                return STAGE3;
            }
            if (stack.method_31574(WCItems.SHOCKWAVE_ITEM_4)) {
                return STAGE4;
            }
            if (stack.method_31574(WCItems.SHOCKWAVE_ITEM_5)) {
                return STAGE5;
            }
            return null;
        }

        public class_1799 asShockwaveStack() {
            switch (this.ordinal()) {
                case 1: {
                    return new class_1799((class_1935)WCItems.SHOCKWAVE_ITEM_2);
                }
                case 2: {
                    return new class_1799((class_1935)WCItems.SHOCKWAVE_ITEM_3);
                }
                case 3: {
                    return new class_1799((class_1935)WCItems.SHOCKWAVE_ITEM_4);
                }
                case 4: {
                    return new class_1799((class_1935)WCItems.SHOCKWAVE_ITEM_5);
                }
            }
            return new class_1799((class_1935)WCItems.SHOCKWAVE_ITEM_1);
        }
    }
}

