/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.storm.sound;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3419;
import net.weather_classic.global.Global;
import net.weather_classic.help.Utils;
import net.weather_classic.storm.sound.StormSound;
import net.weather_classic.storm.sound.StormSoundInfo;

public class StormSoundManager {
    private final class_1937 world;
    private long nextPlayableLongBC = 0L;
    private long nextPlayableLongTC = 0L;
    private Map<Boolean, Pair<String, Boolean>> previousSoundAvoidanceMap = new HashMap<Boolean, Pair<String, Boolean>>();

    public StormSoundManager(class_1937 world) {
        this.world = world;
    }

    public boolean isSoundPlayable(StormSound sound, boolean forceTopChannel) {
        return sound.isTopChannel() || forceTopChannel ? Global.getCurrentMilisecondsInMod() > this.nextPlayableLongTC : Global.getCurrentMilisecondsInMod() > this.nextPlayableLongBC;
    }

    public StormSoundInfo playSound(StormSound sound, class_2338 pos, float volume, float pitch) {
        StormSoundInfo info = sound.getSound(this.world.method_8409());
        if (this.isSoundPlayable(sound, false)) {
            if (sound.isTopChannel()) {
                Utils.playSound(null, this.world, pos, info.getSoundEvent(), class_3419.field_15250, volume, pitch);
                this.nextPlayableLongTC = Global.getCurrentMilisecondsInMod() + info.getLength();
                return info;
            }
            Utils.playSound(null, this.world, pos, info.getSoundEvent(), class_3419.field_15250, volume, pitch);
            this.nextPlayableLongBC = Global.getCurrentMilisecondsInMod() + info.getLength();
            return info;
        }
        return null;
    }

    public StormSoundInfo begin(StormSound sound, long cutting, boolean forceTopChannel) {
        if (this.isSoundPlayable(sound, forceTopChannel)) {
            StormSoundInfo info = sound.getSound(this.world.method_8409());
            Pair<String, Boolean> previousInfo = this.previousSoundAvoidanceMap.get(sound.isTopChannel());
            boolean fail = false;
            if (previousInfo != null && ((Boolean)previousInfo.getSecond()).booleanValue() && ((String)previousInfo.getFirst()).equals(info.getName())) {
                fail = true;
            }
            if (fail) {
                for (StormSoundInfo si : sound.getSoundInfos()) {
                    if (si.getName().equals(info.getName())) continue;
                    info = si;
                    break;
                }
            }
            if (sound.isTopChannel() || forceTopChannel) {
                this.nextPlayableLongTC = Global.getCurrentMilisecondsInMod() + info.getLength() - cutting;
            } else {
                this.nextPlayableLongBC = Global.getCurrentMilisecondsInMod() + info.getLength() - cutting;
            }
            boolean prevent = false;
            if (previousInfo != null) {
                prevent = ((String)previousInfo.getFirst()).equals(info.getName());
            }
            this.previousSoundAvoidanceMap.put(sound.isTopChannel(), (Pair<String, Boolean>)Pair.of((Object)info.getName(), (Object)prevent));
            return info;
        }
        return null;
    }

    public class_1937 getWorld() {
        return this.world;
    }
}

