/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.structures.base;

import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3418;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.weather_classic.WeatherClassic;
import net.weather_classic.help.BP;
import net.weather_classic.help.Utils;
import net.weather_classic.structures.api.NbtStructureAccessor;
import net.weather_classic.structures.api.StructureBlockEntityData;
import org.jetbrains.annotations.Nullable;

public abstract class CustomSimpleStructurePiece
extends class_3418
implements NbtStructureAccessor {
    private final class_2470 rotate;
    private final class_2338 placementPos;
    private final String nbtName;
    private StructureBlockEntityData[] blockEntityData;

    public CustomSimpleStructurePiece(class_3773 type, class_2338 pos, int xSize, int ySize, int zSize, class_2470 rotation, String nbtName) {
        super(type, pos.method_10263(), pos.method_10264(), pos.method_10260(), xSize, ySize, zSize, Utils.directionFromBlockRotation(rotation));
        this.blockEntityData = new StructureBlockEntityData[0];
        this.rotate = rotation;
        this.nbtName = nbtName;
        this.placementPos = pos;
        this.field_15315 = CustomSimpleStructurePiece.createAdjustedBoxForBlockRotation(pos, rotation, xSize, ySize, zSize, this.field_15315);
    }

    protected CustomSimpleStructurePiece(class_3773 type, class_2487 nbt) {
        super(type, nbt);
        this.readCustomNbt(nbt);
        this.rotate = Utils.blockRotationFromDirection(this.method_14934());
        this.nbtName = nbt.method_10545("nbtStructureName") && nbt.method_10558("nbtStructureName").isPresent() ? (String)nbt.method_10558("nbtStructureName").get() : null;
        this.placementPos = nbt.method_10545("pX") && nbt.method_10545("pY") && nbt.method_10545("pZ") ? Utils.readBlockPosForNbt(nbt, "p") : (this.field_15315 != null ? BP.of(this.field_15315.method_35415(), this.field_15315.method_35416(), this.field_15315.method_35417()) : null);
    }

    protected void method_14943(class_6625 context, class_2487 nbt) {
        super.method_14943(context, nbt);
        if (this.validForPlacement()) {
            nbt.method_10582("nbtStructureName", this.nbtName);
            nbt.method_10569("pX", this.placementPos.method_10263());
            nbt.method_10569("pY", this.placementPos.method_10264());
            nbt.method_10569("pZ", this.placementPos.method_10260());
        }
        this.writeCustomNbt(nbt);
    }

    protected boolean validForPlacement() {
        return this.placementPos != null && this.nbtName != null;
    }

    public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
        if (!this.validForPlacement()) {
            WeatherClassic.LOGGER.error("Could not retrieve NBT structure data.");
            return;
        }
        this.onGeneration(world, random, chunkBox, chunkPos, this.placementPos);
        class_3492 data = new class_3492();
        data.method_15123(this.rotate);
        if (this.getProcessors() != null) {
            for (class_3491 processor : this.getProcessors()) {
                data.method_16184(processor);
            }
        }
        this.getAndPlaceNbt((class_5425)world, this.placementPos, pivot, data, this.nbtName, this.getDownwardFillBlock(), this.blockEntityData);
    }

    @Nullable
    public abstract class_2248 getDownwardFillBlock();

    public abstract List<class_3491> getProcessors();

    public void setupBlockEntityData(StructureBlockEntityData ... datas) {
        this.blockEntityData = datas;
    }

    protected abstract void onGeneration(class_5281 var1, class_5819 var2, class_3341 var3, class_1923 var4, class_2338 var5);

    protected abstract void writeCustomNbt(class_2487 var1);

    protected abstract void readCustomNbt(class_2487 var1);

    protected static class_3341 createAdjustedBoxForBlockRotation(class_2338 pos, class_2470 rotation, int width, int height, int depth, class_3341 initialBox) {
        switch (rotation) {
            case field_11465: {
                return new class_3341(pos.method_10263(), initialBox.method_35416(), pos.method_10260() - depth + 1, pos.method_10263() + width - 1, initialBox.method_35419(), pos.method_10260());
            }
            case field_11463: {
                return new class_3341(pos.method_10263() - width + 1, initialBox.method_35416(), pos.method_10260(), pos.method_10263(), initialBox.method_35419(), pos.method_10260() + depth - 1);
            }
            case field_11464: {
                return new class_3341(pos.method_10263() - width + 1, initialBox.method_35416(), pos.method_10260() - depth + 1, pos.method_10263(), initialBox.method_35419(), pos.method_10260());
            }
        }
        return initialBox;
    }
}

