/*
 * Decompiled with CFR 0.152.
 */
package org.karlssonsmp.creeperGuard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.karlssonsmp.creeperguard.bstats.bukkit.Metrics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J3\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J9\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H\u0016\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/karlssonsmp/creeperGuard/CreeperGuard;", "Lorg/bukkit/plugin/java/JavaPlugin;", "Lorg/bukkit/event/Listener;", "Lorg/bukkit/command/TabCompleter;", "<init>", "()V", "protectionEnabled", "", "prefix", "", "onEnable", "", "saveState", "onEntityExplode", "event", "Lorg/bukkit/event/entity/EntityExplodeEvent;", "onCommand", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "onTabComplete", "", "alias", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "CreeperGuard"})
@SourceDebugExtension(value={"SMAP\nCreeperGuard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreeperGuard.kt\norg/karlssonsmp/creeperGuard/CreeperGuard\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n774#2:96\n865#2,2:97\n*S KotlinDebug\n*F\n+ 1 CreeperGuard.kt\norg/karlssonsmp/creeperGuard/CreeperGuard\n*L\n90#1:96\n90#1:97,2\n*E\n"})
public final class CreeperGuard
extends JavaPlugin
implements Listener,
TabCompleter {
    private boolean protectionEnabled = true;
    @NotNull
    private final String prefix;

    public CreeperGuard() {
        this.prefix = "\u00a78\u00a7l\u1d04\u0280\u1d07\u1d07\u1d18\u1d07\u0280\u0262\u1d1c\u1d00\u0280\u1d05 \u00a77\u00bb \u00a7r";
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.protectionEnabled = this.getConfig().getBoolean("creeperguard-enabled", true);
        boolean metricsEnabled = this.getConfig().getBoolean("metrics", true);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        PluginCommand pluginCommand = this.getCommand("creeperguard");
        if (pluginCommand != null) {
            pluginCommand.setExecutor((CommandExecutor)this);
        }
        PluginCommand pluginCommand2 = this.getCommand("creeperguard");
        if (pluginCommand2 != null) {
            pluginCommand2.setTabCompleter((TabCompleter)this);
        }
        if (metricsEnabled) {
            int pluginId = 26867;
            new Metrics(this, pluginId);
        }
        this.getLogger().info("CreeperGuard is ready to protect your builds from creeper damage!");
    }

    private final void saveState() {
        this.getConfig().set("creeperguard-enabled", (Object)this.protectionEnabled);
        this.saveConfig();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public final void onEntityExplode(@NotNull EntityExplodeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.protectionEnabled) {
            return;
        }
        if (event.getEntity().getType() == EntityType.CREEPER) {
            event.blockList().clear();
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args2) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args2, "args");
        if (!sender.hasPermission("creeperguard.admin")) {
            sender.sendMessage(this.prefix + "\u00a7cYou don't have permission to do that.");
            return true;
        }
        String string3 = ArraysKt.getOrNull(args2, 0);
        if (string3 != null) {
            String string4 = string3.toLowerCase(Locale.ROOT);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
        } else {
            string2 = string = null;
        }
        if (Intrinsics.areEqual(string, "on")) {
            if (this.protectionEnabled) {
                sender.sendMessage(this.prefix + "\u00a7aCreeper protection is already ON");
            } else {
                this.protectionEnabled = true;
                this.saveState();
                sender.sendMessage(this.prefix + "\u00a7aCreeper protection ON");
            }
        } else if (Intrinsics.areEqual(string, "off")) {
            if (!this.protectionEnabled) {
                sender.sendMessage(this.prefix + "\u00a7cCreeper protection is already OFF");
            } else {
                this.protectionEnabled = false;
                this.saveState();
                sender.sendMessage(this.prefix + "\u00a7cCreeper protection OFF");
            }
        } else {
            sender.sendMessage(this.prefix + "\u00a77Usage: /" + label + " [on | off]");
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args2) {
        List list;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(alias, "alias");
        Intrinsics.checkNotNullParameter(args2, "args");
        if (!sender.hasPermission("creeperguard.admin")) {
            return CollectionsKt.emptyList();
        }
        if (args2.length == 1) {
            void $this$filterTo$iv$iv;
            String[] stringArray = new String[]{"on", "off"};
            List<String> options = CollectionsKt.listOf(stringArray);
            Iterable $this$filter$iv = options;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                String string = args2[0].toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                if (!StringsKt.startsWith$default(it, string, false, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

