/*
 * Decompiled with CFR 0.152.
 */
package org.karlssonsmp.creeperGuard;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.karlssonsmp.creeperguard.bstats.bukkit.Metrics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007J3\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/karlssonsmp/creeperGuard/CreeperGuard;", "Lorg/bukkit/plugin/java/JavaPlugin;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "protectionEnabled", "", "prefix", "", "onEnable", "", "saveState", "onEntityExplode", "event", "Lorg/bukkit/event/entity/EntityExplodeEvent;", "onCommand", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "CreeperGuard"})
public final class CreeperGuard
extends JavaPlugin
implements Listener {
    private boolean protectionEnabled = true;
    @NotNull
    private final String prefix;

    public CreeperGuard() {
        this.prefix = "\u00a78\u00a7l\u1d04\u0280\u1d07\u1d07\u1d18\u1d07\u0280\u0262\u1d1c\u1d00\u0280\u1d05 \u00a77\u00bb \u00a7r";
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.protectionEnabled = this.getConfig().getBoolean("creeperguard-enabled", true);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        PluginCommand pluginCommand = this.getCommand("creeperguard");
        if (pluginCommand != null) {
            pluginCommand.setExecutor((CommandExecutor)this);
        }
        int pluginId = 26867;
        new Metrics(this, pluginId);
        this.getLogger().info("CreeperGuard is ready to protect your builds from creeper damage!");
    }

    private final void saveState() {
        this.getConfig().set("creeperguard-enabled", (Object)this.protectionEnabled);
        this.saveConfig();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public final void onEntityExplode(@NotNull EntityExplodeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.protectionEnabled) {
            return;
        }
        if (event.getEntity().getType() == EntityType.CREEPER) {
            event.blockList().clear();
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args2) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args2, "args");
        if (!sender.hasPermission("creeperguard.admin")) {
            sender.sendMessage(this.prefix + "\u00a7cYou don't have permission to do that.");
            return true;
        }
        String string3 = ArraysKt.getOrNull(args2, 0);
        if (string3 != null) {
            String string4 = string3.toLowerCase(Locale.ROOT);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
        } else {
            string2 = string = null;
        }
        if (Intrinsics.areEqual(string, "on")) {
            this.protectionEnabled = true;
            this.saveState();
            sender.sendMessage(this.prefix + "\u00a7aCreeper protection ON");
        } else if (Intrinsics.areEqual(string, "off")) {
            this.protectionEnabled = false;
            this.saveState();
            sender.sendMessage(this.prefix + "\u00a7cCreeper protection OFF");
        } else {
            sender.sendMessage(this.prefix + "\u00a77Usage: /" + label + " [on | off]");
        }
        return true;
    }
}

