/*
 * Decompiled with CFR 0.152.
 */
package com.fernsehheft.clearlag;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Keyed;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.LeavesDecayEvent;

public class BlockBreakListener
implements Listener {
    private final ArrayList<BlockFace> neighbors = new ArrayList<BlockFace>(List.of(BlockFace.values()));

    public BlockBreakListener() {
        this.neighbors.remove(BlockFace.SELF);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (Tag.LEAVES.isTagged((Keyed)block.getType())) {
            this.breakLeaf(block, this.isValidLeaf(block), block);
        }
        if (Tag.LOGS.isTagged((Keyed)block.getType())) {
            this.breakLeaf(block, false, block);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onLeavesDecay(LeavesDecayEvent event) {
        this.breakLeaf(event.getBlock(), this.isValidLeaf(event.getBlock(), event.getBlock()), event.getBlock());
    }

    private void breakLeaf(Block block, boolean breakFirstBlock, Block originalBlock) {
        if (breakFirstBlock) {
            block.breakNaturally();
        }
        for (BlockFace neighbor : this.neighbors) {
            Block neighborBlock = block.getRelative(neighbor);
            if (!this.isValidLeaf(neighborBlock, originalBlock)) continue;
            this.breakLeaf(neighborBlock, true, block);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isValidLeaf(Block block, Block originalBlock) {
        void leafBlock;
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Leaves)) {
            return false;
        }
        Leaves leaves = (Leaves)blockData;
        if (leafBlock.getDistance() < 7) {
            return false;
        }
        if (leafBlock.isPersistent()) {
            return false;
        }
        return BlockBreakListener.distance(block, originalBlock) < 35;
    }

    private boolean isValidLeaf(Block block) {
        return this.isValidLeaf(block, block);
    }

    private static int distance(Block b1, Block b2) {
        return Math.abs(b1.getX() - b2.getX()) + Math.abs(b1.getY() - b2.getY()) + Math.abs(b1.getZ() - b2.getZ());
    }
}

