/*
 * Decompiled with CFR 0.152.
 */
package com.fernsehheft.clearlag;

import com.fernsehheft.clearlag.ClearLag;
import java.text.DecimalFormat;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ClearLagExpansion
extends PlaceholderExpansion {
    private final ClearLag plugin;
    private final DecimalFormat decimalFormat = new DecimalFormat("#.##");

    public ClearLagExpansion(ClearLag plugin) {
        this.plugin = plugin;
    }

    public String getIdentifier() {
        return "clearlag";
    }

    public String getAuthor() {
        return (String)this.plugin.getDescription().getAuthors().get(0);
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return false;
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier.equalsIgnoreCase("nextclear")) {
            if (!this.plugin.autoClearEnabled) {
                return "Disabled";
            }
            long currentTime = System.currentTimeMillis();
            long timeUntilNextClear = this.plugin.lastClearTime + (long)this.plugin.autoClearInterval * 1000L - currentTime;
            return this.formatTime(timeUntilNextClear / 1000L);
        }
        if (identifier.equalsIgnoreCase("ram")) {
            long totalMemory = Runtime.getRuntime().totalMemory() / 0x100000L;
            long freeMemory = Runtime.getRuntime().freeMemory() / 0x100000L;
            double usedMemory = totalMemory - freeMemory;
            return this.decimalFormat.format(usedMemory) + " MB / " + totalMemory + " MB";
        }
        if (identifier.equalsIgnoreCase("entity_total")) {
            int totalEntities = 0;
            for (World world : Bukkit.getWorlds()) {
                totalEntities += world.getEntities().size();
            }
            return String.valueOf(totalEntities);
        }
        if (identifier.toLowerCase().startsWith("entity_world_")) {
            String worldName = identifier.substring("entity_world_".length());
            World world = Bukkit.getWorld((String)worldName);
            if (world != null) {
                return String.valueOf(world.getEntities().size());
            }
            return "Unknown World";
        }
        if (identifier.equalsIgnoreCase("stats")) {
            return this.plugin.getLastClearStats();
        }
        if (identifier.equalsIgnoreCase("lastclear_items")) {
            return String.valueOf(this.plugin.getLastClearItems());
        }
        if (identifier.equalsIgnoreCase("lastclear_entities")) {
            return String.valueOf(this.plugin.getLastClearEntities());
        }
        if (identifier.equalsIgnoreCase("lastclear_total")) {
            return String.valueOf(this.plugin.getLastClearTotal());
        }
        if (identifier.equalsIgnoreCase("nextclear_seconds")) {
            if (!this.plugin.autoClearEnabled) {
                return "0";
            }
            long currentTime = System.currentTimeMillis();
            long timeUntilNextClear = this.plugin.lastClearTime + (long)this.plugin.autoClearInterval * 1000L - currentTime;
            long totalSeconds = timeUntilNextClear / 1000L;
            return String.valueOf(Math.max(totalSeconds, 0L));
        }
        if (identifier.equalsIgnoreCase("autoclear_enabled")) {
            return this.plugin.autoClearEnabled ? "Active" : "Disabled";
        }
        if (identifier.equalsIgnoreCase("autoclear_interval")) {
            return String.valueOf(this.plugin.autoClearInterval);
        }
        if (identifier.equalsIgnoreCase("dropped_items_total")) {
            int totalItems = 0;
            for (World world : Bukkit.getWorlds()) {
                totalItems += world.getEntitiesByClass(Item.class).size();
            }
            return String.valueOf(totalItems);
        }
        if (identifier.toLowerCase().startsWith("entities_in_world_")) {
            String worldName = identifier.substring("entities_in_world_".length());
            World world = Bukkit.getWorld((String)worldName);
            if (world != null) {
                return String.valueOf(world.getEntities().size());
            }
            return "Unknown World";
        }
        if (identifier.equalsIgnoreCase("mobs_total")) {
            int totalMobs = 0;
            for (World world : Bukkit.getWorlds()) {
                for (LivingEntity entity : world.getLivingEntities()) {
                    if (entity instanceof Player || entity instanceof ArmorStand || entity instanceof ItemFrame) continue;
                    ++totalMobs;
                }
            }
            return String.valueOf(totalMobs);
        }
        if (identifier.equalsIgnoreCase("loaded_chunks")) {
            int totalChunks = 0;
            for (World world : Bukkit.getWorlds()) {
                totalChunks += world.getLoadedChunks().length;
            }
            return String.valueOf(totalChunks);
        }
        if (identifier.equalsIgnoreCase("chunkunload_threshold")) {
            return String.valueOf(this.plugin.getAutoUnloadEntityThreshold());
        }
        if (identifier.equalsIgnoreCase("lastunload_chunks")) {
            return String.valueOf(this.plugin.getLastUnloadCount());
        }
        return null;
    }

    private String formatTime(long totalSeconds) {
        if (totalSeconds < 0L) {
            totalSeconds = 0L;
        }
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        StringBuilder timeString = new StringBuilder();
        if (hours > 0L) {
            timeString.append(hours).append("h ");
        }
        if (minutes > 0L) {
            timeString.append(minutes).append("m ");
        }
        timeString.append(seconds).append("s");
        return timeString.toString().trim();
    }
}

