/*
 * Decompiled with CFR 0.152.
 */
package com.fernsehheft.clearlag;

import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Breedable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class ClearLag
extends JavaPlugin
implements CommandExecutor,
Listener,
TabCompleter {
    private ClearLag plugin;
    private BukkitTask clearTask;
    private long lastClearTime = 0L;
    private boolean autoClearEnabled;
    private int autoClearInterval;
    private boolean clearItems;
    private boolean clearEntities;
    private List<String> excludedEntities;
    private List<String> excludedItems;
    private boolean redstoneOptimizationEnabled;
    private boolean armorStandLimitEnabled;
    private int armorStandChunkLimit;
    private int armorStandGlobalLimit;
    private boolean itemFrameLimitEnabled;
    private int itemFrameChunkLimit;
    private int itemFrameGlobalLimit;
    private boolean mobSpawnLimitEnabled;
    private int hostileMobLimitPer4Chunks;
    private int passiveMobLimitPer4Chunks;
    private boolean hopperOptimizationEnabled;
    private boolean farmLimiterEnabled;
    private boolean mobAIOptimizationEnabled;
    private double mobDespawnDistance;
    private int mobAICheckInterval;
    private boolean performanceWarningsEnabled;
    private boolean chunkUnloadingOptimizationEnabled;
    private boolean debugModeEnabled;
    private boolean countdownSoundsEnabled;
    private boolean clearSoundsEnabled;
    private boolean broadcastMessagesEnabled;
    private Set<Integer> countdownMessagesAt;
    private boolean autoClearExcludeNamed;
    private boolean autoClearExcludeBred;
    private boolean autoClearExcludeTagged;
    private boolean killMobsExcludeNamed;
    private boolean killMobsExcludeBred;
    private boolean killMobsExcludeTagged;
    private boolean aiOptimizationExcludeNamed;
    private boolean aiOptimizationExcludeBred;
    private boolean aiOptimizationExcludeTagged;
    private Map<Chunk, Map<EntityType, Integer>> chunkEntityCounts;
    private Map<EntityType, Integer> globalEntityCounts;
    private List<Double> tpsHistory;
    private List<Double> msptHistory;
    private List<Double> cpuHistory;
    private List<Double> ramHistory;
    private final int HISTORY_SIZE = 3600;
    private final Map<Location, Long> lastRedstoneUpdate = new ConcurrentHashMap<Location, Long>();
    private final long REDSTONE_COOLDOWN_MS = 50L;
    private final Map<UUID, Long> mobLastPlayerCheck = new ConcurrentHashMap<UUID, Long>();
    private BukkitTask mobAITask;

    public void onEnable() {
        this.plugin = this;
        this.saveDefaultConfig();
        this.loadConfig();
        this.getCommand("clearlag").setExecutor((CommandExecutor)this);
        this.getCommand("clearlag").setAliases(Arrays.asList("cl"));
        this.getCommand("settings").setExecutor((CommandExecutor)this);
        this.getCommand("clearlag").setTabCompleter((TabCompleter)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.chunkEntityCounts = new ConcurrentHashMap<Chunk, Map<EntityType, Integer>>();
        this.globalEntityCounts = new ConcurrentHashMap<EntityType, Integer>();
        for (EntityType type : Arrays.asList(EntityType.ARMOR_STAND, EntityType.ITEM_FRAME)) {
            this.globalEntityCounts.put(type, 0);
        }
        this.tpsHistory = Collections.synchronizedList(new ArrayList());
        this.msptHistory = Collections.synchronizedList(new ArrayList());
        this.cpuHistory = Collections.synchronizedList(new ArrayList());
        this.ramHistory = Collections.synchronizedList(new ArrayList());
        if (this.autoClearEnabled) {
            this.startAutoClearTask();
            this.getLogger().info("Auto-Clear is enabled and starts every " + this.autoClearInterval + " seconds.");
        }
        this.startPerformanceMonitoringTask();
        if (this.mobAIOptimizationEnabled) {
            this.startMobAIOptimizationTask();
            this.getLogger().info("Mob AI Optimization is enabled.");
        }
        this.getLogger().info("ClearLag has been successfully enabled!");
    }

    public void onDisable() {
        if (this.clearTask != null) {
            this.clearTask.cancel();
        }
        if (this.mobAITask != null) {
            this.mobAITask.cancel();
        }
        this.getLogger().info("ClearLag has been disabled!");
    }

    public void loadConfig() {
        this.reloadConfig();
        this.autoClearEnabled = this.getConfig().getBoolean("auto-clear.enabled", true);
        this.autoClearInterval = this.getConfig().getInt("auto-clear.interval-seconds", 300);
        this.clearItems = this.getConfig().getBoolean("auto-clear.clear-items", true);
        this.clearEntities = this.getConfig().getBoolean("auto-clear.clear-entities", true);
        this.excludedEntities = this.getConfig().getStringList("auto-clear.excluded-entities");
        this.excludedItems = this.getConfig().getStringList("auto-clear.excluded-items");
        this.autoClearExcludeNamed = this.getConfig().getBoolean("auto-clear.exclusions.named", false);
        this.autoClearExcludeBred = this.getConfig().getBoolean("auto-clear.exclusions.bred", false);
        this.autoClearExcludeTagged = this.getConfig().getBoolean("auto-clear.exclusions.tagged", false);
        this.killMobsExcludeNamed = this.getConfig().getBoolean("kill-mobs.exclusions.named", false);
        this.killMobsExcludeBred = this.getConfig().getBoolean("kill-mobs.exclusions.bred", false);
        this.killMobsExcludeTagged = this.getConfig().getBoolean("kill-mobs.exclusions.tagged", false);
        this.aiOptimizationExcludeNamed = this.getConfig().getBoolean("optimizations.ai-optimization.exclusions.named", false);
        this.aiOptimizationExcludeBred = this.getConfig().getBoolean("optimizations.ai-optimization.exclusions.bred", false);
        this.aiOptimizationExcludeTagged = this.getConfig().getBoolean("optimizations.ai-optimization.exclusions.tagged", false);
        this.redstoneOptimizationEnabled = this.getConfig().getBoolean("optimizations.redstone.enabled", true);
        this.armorStandLimitEnabled = this.getConfig().getBoolean("optimizations.item-frame-armor-stand-limiter.armor-stand.enabled", true);
        this.armorStandChunkLimit = this.getConfig().getInt("optimizations.item-frame-armor-stand-limiter.armor-stand.chunk-limit", 10);
        this.armorStandGlobalLimit = this.getConfig().getInt("optimizations.item-frame-armor-stand-limiter.armor-stand.global-limit", 100);
        this.itemFrameLimitEnabled = this.getConfig().getBoolean("optimizations.item-frame-armor-stand-limiter.item-frame.enabled", true);
        this.itemFrameChunkLimit = this.getConfig().getInt("optimizations.item-frame-armor-stand-limiter.item-frame.chunk-limit", 10);
        this.itemFrameGlobalLimit = this.getConfig().getInt("optimizations.item-frame-armor-stand-limiter.item-frame.global-limit", 100);
        this.mobSpawnLimitEnabled = this.getConfig().getBoolean("optimizations.mob-spawn-limiter.enabled", true);
        this.hostileMobLimitPer4Chunks = this.getConfig().getInt("optimizations.mob-spawn-limiter.hostile-limit-per-4-chunks", 30);
        this.passiveMobLimitPer4Chunks = this.getConfig().getInt("optimizations.mob-spawn-limiter.passive-limit-per-4-chunks", 20);
        this.hopperOptimizationEnabled = this.getConfig().getBoolean("optimizations.hopper-optimization.enabled", true);
        this.farmLimiterEnabled = this.getConfig().getBoolean("optimizations.farm-limiter.enabled", true);
        this.mobAIOptimizationEnabled = this.getConfig().getBoolean("optimizations.ai-optimization.enabled", true);
        this.mobDespawnDistance = this.getConfig().getDouble("optimizations.ai-optimization.despawn-distance-blocks", 64.0);
        this.mobAICheckInterval = this.getConfig().getInt("optimizations.ai-optimization.check-interval-seconds", 30);
        this.performanceWarningsEnabled = this.getConfig().getBoolean("optimizations.performance-warnings.enabled", true);
        this.chunkUnloadingOptimizationEnabled = this.getConfig().getBoolean("optimizations.chunk-unloading-optimization.enabled", false);
        this.debugModeEnabled = this.getConfig().getBoolean("debug-mode", false);
        this.countdownSoundsEnabled = this.getConfig().getBoolean("sounds.countdown-enabled", true);
        this.clearSoundsEnabled = this.getConfig().getBoolean("sounds.clear-enabled", true);
        this.broadcastMessagesEnabled = this.getConfig().getBoolean("messages.broadcast-enabled", true);
        this.countdownMessagesAt = this.getConfig().getIntegerList("countdown-messages-at").stream().collect(Collectors.toSet());
        if (this.debugModeEnabled) {
            this.getLogger().setLevel(Level.INFO);
        } else {
            this.getLogger().setLevel(Level.WARNING);
        }
        if (this.mobAIOptimizationEnabled) {
            this.startMobAIOptimizationTask();
        } else if (this.mobAITask != null) {
            this.mobAITask.cancel();
            this.mobAITask = null;
        }
        this.getLogger().info("ClearLag configuration reloaded.");
    }

    private void startAutoClearTask() {
        if (this.clearTask != null) {
            this.clearTask.cancel();
        }
        this.clearTask = new BukkitRunnable(){
            int countdown;
            long lastSecond;
            {
                this.countdown = ClearLag.this.autoClearInterval;
                this.lastSecond = System.currentTimeMillis();
            }

            public void run() {
                if (System.currentTimeMillis() - this.lastSecond < 1000L) {
                    return;
                }
                this.lastSecond = System.currentTimeMillis();
                if (this.countdown <= 0) {
                    ClearLag.this.performClear("auto");
                    ClearLag.this.lastClearTime = System.currentTimeMillis();
                    this.countdown = ClearLag.this.autoClearInterval;
                    return;
                }
                if (ClearLag.this.broadcastMessagesEnabled && ClearLag.this.countdownMessagesAt.contains(this.countdown)) {
                    Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GOLD) + "[ClearLag] Items and entities will be cleared in " + String.valueOf(ChatColor.RED) + this.countdown + String.valueOf(ChatColor.GOLD) + " seconds!"));
                }
                if (ClearLag.this.countdownSoundsEnabled && ClearLag.this.countdownMessagesAt.contains(this.countdown)) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
                    }
                }
                --this.countdown;
            }
        }.runTaskTimer((Plugin)this, 20L, 20L);
    }

    public int performClear(String type) {
        int removedCount = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (entity instanceof Player || entity instanceof LivingEntity && this.isExcludedMob((LivingEntity)entity, "auto-clear")) continue;
                if (type.equals("all") || type.equals("auto")) {
                    if (this.clearItems && entity instanceof Item) {
                        if (this.isItemExcluded((Item)entity)) continue;
                        entity.remove();
                        ++removedCount;
                        continue;
                    }
                    if (!this.clearEntities || entity instanceof Item || this.isEntityExcluded(entity)) continue;
                    entity.remove();
                    ++removedCount;
                    continue;
                }
                if (type.equals("items") && entity instanceof Item) {
                    if (this.isItemExcluded((Item)entity)) continue;
                    entity.remove();
                    ++removedCount;
                    continue;
                }
                if (!type.equals("entity") || entity instanceof Item || this.isEntityExcluded(entity)) continue;
                entity.remove();
                ++removedCount;
            }
        }
        if (this.broadcastMessagesEnabled) {
            Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GREEN) + "[ClearLag] " + removedCount + " entities have been removed!"));
        }
        return removedCount;
    }

    private boolean isItemExcluded(Item item) {
        if (item.getItemStack() == null || item.getItemStack().getType() == null) {
            return false;
        }
        return this.excludedItems.contains(item.getItemStack().getType().name());
    }

    private boolean isEntityExcluded(Entity entity) {
        return this.excludedEntities.contains(entity.getType().name());
    }

    private boolean isExcludedMob(LivingEntity mob, String category) {
        switch (category) {
            case "auto-clear": {
                if (this.autoClearExcludeNamed && mob.getCustomName() != null) {
                    return true;
                }
                if (this.autoClearExcludeBred && mob instanceof Breedable && ((Breedable)mob).isAdult()) {
                    return true;
                }
                if (!this.autoClearExcludeTagged || !mob.getScoreboardTags().contains("clearlag_exclude")) break;
                return true;
            }
            case "kill-mobs": {
                if (this.killMobsExcludeNamed && mob.getCustomName() != null) {
                    return true;
                }
                if (this.killMobsExcludeBred && mob instanceof Breedable && ((Breedable)mob).isAdult()) {
                    return true;
                }
                if (!this.killMobsExcludeTagged || !mob.getScoreboardTags().contains("clearlag_exclude")) break;
                return true;
            }
            case "ai-optimization": {
                if (this.aiOptimizationExcludeNamed && mob.getCustomName() != null) {
                    return true;
                }
                if (this.aiOptimizationExcludeBred && mob instanceof Breedable && ((Breedable)mob).isAdult()) {
                    return true;
                }
                if (!this.aiOptimizationExcludeTagged || !mob.getScoreboardTags().contains("clearlag_exclude")) break;
                return true;
            }
        }
        return false;
    }

    public int killMobs(String mobType) {
        int killedCount = 0;
        for (World world : Bukkit.getWorlds()) {
            for (LivingEntity entity : world.getLivingEntities()) {
                if (entity.getType() == EntityType.PLAYER || entity instanceof ArmorStand || entity instanceof ItemFrame || this.isExcludedMob(entity, "kill-mobs")) continue;
                boolean isHostile = this.isHostile(entity.getType());
                if (mobType.equals("all")) {
                    entity.remove();
                    ++killedCount;
                    continue;
                }
                if (mobType.equals("evil") && isHostile) {
                    entity.remove();
                    ++killedCount;
                    continue;
                }
                if (!mobType.equals("good") || isHostile) continue;
                entity.remove();
                ++killedCount;
            }
        }
        return killedCount;
    }

    private boolean isHostile(EntityType type) {
        switch (type) {
            case ELDER_GUARDIAN: 
            case WITHER_SKELETON: 
            case STRAY: 
            case HUSK: 
            case EVOKER: 
            case VINDICATOR: 
            case CREEPER: 
            case SKELETON: 
            case SPIDER: 
            case ZOMBIE: 
            case SLIME: 
            case GHAST: 
            case ZOMBIFIED_PIGLIN: 
            case ENDERMAN: 
            case BLAZE: 
            case MAGMA_CUBE: 
            case ENDER_DRAGON: 
            case WITHER: 
            case WITCH: 
            case GUARDIAN: 
            case SHULKER: 
            case PHANTOM: 
            case DROWNED: 
            case PILLAGER: 
            case RAVAGER: 
            case HOGLIN: 
            case ZOGLIN: 
            case PIGLIN_BRUTE: {
                return true;
            }
        }
        return false;
    }

    public boolean isArmorStandLimitEnabled() {
        return this.armorStandLimitEnabled;
    }

    public int getArmorStandChunkLimit() {
        return this.armorStandChunkLimit;
    }

    public int getArmorStandGlobalLimit() {
        return this.armorStandGlobalLimit;
    }

    public boolean isItemFrameLimitEnabled() {
        return this.itemFrameLimitEnabled;
    }

    public int getItemFrameChunkLimit() {
        return this.itemFrameChunkLimit;
    }

    public int getItemFrameGlobalLimit() {
        return this.itemFrameGlobalLimit;
    }

    public void incrementEntityCount(Chunk chunk, EntityType type) {
        this.chunkEntityCounts.computeIfAbsent(chunk, k -> new ConcurrentHashMap()).merge(type, 1, Integer::sum);
        this.globalEntityCounts.merge(type, 1, Integer::sum);
        this.debugLog("Incremented " + type.name() + " in chunk " + chunk.getX() + "," + chunk.getZ() + ". Chunk count: " + this.getChunkEntityCount(chunk, type) + ", Global count: " + this.getGlobalEntityCount(type));
    }

    public void decrementEntityCount(Chunk chunk, EntityType type) {
        this.chunkEntityCounts.computeIfAbsent(chunk, k -> new ConcurrentHashMap()).merge(type, -1, Integer::sum);
        this.globalEntityCounts.merge(type, -1, Integer::sum);
        this.debugLog("Decremented " + type.name() + " in chunk " + chunk.getX() + "," + chunk.getZ() + ". Chunk count: " + this.getChunkEntityCount(chunk, type) + ", Global count: " + this.getGlobalEntityCount(type));
    }

    public int getChunkEntityCount(Chunk chunk, EntityType type) {
        return ((Map)this.chunkEntityCounts.getOrDefault(chunk, new HashMap())).getOrDefault(type, 0);
    }

    public int getGlobalEntityCount(EntityType type) {
        return this.globalEntityCounts.getOrDefault(type, 0);
    }

    public void initializeChunkCounts(Chunk chunk) {
        if (!this.chunkEntityCounts.containsKey(chunk)) {
            ConcurrentHashMap<EntityType, Integer> counts = new ConcurrentHashMap<EntityType, Integer>();
            Entity[] entityArray = chunk.getEntities();
            int n = entityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Entity entity = entityArray[n2];
                if (entity instanceof ArmorStand) {
                    counts.merge(EntityType.ARMOR_STAND, 1, Integer::sum);
                    this.globalEntityCounts.merge(EntityType.ARMOR_STAND, 1, Integer::sum);
                } else if (entity instanceof ItemFrame) {
                    counts.merge(EntityType.ITEM_FRAME, 1, Integer::sum);
                    this.globalEntityCounts.merge(EntityType.ITEM_FRAME, 1, Integer::sum);
                }
                ++n2;
            }
            this.chunkEntityCounts.put(chunk, counts);
            this.debugLog("Initialized counts for chunk " + chunk.getX() + "," + chunk.getZ());
        }
    }

    public void removeChunkCounts(Chunk chunk) {
        Map<EntityType, Integer> counts = this.chunkEntityCounts.remove(chunk);
        if (counts != null) {
            for (Map.Entry<EntityType, Integer> entry : counts.entrySet()) {
                this.globalEntityCounts.merge(entry.getKey(), -entry.getValue().intValue(), Integer::sum);
            }
            this.debugLog("Removed counts for chunk " + chunk.getX() + "," + chunk.getZ());
        }
    }

    public boolean isRedstoneOptimizationEnabled() {
        return this.redstoneOptimizationEnabled;
    }

    public boolean isMobSpawnLimitEnabled() {
        return this.mobSpawnLimitEnabled;
    }

    public int getHostileMobLimitPer4Chunks() {
        return this.hostileMobLimitPer4Chunks;
    }

    public int getPassiveMobLimitPer4Chunks() {
        return this.passiveMobLimitPer4Chunks;
    }

    public boolean isHopperOptimizationEnabled() {
        return this.hopperOptimizationEnabled;
    }

    public boolean isFarmLimiterEnabled() {
        return this.farmLimiterEnabled;
    }

    public boolean isMobAIOptimizationEnabled() {
        return this.mobAIOptimizationEnabled;
    }

    private double[] getSpigotTPS() {
        try {
            Object minecraftServer = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
            Field recentTpsField = minecraftServer.getClass().getField("recentTps");
            recentTpsField.setAccessible(true);
            return (double[])recentTpsField.get(minecraftServer);
        }
        catch (Exception e) {
            try {
                Object minecraftServer = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
                Field tpsField = minecraftServer.getClass().getField("tps");
                tpsField.setAccessible(true);
                return (double[])tpsField.get(minecraftServer);
            }
            catch (Exception e2) {
                this.getLogger().log(Level.WARNING, "Could not retrieve TPS via reflection. Falling back to default values. Errors: " + e.getMessage() + ", " + e2.getMessage());
                return new double[]{20.0, 20.0, 20.0};
            }
        }
    }

    private double getProcessCpuLoad() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            Method method = osBean.getClass().getMethod("getProcessCpuLoad", new Class[0]);
            method.setAccessible(true);
            return (Double)method.invoke((Object)osBean, new Object[0]) * 100.0;
        }
        catch (Exception e) {
            this.debugLog("Failed to get process CPU load. Error: " + e.getMessage());
            return -1.0;
        }
    }

    private String getAverage(List<Double> history, int seconds) {
        if (history.isEmpty() || seconds <= 0) {
            return "N/A";
        }
        int startIndex = Math.max(0, history.size() - seconds);
        List<Double> sublist = history.subList(startIndex, history.size());
        double sum = sublist.stream().mapToDouble(Double::doubleValue).sum();
        double average = sum / (double)sublist.size();
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(average);
    }

    private void startPerformanceMonitoringTask() {
        new BukkitRunnable(){

            public void run() {
                double[] tpsArray = ClearLag.this.getSpigotTPS();
                double tps = tpsArray[0];
                if (ClearLag.this.tpsHistory.size() >= 3600) {
                    ClearLag.this.tpsHistory.remove(0);
                }
                ClearLag.this.tpsHistory.add(tps);
                double mspt = 50.0 / tps;
                if (ClearLag.this.msptHistory.size() >= 3600) {
                    ClearLag.this.msptHistory.remove(0);
                }
                ClearLag.this.msptHistory.add(mspt);
                double cpuLoad = ClearLag.this.getProcessCpuLoad();
                if (ClearLag.this.cpuHistory.size() >= 3600) {
                    ClearLag.this.cpuHistory.remove(0);
                }
                ClearLag.this.cpuHistory.add(cpuLoad);
                long totalMemory = Runtime.getRuntime().totalMemory() / 0x100000L;
                long freeMemory = Runtime.getRuntime().freeMemory() / 0x100000L;
                double usedMemory = totalMemory - freeMemory;
                if (ClearLag.this.ramHistory.size() >= 3600) {
                    ClearLag.this.ramHistory.remove(0);
                }
                ClearLag.this.ramHistory.add(usedMemory);
            }
        }.runTaskTimer((Plugin)this, 20L, 20L);
    }

    private void startMobAIOptimizationTask() {
        if (this.mobAITask != null) {
            this.mobAITask.cancel();
        }
        final double finalMobDespawnDistanceSq = this.mobDespawnDistance * this.mobDespawnDistance;
        final int finalMobAICheckIntervalTicks = this.mobAICheckInterval * 20;
        this.mobAITask = new BukkitRunnable(){

            public void run() {
                for (World world : Bukkit.getWorlds()) {
                    long currentTime = System.currentTimeMillis();
                    for (LivingEntity entity : world.getLivingEntities()) {
                        if (entity instanceof Player || entity instanceof ItemFrame || entity instanceof ArmorStand || ClearLag.this.isExcludedMob(entity, "ai-optimization") || ClearLag.this.mobLastPlayerCheck.containsKey(entity.getUniqueId()) && currentTime - ClearLag.this.mobLastPlayerCheck.get(entity.getUniqueId()) < (long)(finalMobAICheckIntervalTicks / 20 * 1000)) continue;
                        boolean foundPlayer = false;
                        for (Player player : world.getPlayers()) {
                            if (!(player.getLocation().distanceSquared(entity.getLocation()) < finalMobDespawnDistanceSq)) continue;
                            foundPlayer = true;
                            break;
                        }
                        if (!foundPlayer) {
                            entity.remove();
                            ClearLag.this.debugLog("Despawned " + entity.getType().name() + " at " + entity.getLocation().toString() + " due to AI optimization (no nearby player).");
                        }
                        ClearLag.this.mobLastPlayerCheck.put(entity.getUniqueId(), currentTime);
                    }
                }
            }
        }.runTaskTimer((Plugin)this, (long)finalMobAICheckIntervalTicks, (long)finalMobAICheckIntervalTicks);
    }

    private void debugLog(String message) {
        if (this.debugModeEnabled) {
            this.getLogger().info("[DEBUG] " + message);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("clearlag")) {
            if (args.length == 0) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- ClearLag Commands ---");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag clear <items/entity/all> " + String.valueOf(ChatColor.WHITE) + " - Removes entities/items.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag info " + String.valueOf(ChatColor.WHITE) + " - Shows plugin information.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag killmobs <evil/good/all> " + String.valueOf(ChatColor.WHITE) + " - Removes mobs.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag reload " + String.valueOf(ChatColor.WHITE) + " - Reloads the plugin configuration.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag nextclear " + String.valueOf(ChatColor.WHITE) + " - Shows time until next auto clear.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag cpu " + String.valueOf(ChatColor.WHITE) + " - Shows recent CPU load.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag ram " + String.valueOf(ChatColor.WHITE) + " - Shows recent RAM usage.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag specs " + String.valueOf(ChatColor.WHITE) + " - Shows combined system specs.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/settings " + String.valueOf(ChatColor.WHITE) + " - Opens the settings GUI.");
                return true;
            }
            String subCommand = args[0].toLowerCase();
            if (subCommand.equals("clear")) {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /clearlag clear <items/entity/all>");
                    return true;
                }
                String typeToClear = args[1].toLowerCase();
                int removedCount = this.performClear(typeToClear);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Removed " + removedCount + " entities of type " + typeToClear + ".");
                return true;
            }
            if (subCommand.equals("info")) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- ClearLag Info ---");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Version: " + this.getDescription().getVersion());
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Author: " + (String)this.getDescription().getAuthors().get(0));
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Website: " + this.getDescription().getWebsite());
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Auto-Clear Enabled: " + (this.autoClearEnabled ? String.valueOf(ChatColor.GREEN) + "Yes" : String.valueOf(ChatColor.RED) + "No"));
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Interval: " + this.autoClearInterval + " seconds");
                return true;
            }
            if (subCommand.equals("killmobs")) {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /clearlag killmobs <evil/good/all>");
                    return true;
                }
                String mobType = args[1].toLowerCase();
                int killedCount = this.killMobs(mobType);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Killed " + killedCount + " mobs of type " + mobType + ".");
                return true;
            }
            if (subCommand.equals("reload")) {
                this.loadConfig();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "ClearLag configuration reloaded!");
                if (this.autoClearEnabled) {
                    this.startAutoClearTask();
                } else if (this.clearTask != null) {
                    this.clearTask.cancel();
                    this.clearTask = null;
                }
                return true;
            }
            if (subCommand.equals("nextclear")) {
                long currentTime = System.currentTimeMillis();
                long timeUntilNextClear = this.lastClearTime + (long)(this.autoClearInterval * 1000) - currentTime;
                if (timeUntilNextClear < 0L) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "An auto-clear is currently in progress or about to happen.");
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Next auto clear in " + String.valueOf(ChatColor.AQUA) + timeUntilNextClear / 1000L + String.valueOf(ChatColor.YELLOW) + " seconds.");
                }
                return true;
            }
            if (subCommand.equals("cpu")) {
                if (this.cpuHistory.isEmpty()) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "CPU history is not yet available. Please wait a moment.");
                    return true;
                }
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- CPU Usage (System-wide) ---");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 1 min: " + this.getAverage(this.cpuHistory, 60) + "%");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 5 min: " + this.getAverage(this.cpuHistory, 300) + "%");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 10 min: " + this.getAverage(this.cpuHistory, 600) + "%");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 30 min: " + this.getAverage(this.cpuHistory, 1800) + "%");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 60 min: " + this.getAverage(this.cpuHistory, 3600) + "%");
                return true;
            }
            if (subCommand.equals("ram")) {
                if (this.ramHistory.isEmpty()) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "RAM history is not yet available. Please wait a moment.");
                    return true;
                }
                long totalMemory = Runtime.getRuntime().totalMemory() / 0x100000L;
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- RAM Usage (JVM) ---");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Total Memory: " + totalMemory + " MB");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 1 min: " + this.getAverage(this.ramHistory, 60) + " MB");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 5 min: " + this.getAverage(this.ramHistory, 300) + " MB");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 10 min: " + this.getAverage(this.ramHistory, 600) + " MB");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 30 min: " + this.getAverage(this.ramHistory, 1800) + " MB");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 60 min: " + this.getAverage(this.ramHistory, 3600) + " MB");
                return true;
            }
            if (subCommand.equals("specs")) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- Server Performance Summary ---");
                double[] tpsArray = this.getSpigotTPS();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "TPS: " + new DecimalFormat("#.##").format(tpsArray[0]));
                if (this.cpuHistory.isEmpty()) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "CPU: N/A");
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "CPU (1m Avg): " + this.getAverage(this.cpuHistory, 60) + "%");
                }
                if (this.ramHistory.isEmpty()) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "RAM: N/A");
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "RAM (1m Avg): " + this.getAverage(this.ramHistory, 60) + " MB");
                }
                return true;
            }
        } else if (command.getName().equalsIgnoreCase("settings")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players.");
                return true;
            }
            Player player = (Player)sender;
            this.openSettingsGUI(player);
            return true;
        }
        return false;
    }

    private void openSettingsGUI(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)36, (String)"ClearLag Settings");
        ItemStack soundToggle = new ItemStack(Material.NOTE_BLOCK);
        ItemMeta soundMeta = soundToggle.getItemMeta();
        soundMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Toggle Countdown Sounds");
        ArrayList<CallSite> soundLore = new ArrayList<CallSite>();
        soundLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Click to toggle sounds for the auto-clear countdown.")));
        soundLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Status: " + (this.countdownSoundsEnabled ? String.valueOf(ChatColor.GREEN) + "ON" : String.valueOf(ChatColor.RED) + "OFF"))));
        soundMeta.setLore(soundLore);
        soundToggle.setItemMeta(soundMeta);
        gui.setItem(11, soundToggle);
        ItemStack messageToggle = new ItemStack(Material.PAPER);
        ItemMeta messageMeta = messageToggle.getItemMeta();
        messageMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Toggle Broadcast Messages");
        ArrayList<CallSite> messageLore = new ArrayList<CallSite>();
        messageLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Click to toggle broadcast messages for auto-clear.")));
        messageLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Status: " + (this.broadcastMessagesEnabled ? String.valueOf(ChatColor.GREEN) + "ON" : String.valueOf(ChatColor.RED) + "OFF"))));
        messageMeta.setLore(messageLore);
        messageToggle.setItemMeta(messageMeta);
        gui.setItem(15, messageToggle);
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals("ClearLag Settings")) {
            event.setCancelled(true);
            Player player = (Player)event.getWhoClicked();
            if (event.getSlot() == 11) {
                this.countdownSoundsEnabled = !this.countdownSoundsEnabled;
                this.getConfig().set("sounds.countdown-enabled", (Object)this.countdownSoundsEnabled);
                this.saveConfig();
                this.loadConfig();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Countdown sounds have been toggled to " + (this.countdownSoundsEnabled ? "ON" : "OFF"));
                this.openSettingsGUI(player);
            } else if (event.getSlot() == 15) {
                this.broadcastMessagesEnabled = !this.broadcastMessagesEnabled;
                this.getConfig().set("messages.broadcast-enabled", (Object)this.broadcastMessagesEnabled);
                this.saveConfig();
                this.loadConfig();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Broadcast messages have been toggled to " + (this.broadcastMessagesEnabled ? "ON" : "OFF"));
                this.openSettingsGUI(player);
            }
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("clearlag")) {
            if (args.length == 1) {
                List<String> subCommands = Arrays.asList("clear", "info", "killmobs", "reload", "nextclear", "cpu", "ram", "specs", "settings");
                return subCommands.stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
            }
            if (args.length == 2) {
                if (args[0].equalsIgnoreCase("clear")) {
                    return Arrays.asList("items", "entity", "all");
                }
                if (args[0].equalsIgnoreCase("killmobs")) {
                    return Arrays.asList("evil", "good", "all");
                }
            }
        }
        return new ArrayList<String>();
    }
}

