/*
 * Decompiled with CFR 0.152.
 */
package com.fernsehheft.clearlag;

import com.fernsehheft.clearlag.ClearLagExpansion;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Breedable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class ClearLag
extends JavaPlugin
implements CommandExecutor,
Listener,
TabCompleter {
    public ClearLag plugin;
    public BukkitTask clearTask;
    public long lastClearTime = 0L;
    public boolean updateAvailable = false;
    private String newVersionString = "";
    private File logFile;
    private YamlConfiguration logConfig;
    private boolean discordWebhookEnabled;
    private String discordWebhookUrl;
    private boolean discordReportEnabled;
    private int discordReportInterval;
    private BukkitTask discordReportTask;
    private final AtomicInteger entitiesRemovedSinceReport = new AtomicInteger(0);
    private final AtomicInteger lastClearItems = new AtomicInteger(0);
    private final AtomicInteger lastClearEntities = new AtomicInteger(0);
    private final AtomicInteger lastClearTotal = new AtomicInteger(0);
    private final AtomicInteger lastUnloadCount = new AtomicInteger(0);
    private String lastClearStats = "No data";
    public boolean autoClearEnabled;
    public int autoClearInterval;
    private boolean clearItems;
    private boolean clearEntities;
    private List<String> excludedEntities;
    private List<String> excludedItems;
    private List<String> excludedWorlds;
    private boolean redstoneOptimizationEnabled;
    private boolean armorStandLimitEnabled;
    private int armorStandChunkLimit;
    private int armorStandGlobalLimit;
    private boolean itemFrameLimitEnabled;
    private int itemFrameChunkLimit;
    private int itemFrameGlobalLimit;
    private boolean mobSpawnLimitEnabled;
    private int hostileMobLimitPer4Chunks;
    private int passiveMobLimitPer4Chunks;
    private boolean hopperOptimizationEnabled;
    private boolean farmLimiterEnabled;
    private boolean mobAIOptimizationEnabled;
    private double mobDespawnDistance;
    private int mobAICheckInterval;
    private boolean performanceWarningsEnabled;
    private double tpsWarningThreshold;
    private int warningCheckInterval;
    private String warningMessage;
    private int performanceWarningStartupDelay;
    private boolean debugModeEnabled;
    private boolean hideAllCommands;
    private boolean broadcastMessagesEnabled;
    private Set<Integer> countdownMessagesAt;
    private boolean autoClearExcludeNamed;
    private boolean autoClearExcludeBred;
    private boolean autoClearExcludeTagged;
    private boolean killMobsExcludeNamed;
    private boolean killMobsExcludeBred;
    private boolean killMobsExcludeTagged;
    private boolean aiOptimizationExcludeNamed;
    private boolean aiOptimizationExcludeBred;
    private boolean aiOptimizationExcludeTagged;
    private boolean fastClockDetectorEnabled;
    private int fastClockThreshold;
    private int fastClockBlockDuration;
    private boolean fastClockNotifyPlayers;
    private final Map<Chunk, AtomicInteger> chunkRedstoneActivations = new ConcurrentHashMap<Chunk, AtomicInteger>();
    private final Map<Chunk, Long> blockedRedstoneChunks = new ConcurrentHashMap<Chunk, Long>();
    private BukkitTask fastClockCheckTask;
    private boolean deathItemProtectionEnabled;
    private int deathItemProtectionDuration;
    private boolean blockVersionCommand;
    private boolean blockPluginsCommand;
    private boolean autoUnloadEnabled;
    private int autoUnloadInterval;
    private int autoUnloadEntityThreshold;
    private double autoUnloadMinPlayerDistanceSq;
    private List<String> autoUnloadExcludedWorlds;
    private boolean autoUnloadExcludeImportant;
    private BukkitTask autoUnloadTask;
    private boolean mobStackingEnabled;
    private double stackRadiusH;
    private double stackRadiusV;
    private int stackInterval;
    private int minStackSize;
    private int maxStackSize;
    private String stackNameFormat;
    private List<String> mobStackingExcludedMobs;
    private final Map<String, Boolean> mobStackingExclusions = new HashMap<String, Boolean>();
    private BukkitTask mobStackingTask;
    private boolean antiPhysicsAbuseEnabled;
    private Set<Material> physicsBlockList = new HashSet<Material>();
    private int physicsCheckInterval;
    private int physicsThreshold;
    private String physicsAction;
    private int physicsLimitDuration;
    private final AtomicInteger fallingBlockCounter = new AtomicInteger(0);
    private BukkitTask antiPhysicsCheckTask;
    private volatile boolean physicsLimited = false;
    private long physicsLimitEndTime = 0L;
    private Map<Chunk, Map<EntityType, Integer>> chunkEntityCounts;
    private Map<EntityType, Integer> globalEntityCounts;
    private List<Double> tpsHistory;
    private List<Double> msptHistory;
    private List<Double> cpuHistory;
    private List<Double> ramHistory;
    private final int HISTORY_SIZE = 7200;
    private final Map<Location, Long> lastRedstoneUpdate = new ConcurrentHashMap<Location, Long>();
    private final long REDSTONE_COOLDOWN_MS = 50L;
    private final Map<UUID, Long> mobLastPlayerCheck = new ConcurrentHashMap<UUID, Long>();
    private BukkitTask mobAITask;
    private BukkitTask warningTask;
    private Map<UUID, Boolean> playerMessagesEnabled = new ConcurrentHashMap<UUID, Boolean>();
    private File playerDataFile;
    private YamlConfiguration playerDataConfig;
    private String prefix;

    public void onEnable() {
        this.plugin = this;
        this.saveDefaultConfig();
        this.loadConfig();
        this.lastClearTime = System.currentTimeMillis();
        this.checkForUpdates();
        this.logFile = new File(this.getDataFolder(), "log.yml");
        if (!this.logFile.exists()) {
            try {
                this.logFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Could not create log.yml file!", e);
            }
        }
        this.logConfig = YamlConfiguration.loadConfiguration((File)this.logFile);
        if (!this.logConfig.contains("logs")) {
            this.logConfig.set("logs", new ArrayList());
        }
        this.playerDataFile = new File(this.getDataFolder(), "playerdata.yml");
        if (!this.playerDataFile.exists()) {
            try {
                this.playerDataFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Could not create playerdata.yml file!", e);
            }
        }
        this.playerDataConfig = YamlConfiguration.loadConfiguration((File)this.playerDataFile);
        this.loadPlayerPreferences();
        if (Bukkit.getPluginManager().getPlugin("LuckPerms") != null) {
            this.getLogger().warning("Luckperms detected! Running in advanced permission mode.");
        } else {
            this.getLogger().warning("No Luckperms found! Running in normal permission mode (OP only except togglemessages command).");
            this.getLogger().warning("If you want to have advanced permissions, please download LuckPerms from luckperms.net");
        }
        this.getCommand("clearlag").setExecutor((CommandExecutor)this);
        this.getCommand("clearlag").setAliases(Arrays.asList("cl"));
        this.getCommand("clearlag").setTabCompleter((TabCompleter)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.chunkEntityCounts = new ConcurrentHashMap<Chunk, Map<EntityType, Integer>>();
        this.globalEntityCounts = new ConcurrentHashMap<EntityType, Integer>();
        for (EntityType type : Arrays.asList(EntityType.ARMOR_STAND, EntityType.ITEM_FRAME)) {
            this.globalEntityCounts.put(type, 0);
        }
        this.tpsHistory = Collections.synchronizedList(new ArrayList());
        this.msptHistory = Collections.synchronizedList(new ArrayList());
        this.cpuHistory = Collections.synchronizedList(new ArrayList());
        this.ramHistory = Collections.synchronizedList(new ArrayList());
        if (this.autoClearEnabled) {
            this.startAutoClearTask();
            this.getLogger().info("Auto-Clear is enabled and starts every " + this.autoClearInterval + " seconds.");
        }
        this.startPerformanceMonitoringTask();
        if (this.mobAIOptimizationEnabled) {
            this.startMobAIOptimizationTask();
            this.getLogger().info("Mob AI Optimization is enabled.");
        }
        if (this.performanceWarningsEnabled) {
            this.startPerformanceWarningTask();
            this.getLogger().info("Performance Warnings are enabled.");
        }
        if (this.discordReportEnabled) {
            this.startDiscordReportTask();
            this.getLogger().info("Discord Performance Reports are enabled.");
        }
        if (this.autoUnloadEnabled) {
            this.startAutoUnloadTask();
            this.getLogger().info("Auto-Unload for laggy chunks is enabled.");
        }
        if (this.mobStackingEnabled) {
            this.startMobStackingTask();
            this.getLogger().info("Mob Stacking is enabled.");
        }
        if (this.antiPhysicsAbuseEnabled) {
            this.startAntiPhysicsCheckTask();
            this.getLogger().info("Anti-Physics-Abuse is enabled.");
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new ClearLagExpansion(this).register();
            this.getLogger().info("PlaceholderAPI Expansion for ClearLag registered!");
        } else {
            this.getLogger().warning("PlaceholderAPI not found! ClearLag placeholders will not work.");
        }
        this.getLogger().info("ClearLag has been successfully enabled!");
    }

    public void onDisable() {
        if (this.clearTask != null) {
            this.clearTask.cancel();
        }
        if (this.mobAITask != null) {
            this.mobAITask.cancel();
        }
        if (this.warningTask != null) {
            this.warningTask.cancel();
        }
        if (this.discordReportTask != null) {
            this.discordReportTask.cancel();
        }
        if (this.fastClockCheckTask != null) {
            this.fastClockCheckTask.cancel();
        }
        if (this.autoUnloadTask != null) {
            this.autoUnloadTask.cancel();
        }
        if (this.mobStackingTask != null) {
            this.mobStackingTask.cancel();
        }
        if (this.antiPhysicsCheckTask != null) {
            this.antiPhysicsCheckTask.cancel();
        }
        this.savePlayerPreferences();
        this.getLogger().info("ClearLag has been disabled!");
    }

    private void loadPlayerPreferences() {
        if (this.playerDataConfig.contains("players")) {
            for (String uuidString : this.playerDataConfig.getConfigurationSection("players").getKeys(false)) {
                UUID uuid = UUID.fromString(uuidString);
                boolean messagesEnabled = this.playerDataConfig.getBoolean("players." + uuidString + ".messages-enabled", true);
                this.playerMessagesEnabled.put(uuid, messagesEnabled);
            }
        }
        this.getLogger().info("Loaded " + this.playerMessagesEnabled.size() + " player message preferences.");
    }

    private void savePlayerPreferences() {
        for (Map.Entry<UUID, Boolean> entry : this.playerMessagesEnabled.entrySet()) {
            this.playerDataConfig.set("players." + entry.getKey().toString() + ".messages-enabled", (Object)entry.getValue());
        }
        try {
            this.playerDataConfig.save(this.playerDataFile);
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not save player data!", e);
        }
    }

    public void loadConfig() {
        this.reloadConfig();
        this.prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("prefix", "&e[ClearLag] &r"));
        this.autoClearEnabled = this.getConfig().getBoolean("auto-clear.enabled", true);
        this.autoClearInterval = this.getConfig().getInt("auto-clear.interval-seconds", 300);
        this.clearItems = this.getConfig().getBoolean("auto-clear.clear-items", true);
        this.clearEntities = this.getConfig().getBoolean("auto-clear.clear-entities", true);
        this.excludedEntities = this.getConfig().getStringList("auto-clear.excluded-entities");
        this.excludedItems = this.getConfig().getStringList("auto-clear.excluded-items");
        this.excludedWorlds = this.getConfig().getStringList("auto-clear.excluded-worlds");
        this.autoClearExcludeNamed = this.getConfig().getBoolean("auto-clear.exclusions.named", false);
        this.autoClearExcludeBred = this.getConfig().getBoolean("auto-clear.exclusions.bred", false);
        this.autoClearExcludeTagged = this.getConfig().getBoolean("auto-clear.exclusions.tagged", false);
        this.killMobsExcludeNamed = this.getConfig().getBoolean("kill-mobs.exclusions.named", false);
        this.killMobsExcludeBred = this.getConfig().getBoolean("kill-mobs.exclusions.bred", false);
        this.killMobsExcludeTagged = this.getConfig().getBoolean("kill-mobs.exclusions.tagged", false);
        this.aiOptimizationExcludeNamed = this.getConfig().getBoolean("optimizations.ai-optimization.exclusions.named", false);
        this.aiOptimizationExcludeBred = this.getConfig().getBoolean("optimizations.ai-optimization.exclusions.bred", false);
        this.aiOptimizationExcludeTagged = this.getConfig().getBoolean("optimizations.ai-optimization.exclusions.tagged", false);
        this.deathItemProtectionEnabled = this.getConfig().getBoolean("death-item-protection.enabled", true);
        this.deathItemProtectionDuration = this.getConfig().getInt("death-item-protection.protection-duration-seconds", 600);
        this.redstoneOptimizationEnabled = this.getConfig().getBoolean("optimizations.redstone.enabled", true);
        this.armorStandLimitEnabled = this.getConfig().getBoolean("optimizations.item-frame-armor-stand-limiter.armor-stand.enabled", true);
        this.armorStandChunkLimit = this.getConfig().getInt("optimizations.item-frame-armor-stand-limiter.armor-stand.chunk-limit", 10);
        this.armorStandGlobalLimit = this.getConfig().getInt("optimizations.item-frame-armor-stand-limiter.armor-stand.global-limit", 100);
        this.itemFrameLimitEnabled = this.getConfig().getBoolean("optimizations.item-frame-armor-stand-limiter.item-frame.enabled", true);
        this.itemFrameChunkLimit = this.getConfig().getInt("optimizations.item-frame-armor-stand-limiter.item-frame.chunk-limit", 10);
        this.itemFrameGlobalLimit = this.getConfig().getInt("optimizations.item-frame-armor-stand-limiter.item-frame.global-limit", 100);
        this.mobSpawnLimitEnabled = this.getConfig().getBoolean("optimizations.mob-spawn-limiter.enabled", true);
        this.hostileMobLimitPer4Chunks = this.getConfig().getInt("optimizations.mob-spawn-limiter.hostile-limit-per-4-chunks", 30);
        this.passiveMobLimitPer4Chunks = this.getConfig().getInt("optimizations.mob-spawn-limiter.passive-limit-per-4-chunks", 20);
        this.hopperOptimizationEnabled = this.getConfig().getBoolean("optimizations.hopper-optimization.enabled", true);
        this.farmLimiterEnabled = this.getConfig().getBoolean("optimizations.farm-limiter.enabled", true);
        this.mobAIOptimizationEnabled = this.getConfig().getBoolean("optimizations.ai-optimization.enabled", true);
        this.mobDespawnDistance = this.getConfig().getDouble("optimizations.ai-optimization.despawn-distance-blocks", 64.0);
        this.mobAICheckInterval = this.getConfig().getInt("optimizations.ai-optimization.check-interval-seconds", 30);
        this.performanceWarningsEnabled = this.getConfig().getBoolean("optimizations.performance-warnings.enabled", true);
        this.tpsWarningThreshold = this.getConfig().getDouble("optimizations.performance-warnings.tps-threshold", 18.0);
        this.warningCheckInterval = this.getConfig().getInt("optimizations.performance-warnings.check-interval-seconds", 60);
        this.warningMessage = this.getConfig().getString("optimizations.performance-warnings.message", "&c[ClearLag] Server TPS has dropped to &e{tps}&c! Performance is critical!");
        this.debugModeEnabled = this.getConfig().getBoolean("debug-mode", false);
        this.hideAllCommands = this.getConfig().getBoolean("hide-all-commands", false);
        this.broadcastMessagesEnabled = this.getConfig().getBoolean("messages.broadcast-enabled", true);
        this.countdownMessagesAt = this.getConfig().getIntegerList("countdown-messages-at").stream().collect(Collectors.toSet());
        this.discordWebhookEnabled = this.getConfig().getBoolean("discord.webhook-enabled", false);
        this.discordWebhookUrl = this.getConfig().getString("discord.webhook-url", "");
        this.discordReportEnabled = this.getConfig().getBoolean("discord.performance-report.enabled", false);
        this.discordReportInterval = this.getConfig().getInt("discord.performance-report.interval-seconds", 3600);
        this.blockVersionCommand = this.getConfig().getBoolean("command-blocking.block-version-command", false);
        this.blockPluginsCommand = this.getConfig().getBoolean("command-blocking.block-plugins-command", false);
        this.autoUnloadEnabled = this.getConfig().getBoolean("auto-unload.enabled", false);
        this.autoUnloadInterval = this.getConfig().getInt("auto-unload.check-interval-seconds", 300);
        this.autoUnloadEntityThreshold = this.getConfig().getInt("auto-unload.entity-threshold", 250);
        double minPlayerDistance = this.getConfig().getDouble("auto-unload.min-player-distance", 128.0);
        this.autoUnloadMinPlayerDistanceSq = minPlayerDistance * minPlayerDistance;
        this.autoUnloadExcludedWorlds = this.getConfig().getStringList("auto-unload.excluded-worlds");
        this.autoUnloadExcludeImportant = this.getConfig().getBoolean("auto-unload.exclude-important-mobs", true);
        this.mobStackingEnabled = this.getConfig().getBoolean("optimizations.mob-stacking.enabled", false);
        this.stackRadiusH = this.getConfig().getDouble("optimizations.mob-stacking.stack-radius-horizontal", 8.0);
        this.stackRadiusV = this.getConfig().getDouble("optimizations.mob-stacking.stack-radius-vertical", 4.0);
        this.stackInterval = this.getConfig().getInt("optimizations.mob-stacking.stack-interval-ticks", 100);
        this.minStackSize = this.getConfig().getInt("optimizations.mob-stacking.min-stack-size", 2);
        this.maxStackSize = this.getConfig().getInt("optimizations.mob-stacking.max-stack-size", 500);
        this.stackNameFormat = this.getConfig().getString("optimizations.mob-stacking.name-format", "&e{type} &fx{count}");
        this.mobStackingExcludedMobs = this.getConfig().getStringList("optimizations.mob-stacking.excluded-mobs");
        this.mobStackingExclusions.put("named", this.getConfig().getBoolean("optimizations.mob-stacking.exclusions.named", true));
        this.mobStackingExclusions.put("bred", this.getConfig().getBoolean("optimizations.mob-stacking.exclusions.bred", true));
        this.mobStackingExclusions.put("tagged", this.getConfig().getBoolean("optimizations.mob-stacking.exclusions.tagged", true));
        this.mobStackingExclusions.put("leashed", this.getConfig().getBoolean("optimizations.mob-stacking.exclusions.leashed", true));
        this.mobStackingExclusions.put("tamed", this.getConfig().getBoolean("optimizations.mob-stacking.exclusions.tamed", true));
        this.antiPhysicsAbuseEnabled = this.getConfig().getBoolean("optimizations.anti-physics-abuse.enabled", false);
        List blockNames = this.getConfig().getStringList("optimizations.anti-physics-abuse.block-list");
        this.physicsBlockList.clear();
        for (String name : blockNames) {
            try {
                this.physicsBlockList.add(Material.valueOf((String)name.toUpperCase()));
            }
            catch (Exception e) {
                this.getLogger().warning("Invalid material in anti-physics-abuse.block-list: " + name);
            }
        }
        this.physicsCheckInterval = this.getConfig().getInt("optimizations.anti-physics-abuse.check-interval-ticks", 10);
        this.physicsThreshold = this.getConfig().getInt("optimizations.anti-physics-abuse.threshold", 100);
        this.physicsAction = this.getConfig().getString("optimizations.anti-physics-abuse.action", "CONVERT_TO_ITEMS");
        this.physicsLimitDuration = this.getConfig().getInt("optimizations.anti-physics-abuse.limit-duration-ticks", 60);
        if (this.debugModeEnabled) {
            this.getLogger().setLevel(Level.INFO);
        } else {
            this.getLogger().setLevel(Level.WARNING);
        }
        if (this.mobAIOptimizationEnabled) {
            this.startMobAIOptimizationTask();
        } else if (this.mobAITask != null) {
            this.mobAITask.cancel();
            this.mobAITask = null;
        }
        if (this.warningTask != null) {
            this.warningTask.cancel();
        }
        if (this.performanceWarningsEnabled) {
            this.startPerformanceWarningTask();
        }
        if (this.discordReportTask != null) {
            this.discordReportTask.cancel();
        }
        if (this.discordReportEnabled) {
            this.startDiscordReportTask();
        }
        if (this.autoUnloadTask != null) {
            this.autoUnloadTask.cancel();
        }
        if (this.autoUnloadEnabled) {
            this.startAutoUnloadTask();
        }
        this.fastClockDetectorEnabled = this.getConfig().getBoolean("optimizations.fast-clock-detector.enabled", true);
        this.fastClockThreshold = this.getConfig().getInt("optimizations.fast-clock-detector.threshold-per-second", 150);
        this.fastClockBlockDuration = this.getConfig().getInt("optimizations.fast-clock-detector.block-duration-seconds", 30);
        this.fastClockNotifyPlayers = this.getConfig().getBoolean("optimizations.fast-clock-detector.notify-players", true);
        if (this.fastClockCheckTask != null) {
            this.fastClockCheckTask.cancel();
        }
        if (this.fastClockDetectorEnabled) {
            this.startFastClockCheckTask();
        }
        if (this.mobStackingTask != null) {
            this.mobStackingTask.cancel();
        }
        if (this.mobStackingEnabled) {
            this.startMobStackingTask();
        }
        if (this.antiPhysicsCheckTask != null) {
            this.antiPhysicsCheckTask.cancel();
        }
        if (this.antiPhysicsAbuseEnabled) {
            this.startAntiPhysicsCheckTask();
        }
        this.getLogger().info("ClearLag configuration reloaded.");
    }

    private void startAutoClearTask() {
        if (this.clearTask != null) {
            this.clearTask.cancel();
        }
        this.clearTask = new BukkitRunnable(){
            int countdown;
            long lastSecond;
            {
                this.countdown = ClearLag.this.autoClearInterval;
                this.lastSecond = System.currentTimeMillis();
            }

            public void run() {
                if (System.currentTimeMillis() - this.lastSecond < 1000L) {
                    return;
                }
                this.lastSecond = System.currentTimeMillis();
                if (this.countdown <= 0) {
                    ClearLag.this.performClear("auto");
                    ClearLag.this.lastClearTime = System.currentTimeMillis();
                    this.countdown = ClearLag.this.autoClearInterval;
                    return;
                }
                if (ClearLag.this.broadcastMessagesEnabled && ClearLag.this.countdownMessagesAt.contains(this.countdown)) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!ClearLag.this.playerMessagesEnabled.getOrDefault(player.getUniqueId(), true).booleanValue()) continue;
                        player.sendMessage(ClearLag.this.prefix + String.valueOf(ChatColor.GOLD) + " Items and entities will be cleared in " + String.valueOf(ChatColor.RED) + this.countdown + String.valueOf(ChatColor.GOLD) + " seconds!");
                    }
                }
                --this.countdown;
            }
        }.runTaskTimer((Plugin)this, 20L, 20L);
    }

    public int performClear(String type) {
        int itemsRemoved = 0;
        int entitiesRemoved = 0;
        for (World world : Bukkit.getWorlds()) {
            if (type.equals("auto") && this.excludedWorlds.contains(world.getName())) {
                this.debugLog("Skipping auto-clear for excluded world: " + world.getName());
                continue;
            }
            for (Entity entity : world.getEntities()) {
                if (entity instanceof Player || entity instanceof LivingEntity && this.isExcludedMob((LivingEntity)entity, "auto-clear") || entity.hasMetadata("clearlag_stack_size")) continue;
                boolean removed = false;
                if (type.equals("all") || type.equals("auto")) {
                    if (this.clearItems && entity instanceof Item) {
                        Item item = (Item)entity;
                        if (this.deathItemProtectionEnabled && item.hasMetadata("clearlag_death_drop_time")) {
                            if (this.deathItemProtectionDuration == -1) continue;
                            long dropTime = ((MetadataValue)item.getMetadata("clearlag_death_drop_time").get(0)).asLong();
                            long protectionMillis = (long)this.deathItemProtectionDuration * 1000L;
                            if (System.currentTimeMillis() - dropTime < protectionMillis) continue;
                        }
                        if (this.isItemExcluded(item)) continue;
                        entity.remove();
                        removed = true;
                        ++itemsRemoved;
                        continue;
                    }
                    if (!this.clearEntities || entity instanceof Item || this.isEntityExcluded(entity)) continue;
                    entity.remove();
                    removed = true;
                    ++entitiesRemoved;
                    continue;
                }
                if (type.equals("items") && entity instanceof Item) {
                    if (this.isItemExcluded((Item)entity)) continue;
                    entity.remove();
                    removed = true;
                    ++itemsRemoved;
                    continue;
                }
                if (!type.equals("entity") || entity instanceof Item || this.isEntityExcluded(entity)) continue;
                entity.remove();
                removed = true;
                ++entitiesRemoved;
            }
        }
        int totalRemoved = itemsRemoved + entitiesRemoved;
        this.lastClearItems.set(itemsRemoved);
        this.lastClearEntities.set(entitiesRemoved);
        this.lastClearTotal.set(totalRemoved);
        if (totalRemoved > 0) {
            this.entitiesRemovedSinceReport.addAndGet(totalRemoved);
            this.lastClearStats = totalRemoved + " Entities have been removed";
        } else {
            this.lastClearStats = "0 Entities have been removed";
        }
        if (this.broadcastMessagesEnabled) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!this.playerMessagesEnabled.getOrDefault(player.getUniqueId(), true).booleanValue()) continue;
                player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + " " + totalRemoved + " entities have been removed!");
            }
        }
        this.writeToLog("Clear executed (" + type + "). " + totalRemoved + " entities removed (" + itemsRemoved + " items, " + entitiesRemoved + " entities).");
        this.sendToDiscord("Clear executed (" + type + "). " + totalRemoved + " entities removed (" + itemsRemoved + " items, " + entitiesRemoved + " entities).");
        return totalRemoved;
    }

    private boolean isItemExcluded(Item item) {
        if (item.getItemStack() == null || item.getItemStack().getType() == null) {
            return false;
        }
        return this.excludedItems.contains(item.getItemStack().getType().name());
    }

    private boolean isEntityExcluded(Entity entity) {
        if (entity.getType().name().equalsIgnoreCase("COPPER_GOLEM")) {
            return true;
        }
        return this.excludedEntities.contains(entity.getType().name());
    }

    private boolean isExcludedMob(LivingEntity mob, String category) {
        switch (category) {
            case "auto-clear": {
                if (this.autoClearExcludeNamed && mob.getCustomName() != null) {
                    return true;
                }
                if (this.autoClearExcludeBred && mob instanceof Breedable) {
                    return true;
                }
                if (!this.autoClearExcludeTagged || !mob.getScoreboardTags().contains("clearlag_exclude")) break;
                return true;
            }
            case "kill-mobs": {
                if (this.killMobsExcludeNamed && mob.getCustomName() != null) {
                    return true;
                }
                if (this.killMobsExcludeBred && mob instanceof Breedable) {
                    return true;
                }
                if (!this.killMobsExcludeTagged || !mob.getScoreboardTags().contains("clearlag_exclude")) break;
                return true;
            }
            case "ai-optimization": {
                if (this.aiOptimizationExcludeNamed && mob.getCustomName() != null) {
                    return true;
                }
                if (this.aiOptimizationExcludeBred && mob instanceof Breedable) {
                    return true;
                }
                if (!this.aiOptimizationExcludeTagged || !mob.getScoreboardTags().contains("clearlag_exclude")) break;
                return true;
            }
        }
        return false;
    }

    public int killMobs(String mobType) {
        int killedCount = 0;
        for (World world : Bukkit.getWorlds()) {
            for (LivingEntity entity : world.getLivingEntities()) {
                if (entity.getType() == EntityType.PLAYER || entity instanceof ArmorStand || entity instanceof ItemFrame || entity.getType().name().equalsIgnoreCase("COPPER_GOLEM") || this.isExcludedMob(entity, "kill-mobs")) continue;
                if (entity.hasMetadata("clearlag_stack_size")) {
                    int stackSize = ((MetadataValue)entity.getMetadata("clearlag_stack_size").get(0)).asInt();
                    entity.remove();
                    killedCount += stackSize;
                    continue;
                }
                boolean isHostile = this.isHostile(entity.getType());
                if (mobType.equals("all")) {
                    entity.remove();
                    ++killedCount;
                    continue;
                }
                if (mobType.equals("evil") && isHostile) {
                    entity.remove();
                    ++killedCount;
                    continue;
                }
                if (!mobType.equals("good") || isHostile) continue;
                entity.remove();
                ++killedCount;
            }
        }
        return killedCount;
    }

    private boolean isHostile(EntityType type) {
        switch (type) {
            case ELDER_GUARDIAN: 
            case WITHER_SKELETON: 
            case STRAY: 
            case HUSK: 
            case EVOKER: 
            case VINDICATOR: 
            case CREEPER: 
            case SKELETON: 
            case SPIDER: 
            case ZOMBIE: 
            case SLIME: 
            case GHAST: 
            case ZOMBIFIED_PIGLIN: 
            case ENDERMAN: 
            case BLAZE: 
            case MAGMA_CUBE: 
            case ENDER_DRAGON: 
            case WITHER: 
            case WITCH: 
            case GUARDIAN: 
            case SHULKER: 
            case PHANTOM: 
            case DROWNED: 
            case PILLAGER: 
            case RAVAGER: 
            case HOGLIN: 
            case ZOGLIN: 
            case PIGLIN_BRUTE: {
                return true;
            }
        }
        return false;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntitySpawn(EntitySpawnEvent event) {
        if (!this.antiPhysicsAbuseEnabled || event.getEntityType() != EntityType.FALLING_BLOCK) {
            return;
        }
        FallingBlock fallingBlock = (FallingBlock)event.getEntity();
        Material type = fallingBlock.getBlockData().getMaterial();
        if (!this.physicsBlockList.contains(type)) {
            return;
        }
        if (this.physicsLimited) {
            if (this.physicsAction.equalsIgnoreCase("CONVERT_TO_ITEMS")) {
                event.setCancelled(true);
                Location loc = event.getLocation();
                loc.getWorld().dropItemNaturally(loc, new ItemStack(type, 1));
            } else if (this.physicsAction.equalsIgnoreCase("LIMIT")) {
                event.setCancelled(true);
            }
        } else {
            this.fallingBlockCounter.incrementAndGet();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity mob = event.getEntity();
        if (!mob.hasMetadata("clearlag_stack_size")) {
            return;
        }
        int stackSize = ((MetadataValue)mob.getMetadata("clearlag_stack_size").get(0)).asInt();
        if (stackSize > 1) {
            final int newSize = stackSize - 1;
            final Location loc = mob.getLocation();
            final EntityType type = mob.getType();
            final boolean isBaby = mob instanceof Ageable && !((Ageable)mob).isAdult();
            new BukkitRunnable(){

                public void run() {
                    if (!loc.getChunk().isLoaded()) {
                        return;
                    }
                    LivingEntity newMob = (LivingEntity)loc.getWorld().spawnEntity(loc, type);
                    if (newMob instanceof Ageable && isBaby) {
                        ((Ageable)newMob).setBaby();
                    }
                    newMob.setMetadata("clearlag_stack_size", (MetadataValue)new FixedMetadataValue((Plugin)ClearLag.this.plugin, (Object)newSize));
                    newMob.setCustomName(ClearLag.this.formatStackName(type, newSize));
                    newMob.setCustomNameVisible(true);
                }
            }.runTaskLater((Plugin)this, 1L);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!this.deathItemProtectionEnabled) {
            return;
        }
        final Player player = event.getEntity();
        if (event.getDrops().isEmpty()) {
            return;
        }
        final ArrayList drops = new ArrayList(event.getDrops());
        event.getDrops().clear();
        final long dropTime = System.currentTimeMillis();
        new BukkitRunnable(){

            public void run() {
                for (ItemStack itemStack : drops) {
                    Item droppedItem;
                    if (itemStack == null || itemStack.getType() == Material.AIR || (droppedItem = player.getWorld().dropItem(player.getLocation(), itemStack)) == null) continue;
                    droppedItem.setMetadata("clearlag_death_drop_time", (MetadataValue)new FixedMetadataValue((Plugin)ClearLag.this.plugin, (Object)dropTime));
                    ClearLag.this.debugLog("Protected death drop item for " + player.getName() + ": " + itemStack.getType().name());
                }
            }
        }.runTaskLater((Plugin)this, 1L);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.updateAvailable && event.getPlayer().isOp()) {
            final Player player = event.getPlayer();
            new BukkitRunnable(){

                public void run() {
                    player.sendMessage(String.valueOf(ChatColor.GOLD) + "========================================");
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "ClearLag is outdated!");
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your version: " + String.valueOf(ChatColor.RED) + ClearLag.this.getDescription().getVersion());
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Newest version: " + String.valueOf(ChatColor.GREEN) + ClearLag.this.newVersionString);
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Download the new version here: " + String.valueOf(ChatColor.AQUA) + "https://modrinth.com/plugin/clearlag++");
                    player.sendMessage(String.valueOf(ChatColor.GOLD) + "========================================");
                }
            }.runTaskLater((Plugin)this.plugin, 60L);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (player.isOp() || player.hasPermission("clearlag.bypass.commandblock")) {
            return;
        }
        String commandMessage = event.getMessage().toLowerCase();
        String command = commandMessage.split(" ")[0];
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        if (this.blockVersionCommand && (command.equals("version") || command.equals("ver") || command.equals("bukkit:version") || command.equals("bukkit:ver"))) {
            event.setCancelled(true);
        }
        if (this.blockPluginsCommand && (command.equals("plugins") || command.equals("pl") || command.equals("bukkit:plugins") || command.equals("bukkit:pl"))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerCommandSend(PlayerCommandSendEvent event) {
        Player player = event.getPlayer();
        if (player.isOp() || player.hasPermission("clearlag.bypass.commandblock")) {
            return;
        }
        Collection commands = event.getCommands();
        if (this.blockVersionCommand) {
            commands.removeIf(cmd -> cmd.equalsIgnoreCase("version") || cmd.equalsIgnoreCase("ver") || cmd.equalsIgnoreCase("bukkit:version") || cmd.equalsIgnoreCase("bukkit:ver"));
        }
        if (this.blockPluginsCommand) {
            commands.removeIf(cmd -> cmd.equalsIgnoreCase("plugins") || cmd.equalsIgnoreCase("pl") || cmd.equalsIgnoreCase("bukkit:plugins") || cmd.equalsIgnoreCase("bukkit:pl"));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockRedstone(BlockRedstoneEvent event) {
        if (!this.fastClockDetectorEnabled) {
            return;
        }
        Chunk chunk = event.getBlock().getChunk();
        if (this.blockedRedstoneChunks.containsKey(chunk)) {
            long expiryTime = this.blockedRedstoneChunks.get(chunk);
            if (System.currentTimeMillis() < expiryTime) {
                event.setNewCurrent(event.getOldCurrent());
                return;
            }
            this.blockedRedstoneChunks.remove(chunk);
        }
        this.chunkRedstoneActivations.computeIfAbsent(chunk, k -> new AtomicInteger(0)).incrementAndGet();
    }

    public boolean isArmorStandLimitEnabled() {
        return this.armorStandLimitEnabled;
    }

    public int getArmorStandChunkLimit() {
        return this.armorStandChunkLimit;
    }

    public int getArmorStandGlobalLimit() {
        return this.armorStandGlobalLimit;
    }

    public boolean isItemFrameLimitEnabled() {
        return this.itemFrameLimitEnabled;
    }

    public int getItemFrameChunkLimit() {
        return this.itemFrameChunkLimit;
    }

    public int getItemFrameGlobalLimit() {
        return this.itemFrameGlobalLimit;
    }

    public void incrementEntityCount(Chunk chunk, EntityType type) {
        this.chunkEntityCounts.computeIfAbsent(chunk, k -> new ConcurrentHashMap()).merge(type, 1, Integer::sum);
        this.globalEntityCounts.merge(type, 1, Integer::sum);
        this.debugLog("Incremented " + type.name() + " in chunk " + chunk.getX() + "," + chunk.getZ() + ". Chunk count: " + this.getChunkEntityCount(chunk, type) + ", Global count: " + this.getGlobalEntityCount(type));
    }

    public void decrementEntityCount(Chunk chunk, EntityType type) {
        this.chunkEntityCounts.computeIfAbsent(chunk, k -> new ConcurrentHashMap()).merge(type, -1, Integer::sum);
        this.globalEntityCounts.merge(type, -1, Integer::sum);
        this.debugLog("Decremented " + type.name() + " in chunk " + chunk.getX() + "," + chunk.getZ() + ". Chunk count: " + this.getChunkEntityCount(chunk, type) + ", Global count: " + this.getGlobalEntityCount(type));
    }

    public int getChunkEntityCount(Chunk chunk, EntityType type) {
        return ((Map)this.chunkEntityCounts.getOrDefault(chunk, new HashMap())).getOrDefault(type, 0);
    }

    public int getGlobalEntityCount(EntityType type) {
        return this.globalEntityCounts.getOrDefault(type, 0);
    }

    public void initializeChunkCounts(Chunk chunk) {
        if (!this.chunkEntityCounts.containsKey(chunk)) {
            ConcurrentHashMap<EntityType, Integer> counts = new ConcurrentHashMap<EntityType, Integer>();
            Entity[] entityArray = chunk.getEntities();
            int n = entityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Entity entity = entityArray[n2];
                if (entity instanceof ArmorStand) {
                    counts.merge(EntityType.ARMOR_STAND, 1, Integer::sum);
                    this.globalEntityCounts.merge(EntityType.ARMOR_STAND, 1, Integer::sum);
                } else if (entity instanceof ItemFrame) {
                    counts.merge(EntityType.ITEM_FRAME, 1, Integer::sum);
                    this.globalEntityCounts.merge(EntityType.ITEM_FRAME, 1, Integer::sum);
                }
                ++n2;
            }
            this.chunkEntityCounts.put(chunk, counts);
            this.debugLog("Initialized counts for chunk " + chunk.getX() + "," + chunk.getZ());
        }
    }

    public void removeChunkCounts(Chunk chunk) {
        Map<EntityType, Integer> counts = this.chunkEntityCounts.remove(chunk);
        if (counts != null) {
            for (Map.Entry<EntityType, Integer> entry : counts.entrySet()) {
                this.globalEntityCounts.merge(entry.getKey(), -entry.getValue().intValue(), Integer::sum);
            }
            this.debugLog("Removed counts for chunk " + chunk.getX() + "," + chunk.getZ());
        }
    }

    public boolean isRedstoneOptimizationEnabled() {
        return this.redstoneOptimizationEnabled;
    }

    public boolean isMobSpawnLimitEnabled() {
        return this.mobSpawnLimitEnabled;
    }

    public int getHostileMobLimitPer4Chunks() {
        return this.hostileMobLimitPer4Chunks;
    }

    public int getPassiveMobLimitPer4Chunks() {
        return this.passiveMobLimitPer4Chunks;
    }

    public boolean isHopperOptimizationEnabled() {
        return this.hopperOptimizationEnabled;
    }

    public boolean isFarmLimiterEnabled() {
        return this.farmLimiterEnabled;
    }

    public boolean isMobAIOptimizationEnabled() {
        return this.mobAIOptimizationEnabled;
    }

    public int getLastClearItems() {
        return this.lastClearItems.get();
    }

    public int getLastClearEntities() {
        return this.lastClearEntities.get();
    }

    public int getLastClearTotal() {
        return this.lastClearTotal.get();
    }

    public int getAutoUnloadEntityThreshold() {
        return this.autoUnloadEntityThreshold;
    }

    public int getLastUnloadCount() {
        return this.lastUnloadCount.get();
    }

    public String getLastClearStats() {
        return this.lastClearStats;
    }

    private double[] getSpigotTPS() {
        try {
            Method paperTpsMethod = Bukkit.getServer().getClass().getMethod("getTPS", new Class[0]);
            Object tpsResult = paperTpsMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
            if (tpsResult instanceof double[]) {
                return (double[])tpsResult;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException paperTpsMethod) {
            // empty catch block
        }
        CharSequence[] possibleFields = new String[]{"recentTps", "tps"};
        try {
            Object minecraftServer = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
            CharSequence[] charSequenceArray = possibleFields;
            int n = possibleFields.length;
            int n2 = 0;
            while (n2 < n) {
                String fieldName = charSequenceArray[n2];
                try {
                    Field tpsField = minecraftServer.getClass().getDeclaredField(fieldName);
                    tpsField.setAccessible(true);
                    Object tpsValue = tpsField.get(minecraftServer);
                    if (tpsValue instanceof double[]) {
                        return (double[])tpsValue;
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                ++n2;
            }
            this.getLogger().log(Level.WARNING, "ClearLag could not retrieve the TPS via Paper/Spigot reflection. Server version may be incompatible. Fields attempted: " + String.join((CharSequence)", ", possibleFields));
            return new double[]{20.0, 20.0, 20.0};
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "ClearLag: Fatal error during TPS retrieval (reflection attempt): " + e.getMessage());
            return new double[]{20.0, 20.0, 20.0};
        }
    }

    private double getProcessCpuLoad() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            Method method = osBean.getClass().getMethod("getProcessCpuLoad", new Class[0]);
            method.setAccessible(true);
            return (Double)method.invoke((Object)osBean, new Object[0]) * 100.0;
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    private String getAverage(List<Double> history, int seconds) {
        if (history.isEmpty() || seconds <= 0) {
            return "N/A";
        }
        int startIndex = Math.max(0, history.size() - seconds);
        List<Double> sublist = history.subList(startIndex, history.size());
        if (sublist.isEmpty()) {
            return "N/A";
        }
        double sum = sublist.stream().mapToDouble(Double::doubleValue).sum();
        double average = sum / (double)sublist.size();
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(average);
    }

    private void startPerformanceMonitoringTask() {
        new BukkitRunnable(){

            public void run() {
                double[] tpsArray = ClearLag.this.getSpigotTPS();
                double tps = tpsArray[0];
                if (ClearLag.this.tpsHistory.size() >= 7200) {
                    ClearLag.this.tpsHistory.remove(0);
                }
                ClearLag.this.tpsHistory.add(tps);
                double mspt = 50.0 / tps;
                if (ClearLag.this.msptHistory.size() >= 7200) {
                    ClearLag.this.msptHistory.remove(0);
                }
                ClearLag.this.msptHistory.add(mspt);
                double cpuLoad = ClearLag.this.getProcessCpuLoad();
                if (ClearLag.this.cpuHistory.size() >= 7200) {
                    ClearLag.this.cpuHistory.remove(0);
                }
                ClearLag.this.cpuHistory.add(cpuLoad);
                long totalMemory = Runtime.getRuntime().totalMemory() / 0x100000L;
                long freeMemory = Runtime.getRuntime().freeMemory() / 0x100000L;
                double usedMemory = totalMemory - freeMemory;
                if (ClearLag.this.ramHistory.size() >= 7200) {
                    ClearLag.this.ramHistory.remove(0);
                }
                ClearLag.this.ramHistory.add(usedMemory);
            }
        }.runTaskTimer((Plugin)this, 20L, 20L);
    }

    private void startMobAIOptimizationTask() {
        if (this.mobAITask != null) {
            this.mobAITask.cancel();
        }
        final double finalMobDespawnDistanceSq = this.mobDespawnDistance * this.mobDespawnDistance;
        final int finalMobAICheckIntervalTicks = this.mobAICheckInterval * 20;
        this.mobAITask = new BukkitRunnable(){

            public void run() {
                for (World world : Bukkit.getWorlds()) {
                    long currentTime = System.currentTimeMillis();
                    for (LivingEntity entity : world.getLivingEntities()) {
                        if (entity instanceof Player || entity instanceof ItemFrame || entity instanceof ArmorStand || entity.getType().name().equalsIgnoreCase("COPPER_GOLEM") || ClearLag.this.isExcludedMob(entity, "ai-optimization") || ClearLag.this.mobLastPlayerCheck.containsKey(entity.getUniqueId()) && currentTime - ClearLag.this.mobLastPlayerCheck.get(entity.getUniqueId()) < (long)(finalMobAICheckIntervalTicks / 20 * 1000)) continue;
                        boolean foundPlayer = false;
                        for (Player player : world.getPlayers()) {
                            if (!(player.getLocation().distanceSquared(entity.getLocation()) < finalMobDespawnDistanceSq)) continue;
                            foundPlayer = true;
                            break;
                        }
                        if (!foundPlayer) {
                            entity.remove();
                            ClearLag.this.debugLog("Despawned " + entity.getType().name() + " at " + entity.getLocation().toString() + " due to AI optimization (no nearby player).");
                        }
                        ClearLag.this.mobLastPlayerCheck.put(entity.getUniqueId(), currentTime);
                    }
                }
            }
        }.runTaskTimer((Plugin)this, (long)finalMobAICheckIntervalTicks, (long)finalMobAICheckIntervalTicks);
    }

    private void startPerformanceWarningTask() {
        long delayTicks = (long)this.performanceWarningStartupDelay * 20L;
        this.warningTask = new BukkitRunnable(){

            public void run() {
                double currentTps = ClearLag.this.getSpigotTPS()[0];
                if (currentTps < ClearLag.this.tpsWarningThreshold) {
                    String formattedMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)ClearLag.this.warningMessage.replace("{tps}", new DecimalFormat("#.##").format(currentTps)));
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.hasPermission("clearlag.warnings.receive")) continue;
                        player.sendMessage(formattedMessage);
                    }
                    ClearLag.this.getLogger().warning(ChatColor.stripColor((String)formattedMessage));
                }
            }
        }.runTaskTimer((Plugin)this, delayTicks, (long)this.warningCheckInterval * 20L);
    }

    private void startDiscordReportTask() {
        this.discordReportTask = new BukkitRunnable(){

            public void run() {
                if (!ClearLag.this.discordWebhookEnabled || ClearLag.this.discordWebhookUrl.isEmpty()) {
                    return;
                }
                String avgTps = ClearLag.this.getAverage(ClearLag.this.tpsHistory, ClearLag.this.discordReportInterval);
                int removedEntities = ClearLag.this.entitiesRemovedSinceReport.getAndSet(0);
                JsonObject embed = new JsonObject();
                embed.addProperty("title", "Server Performance Report");
                embed.addProperty("color", (Number)15158332);
                JsonArray fields = new JsonArray();
                JsonObject tpsField = new JsonObject();
                tpsField.addProperty("name", "Average TPS");
                tpsField.addProperty("value", avgTps.equals("N/A") ? "Not enough data" : avgTps);
                tpsField.addProperty("inline", Boolean.valueOf(true));
                fields.add((JsonElement)tpsField);
                JsonObject removedField = new JsonObject();
                removedField.addProperty("name", "Entities Removed");
                removedField.addProperty("value", String.valueOf(removedEntities));
                removedField.addProperty("inline", Boolean.valueOf(true));
                fields.add((JsonElement)removedField);
                embed.add("fields", (JsonElement)fields);
                embed.addProperty("footer", "Report generated by ClearLag++");
                JsonObject payload = new JsonObject();
                JsonArray embeds = new JsonArray();
                embeds.add((JsonElement)embed);
                payload.add("embeds", (JsonElement)embeds);
                ClearLag.this.sendJsonToDiscord(payload.toString());
                ClearLag.this.debugLog("Sent Discord performance report.");
            }
        }.runTaskTimerAsynchronously((Plugin)this, (long)this.discordReportInterval * 20L, (long)this.discordReportInterval * 20L);
    }

    private void startAutoUnloadTask() {
        this.autoUnloadTask = new BukkitRunnable(){

            /*
             * Unable to fully structure code
             */
            public void run() {
                if (!ClearLag.this.autoUnloadEnabled) {
                    this.cancel();
                    return;
                }
                ClearLag.this.debugLog("Starting automatic laggy chunk scan...");
                unloadedCount = 0;
                onlinePlayers = Bukkit.getOnlinePlayers();
                for (World world : Bukkit.getWorlds()) {
                    if (ClearLag.this.autoUnloadExcludedWorlds.contains(world.getName())) continue;
                    var8_8 = world.getLoadedChunks();
                    var7_7 = var8_8.length;
                    var6_6 = 0;
                    while (var6_6 < var7_7) {
                        block12: {
                            block13: {
                                chunk = var8_8[var6_6];
                                entities = chunk.getEntities();
                                if (entities.length < ClearLag.this.autoUnloadEntityThreshold) break block12;
                                playerNearby = false;
                                if (ClearLag.this.autoUnloadMinPlayerDistanceSq > 0.0) {
                                    chunkCenter = new Location(world, (double)(chunk.getX() * 16 + 8), 128.0, (double)(chunk.getZ() * 16 + 8));
                                    for (Player player : onlinePlayers) {
                                        if (!player.getWorld().equals(world) || !(player.getLocation().distanceSquared(chunkCenter) < ClearLag.this.autoUnloadMinPlayerDistanceSq)) continue;
                                        playerNearby = true;
                                        break;
                                    }
                                }
                                if (!playerNearby) break block13;
                                ClearLag.this.debugLog("Chunk " + chunk.getX() + "," + chunk.getZ() + " in " + world.getName() + " is over threshold but a player is nearby. Skipping.");
                                break block12;
                            }
                            if (!ClearLag.this.autoUnloadExcludeImportant) ** GOTO lbl-1000
                            hasImportantMob = false;
                            var15_17 = entities;
                            var14_16 = entities.length;
                            var13_15 = 0;
                            while (var13_15 < var14_16) {
                                entity = var15_17[var13_15];
                                if (entity instanceof LivingEntity && ClearLag.this.isExcludedMob((LivingEntity)entity, "auto-clear")) {
                                    hasImportantMob = true;
                                    break;
                                }
                                ++var13_15;
                            }
                            if (hasImportantMob) {
                                ClearLag.this.debugLog("Chunk " + chunk.getX() + "," + chunk.getZ() + " in " + world.getName() + " is over threshold but contains important mobs. Skipping.");
                            } else if (chunk.unload(true)) {
                                ++unloadedCount;
                                ClearLag.this.debugLog("Unloaded laggy chunk at [" + world.getName() + "] " + chunk.getX() + ", " + chunk.getZ() + " (Entities: " + entities.length + ")");
                            } else {
                                ClearLag.this.debugLog("Failed to unload chunk at [" + world.getName() + "] " + chunk.getX() + ", " + chunk.getZ());
                            }
                        }
                        ++var6_6;
                    }
                }
                ClearLag.this.lastUnloadCount.set(unloadedCount);
                if (unloadedCount > 0) {
                    ClearLag.this.getLogger().info("Auto-Unload Task: Unloaded " + unloadedCount + " laggy chunks.");
                    ClearLag.this.sendToDiscord("Auto-Unload Task: Unloaded " + unloadedCount + " laggy chunks.");
                }
            }
        }.runTaskTimer((Plugin)this, 1200L, (long)this.autoUnloadInterval * 20L);
    }

    private void startMobStackingTask() {
        this.mobStackingTask = new BukkitRunnable(){

            public void run() {
                if (!ClearLag.this.mobStackingEnabled) {
                    this.cancel();
                    return;
                }
                for (World world : Bukkit.getWorlds()) {
                    ArrayList entities = new ArrayList(world.getLivingEntities());
                    for (LivingEntity entity : entities) {
                        boolean isBaby;
                        if (!entity.isValid() || entity.hasMetadata("clearlag_stack_size")) continue;
                        boolean bl = isBaby = entity instanceof Ageable && !((Ageable)entity).isAdult();
                        if (!ClearLag.this.isStackable(entity)) continue;
                        ArrayList<LivingEntity> stack = new ArrayList<LivingEntity>();
                        stack.add(entity);
                        List nearbyEntities = entity.getNearbyEntities(ClearLag.this.stackRadiusH, ClearLag.this.stackRadiusV, ClearLag.this.stackRadiusH);
                        for (Entity nearby : nearbyEntities) {
                            boolean nearbyIsBaby;
                            LivingEntity nearbyLiving;
                            if (!(nearby instanceof LivingEntity) || nearby.getType() != entity.getType() || !nearby.isValid() || nearby.hasMetadata("clearlag_stack_size") || !ClearLag.this.isStackable(nearbyLiving = (LivingEntity)nearby)) continue;
                            boolean bl2 = nearbyIsBaby = nearbyLiving instanceof Ageable && !((Ageable)nearbyLiving).isAdult();
                            if (isBaby != nearbyIsBaby) continue;
                            stack.add(nearbyLiving);
                        }
                        if (stack.size() < ClearLag.this.minStackSize) continue;
                        LivingEntity baseMob = (LivingEntity)stack.get(0);
                        int stackSize = stack.size();
                        if (stackSize > ClearLag.this.maxStackSize) {
                            stackSize = ClearLag.this.maxStackSize;
                        }
                        baseMob.setMetadata("clearlag_stack_size", (MetadataValue)new FixedMetadataValue((Plugin)ClearLag.this.plugin, (Object)stackSize));
                        baseMob.setCustomName(ClearLag.this.formatStackName(baseMob.getType(), stackSize));
                        baseMob.setCustomNameVisible(true);
                        if (isBaby && baseMob instanceof Ageable) {
                            ((Ageable)baseMob).setBaby();
                        }
                        int i = 1;
                        while (i < stackSize) {
                            ((LivingEntity)stack.get(i)).remove();
                            ++i;
                        }
                        ClearLag.this.debugLog("Created a new stack of " + baseMob.getType().name() + " with size " + stackSize);
                    }
                }
            }
        }.runTaskTimer((Plugin)this, (long)this.stackInterval, (long)this.stackInterval);
    }

    private boolean isStackable(LivingEntity mob) {
        if (mob.getType() == EntityType.PLAYER || !mob.isValid()) {
            return false;
        }
        if (this.mobStackingExcludedMobs.contains(mob.getType().name())) {
            return false;
        }
        if (this.mobStackingExclusions.getOrDefault("named", true).booleanValue() && mob.getCustomName() != null) {
            return false;
        }
        if (this.mobStackingExclusions.getOrDefault("bred", true).booleanValue() && mob instanceof Breedable) {
            return false;
        }
        if (this.mobStackingExclusions.getOrDefault("tagged", true).booleanValue() && mob.getScoreboardTags().contains("clearlag_exclude")) {
            return false;
        }
        if (this.mobStackingExclusions.getOrDefault("tamed", true).booleanValue() && mob instanceof Tameable && ((Tameable)mob).isTamed()) {
            return false;
        }
        return this.mobStackingExclusions.getOrDefault("leashed", true) == false || !mob.isLeashed();
    }

    private String formatStackName(EntityType type, int count) {
        String typeName = type.name().replace("_", " ").toLowerCase();
        StringBuilder capitalized = new StringBuilder();
        String[] stringArray = typeName.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            capitalized.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
            ++n2;
        }
        typeName = capitalized.toString().trim();
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.stackNameFormat.replace("{type}", typeName).replace("{count}", String.valueOf(count)));
    }

    private void startAntiPhysicsCheckTask() {
        this.antiPhysicsCheckTask = new BukkitRunnable(){

            public void run() {
                if (!ClearLag.this.antiPhysicsAbuseEnabled) {
                    this.cancel();
                    return;
                }
                int count = ClearLag.this.fallingBlockCounter.getAndSet(0);
                if (count > ClearLag.this.physicsThreshold) {
                    ClearLag.this.getLogger().warning("[Anti-Physics-Abuse] Triggered! " + count + " falling blocks detected.");
                    ClearLag.this.physicsLimited = true;
                    ClearLag.this.physicsLimitEndTime = System.currentTimeMillis() + (long)ClearLag.this.physicsLimitDuration * 50L;
                    if (ClearLag.this.physicsAction.equalsIgnoreCase("LIMIT")) {
                        ClearLag.this.getLogger().warning("Limiting block physics for " + ClearLag.this.physicsLimitDuration + " ticks.");
                    } else {
                        ClearLag.this.getLogger().warning("Converting new falling blocks to items for " + ClearLag.this.physicsLimitDuration + " ticks.");
                    }
                }
                if (ClearLag.this.physicsLimited && System.currentTimeMillis() > ClearLag.this.physicsLimitEndTime) {
                    ClearLag.this.physicsLimited = false;
                    ClearLag.this.debugLog("Block physics limit expired.");
                }
            }
        }.runTaskTimer((Plugin)this, (long)this.physicsCheckInterval, (long)this.physicsCheckInterval);
    }

    private void debugLog(String message) {
        if (this.debugModeEnabled) {
            this.getLogger().info("[DEBUG] " + message);
        }
    }

    private void writeToLog(String message) {
        if (this.logConfig == null) {
            return;
        }
        List logs = this.logConfig.getStringList("logs");
        logs.add("[" + String.valueOf(new Date()) + "] " + message);
        this.logConfig.set("logs", (Object)logs);
        try {
            this.logConfig.save(this.logFile);
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not save log file!", e);
        }
    }

    private void sendToDiscord(String message) {
        String jsonPayload = "{\"content\": \"" + message.replace("\"", "\\\"") + "\"}";
        this.sendJsonToDiscord(jsonPayload);
    }

    private void sendJsonToDiscord(String jsonPayload) {
        if (!this.discordWebhookEnabled || this.discordWebhookUrl.isEmpty()) {
            return;
        }
        new Thread(() -> {
            try {
                URL url = new URL(this.discordWebhookUrl);
                HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                Throwable throwable = null;
                Object var5_8 = null;
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = jsonPayload.getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                int responseCode = connection.getResponseCode();
                if (responseCode != 204) {
                    this.getLogger().warning("Failed to send Discord webhook message. Response code: " + responseCode);
                }
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Error sending Discord webhook message.", e);
            }
        }).start();
    }

    private List<ChunkData> findLaggyChunks(int count) {
        ArrayList<ChunkData> allChunks = new ArrayList<ChunkData>();
        for (World world : Bukkit.getWorlds()) {
            Chunk[] chunkArray = world.getLoadedChunks();
            int n = chunkArray.length;
            int n2 = 0;
            while (n2 < n) {
                Chunk chunk = chunkArray[n2];
                allChunks.add(new ChunkData(chunk));
                ++n2;
            }
        }
        Collections.sort(allChunks);
        return allChunks.subList(0, Math.min(count, allChunks.size()));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block86: {
            String subCommand;
            if (!command.getName().equalsIgnoreCase("clearlag")) break block86;
            if (!sender.hasPermission("clearlag.all") && !sender.isOp() && args.length == 0) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                return true;
            }
            if (args.length == 0) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- ClearLag Commands ---");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag clear <items/entity/all> " + String.valueOf(ChatColor.WHITE) + " - Removes entities/items.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag info " + String.valueOf(ChatColor.WHITE) + " - Shows plugin information.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag killmobs <evil/good/all> " + String.valueOf(ChatColor.WHITE) + " - Removes mobs.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag reload " + String.valueOf(ChatColor.WHITE) + " - Reloads the plugin configuration.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag nextclear " + String.valueOf(ChatColor.WHITE) + " - Shows time until next auto clear.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag topworld " + String.valueOf(ChatColor.WHITE) + " - Shows world entity ranking.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag cpu " + String.valueOf(ChatColor.WHITE) + " - Shows recent CPU load.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag ram " + String.valueOf(ChatColor.WHITE) + " - Shows recent RAM usage.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag specs " + String.valueOf(ChatColor.WHITE) + " - Shows combined system specs.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag togglemessages " + String.valueOf(ChatColor.WHITE) + " - Toggle countdown messages for yourself.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag chunkfinder <count> " + String.valueOf(ChatColor.WHITE) + " - Finds <count> laggiest chunks.");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/clearlag unloadchunk <world> <x> <z> " + String.valueOf(ChatColor.WHITE) + " - Unloads a chunk.");
                return true;
            }
            switch (subCommand = args[0].toLowerCase()) {
                case "clear": {
                    if (!(sender.hasPermission("clearlag.all") || sender.hasPermission("clearlag.clear") || sender.isOp())) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                        return true;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /clearlag clear <items/entity/all>");
                        return true;
                    }
                    String typeToClear = args[1].toLowerCase();
                    int removedCount = this.performClear(typeToClear);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Removed " + removedCount + " entities of type " + typeToClear + ".");
                    return true;
                }
                case "info": {
                    if (!(sender.hasPermission("clearlag.all") || sender.hasPermission("clearlag.info") || sender.isOp())) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                        return true;
                    }
                    sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- ClearLag Info ---");
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Version: " + this.getDescription().getVersion());
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Author: " + (String)this.getDescription().getAuthors().get(0));
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Website: " + this.getDescription().getWebsite());
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Auto-Clear Enabled: " + (this.autoClearEnabled ? String.valueOf(ChatColor.GREEN) + "Yes" : String.valueOf(ChatColor.RED) + "No"));
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Interval: " + this.autoClearInterval + " seconds");
                    return true;
                }
                case "killmobs": {
                    if (!(sender.hasPermission("clearlag.all") || sender.hasPermission("clearlag.killmobs") || sender.isOp())) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                        return true;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /clearlag killmobs <evil/good/all>");
                        return true;
                    }
                    String mobType = args[1].toLowerCase();
                    int killedCount = this.killMobs(mobType);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Killed " + killedCount + " mobs of type " + mobType + ".");
                    return true;
                }
                case "reload": {
                    if (!(sender.hasPermission("clearlag.all") || sender.hasPermission("clearlag.reload") || sender.isOp())) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                        return true;
                    }
                    this.loadConfig();
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "ClearLag configuration reloaded!");
                    if (this.autoClearEnabled) {
                        this.startAutoClearTask();
                    } else if (this.clearTask != null) {
                        this.clearTask.cancel();
                        this.clearTask = null;
                    }
                    return true;
                }
                case "nextclear": {
                    if (!(sender.hasPermission("clearlag.all") || sender.hasPermission("clearlag.nextclear") || sender.isOp())) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                        return true;
                    }
                    if (!this.autoClearEnabled) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Auto-clear is disabled.");
                        return true;
                    }
                    long currentTime = System.currentTimeMillis();
                    long timeUntilNextClear = this.lastClearTime + (long)(this.autoClearInterval * 1000) - currentTime;
                    if (timeUntilNextClear < 0L) {
                        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "An auto-clear is currently in progress or just happened.");
                    } else {
                        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Next auto clear in " + String.valueOf(ChatColor.AQUA) + this.formatTime(timeUntilNextClear / 1000L));
                    }
                    return true;
                }
                case "topworld": {
                    if (!(sender.hasPermission("clearlag.all") || sender.hasPermission("clearlag.topworld") || sender.isOp())) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                        return true;
                    }
                    HashMap<String, Integer> worldEntityCounts = new HashMap<String, Integer>();
                    for (World world : Bukkit.getWorlds()) {
                        worldEntityCounts.put(world.getName(), world.getEntities().size());
                    }
                    LinkedHashMap sortedWorlds = worldEntityCounts.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
                    sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- Top Worlds by Entity Count ---");
                    int rank = 1;
                    for (Map.Entry entry : sortedWorlds.entrySet()) {
                        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + rank + ". " + (String)entry.getKey() + ": " + String.valueOf(ChatColor.AQUA) + String.valueOf(entry.getValue()) + " entities");
                        ++rank;
                    }
                    return true;
                }
                case "cpu": {
                    if (!(sender.hasPermission("clearlag.all") || sender.hasPermission("clearlag.cpu") || sender.isOp())) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                        return true;
                    }
                    if (this.cpuHistory.isEmpty()) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "CPU history is not yet available. Please wait a moment.");
                        return true;
                    }
                    sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- CPU Usage (System-wide) ---");
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 1 min: " + this.getAverage(this.cpuHistory, 60) + "%");
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 5 min: " + this.getAverage(this.cpuHistory, 300) + "%");
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 10 min: " + this.getAverage(this.cpuHistory, 600) + "%");
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 30 min: " + this.getAverage(this.cpuHistory, 1800) + "%");
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 60 min: " + this.getAverage(this.cpuHistory, 3600) + "%");
                    return true;
                }
                case "ram": {
                    if (!(sender.hasPermission("clearlag.all") || sender.hasPermission("clearlag.ram") || sender.isOp())) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                        return true;
                    }
                    if (this.ramHistory.isEmpty()) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "RAM history is not yet available. Please wait a moment.");
                        return true;
                    }
                    long totalMemory = Runtime.getRuntime().totalMemory() / 0x100000L;
                    sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- RAM Usage (JVM) ---");
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Total Memory: " + totalMemory + " MB");
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 1 min: " + this.getAverage(this.ramHistory, 60) + " MB");
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 5 min: " + this.getAverage(this.ramHistory, 300) + " MB");
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 10 min: " + this.getAverage(this.ramHistory, 600) + " MB");
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 30 min: " + this.getAverage(this.ramHistory, 1800) + " MB");
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last 60 min: " + this.getAverage(this.ramHistory, 600) + " MB");
                    return true;
                }
                case "specs": {
                    if (!(sender.hasPermission("clearlag.all") || sender.hasPermission("clearlag.specs") || sender.isOp())) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                        return true;
                    }
                    sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- Server Performance Summary ---");
                    double[] tpsArray = this.getSpigotTPS();
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "TPS: " + new DecimalFormat("#.##").format(tpsArray[0]));
                    if (this.cpuHistory.isEmpty()) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "CPU: N/A");
                    } else {
                        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "CPU (1m Avg): " + this.getAverage(this.cpuHistory, 60) + "%");
                    }
                    if (this.ramHistory.isEmpty()) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "RAM: N/A");
                    } else {
                        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "RAM (1m Avg): " + this.getAverage(this.ramHistory, 60) + " MB");
                    }
                    return true;
                }
                case "togglemessages": {
                    if (this.hideAllCommands && !sender.hasPermission("clearlag.all") && !sender.hasPermission("clearlag.togglemessages") && !sender.isOp()) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                        return true;
                    }
                    if (!(sender instanceof Player)) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players.");
                        return true;
                    }
                    Player player = (Player)sender;
                    UUID playerUUID = player.getUniqueId();
                    boolean currentStatus = this.playerMessagesEnabled.getOrDefault(playerUUID, true);
                    boolean newStatus = !currentStatus;
                    this.playerMessagesEnabled.put(playerUUID, newStatus);
                    this.savePlayerPreferences();
                    if (newStatus) {
                        player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + " Countdown messages are now " + String.valueOf(ChatColor.BOLD) + "ENABLED" + String.valueOf(ChatColor.GREEN) + " for you.");
                    } else {
                        player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + " Countdown messages are now " + String.valueOf(ChatColor.BOLD) + "DISABLED" + String.valueOf(ChatColor.GREEN) + " for you.");
                    }
                    return true;
                }
                case "chunkfinder": {
                    if (!(sender.hasPermission("clearlag.all") || sender.hasPermission("clearlag.chunkfinder") || sender.isOp())) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                        return true;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /clearlag chunkfinder <count>");
                        return true;
                    }
                    try {
                        int count = Integer.parseInt(args[1]);
                        if (count <= 0) {
                            sender.sendMessage(String.valueOf(ChatColor.RED) + "<count> must be a positive number.");
                            return true;
                        }
                        List<ChunkData> topChunks = this.findLaggyChunks(count);
                        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- Top " + topChunks.size() + " Laggiest Chunks (by Entity Count) ---");
                        if (topChunks.isEmpty()) {
                            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "No loaded chunks found.");
                            return true;
                        }
                        int i = 0;
                        while (i < topChunks.size()) {
                            ChunkData data = topChunks.get(i);
                            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + (i + 1) + ". World: " + String.valueOf(ChatColor.AQUA) + data.worldName + String.valueOf(ChatColor.YELLOW) + ", Chunk: [" + String.valueOf(ChatColor.AQUA) + data.x + ", " + data.z + "]" + String.valueOf(ChatColor.YELLOW) + " - Entities: " + String.valueOf(ChatColor.RED) + data.entityCount);
                            ++i;
                        }
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "<count> must be a valid number.");
                    }
                    return true;
                }
                case "unloadchunk": {
                    if (!(sender.hasPermission("clearlag.all") || sender.hasPermission("clearlag.unloadchunk") || sender.isOp())) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                        return true;
                    }
                    if (args.length < 4) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /clearlag unloadchunk <world> <x> <z>");
                        return true;
                    }
                    World world = Bukkit.getWorld((String)args[1]);
                    if (world == null) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "World '" + args[1] + "' not found.");
                        return true;
                    }
                    try {
                        int chunkX = Integer.parseInt(args[2]);
                        int chunkZ = Integer.parseInt(args[3]);
                        if (!world.isChunkLoaded(chunkX, chunkZ)) {
                            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Chunk at [" + chunkX + ", " + chunkZ + "] in " + world.getName() + " is already unloaded.");
                            return true;
                        }
                        Chunk chunkToUnload = world.getChunkAt(chunkX, chunkZ);
                        if (chunkToUnload.unload(true)) {
                            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Successfully unloaded chunk at [" + chunkX + ", " + chunkZ + "] in " + world.getName() + ".");
                        } else {
                            sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to unload chunk. It might be in use or is a spawn chunk.");
                        }
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Chunk coordinates <x> and <z> must be valid numbers.");
                    }
                    return true;
                }
            }
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command does not exist. Use /clearlag for a list of commands.");
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("clearlag")) {
            if (args.length == 1) {
                ArrayList<String> subCommands = new ArrayList<String>(Arrays.asList("clear", "info", "killmobs", "reload", "nextclear", "topworld", "cpu", "ram", "specs", "togglemessages", "chunkfinder", "unloadchunk"));
                if (this.hideAllCommands && !sender.hasPermission("clearlag.togglemessages") && !sender.hasPermission("clearlag.all") && !sender.isOp()) {
                    subCommands.remove("togglemessages");
                }
                return subCommands.stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
            }
            if (args.length == 2) {
                if (args[0].equalsIgnoreCase("clear")) {
                    return Arrays.asList("items", "entity", "all");
                }
                if (args[0].equalsIgnoreCase("killmobs")) {
                    return Arrays.asList("evil", "good", "all");
                }
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("unloadchunk")) {
                return Bukkit.getWorlds().stream().map(WorldInfo::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("unloadchunk") && sender instanceof Player) {
                return Collections.singletonList(String.valueOf(((Player)sender).getLocation().getChunk().getX()));
            }
            if (args.length == 4 && args[0].equalsIgnoreCase("unloadchunk") && sender instanceof Player) {
                return Collections.singletonList(String.valueOf(((Player)sender).getLocation().getChunk().getZ()));
            }
        }
        return new ArrayList<String>();
    }

    private String formatTime(long totalSeconds) {
        if (totalSeconds < 0L) {
            totalSeconds = 0L;
        }
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        StringBuilder timeString = new StringBuilder();
        if (hours > 0L) {
            timeString.append(hours).append("h ");
        }
        if (minutes > 0L) {
            timeString.append(minutes).append("m ");
        }
        timeString.append(seconds).append("s");
        return timeString.toString().trim();
    }

    private void startFastClockCheckTask() {
        this.fastClockCheckTask = new BukkitRunnable(){

            public void run() {
                long now = System.currentTimeMillis();
                long blockDurationMillis = (long)ClearLag.this.fastClockBlockDuration * 1000L;
                ClearLag.this.blockedRedstoneChunks.entrySet().removeIf(entry -> (Long)entry.getValue() <= now);
                for (Map.Entry<Chunk, AtomicInteger> entry2 : ClearLag.this.chunkRedstoneActivations.entrySet()) {
                    Chunk chunk = entry2.getKey();
                    int activations = entry2.getValue().get();
                    if (activations <= ClearLag.this.fastClockThreshold) continue;
                    ClearLag.this.blockedRedstoneChunks.put(chunk, now + blockDurationMillis);
                    ClearLag.this.debugLog("Fast redstone clock detected in chunk [" + chunk.getWorld().getName() + "] " + chunk.getX() + "," + chunk.getZ() + ". Activations: " + activations + ". Blocking for " + ClearLag.this.fastClockBlockDuration + "s.");
                    if (!ClearLag.this.fastClockNotifyPlayers) continue;
                    ClearLag.this.notifyNearbyPlayers(chunk);
                }
                ClearLag.this.chunkRedstoneActivations.clear();
            }
        }.runTaskTimer((Plugin)this, 20L, 20L);
    }

    private void notifyNearbyPlayers(Chunk chunk) {
        String message = this.prefix + String.valueOf(ChatColor.RED) + " A fast redstone clock was detected in your chunk (" + chunk.getX() + ", " + chunk.getZ() + ") and has been temporarily disabled for lag prevention.";
        int x = -1;
        while (x <= 1) {
            int z = -1;
            while (z <= 1) {
                Chunk adjacentChunk = chunk.getWorld().getChunkAt(chunk.getX() + x, chunk.getZ() + z);
                if (adjacentChunk.isLoaded()) {
                    Entity[] entityArray = adjacentChunk.getEntities();
                    int n = entityArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Entity entity = entityArray[n2];
                        if (entity instanceof Player && entity.hasPermission("clearlag.warnings.receive")) {
                            ((Player)entity).sendMessage(message);
                        }
                        ++n2;
                    }
                }
                ++z;
            }
            ++x;
        }
    }

    private void checkForUpdates() {
        new BukkitRunnable(){

            public void run() {
                block16: {
                    try {
                        String projectId = "7bhTp28M";
                        URL url = new URL("https://api.modrinth.com/v2/project/" + projectId + "/version");
                        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
                        connection.setRequestMethod("GET");
                        connection.setRequestProperty("User-Agent", "ClearLag-Updater/1.0");
                        int responseCode = connection.getResponseCode();
                        if (responseCode == 200) {
                            Throwable throwable = null;
                            Object var6_8 = null;
                            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                                String inputLine;
                                StringBuilder content = new StringBuilder();
                                while ((inputLine = in.readLine()) != null) {
                                    content.append(inputLine);
                                }
                                Gson gson = new Gson();
                                JsonArray versions = (JsonArray)gson.fromJson(content.toString(), JsonArray.class);
                                if (!versions.isEmpty()) {
                                    JsonObject latestVersion = versions.get(0).getAsJsonObject();
                                    String latestVersionNumber = latestVersion.get("version_number").getAsString();
                                    String currentVersion = ClearLag.this.getDescription().getVersion();
                                    if (!currentVersion.equals(latestVersionNumber)) {
                                        ClearLag.this.updateAvailable = true;
                                        ClearLag.this.newVersionString = latestVersionNumber;
                                        Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GOLD) + "========================================");
                                        Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.YELLOW) + "ClearLag is outdated!");
                                        Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.YELLOW) + "Your version: " + String.valueOf(ChatColor.RED) + currentVersion);
                                        Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.YELLOW) + "Newest version: " + String.valueOf(ChatColor.GREEN) + ClearLag.this.newVersionString);
                                        Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.YELLOW) + "Download the new version here: " + String.valueOf(ChatColor.AQUA) + "https://modrinth.com/plugin/" + projectId);
                                        Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GOLD) + "========================================");
                                    } else {
                                        Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "[ClearLag] You are running the latest version (" + currentVersion + ").");
                                    }
                                }
                                break block16;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        ClearLag.this.getLogger().warning("Failed to check for updates. Response code: " + responseCode);
                    }
                    catch (Exception e) {
                        ClearLag.this.getLogger().log(Level.SEVERE, "Could not check for updates!", e);
                    }
                }
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private static class ChunkData
    implements Comparable<ChunkData> {
        final String worldName;
        final int x;
        final int z;
        final int entityCount;
        final Chunk chunk;

        ChunkData(Chunk chunk) {
            this.chunk = chunk;
            this.worldName = chunk.getWorld().getName();
            this.x = chunk.getX();
            this.z = chunk.getZ();
            this.entityCount = chunk.getEntities().length;
        }

        @Override
        public int compareTo(ChunkData other) {
            return Integer.compare(other.entityCount, this.entityCount);
        }
    }
}

