/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.backup;

import java.time.LocalDateTime;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.task.BackupDeleteTask;
import ru.dvdishka.backuper.backend.task.BackupToZipTask;
import ru.dvdishka.backuper.backend.task.BackupUnZipTask;

public interface Backup
extends Comparable<Backup> {
    public Storage getStorage();

    default public LocalDateTime getLocalDateTime() {
        return LocalDateTime.parse(this.getName(), Backuper.getInstance().getConfigManager().getBackupConfig().getDateTimeFormatter());
    }

    public String getName();

    default public String getFormattedName() {
        return this.getLocalDateTime().format(Backuper.getInstance().getConfigManager().getBackupConfig().getDateTimeFormatter());
    }

    default public long calculateByteSize() {
        return this.getStorage().getDirByteSize(this.getPath());
    }

    default public long getByteSize() {
        return this.getStorage().getBackupManager().cachedBackupsSize.get(this.getName(), key -> this.calculateByteSize());
    }

    default public long getMbSize() {
        return this.getByteSize() / 1024L / 1024L;
    }

    default public BackupFileType getFileType() {
        if (this.getStorage().ls(this.getStorage().getConfig().getBackupsFolder()).contains("%s.zip".formatted(this.getName()))) {
            return BackupFileType.ZIP;
        }
        return BackupFileType.DIR;
    }

    default public String getFileName(BackupFileType fileType) {
        if (BackupFileType.ZIP.equals((Object)fileType)) {
            return "%s.zip".formatted(this.getName());
        }
        return this.getName();
    }

    default public String getFileName() {
        return this.getFileName(this.getFileType());
    }

    default public String getInProgressFileName(BackupFileType fileType) {
        if (BackupFileType.ZIP.equals((Object)fileType)) {
            return "%s in progress.zip".formatted(this.getName());
        }
        return "%s in progress".formatted(this.getName());
    }

    default public String getInProgressFileName() {
        return this.getInProgressFileName(this.getFileType());
    }

    default public String getPath(BackupFileType fileType) {
        return this.getStorage().resolve(this.getStorage().getConfig().getBackupsFolder(), this.getFileName(fileType));
    }

    default public String getPath() {
        return this.getPath(this.getFileType());
    }

    default public String getInProgressPath(BackupFileType fileType) {
        return this.getStorage().resolve(this.getStorage().getConfig().getBackupsFolder(), this.getInProgressFileName(fileType));
    }

    default public String getInProgressPath() {
        return this.getInProgressPath(this.getFileType());
    }

    default public BackupDeleteTask getDeleteTask() {
        return new BackupDeleteTask(this);
    }

    default public BackupUnZipTask getUnZipTask() {
        return new BackupUnZipTask(this);
    }

    default public BackupToZipTask getToZipTask() {
        return new BackupToZipTask(this);
    }

    @Override
    default public int compareTo(Backup backup) {
        return this.getLocalDateTime().compareTo(backup.getLocalDateTime());
    }

    public static enum BackupFileType {
        DIR,
        ZIP;

    }
}

