/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.config;

import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import ru.dvdishka.backuper.Backuper;

public class ConfigBackwardsCompatibility {
    public static void configBelow4(FileConfiguration config) {
        double configVersion = config.getDouble("configVersion");
        if (configVersion >= 4.0) {
            return;
        }
        int backupPeriod = config.getInt("backupPeriod", 1440);
        config.set("backupPeriod", (Object)(backupPeriod *= 60));
        boolean fixedBackupTime = config.getBoolean("fixedBackupTime", false);
        if (!fixedBackupTime) {
            config.set("backupTime", (Object)-1);
        } else {
            config.set("backupTime", (Object)config.getInt("firstBackupTime"));
        }
    }

    public static void configBelow8(FileConfiguration config) {
        double configVersion = config.getDouble("configVersion");
        if (configVersion >= 8.0) {
            return;
        }
        String localBackupsFolder = config.getString("backupsFolder", "plugins/Backuper/Backups");
        int localMaxBackupsNumber = config.getInt("maxBackupsNumber", 0);
        long localMaxBackupsWeight = config.getLong("maxBackupsWeight", 0L);
        boolean localZipArchive = config.getBoolean("zipArchive", true);
        boolean autoBackup = config.getBoolean("autoBackup", true);
        List addDirectoryToBackup = config.getStringList("addDirectoryToBackup");
        List excludeDirectoryFromBackup = config.getStringList("excludeDirectoryFromBackup");
        int backupPeriod = config.getInt("backupPeriod", 1440);
        int backupTime = config.getInt("backupTime", -1);
        boolean skipDuplicateBackup = config.getBoolean("skipDuplicateBackup", true);
        String afterBackup = config.getString("afterBackup", "NOTHING");
        boolean setWorldsReadOnly = config.getBoolean("setWorldsReadOnly", false);
        long alertTimeBeforeRestart = config.getLong("alertTimeBeforeRestart", 60L);
        boolean alertOnlyServerRestart = config.getBoolean("alertOnlyServerRestart", true);
        boolean betterLogging = config.getBoolean("betterLogging", false);
        config.set("local.backupsFolder", (Object)localBackupsFolder);
        config.set("local.maxBackupsNumber", (Object)localMaxBackupsNumber);
        config.set("local.maxBackupsWeight", (Object)localMaxBackupsWeight);
        config.set("local.zipArchive", (Object)localZipArchive);
        config.set("backup.autoBackup", (Object)autoBackup);
        config.set("backup.addDirectoryToBackup", (Object)addDirectoryToBackup);
        config.set("backup.excludeDirectoryFromBackup", (Object)excludeDirectoryFromBackup);
        config.set("backup.backupPeriod", (Object)backupPeriod);
        config.set("backup.backupTime", (Object)backupTime);
        config.set("backup.skipDuplicateBackup", (Object)skipDuplicateBackup);
        config.set("backup.afterBackup", (Object)afterBackup);
        config.set("backup.setWorldsReadOnly", (Object)setWorldsReadOnly);
        config.set("server.alertTimeBeforeRestart", (Object)alertTimeBeforeRestart);
        config.set("server.alertOnlyServerRestart", (Object)alertOnlyServerRestart);
        config.set("server.betterLogging", (Object)betterLogging);
    }

    public static void configBelow13(FileConfiguration config) {
        double configVersion = config.getDouble("configVersion");
        if (configVersion >= 13.0) {
            return;
        }
        int backupPeriod = config.getInt("backup.backupPeriod", 1440);
        int backupTime22 = config.getInt("backup.backupTime", -1);
        if (backupTime22 < -1 || backupTime22 > 23) {
            Backuper.getInstance().getLogManager().warn("Failed to load config value!");
            Backuper.getInstance().getLogManager().warn("backupTime must be >= -1, using default -1 value...");
            backupTime22 = -1;
        }
        if (backupPeriod <= 0 && backupPeriod != -1) {
            Backuper.getInstance().getLogManager().warn("Failed to load config value!");
            Backuper.getInstance().getLogManager().warn("backup.backupPeriod must be > 0, using default 1440 value...");
            backupPeriod = 1440;
        }
        String cron22 = "";
        if (backupTime22 != -1) {
            cron22 = "0 0 %s 1/1 * ? *".formatted(backupTime22);
        }
        config.set("backup.autoBackupCron", (Object)cron22);
        config.set("backup.autoBackupPeriod", (Object)backupPeriod);
        ConfigurationSection localSection = config.getConfigurationSection("local");
        try {
            localSection.set("type", (Object)"local");
        }
        catch (Exception backupTime22) {
            // empty catch block
        }
        ConfigurationSection ftpSection = config.getConfigurationSection("ftp");
        try {
            ftpSection.set("type", (Object)"ftp");
        }
        catch (Exception cron22) {
            // empty catch block
        }
        ConfigurationSection sftpSection = config.getConfigurationSection("sftp");
        try {
            sftpSection.set("type", (Object)"sftp");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ConfigurationSection googleDriveSection = config.getConfigurationSection("googleDrive");
        try {
            googleDriveSection.set("type", (Object)"googleDrive");
        }
        catch (Exception exception) {
            // empty catch block
        }
        config.set("local", null);
        config.set("ftp", null);
        config.set("sftp", null);
        config.set("googleDrive", null);
        config.set("storages.local", (Object)localSection);
        config.set("storages.ftp", (Object)ftpSection);
        config.set("storages.sftp", (Object)sftpSection);
        config.set("storages.googleDrive", (Object)googleDriveSection);
    }
}

