/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.config;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.config.Config;

public class ServerConfig
implements Config {
    private long alertTimeBeforeRestart;
    private boolean betterLogging;
    private boolean alertOnlyServerRestart;
    private boolean checkUpdates;
    private File sizeCacheFile;
    private String alertBackupMessage;
    private String alertBackupRestartMessage;
    private int threadNumber;
    private ConfigurationSection config;

    @Override
    public Config load(ConfigurationSection config, String name) {
        this.config = config;
        this.alertBackupMessage = config.getString("alertBackupMessage");
        this.alertBackupRestartMessage = config.getString("alertBackupRestartMessage");
        this.sizeCacheFile = new File(config.getString("sizeCacheFile"));
        this.threadNumber = config.getInt("threadNumber");
        this.betterLogging = config.getBoolean("betterLogging");
        this.alertTimeBeforeRestart = config.getLong("alertTimeBeforeRestart");
        this.alertOnlyServerRestart = config.getBoolean("alertOnlyServerRestart");
        this.checkUpdates = config.getBoolean("checkUpdates");
        return this;
    }

    @Override
    public ConfigurationSection getDefaultConfig() {
        return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Backuper.getInstance().getResource("server_config.yml")));
    }

    @Generated
    public long getAlertTimeBeforeRestart() {
        return this.alertTimeBeforeRestart;
    }

    @Generated
    public boolean isBetterLogging() {
        return this.betterLogging;
    }

    @Generated
    public boolean isAlertOnlyServerRestart() {
        return this.alertOnlyServerRestart;
    }

    @Generated
    public boolean isCheckUpdates() {
        return this.checkUpdates;
    }

    @Generated
    public File getSizeCacheFile() {
        return this.sizeCacheFile;
    }

    @Generated
    public String getAlertBackupMessage() {
        return this.alertBackupMessage;
    }

    @Generated
    public String getAlertBackupRestartMessage() {
        return this.alertBackupRestartMessage;
    }

    @Generated
    public int getThreadNumber() {
        return this.threadNumber;
    }

    @Override
    @Generated
    public ConfigurationSection getConfig() {
        return this.config;
    }
}

