/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.storage;

import java.io.IOException;
import java.time.Duration;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.storage.FtpStorage;
import ru.dvdishka.backuper.backend.storage.exception.StorageConnectionException;

public class FtpClientProvider {
    private final FtpStorage storage;
    private FTPClient ftpClient = null;
    private String defaultPath = ".";

    FtpClientProvider(FtpStorage storage) {
        this.storage = storage;
    }

    synchronized FTPClient getClient() throws StorageConnectionException {
        if (this.ftpClient != null) {
            try {
                if (!this.ftpClient.isConnected() || !this.ftpClient.isAvailable()) {
                    this.connect();
                }
                try {
                    if (!this.ftpClient.sendNoOp()) {
                        this.connect();
                        this.ftpClient.sendNoOp();
                    }
                }
                catch (Exception e) {
                    this.connect();
                    this.ftpClient.sendNoOp();
                }
            }
            catch (IOException e) {
                Backuper.getInstance().getLogManager().warn("Failed to reconnect to FTP(S) connection");
                Backuper.getInstance().getLogManager().warn(e);
            }
            this.resetWorkingDirectory();
            return this.ftpClient;
        }
        this.ftpClient = new FTPClient();
        this.connect();
        try {
            this.defaultPath = this.ftpClient.printWorkingDirectory();
        }
        catch (IOException e) {
            Backuper.getInstance().getLogManager().warn("Failed to get default %s working directory".formatted(this.storage.getId()));
        }
        return this.ftpClient;
    }

    synchronized void resetWorkingDirectory() {
        try {
            this.ftpClient.changeWorkingDirectory(this.defaultPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void connect() {
        this.ftpClient.setConnectTimeout(30000);
        this.ftpClient.setDefaultTimeout(30000);
        this.ftpClient.setDataTimeout(Duration.ofSeconds(30L));
        this.ftpClient.setControlKeepAliveTimeout(Duration.ofMinutes(5L));
        this.ftpClient.setControlEncoding("UTF-8");
        try {
            this.ftpClient.connect(this.storage.getConfig().getAddress(), this.storage.getConfig().getPort());
        }
        catch (IOException e) {
            throw new StorageConnectionException(this.storage, "Failed to establish FTP(S) connection", e);
        }
        int reply = this.ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            try {
                this.ftpClient.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new StorageConnectionException(this.storage, "Failed to establish FTP(S) connection");
        }
        this.ftpClient.enterLocalPassiveMode();
        try {
            this.ftpClient.login(this.storage.getConfig().getUsername(), this.storage.getConfig().getPassword());
        }
        catch (IOException e) {
            throw new StorageConnectionException(this.storage, "Failed to login FTP(S) connection", e);
        }
        reply = this.ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            try {
                this.ftpClient.disconnect();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new StorageConnectionException(this.storage, "Failed to establish FTP(S) connection");
        }
        try {
            this.ftpClient.setFileType(2, 2);
            this.ftpClient.setFileTransferMode(10);
            this.ftpClient.setListHiddenFiles(true);
        }
        catch (IOException e) {
            throw new StorageConnectionException(this.storage, "Failed to set FTP(S) connection parameters", e);
        }
        try {
            this.ftpClient.sendNoOp();
        }
        catch (IOException e) {
            Backuper.getInstance().getLogManager().warn("Failed to send FTP(S) server ping");
        }
    }

    void disconnect() {
        if (this.ftpClient != null) {
            try {
                this.ftpClient.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.ftpClient = null;
    }
}

