/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.storage;

import ru.dvdishka.backuper.backend.config.PathStorageConfig;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.storage.exception.StorageConnectionException;
import ru.dvdishka.backuper.backend.storage.exception.StorageMethodException;

public interface PathStorage
extends Storage {
    @Override
    public PathStorageConfig getConfig();

    @Override
    default public String getFileNameFromPath(String path) throws StorageMethodException, StorageConnectionException {
        return path.substring(path.lastIndexOf(this.getConfig().getPathSeparatorSymbol()) + 1);
    }

    @Override
    default public String getParentPath(String path) throws StorageMethodException, StorageConnectionException {
        return path.substring(0, path.lastIndexOf(this.getConfig().getPathSeparatorSymbol()) == -1 ? 0 : path.lastIndexOf(this.getConfig().getPathSeparatorSymbol()));
    }

    @Override
    default public String resolve(String path, String fileName) {
        if (!path.endsWith(this.getConfig().getPathSeparatorSymbol())) {
            path = "%s%s".formatted(path, this.getConfig().getPathSeparatorSymbol());
        }
        return "%s%s".formatted(path, fileName);
    }
}

