/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.task;

import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.task.BaseTask;
import ru.dvdishka.backuper.backend.task.DeleteDirTask;
import ru.dvdishka.backuper.backend.task.TaskException;
import ru.dvdishka.backuper.backend.task.UnpackZipTask;

public class BackupUnZipTask
extends BaseTask {
    private final Backup backup;
    private UnpackZipTask unZipTask;
    private DeleteDirTask deleteZipTask;

    public BackupUnZipTask(Backup backup) {
        this.backup = backup;
    }

    @Override
    public void run() {
        try {
            if (!this.cancelled) {
                Backuper.getInstance().getTaskManager().startTaskRaw(this.unZipTask, this.sender);
            }
            if (!this.cancelled) {
                this.backup.getStorage().getBackupManager().invalidateBackupSizeCache(this.backup.getName());
                Backuper.getInstance().getTaskManager().startTaskRaw(this.deleteZipTask, this.sender);
                this.backup.getStorage().renameFile(this.backup.getInProgressPath(Backup.BackupFileType.DIR), this.backup.getFileName(Backup.BackupFileType.DIR));
                this.backup.getStorage().getBackupManager().saveBackupSizeToCache(this.backup.getName(), this.unZipTask.getBytesUploaded());
            }
        }
        catch (TaskException e) {
            this.warn(e);
        }
    }

    @Override
    public void prepareTask(CommandSender sender) throws Throwable {
        if (this.cancelled) {
            return;
        }
        this.deleteZipTask = new DeleteDirTask(this.backup.getStorage(), this.backup.getPath());
        this.deleteZipTask.maxProgress = this.backup.getByteSize();
        Backuper.getInstance().getTaskManager().prepareTask(this.deleteZipTask, sender);
        this.backup.getStorage().createDir(this.backup.getInProgressFileName(Backup.BackupFileType.DIR), this.backup.getStorage().getConfig().getBackupsFolder());
        this.unZipTask = new UnpackZipTask(this.backup.getStorage(), this.backup.getPath(), this.backup.getInProgressPath(Backup.BackupFileType.DIR));
        this.unZipTask.maxProgress = this.backup.getByteSize();
        Backuper.getInstance().getTaskManager().prepareTask(this.unZipTask, sender);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        if (this.unZipTask != null) {
            Backuper.getInstance().getTaskManager().cancelTaskRaw(this.unZipTask);
        }
        if (this.deleteZipTask != null) {
            Backuper.getInstance().getTaskManager().cancelTaskRaw(this.deleteZipTask);
        }
    }

    @Override
    public long getTaskMaxProgress() {
        if (!this.isTaskPrepared()) {
            return 0L;
        }
        return this.unZipTask.getTaskMaxProgress() * (long)this.backup.getStorage().getZipProgressMultiplier() + this.deleteZipTask.getTaskMaxProgress() * (long)this.backup.getStorage().getDeleteProgressMultiplier();
    }

    @Override
    public long getTaskCurrentProgress() {
        if (!this.isTaskPrepared()) {
            return 0L;
        }
        return this.unZipTask.getTaskCurrentProgress() * (long)this.backup.getStorage().getZipProgressMultiplier() + this.deleteZipTask.getTaskCurrentProgress() * (long)this.backup.getStorage().getDeleteProgressMultiplier();
    }
}

