/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.task;

import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.ApiStatus;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.task.Task;
import ru.dvdishka.backuper.backend.task.TaskException;

public abstract class BaseTask
implements Task {
    protected CommandSender sender = null;
    protected String taskName;
    protected long currentProgress = 0L;
    protected long maxProgress = 0L;
    protected boolean cancelled = false;
    protected CompletableFuture<Void> prepareTaskFuture = null;
    protected CompletableFuture<Void> taskFuture = null;

    protected BaseTask() {
    }

    @Override
    public String getTaskName() {
        return this.getClass().getSimpleName().replace("Task", "");
    }

    @Override
    public long getTaskPercentProgress() {
        if (this.getTaskMaxProgress() == 0L) {
            return 0L;
        }
        return (long)Math.min((double)this.getTaskCurrentProgress() / (double)this.getTaskMaxProgress() * 100.0, 100.0);
    }

    @Override
    public long getTaskCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    public long getTaskMaxProgress() {
        return this.maxProgress;
    }

    @Override
    public synchronized void incrementCurrentProgress(long progress) {
        this.currentProgress += progress;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    @ApiStatus.Internal
    public abstract void run();

    @Override
    @ApiStatus.Internal
    public abstract void prepareTask(CommandSender var1) throws Throwable;

    @Override
    @ApiStatus.Internal
    public void start(CommandSender sender) throws TaskException {
        if (!this.cancelled) {
            this.sender = sender;
        }
        if (!this.isTaskPrepared() && !this.cancelled) {
            try {
                Backuper.getInstance().getTaskManager().prepareTask(this, sender);
            }
            catch (Throwable e) {
                throw new TaskException(this, e);
            }
        }
        if (!this.cancelled) {
            try {
                this.prepareTaskFuture.get();
            }
            catch (Exception e) {
                throw new TaskException(this, (Throwable)e);
            }
        }
        if (!this.cancelled) {
            try {
                this.run();
            }
            catch (Exception e) {
                throw new TaskException(this, (Throwable)e);
            }
        }
    }

    @Override
    @ApiStatus.Internal
    public abstract void cancel();

    @Override
    public void setPrepareTaskFuture(CompletableFuture<Void> future) {
        this.prepareTaskFuture = future;
    }

    @Override
    public CompletableFuture<Void> getPrepareTaskFuture() {
        return this.prepareTaskFuture;
    }

    @Override
    public void setTaskFuture(CompletableFuture<Void> future) {
        this.taskFuture = future;
    }

    @Override
    public CompletableFuture<Void> getTaskFuture() {
        return this.taskFuture;
    }

    protected void warn(String message) {
        Backuper.getInstance().getLogManager().warn(message);
    }

    protected void warn(String message, CommandSender sender) {
        Backuper.getInstance().getLogManager().warn(message, sender);
    }

    protected void warn(Exception e) {
        Backuper.getInstance().getLogManager().warn(e);
    }

    protected void warn(TaskException e) {
        Backuper.getInstance().getLogManager().warn(e);
    }

    protected void log(String message) {
        Backuper.getInstance().getLogManager().log(message);
    }

    protected void log(String message, CommandSender sender) {
        Backuper.getInstance().getLogManager().log(message, sender);
    }

    protected void devLog(String message) {
        Backuper.getInstance().getLogManager().devLog(message);
    }

    protected void devWarn(String message) {
        Backuper.getInstance().getLogManager().devWarn(message);
    }

    protected void devWarn(Exception e) {
        Backuper.getInstance().getLogManager().devWarn(e);
    }

    @Override
    public boolean isTaskPrepared() {
        return this.prepareTaskFuture != null && this.prepareTaskFuture.isDone();
    }
}

