/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.task;

import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.task.BaseTask;
import ru.dvdishka.backuper.backend.task.DeleteDirTask;
import ru.dvdishka.backuper.backend.task.Task;
import ru.dvdishka.backuper.backend.task.TaskException;

public class DeleteBrokenBackupsTask
extends BaseTask {
    private final ArrayList<Task> tasks = new ArrayList();

    @Override
    public void run() {
        for (Task task : this.tasks) {
            if (this.cancelled) {
                return;
            }
            try {
                Backuper.getInstance().getTaskManager().startTaskRaw(task, this.sender);
            }
            catch (TaskException e) {
                this.warn(e);
            }
        }
    }

    @Override
    public void prepareTask(CommandSender sender) throws Throwable {
        if (this.cancelled) {
            return;
        }
        for (Storage storage : Backuper.getInstance().getStorageManager().getStorages()) {
            if (!storage.checkConnection(sender)) continue;
            for (String file : storage.ls(storage.getConfig().getBackupsFolder())) {
                if (this.cancelled) {
                    return;
                }
                if (!file.replace(".zip", "").endsWith(" in progress")) continue;
                DeleteDirTask task = new DeleteDirTask(storage, storage.resolve(storage.getConfig().getBackupsFolder(), file));
                Backuper.getInstance().getTaskManager().prepareTask(task, sender);
                this.tasks.add(task);
            }
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        for (Task task : this.tasks) {
            Backuper.getInstance().getTaskManager().cancelTaskRaw(task);
        }
    }

    @Override
    public long getTaskMaxProgress() {
        return this.tasks.stream().mapToLong(Task::getTaskMaxProgress).sum();
    }

    @Override
    public long getTaskCurrentProgress() {
        return this.tasks.stream().mapToLong(Task::getTaskCurrentProgress).sum();
    }
}

