/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.task;

import com.jcraft.jsch.SftpException;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.task.BaseTask;
import ru.dvdishka.backuper.backend.task.SingleStorageTask;

public class DeleteDirTask
extends BaseTask
implements SingleStorageTask {
    private final Storage storage;
    private final String path;

    public DeleteDirTask(Storage storage, String path) {
        this.storage = storage;
        this.path = path;
    }

    @Override
    public void run() {
        if (!this.cancelled) {
            this.deleteDir(this.path);
        }
    }

    @Override
    public void prepareTask(CommandSender sender) throws SftpException {
        if (this.maxProgress != 0L) {
            return;
        }
        this.maxProgress = this.storage.getDirByteSize(this.path);
    }

    private void deleteDir(String currentPath) {
        if (this.cancelled) {
            return;
        }
        try {
            if (this.storage.isDir(currentPath)) {
                for (String file : this.storage.ls(currentPath)) {
                    this.deleteDir(this.storage.resolve(currentPath, file));
                }
                this.storage.delete(currentPath);
            } else {
                long fileSize = this.storage.getDirByteSize(currentPath);
                this.storage.delete(currentPath);
                this.incrementCurrentProgress(fileSize);
            }
        }
        catch (Exception e) {
            this.warn("Something went while trying to delete %s directory from %s storage".formatted(currentPath, this.storage.getId()), this.sender);
            this.warn(e);
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public Storage getStorage() {
        return this.storage;
    }
}

