/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.task;

import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.task.BaseTask;
import ru.dvdishka.backuper.backend.util.Utils;

public class SetWorldsWritableTask
extends BaseTask {
    private final boolean force;

    public SetWorldsWritableTask(boolean force) {
        this.force = force;
    }

    public SetWorldsWritableTask() {
        this.force = false;
    }

    @Override
    public void run() {
        if (!Backuper.getInstance().getConfigManager().getBackupConfig().isSetWorldsReadOnly() && !this.force) {
            return;
        }
        Utils.errorSetWritable = false;
        for (World world : Bukkit.getWorlds()) {
            if (!world.getWorldFolder().setWritable(true)) {
                this.warn("Can not set %s writable!".formatted(world.getWorldFolder().getPath()), this.sender);
                Utils.errorSetWritable = true;
            }
            if (!Utils.isAutoSaveEnabled.containsKey(world.getName())) continue;
            world.setAutoSave(this.force || Utils.isAutoSaveEnabled.get(world.getName()) != false);
        }
    }

    @Override
    public void prepareTask(CommandSender sender) {
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }
}

