/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.task;

import com.jcraft.jsch.SftpException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import javax.naming.AuthenticationException;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.backend.storage.LocalStorage;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.storage.exception.StorageLimitException;
import ru.dvdishka.backuper.backend.storage.exception.StorageQuotaExceededException;
import ru.dvdishka.backuper.backend.storage.util.BasicStorageProgressListener;
import ru.dvdishka.backuper.backend.storage.util.StorageProgressListener;
import ru.dvdishka.backuper.backend.task.BaseTask;
import ru.dvdishka.backuper.backend.task.DoubleStorageTask;
import ru.dvdishka.backuper.backend.util.Utils;

public class TransferDirTask
extends BaseTask
implements DoubleStorageTask {
    private final Storage sourceStorage;
    private final String sourceDir;
    private final Storage targetStorage;
    private final String targetParentDir;
    private final String targetFileName;
    private final boolean forceExcludedDirs;
    private ArrayList<StorageProgressListener> downloadProgressListeners;
    private static final int STREAM_BUFFER_SIZE = 0x100000;

    public TransferDirTask(Storage sourceStorage, String sourceDir, Storage targetStorage, String targetParentDir, String targetFileName, boolean forceExcludedDirs) {
        this.sourceStorage = sourceStorage;
        this.targetStorage = targetStorage;
        this.sourceDir = sourceDir;
        this.targetParentDir = targetParentDir;
        this.targetFileName = targetFileName;
        this.forceExcludedDirs = forceExcludedDirs;
    }

    @Override
    public void run() {
        this.downloadProgressListeners = new ArrayList();
        if (!this.cancelled) {
            this.sendFolder(this.sourceDir, this.targetParentDir, this.targetFileName);
        }
    }

    @Override
    public void prepareTask(CommandSender sender) throws ExecutionException, InterruptedException, AuthenticationException, IOException, StorageLimitException, StorageQuotaExceededException, SftpException {
        if (this.maxProgress != 0L) {
            return;
        }
        this.maxProgress = this.sourceStorage instanceof LocalStorage && !this.forceExcludedDirs ? Utils.getFileFolderByteSizeExceptExcluded(new File(this.sourceDir)) : this.sourceStorage.getDirByteSize(this.sourceDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFolder(String sourceDir, String targetParentDir, String targetFileName) {
        if (this.cancelled) {
            return;
        }
        if (!this.sourceStorage.exists(sourceDir)) {
            this.warn("Something went wrong while trying to send files from %s".formatted(sourceDir));
            this.warn("Directory %s doesn't exist".formatted(sourceDir), this.sender);
            return;
        }
        if (this.sourceStorage instanceof LocalStorage && !this.forceExcludedDirs && Utils.isExcludedDirectory(new File(sourceDir), this.sender)) {
            return;
        }
        if (this.sourceStorage.isFile(sourceDir) && !this.sourceStorage.getFileNameFromPath(sourceDir).equals("session.lock")) {
            try {
                BasicStorageProgressListener progressListener = new BasicStorageProgressListener();
                this.downloadProgressListeners.add(progressListener);
                try (InputStream directInputStream = this.sourceStorage.downloadFile(sourceDir, progressListener);
                     BufferedInputStream inputStream = new BufferedInputStream(directInputStream, 0x100000);){
                    this.targetStorage.uploadFile(inputStream, targetFileName, targetParentDir);
                }
                catch (Exception e) {
                    this.warn("Failed to send file \"%s\" to %s storage".formatted(sourceDir, this.targetStorage.getId()));
                    this.warn(e);
                }
                finally {
                    this.sourceStorage.downloadCompleted();
                }
            }
            catch (Exception e) {
                this.warn("Failed to send file \"%s\" to %s storage".formatted(sourceDir, this.targetStorage.getId()), this.sender);
                this.warn(e);
            }
        }
        if (this.sourceStorage.isDir(sourceDir)) {
            this.targetStorage.createDir(targetFileName, targetParentDir);
            for (String file : this.sourceStorage.ls(sourceDir)) {
                this.sendFolder(this.sourceStorage.resolve(sourceDir, file), this.targetStorage.resolve(targetParentDir, targetFileName), file);
            }
        }
    }

    @Override
    public long getTaskCurrentProgress() {
        if (this.downloadProgressListeners == null) {
            return 0L;
        }
        return this.downloadProgressListeners.stream().mapToLong(StorageProgressListener::getCurrentProgress).sum();
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public Storage getSourceStorage() {
        return this.sourceStorage;
    }

    @Override
    public Storage getTargetStorage() {
        return this.targetStorage;
    }
}

