/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.task;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.storage.LocalStorage;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.storage.util.BasicStorageProgressListener;
import ru.dvdishka.backuper.backend.storage.util.StorageProgressListener;
import ru.dvdishka.backuper.backend.task.BaseTask;
import ru.dvdishka.backuper.backend.task.DoubleStorageTask;
import ru.dvdishka.backuper.backend.util.Utils;

public class TransferDirsAsZipTask
extends BaseTask
implements DoubleStorageTask {
    private static final int FILE_BUFFER_SIZE = 65536;
    private static final int STREAM_BUFFER_SIZE = 0x100000;
    private static final int PIPE_BUFFER_SIZE = 0x400000;
    private final Storage sourceStorage;
    private final List<String> sourceDirs;
    private final boolean forceExcludedDirs;
    private final boolean createRootDirInTargetZIP;
    private final Storage targetStorage;
    private final String targetParentDir;
    private final String targetZipFileName;
    private final List<StorageProgressListener> downloadProgressListeners = new ArrayList<StorageProgressListener>();
    private final AtomicLong bytesUploaded = new AtomicLong(0L);

    public TransferDirsAsZipTask(Storage sourceStorage, List<String> sourceDirs, Storage targetStorage, String targetParentDir, String targetZipFileName, boolean createRootDirInTargetZIP, boolean forceExcludedDirs) {
        this.sourceStorage = sourceStorage;
        this.targetStorage = targetStorage;
        this.sourceDirs = sourceDirs;
        this.targetParentDir = targetParentDir;
        this.targetZipFileName = targetZipFileName;
        this.createRootDirInTargetZIP = createRootDirInTargetZIP;
        this.forceExcludedDirs = forceExcludedDirs;
    }

    @Override
    public void run() {
        try (PipedInputStream pipedInputStream = new PipedInputStream(0x400000);
             PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);){
            Backuper.getInstance().getScheduleManager().runAsync(() -> {
                try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(pipedOutputStream, 0x100000);
                     ZipOutputStream targetZipOutputStream = new ZipOutputStream(bufferedOutputStream);){
                    for (String sourceDirToAdd : this.sourceDirs) {
                        if (this.cancelled) {
                            return;
                        }
                        if (this.createRootDirInTargetZIP) {
                            this.addDirToZip(targetZipOutputStream, sourceDirToAdd, this.sourceStorage.getFileNameFromPath(sourceDirToAdd));
                            continue;
                        }
                        this.addDirToZip(targetZipOutputStream, sourceDirToAdd, "");
                    }
                }
                catch (Exception e) {
                    this.warn("Failed to send ZIP entry to %s storage".formatted(this.targetStorage), this.sender);
                    this.warn(e);
                }
            });
            this.targetStorage.uploadFile(pipedInputStream, this.targetZipFileName, this.targetParentDir);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getTaskCurrentProgress() {
        return this.downloadProgressListeners.stream().mapToLong(StorageProgressListener::getCurrentProgress).sum();
    }

    @Override
    public void prepareTask(CommandSender sender) {
        if (this.maxProgress != 0L) {
            return;
        }
        if (this.sourceStorage instanceof LocalStorage && !this.forceExcludedDirs) {
            for (String dir : this.sourceDirs) {
                this.maxProgress += Utils.getFileFolderByteSizeExceptExcluded(new File(dir));
            }
        } else {
            for (String dir : this.sourceDirs) {
                this.maxProgress += this.sourceStorage.getDirByteSize(dir);
            }
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDirToZip(ZipOutputStream zip, String sourceDir, String relativeDirPath) {
        block31: {
            if (this.cancelled) {
                return;
            }
            if (!this.sourceStorage.exists(sourceDir)) {
                this.warn("Directory does not exist: %s".formatted(sourceDir), this.sender);
                return;
            }
            if (this.sourceStorage instanceof LocalStorage && !this.forceExcludedDirs && Utils.isExcludedDirectory(new File(sourceDir), this.sender)) {
                return;
            }
            try {
                if (!this.sourceStorage.isFile(sourceDir)) break block31;
                long crc = 0L;
                if (this.isAlreadyCompressed(this.sourceStorage, sourceDir)) {
                    crc = this.calculateCRC(sourceDir);
                }
                BasicStorageProgressListener downloadProgressListener = new BasicStorageProgressListener();
                this.downloadProgressListeners.add(downloadProgressListener);
                try (InputStream directInputStream = this.sourceStorage.downloadFile(sourceDir, downloadProgressListener);
                     BufferedInputStream bufferedInputStream = new BufferedInputStream(directInputStream, 65536);){
                    int read;
                    ZipEntry entry = new ZipEntry(relativeDirPath);
                    if (this.isAlreadyCompressed(this.sourceStorage, sourceDir)) {
                        entry.setMethod(0);
                        entry.setCompressedSize(this.sourceStorage.getDirByteSize(sourceDir));
                        entry.setCrc(crc);
                    } else {
                        zip.setLevel(this.targetStorage.getConfig().getZipCompressionLevel());
                    }
                    entry.setSize(this.sourceStorage.getDirByteSize(sourceDir));
                    zip.putNextEntry(entry);
                    byte[] buffer = new byte[65536];
                    while ((read = bufferedInputStream.read(buffer)) != -1) {
                        if (this.cancelled) {
                            return;
                        }
                        zip.write(buffer, 0, read);
                        this.bytesUploaded.getAndAdd(read);
                    }
                    zip.closeEntry();
                }
                finally {
                    this.sourceStorage.downloadCompleted();
                }
            }
            catch (Exception e) {
                this.warn("Error adding to ZIP: %s".formatted(sourceDir), this.sender);
                this.warn(e);
            }
        }
        if (this.sourceStorage.isDir(sourceDir)) {
            try {
                ZipEntry entry = new ZipEntry(relativeDirPath.endsWith("/") ? relativeDirPath : "%s/".formatted(relativeDirPath));
                zip.putNextEntry(entry);
                zip.closeEntry();
                List<String> ls = this.sourceStorage.ls(sourceDir);
                for (String file : ls) {
                    if ("session.lock".equals(file)) continue;
                    this.addDirToZip(zip, this.sourceStorage.resolve(sourceDir, file), "%s/%s".formatted(relativeDirPath, file));
                }
            }
            catch (Exception e) {
                this.warn("Error adding a dir to ZIP: %s".formatted(sourceDir), this.sender);
                this.warn(e);
            }
        }
    }

    private boolean isAlreadyCompressed(Storage storage, String path) {
        String name = storage.getFileNameFromPath(path).toLowerCase();
        return name.endsWith(".zip") || name.endsWith(".jar") || name.endsWith(".gz") || name.endsWith(".7z") || name.endsWith(".rar") || name.endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".png") || name.endsWith(".mp3") || name.endsWith(".mp4") || name.endsWith(".avi") || name.endsWith(".mkv") || name.endsWith(".webm") || name.endsWith(".webp");
    }

    private long calculateCRC(String path) throws IOException {
        try {
            long l;
            try (BufferedInputStream bis = new BufferedInputStream(this.sourceStorage.downloadFile(path), 65536);){
                int read;
                CRC32 crc = new CRC32();
                byte[] buffer = new byte[65536];
                while ((read = bis.read(buffer)) != -1) {
                    crc.update(buffer, 0, read);
                }
                l = crc.getValue();
            }
            return l;
        }
        finally {
            this.sourceStorage.downloadCompleted();
        }
    }

    public long getBytesUploaded() {
        return this.bytesUploaded.get();
    }

    @Override
    public Storage getSourceStorage() {
        return this.sourceStorage;
    }

    @Override
    public Storage getTargetStorage() {
        return this.targetStorage;
    }
}

