/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.task;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.SequencedCollection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.storage.util.BasicStorageProgressListener;
import ru.dvdishka.backuper.backend.storage.util.StorageProgressListener;
import ru.dvdishka.backuper.backend.task.BaseTask;
import ru.dvdishka.backuper.backend.task.SingleStorageTask;

public class UnpackZipTask
extends BaseTask
implements SingleStorageTask {
    private final Storage storage;
    private final String sourceZipDir;
    private final String targetFolderDir;
    private StorageProgressListener downloadProgressListener;
    private final List<StorageProgressListener> uploadProgressListeners = new ArrayList<StorageProgressListener>();
    private static final int STREAM_BUFFER_SIZE = 0x100000;

    public UnpackZipTask(Storage storage, String sourceZipDir, String targetFolderDir) {
        this.storage = storage;
        this.sourceZipDir = sourceZipDir;
        this.targetFolderDir = targetFolderDir;
    }

    @Override
    public void run() {
        this.downloadProgressListener = new BasicStorageProgressListener();
        try (InputStream directInputStream = this.storage.downloadFile(this.sourceZipDir, this.downloadProgressListener);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(directInputStream, 0x100000);
             ZipInputStream zipInput = new ZipInputStream(bufferedInputStream);){
            ZipEntry zipEntry;
            if (!this.storage.exists(this.targetFolderDir)) {
                this.storage.createDir(this.storage.getFileNameFromPath(this.targetFolderDir), this.storage.getParentPath(this.targetFolderDir));
            }
            while (!this.cancelled && (zipEntry = zipInput.getNextEntry()) != null) {
                String name = zipEntry.getName();
                try {
                    SequencedCollection entryRelativeListedPath = new ArrayList<String>();
                    if (zipEntry.isDirectory()) {
                        name = name.substring(0, name.length() - 1);
                    }
                    String currentRelativePath = name;
                    while (!(currentRelativePath = this.getParentFromZipPath(currentRelativePath)).isEmpty()) {
                        entryRelativeListedPath.add(this.getFileNameFromZipPath(currentRelativePath));
                    }
                    entryRelativeListedPath = entryRelativeListedPath.reversed();
                    String entryParentRelativePath = this.targetFolderDir;
                    for (String dir : entryRelativeListedPath) {
                        entryParentRelativePath = this.storage.resolve(entryParentRelativePath, dir);
                    }
                    if (zipEntry.isDirectory()) {
                        if (zipEntry.getName().equals("/")) continue;
                        this.storage.createDir(this.getFileNameFromZipPath(name), entryParentRelativePath);
                    } else {
                        BasicStorageProgressListener uploadProgressListener = new BasicStorageProgressListener();
                        this.uploadProgressListeners.add(uploadProgressListener);
                        this.storage.uploadFile(zipInput, this.getFileNameFromZipPath(name), entryParentRelativePath, uploadProgressListener);
                    }
                }
                catch (Exception e) {
                    this.warn("Something went wrong while trying to unpack file", this.sender);
                    this.warn(e);
                }
                zipInput.closeEntry();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.storage.downloadCompleted();
        }
    }

    @Override
    public void prepareTask(CommandSender sender) throws IOException {
        if (this.maxProgress != 0L) {
            return;
        }
        this.maxProgress = this.storage.getDirByteSize(this.sourceZipDir);
    }

    @Override
    public long getTaskCurrentProgress() {
        return this.downloadProgressListener.getCurrentProgress();
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public Storage getStorage() {
        return this.storage;
    }

    private String getFileNameFromZipPath(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    private String getParentFromZipPath(String path) {
        return path.substring(0, path.lastIndexOf("/") == -1 ? 0 : path.lastIndexOf("/"));
    }

    public long getBytesUploaded() {
        return this.uploadProgressListeners.stream().mapToLong(StorageProgressListener::getCurrentProgress).sum();
    }
}

