/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.googleDrive;

import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.storage.UserAuthStorage;
import ru.dvdishka.backuper.backend.storage.exception.StorageConnectionException;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.backuper.handlers.commands.Permission;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class AccountLinkCommand
extends Command {
    private UserAuthStorage storage;

    public AccountLinkCommand(CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
    }

    @Override
    public boolean check() {
        if (Backuper.getInstance().getTaskManager().isLocked()) {
            this.returnFailure("You cannot link your account while some process is running");
            return false;
        }
        Storage storage = Backuper.getInstance().getStorageManager().getStorage((String)this.arguments.get("storage"));
        if (storage == null) {
            this.returnFailure("Wrong storage name %s".formatted((String)this.arguments.get("storage")));
            return false;
        }
        if (!this.sender.hasPermission(Permission.ACCOUNT.getPermission(storage))) {
            this.returnFailure("Don't have enough permissions to perform this command");
            return false;
        }
        if (!(storage instanceof UserAuthStorage)) {
            this.returnFailure("There is no option to link account to this storage %s".formatted((String)this.arguments.get("storage")));
            return false;
        }
        this.storage = (UserAuthStorage)storage;
        return true;
    }

    @Override
    public void run() {
        try {
            this.storage.authorizeForced(this.sender);
        }
        catch (StorageConnectionException e) {
            Backuper.getInstance().getLogManager().warn("Failed to link account to %s storage".formatted(this.storage.getId()), this.sender);
            Backuper.getInstance().getLogManager().warn(e);
        }
    }
}

