/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.menu;

import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.util.UIUtils;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.backuper.handlers.commands.Permission;
import ru.dvdishka.backuper.handlers.commands.menu.DeleteCommand;
import ru.dvdishka.backuper.handlers.commands.menu.ToZIPCommand;
import ru.dvdishka.backuper.handlers.commands.menu.UnZIPCommand;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class MenuCommand
extends Command {
    private Storage storage;
    private Backup backup;

    public MenuCommand(CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
    }

    @Override
    public boolean check() {
        this.storage = Backuper.getInstance().getStorageManager().getStorage((String)this.arguments.get("storage"));
        if (this.storage == null) {
            this.returnFailure("Wrong storage name %s".formatted((String)this.arguments.get("storage")));
            return false;
        }
        if (!this.storage.checkConnection()) {
            this.returnFailure("Failed to establish connection to storage %s".formatted(this.storage.getId()));
            return false;
        }
        this.backup = this.storage.getBackupManager().getBackup((String)this.arguments.get("backupName"));
        if (this.backup == null) {
            this.returnFailure("Wrong backup name %s".formatted((String)this.arguments.get("backupName")));
            return false;
        }
        if (!this.sender.hasPermission(Permission.STORAGE.getPermission(this.storage))) {
            this.returnFailure("Don't have enough permissions to perform this command");
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        String backupFormattedName = this.backup.getFormattedName();
        long backupMbSize = this.backup.getMbSize();
        TextComponent header = Component.empty();
        header = header.append(Component.text((String)"Backup menu").decorate(TextDecoration.BOLD)).append((Component)Component.space()).append(((TextComponent)Component.text((String)"(%s)".formatted(this.storage.getId())).color(UIUtils.getSecondaryColor())).decorate(TextDecoration.BOLD));
        TextComponent message = Component.empty();
        if (!(this.sender instanceof ConsoleCommandSender)) {
            message = message.append(Component.text((String)backupFormattedName).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"(%s) (%s) %s MB".formatted(this.storage.getId(), this.backup.getFileType().name(), this.backup.getMbSize()))))).append((Component)Component.newline()).append((Component)Component.newline());
            if (Backup.BackupFileType.DIR.equals((Object)this.backup.getFileType())) {
                message = message.append(((TextComponent)((TextComponent)Component.text((String)"[TO ZIP]").clickEvent(ClickEvent.callback(audience -> new ToZIPCommand((CommandSender)audience, new CommandArguments(new Object[]{this.backup.getStorage().getId(), this.backup.getName()}, (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("storage", MenuCommand.this.backup.getStorage().getId());
                        this.put("backupName", MenuCommand.this.backup.getName());
                    }
                }, new String[]{this.backup.getStorage().getId(), this.backup.getName()}, (Map<String, String>)new HashMap<String, String>(){
                    {
                        this.put("storage", MenuCommand.this.backup.getStorage().getId());
                        this.put("backupName", MenuCommand.this.backup.getName());
                    }
                }, "/backuper menu \"%s\" \"%s\" tozip".formatted(this.backup.getStorage().getId(), this.backup.getName()))).executeConfirm()))).decorate(TextDecoration.BOLD)).color(TextColor.color((int)300875))).append((Component)Component.space());
            }
            if (Backup.BackupFileType.ZIP.equals((Object)this.backup.getFileType())) {
                message = message.append(((TextComponent)((TextComponent)Component.text((String)"[UNZIP]").clickEvent(ClickEvent.callback(audience -> new UnZIPCommand((CommandSender)audience, new CommandArguments(new Object[]{this.backup.getStorage().getId(), this.backup.getName()}, (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("storage", MenuCommand.this.backup.getStorage().getId());
                        this.put("backupName", MenuCommand.this.backup.getName());
                    }
                }, new String[]{this.backup.getStorage().getId(), this.backup.getName()}, (Map<String, String>)new HashMap<String, String>(){
                    {
                        this.put("storage", MenuCommand.this.backup.getStorage().getId());
                        this.put("backupName", MenuCommand.this.backup.getName());
                    }
                }, "/backuper menu \"%s\" \"%s\" unzip".formatted(this.backup.getStorage().getId(), this.backup.getName()))).executeConfirm()))).decorate(TextDecoration.BOLD)).color(TextColor.color((int)300875))).append((Component)Component.space());
            }
            if (Backuper.getInstance().getStorageManager().getStorages().size() >= 2) {
                message = message.append(((TextComponent)((TextComponent)Component.text((String)"[COPY TO]").clickEvent(ClickEvent.suggestCommand((String)"/backuper menu %s \"%s\" copyto ".formatted(this.storage.getId(), this.backup.getName())))).decorate(TextDecoration.BOLD)).color(TextColor.color((int)17, (int)102, (int)212))).append((Component)Component.space());
            }
            message = message.append(((TextComponent)((TextComponent)Component.text((String)"[DELETE]").clickEvent(ClickEvent.callback(audience -> new DeleteCommand((CommandSender)audience, new CommandArguments(new Object[]{this.backup.getStorage().getId(), this.backup.getName()}, (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("storage", MenuCommand.this.backup.getStorage().getId());
                    this.put("backupName", MenuCommand.this.backup.getName());
                }
            }, new String[]{this.backup.getStorage().getId(), this.backup.getName()}, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("storage", MenuCommand.this.backup.getStorage().getId());
                    this.put("backupName", MenuCommand.this.backup.getName());
                }
            }, "/backuper menu \"%s\" \"%s\" delete".formatted(this.backup.getStorage().getId(), this.backup.getName()))).executeConfirm()))).decorate(TextDecoration.BOLD)).color(TextColor.color((int)11542784)));
            this.sendFramedMessage((Component)header, (Component)message, 15);
        } else {
            message = message.append((Component)Component.text((String)backupFormattedName)).append((Component)Component.space()).append((Component)Component.text((String)"(%s)".formatted(this.backup.getStorage().getId()))).append((Component)Component.space()).append((Component)Component.text((String)this.backup.getFileType().name())).append((Component)Component.space()).append((Component)Component.text((long)backupMbSize)).append((Component)Component.space()).append((Component)Component.text((String)"MB"));
            this.sendFramedMessage((Component)header, (Component)message);
        }
    }
}

