/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.imap;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.MalformedServerReplyException;

public final class IMAPReply {
    public static final int OK = 0;
    public static final int NO = 1;
    public static final int BAD = 2;
    public static final int CONT = 3;
    public static final int PARTIAL = 3;
    private static final String IMAP_OK = "OK";
    private static final String IMAP_NO = "NO";
    private static final String IMAP_BAD = "BAD";
    private static final String IMAP_UNTAGGED_PREFIX = "* ";
    private static final String IMAP_CONTINUATION_PREFIX = "+";
    private static final String TAGGED_RESPONSE = "^\\w{1,80} (\\S{1,80}).{0,80}";
    private static final Pattern TAGGED_PATTERN = Pattern.compile("^\\w{1,80} (\\S{1,80}).{0,80}");
    private static final String UNTAGGED_RESPONSE = "^\\* (\\S{1,80}).{0,80}";
    private static final Pattern UNTAGGED_PATTERN = Pattern.compile("^\\* (\\S{1,80}).{0,80}");
    private static final Pattern LITERAL_PATTERN = Pattern.compile("\\{(\\d+)\\}$");

    public static int getReplyCode(String line) throws IOException {
        return IMAPReply.getReplyCode(line, TAGGED_PATTERN);
    }

    private static int getReplyCode(String line, Pattern pattern) throws IOException {
        if (IMAPReply.isContinuation(line)) {
            return 3;
        }
        Matcher m4 = pattern.matcher(line);
        if (m4.matches()) {
            String code = m4.group(1);
            if (code.equals(IMAP_OK)) {
                return 0;
            }
            if (code.equals(IMAP_BAD)) {
                return 2;
            }
            if (code.equals(IMAP_NO)) {
                return 1;
            }
        }
        throw new MalformedServerReplyException("Received unexpected IMAP protocol response from server: '" + line + "'.");
    }

    public static int getUntaggedReplyCode(String line) throws IOException {
        return IMAPReply.getReplyCode(line, UNTAGGED_PATTERN);
    }

    public static boolean isContinuation(int replyCode) {
        return replyCode == 3;
    }

    public static boolean isContinuation(String line) {
        return line.startsWith(IMAP_CONTINUATION_PREFIX);
    }

    public static boolean isSuccess(int replyCode) {
        return replyCode == 0;
    }

    public static boolean isUntagged(String line) {
        return line.startsWith(IMAP_UNTAGGED_PREFIX);
    }

    public static int literalCount(String line) {
        Matcher m4 = LITERAL_PATTERN.matcher(line);
        if (m4.find()) {
            return Integer.parseInt(m4.group(1));
        }
        return -1;
    }

    private IMAPReply() {
    }
}

