/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.backup;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.FtpBackup;
import ru.dvdishka.backuper.backend.backup.GoogleDriveBackup;
import ru.dvdishka.backuper.backend.backup.LocalBackup;
import ru.dvdishka.backuper.backend.backup.SftpBackup;
import ru.dvdishka.backuper.backend.backup.StorageType;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public abstract class Backup {
    String backupName;
    public static HashMap<StorageType, Cache<String, Long>> cachedBackupsSize = new HashMap();
    private static Gson gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();

    public static String getSizeCacheJson(CommandSender sender) {
        HashMap<StorageType, ConcurrentMap<String, Long>> jsonedCache = new HashMap<StorageType, ConcurrentMap<String, Long>>();
        for (StorageType storageType : StorageType.values()) {
            jsonedCache.put(storageType, cachedBackupsSize.get((Object)storageType).asMap());
        }
        String json = gson.toJson(jsonedCache);
        return json;
    }

    public static void loadSizeCache(String json, CommandSender sender) {
        try {
            if (json.isEmpty()) {
                return;
            }
            Type typeToken = new TypeToken<HashMap<StorageType, HashMap<String, Long>>>(){}.getType();
            HashMap jsonedCache = (HashMap)gson.fromJson(json, typeToken);
            for (StorageType storageType : StorageType.values()) {
                for (Map.Entry entry : ((HashMap)jsonedCache.get((Object)storageType)).entrySet()) {
                    cachedBackupsSize.get((Object)storageType).put((String)entry.getKey(), (Long)entry.getValue());
                }
            }
            Logger.getLogger().devLog("Size cache has been loaded successfully", sender);
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to load size cache", sender);
            Logger.getLogger().warn(Backup.class, e);
        }
    }

    private StorageType getStorageType() {
        if (this instanceof LocalBackup) {
            return StorageType.LOCAL;
        }
        if (this instanceof FtpBackup) {
            return StorageType.FTP;
        }
        if (this instanceof SftpBackup) {
            return StorageType.SFTP;
        }
        if (this instanceof GoogleDriveBackup) {
            return StorageType.GOOGLE_DRIVE;
        }
        return StorageType.NULL;
    }

    public static void saveBackupSizeToCache(StorageType storageType, String backupName, long byteSize) {
        cachedBackupsSize.get((Object)storageType).put(backupName, byteSize);
        if (storageType == StorageType.GOOGLE_DRIVE) {
            GoogleDriveBackup.getInstance(backupName).saveSizeToFileProperties(byteSize, null);
        }
    }

    public BackupDeleteTask getDeleteTask(boolean setLocked, CommandSender sender) {
        return new BackupDeleteTask(this, setLocked, sender);
    }

    abstract Task getDirectDeleteTask(boolean var1, CommandSender var2);

    public void delete(boolean setLocked, CommandSender sender) {
        this.getDeleteTask(setLocked, sender).run();
    }

    public abstract LocalDateTime getLocalDateTime();

    public abstract String getName();

    public String getFormattedName() {
        return this.getLocalDateTime().format(Config.getInstance().getDateTimeFormatter());
    }

    abstract long calculateByteSize(CommandSender var1);

    public long getByteSize(CommandSender sender) {
        return cachedBackupsSize.get((Object)this.getStorageType()).get(this.getName(), key -> this.calculateByteSize(sender));
    }

    public long getMbSize(CommandSender sender) {
        return this.getByteSize(sender) / 1024L / 1024L;
    }

    public abstract String getFileType();

    public abstract String getFileName();

    public abstract String getPath();

    static {
        cachedBackupsSize.put(StorageType.LOCAL, Caffeine.newBuilder().build());
        cachedBackupsSize.put(StorageType.FTP, Caffeine.newBuilder().build());
        cachedBackupsSize.put(StorageType.SFTP, Caffeine.newBuilder().build());
        cachedBackupsSize.put(StorageType.GOOGLE_DRIVE, Caffeine.newBuilder().build());
        cachedBackupsSize.put(StorageType.NULL, Caffeine.newBuilder().build());
    }

    public class BackupDeleteTask
    extends Task {
        private static final String taskName = "BackupDelete";
        private Backup backup;
        private Task deleteBackupTask;

        private static List<Permissions> getDeletePermissions(Backup backup) {
            ArrayList<Permissions> permissions = new ArrayList<Permissions>();
            if (backup instanceof LocalBackup) {
                permissions.add(Permissions.LOCAL_DELETE);
            }
            if (backup instanceof SftpBackup) {
                permissions.add(Permissions.SFTP_DELETE);
            }
            if (backup instanceof FtpBackup) {
                permissions.add(Permissions.FTP_DELETE);
            }
            if (backup instanceof GoogleDriveBackup) {
                permissions.add(Permissions.GOOGLE_DRIVE_DELETE);
            }
            return permissions;
        }

        public BackupDeleteTask(Backup backup, boolean setLocked, List<Permissions> permissions, CommandSender sender) {
            super(taskName, setLocked, permissions, sender);
            this.backup = null;
            this.deleteBackupTask = null;
            this.backup = backup;
        }

        public BackupDeleteTask(Backup backup, boolean setLocked, CommandSender sender) {
            super(taskName, setLocked, BackupDeleteTask.getDeletePermissions(backup), sender);
            this.backup = null;
            this.deleteBackupTask = null;
            this.backup = backup;
        }

        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            try {
                if (this.setLocked) {
                    Backuper.lock(this);
                }
                if (!this.isTaskPrepared) {
                    this.prepareTask();
                }
                if (!this.cancelled) {
                    this.deleteBackupTask.run();
                }
                cachedBackupsSize.get((Object)Backup.this.getStorageType()).invalidate(this.backup.getName());
                if (this.setLocked) {
                    UIUtils.successSound(this.sender);
                    Backuper.unlock();
                }
            }
            catch (Exception e) {
                if (this.setLocked) {
                    UIUtils.cancelSound(this.sender);
                    Backuper.unlock();
                }
                Logger.getLogger().warn("BackupDelete task has been finished with an exception", this.sender);
                Logger.getLogger().warn(this.getClass(), e);
            }
        }

        @Override
        public void prepareTask() {
            if (this.cancelled) {
                return;
            }
            this.deleteBackupTask = this.backup.getDirectDeleteTask(false, this.sender);
            this.deleteBackupTask.prepareTask();
            this.isTaskPrepared = true;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            if (this.deleteBackupTask != null) {
                this.deleteBackupTask.cancel();
            }
        }

        @Override
        public long getTaskMaxProgress() {
            if (!this.isTaskPrepared) {
                return 0L;
            }
            return this.deleteBackupTask.getTaskMaxProgress();
        }

        @Override
        public long getTaskCurrentProgress() {
            if (!this.isTaskPrepared) {
                return 0L;
            }
            return this.deleteBackupTask.getTaskCurrentProgress();
        }
    }
}

