/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.backup;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.backup.FtpBackup;
import ru.dvdishka.backuper.backend.backup.GoogleDriveBackup;
import ru.dvdishka.backuper.backend.backup.SftpBackup;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.tasks.ftp.FtpGetFileFolderTask;
import ru.dvdishka.backuper.backend.tasks.googleDrive.GoogleDriveGetFileFolderTask;
import ru.dvdishka.backuper.backend.tasks.sftp.SftpGetFileFolderTask;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public abstract class ExternalBackup
extends Backup {
    private Task getDirectCopyToLocalTask(boolean setLocked, CommandSender sender) {
        String inProgressName = this.getName() + " in progress";
        if (this.getFileType().equals("(ZIP)")) {
            inProgressName = inProgressName + ".zip";
        }
        File inProgressFile = new File(Config.getInstance().getLocalConfig().getBackupsFolder(), inProgressName);
        Task task = null;
        if (this instanceof FtpBackup) {
            task = new FtpGetFileFolderTask(this.getPath(), inProgressFile, false, setLocked, List.of(Permissions.FTP_COPY_TO_LOCAL), sender);
        }
        if (this instanceof SftpBackup) {
            task = new SftpGetFileFolderTask(this.getPath(), inProgressFile, false, setLocked, List.of(Permissions.SFTP_COPY_TO_LOCAL), sender);
        }
        if (this instanceof GoogleDriveBackup) {
            task = new GoogleDriveGetFileFolderTask(this.getPath(), inProgressFile, false, setLocked, List.of(Permissions.GOOGLE_DRIVE_COPY_TO_LOCAL), sender);
        }
        return task;
    }

    public CopyToLocalTask getCopyToLocalTask(boolean setLocked, CommandSender sender) {
        return new CopyToLocalTask(this, setLocked, sender);
    }

    public class CopyToLocalTask
    extends Task {
        private static final String taskName = "CopyToLocal";
        private ExternalBackup backup;
        private Task copyToLocalTask;

        private static List<Permissions> getPermissions(Backup backup) {
            ArrayList<Permissions> permissions = new ArrayList<Permissions>();
            if (backup instanceof FtpBackup) {
                permissions.add(Permissions.FTP_COPY_TO_LOCAL);
            }
            if (backup instanceof SftpBackup) {
                permissions.add(Permissions.SFTP_COPY_TO_LOCAL);
            }
            if (backup instanceof GoogleDriveBackup) {
                permissions.add(Permissions.GOOGLE_DRIVE_COPY_TO_LOCAL);
            }
            return permissions;
        }

        public CopyToLocalTask(ExternalBackup backup, boolean setLocked, List<Permissions> permissions, CommandSender sender) {
            super(taskName, setLocked, permissions, sender);
            this.backup = null;
            this.copyToLocalTask = null;
            this.backup = backup;
        }

        public CopyToLocalTask(ExternalBackup backup, boolean setLocked, CommandSender sender) {
            super(taskName, setLocked, CopyToLocalTask.getPermissions(backup), sender);
            this.backup = null;
            this.copyToLocalTask = null;
            this.backup = backup;
        }

        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            try {
                if (this.setLocked) {
                    Backuper.lock(this);
                }
                if (!this.isTaskPrepared) {
                    this.prepareTask();
                }
                if (!this.cancelled) {
                    this.copyToLocalTask.run();
                }
                if (!this.cancelled) {
                    String inProgressName = this.backup.getName() + " in progress";
                    if (this.backup.getFileType().equals("(ZIP)")) {
                        inProgressName = inProgressName + ".zip";
                    }
                    File inProgressFile = new File(Config.getInstance().getLocalConfig().getBackupsFolder(), inProgressName);
                    String backupFileName = this.backup.getFileName();
                    if (!inProgressFile.renameTo(new File(Config.getInstance().getLocalConfig().getBackupsFolder(), backupFileName))) {
                        Logger.getLogger().warn("Failed to rename local file: \"" + inProgressFile.getAbsolutePath() + "\" to \"" + new File(Config.getInstance().getLocalConfig().getBackupsFolder(), backupFileName).getAbsolutePath() + "\"", this.sender);
                    }
                }
                if (this.setLocked) {
                    UIUtils.successSound(this.sender);
                    Backuper.unlock();
                }
            }
            catch (Exception e) {
                if (this.setLocked) {
                    UIUtils.cancelSound(this.sender);
                    Backuper.unlock();
                }
                Logger.getLogger().warn("CopyToLocal task has been finished with an exception", this.sender);
                Logger.getLogger().warn(this.getClass(), e);
            }
        }

        @Override
        public void prepareTask() {
            if (this.cancelled) {
                return;
            }
            this.copyToLocalTask = this.backup.getDirectCopyToLocalTask(false, this.sender);
            this.copyToLocalTask.prepareTask();
            this.isTaskPrepared = true;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            if (this.copyToLocalTask != null) {
                this.copyToLocalTask.cancel();
            }
        }

        @Override
        public long getTaskMaxProgress() {
            if (!this.isTaskPrepared) {
                return 0L;
            }
            return this.copyToLocalTask.getTaskMaxProgress();
        }

        @Override
        public long getTaskCurrentProgress() {
            if (!this.isTaskPrepared) {
                return 0L;
            }
            return this.copyToLocalTask.getTaskCurrentProgress();
        }
    }
}

