/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.config;

import java.io.File;
import java.util.HashMap;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.utils.GoogleDriveUtils;

public class GoogleDriveConfig {
    boolean enabled;
    boolean autoBackup;
    File tokenFolder;
    String backupsFolderId;
    boolean createBackuperFolder;
    int backupsNumber;
    long backupsWeight;
    boolean zipArchive;
    int zipCompressionLevel;

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAutoBackup() {
        return this.autoBackup;
    }

    public File getTokenFolder() {
        return this.tokenFolder;
    }

    public String getRawBackupFolderId() {
        return this.backupsFolderId;
    }

    public String getBackupsFolderId() {
        if (!this.createBackuperFolder) {
            return this.backupsFolderId;
        }
        for (com.google.api.services.drive.model.File driveFile : GoogleDriveUtils.ls(this.backupsFolderId, "appProperties has { key='root' and value='true' }", null)) {
            if (!driveFile.getName().equals("Backuper")) continue;
            return driveFile.getId();
        }
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("root", "true");
            return GoogleDriveUtils.createFolder("Backuper", this.backupsFolderId, properties, null);
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to create Backuper folder in Google Drive. Check if Google Drive account is linked");
            Logger.getLogger().warn(this.getClass(), e);
            return null;
        }
    }

    public int getBackupsNumber() {
        return this.backupsNumber;
    }

    public long getBackupsWeight() {
        return this.backupsWeight;
    }

    public boolean isZipArchive() {
        return this.zipArchive;
    }

    public int getZipCompressionLevel() {
        return this.zipCompressionLevel;
    }
}

