/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public abstract class BaseAddLocalDirsToZipTask
extends Task {
    protected static final int FILE_BUFFER_SIZE = 65536;
    protected final List<File> sourceDirsToAdd;
    protected final boolean forceExcludedDirs;
    protected final boolean createRootDirInTargetZIP;

    protected BaseAddLocalDirsToZipTask(String taskName, List<File> sourceDirsToAdd, boolean createRootDirInTargetZIP, boolean forceExcludedDirs, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, setLocked, permission, sender);
        this.sourceDirsToAdd = sourceDirsToAdd;
        this.forceExcludedDirs = forceExcludedDirs;
        this.createRootDirInTargetZIP = createRootDirInTargetZIP;
    }

    @Override
    public void prepareTask() {
        this.isTaskPrepared = true;
        if (!this.forceExcludedDirs) {
            for (File dir : this.sourceDirsToAdd) {
                this.maxProgress += Utils.getFileFolderByteSizeExceptExcluded(dir);
            }
        } else {
            for (File dir : this.sourceDirsToAdd) {
                this.maxProgress += Utils.getFileFolderByteSize(dir);
            }
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    protected void addDirToZip(ZipOutputStream zip, File sourceDir, Path relativeDirPath) {
        block15: {
            if (this.cancelled) {
                return;
            }
            if (!sourceDir.exists()) {
                Logger.getLogger().warn("Directory does not exist: " + sourceDir.getAbsolutePath(), this.sender);
                return;
            }
            boolean excluded = Utils.isExcludedDirectory(sourceDir, this.sender);
            if (excluded && !this.forceExcludedDirs) {
                return;
            }
            try {
                if (!sourceDir.isFile()) break block15;
                try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceDir), 65536);){
                    int read;
                    String relativePath = relativeDirPath.toAbsolutePath().relativize(sourceDir.toPath().toAbsolutePath()).toString();
                    ZipEntry entry = new ZipEntry(relativePath);
                    if (this.isAlreadyCompressed(sourceDir)) {
                        entry.setMethod(0);
                        entry.setSize(sourceDir.length());
                        entry.setCompressedSize(sourceDir.length());
                        entry.setCrc(this.calculateCRC(sourceDir));
                    } else {
                        zip.setLevel(this.getZipCompressionLevel());
                    }
                    zip.putNextEntry(entry);
                    byte[] buffer = new byte[65536];
                    while ((read = bis.read(buffer)) != -1 && !this.cancelled) {
                        zip.write(buffer, 0, read);
                        this.incrementCurrentProgress(read);
                    }
                    zip.closeEntry();
                }
            }
            catch (Exception e) {
                Logger.getLogger().warn("Error adding to ZIP: " + sourceDir.getName(), this.sender);
                Logger.getLogger().warn(this.getClass(), e);
            }
        }
        File[] children = sourceDir.listFiles();
        if (children != null) {
            for (File f : children) {
                if ("session.lock".equals(f.getName())) continue;
                this.addDirToZip(zip, f, relativeDirPath);
            }
        }
    }

    protected boolean isAlreadyCompressed(File file) {
        String name = file.getName().toLowerCase();
        return name.endsWith(".zip") || name.endsWith(".jar") || name.endsWith(".gz") || name.endsWith(".7z") || name.endsWith(".rar") || name.endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".png") || name.endsWith(".mp3") || name.endsWith(".mp4") || name.endsWith(".avi") || name.endsWith(".mkv") || name.endsWith(".webm") || name.endsWith(".webp");
    }

    protected long calculateCRC(File file) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file), 65536);){
            int read;
            CRC32 crc = new CRC32();
            byte[] buffer = new byte[65536];
            while ((read = bis.read(buffer)) != -1) {
                crc.update(buffer, 0, read);
            }
            long l = crc.getValue();
            return l;
        }
    }

    protected abstract int getZipCompressionLevel();
}

