/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.ftp;

import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.common.BaseAddLocalDirsToZipTask;
import ru.dvdishka.backuper.backend.utils.FtpUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class FtpAddLocalDirsToZipTask
extends BaseAddLocalDirsToZipTask {
    private static final String taskName = "FtpAddLocalDirToZip";
    private String targetZipPath;
    private FTPClient ftpClient = null;

    public FtpAddLocalDirsToZipTask(List<File> sourceDirsToAdd, String targetZipPath, boolean createRootDirInTargetZIP, boolean forceExcludedDirs, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, sourceDirsToAdd, createRootDirInTargetZIP, forceExcludedDirs, setLocked, permission, sender);
        this.targetZipPath = targetZipPath;
        this.sender = sender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.setLocked) {
            Backuper.lock(this);
        }
        try {
            Logger.getLogger().devLog("FtpAddLocalDirToZip task has been started");
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            if (!this.cancelled) {
                this.ftpClient = FtpUtils.getClient(this.sender);
                if (this.ftpClient == null) {
                    return;
                }
            }
            OutputStream outputStream = this.ftpClient.storeFileStream(this.targetZipPath);
            ZipOutputStream targetZipOutputStream = new ZipOutputStream(outputStream);
            try {
                for (File sourceDirToAdd : this.sourceDirsToAdd) {
                    if (this.cancelled) {
                        break;
                    }
                    if (this.createRootDirInTargetZIP) {
                        File parent = sourceDirToAdd.getParentFile();
                        parent = parent == null ? new File("") : parent;
                        this.addDirToZip(targetZipOutputStream, sourceDirToAdd, parent.toPath());
                        continue;
                    }
                    this.addDirToZip(targetZipOutputStream, sourceDirToAdd, sourceDirToAdd.toPath());
                }
            }
            catch (Exception e) {
                Logger.getLogger().warn("FtpAddLocalDirToZip task failed", this.sender);
                Logger.getLogger().warn(this.getClass(), e);
                Backuper.unlock();
            }
            finally {
                targetZipOutputStream.finish();
                targetZipOutputStream.close();
                outputStream.close();
                this.ftpClient.disconnect();
            }
            if (this.setLocked) {
                UIUtils.successSound(this.sender);
                Backuper.unlock();
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
            Logger.getLogger().warn("Something went wrong while running FtpAddLocalDirToZip task", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
        finally {
            Logger.getLogger().devLog("FtpAddLocalDirToZip task has been finished");
        }
    }

    @Override
    protected int getZipCompressionLevel() {
        return Config.getInstance().getFtpConfig().getZipCompressionLevel();
    }
}

