/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.ftp;

import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.utils.FtpUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class FtpDeleteDirTask
extends Task {
    private static final String taskName = "FtpDeleteDir";
    private String remoteDirToDelete = "";
    private FTPClient ftp;

    public FtpDeleteDirTask(String remoteDirToDelete, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, setLocked, permission, sender);
        this.remoteDirToDelete = remoteDirToDelete;
    }

    @Override
    public void run() {
        try {
            if (this.setLocked) {
                Backuper.lock(this);
            }
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            Logger.getLogger().devLog("FtpDeleteDir task started");
            if (!this.cancelled) {
                this.ftp = FtpUtils.getClient(this.sender);
                if (this.ftp == null) {
                    return;
                }
            }
            if (!this.cancelled) {
                this.deleteDir(this.remoteDirToDelete);
            }
            if (this.setLocked) {
                Backuper.unlock();
                UIUtils.successSound(this.sender);
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                Backuper.unlock();
                UIUtils.cancelSound(this.sender);
            }
            Logger.getLogger().warn("Something went wrong when trying to execute FtpDeleteDir task", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
        finally {
            try {
                this.ftp.disconnect();
            }
            catch (Exception e) {
                Logger.getLogger().warn(this.getClass(), e);
            }
            Logger.getLogger().devLog("FtpDeleteDir task has been finished");
        }
    }

    @Override
    public void prepareTask() {
        this.isTaskPrepared = true;
        this.maxProgress = FtpUtils.getDirByteSize(this.remoteDirToDelete, this.sender);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    private void deleteDir(String remoteDirToDelete) {
        if (this.cancelled) {
            return;
        }
        try {
            this.ftp.changeWorkingDirectory("");
            FTPFile remoteFile = this.ftp.mlistFile(remoteDirToDelete);
            if (remoteFile.isDirectory()) {
                if (!this.ftp.changeWorkingDirectory(remoteDirToDelete)) {
                    return;
                }
                for (FTPFile file : this.ftp.listFiles()) {
                    if (file.getName().equals(".") || file.getName().equals("..")) continue;
                    this.deleteDir(FtpUtils.resolve(remoteDirToDelete, file.getName()));
                }
                this.ftp.changeWorkingDirectory("");
                this.ftp.removeDirectory(remoteDirToDelete);
            }
            if (remoteFile.isFile()) {
                long fileSize = remoteFile.getSize();
                this.ftp.deleteFile(remoteDirToDelete);
                this.incrementCurrentProgress(fileSize);
            }
        }
        catch (Exception e) {
            Logger.getLogger().warn("Something went while trying to delete FTP(S) directory", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
    }
}

