/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.ftp;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.utils.FtpUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class FtpGetFileFolderTask
extends Task {
    private static String taskName = "FtpGetFileFolder";
    private String remotePathToGet = "";
    private File localTargetPathFile;
    private boolean createRootDirInTargetDir = true;
    private ArrayList<CompletableFuture<Void>> ftpTasks = new ArrayList();
    FTPClient ftp;

    public FtpGetFileFolderTask(String remotePathToGet, File localTargetPathFile, boolean createRootDirInTargetDir, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, setLocked, permission, sender);
        this.remotePathToGet = remotePathToGet;
        this.localTargetPathFile = localTargetPathFile;
        this.createRootDirInTargetDir = createRootDirInTargetDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.setLocked) {
                Backuper.lock(this);
            }
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            Logger.getLogger().devLog("FtpGetFileFolder task has been started");
            if (!this.cancelled) {
                this.ftp = FtpUtils.getClient(this.sender);
                if (this.ftp == null) {
                    return;
                }
            }
            if (this.createRootDirInTargetDir) {
                Object remoteDirName = "";
                for (char c : this.remotePathToGet.toCharArray()) {
                    String symbol = String.valueOf(c);
                    remoteDirName = Objects.equals(symbol, Config.getInstance().getSftpConfig().getPathSeparatorSymbol()) ? "" : (String)remoteDirName + symbol;
                }
                this.localTargetPathFile = this.localTargetPathFile.toPath().resolve((String)remoteDirName).toFile();
            }
            if (!this.cancelled) {
                this.getFileFolder(this.remotePathToGet, this.localTargetPathFile, this.sender);
            }
            if (this.setLocked) {
                Backuper.unlock();
                UIUtils.successSound(this.sender);
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                Backuper.unlock();
                UIUtils.cancelSound(this.sender);
            }
            Logger.getLogger().warn("Something went wrong when trying to download file/folder from FTP(S) server", this.sender);
            Logger.getLogger().warn("FtpGetFileFolderTask:run", e);
        }
        finally {
            try {
                this.ftp.disconnect();
            }
            catch (Exception e) {
                Logger.getLogger().warn(this.getClass(), e);
            }
            Logger.getLogger().devLog("FtpGetFileFolder task has been finished");
        }
    }

    @Override
    public void prepareTask() {
        this.isTaskPrepared = true;
        this.maxProgress = FtpUtils.getDirByteSize(this.remotePathToGet, this.sender);
    }

    private void getFileFolder(String remoteDir, File localDir, CommandSender sender) {
        if (this.cancelled) {
            return;
        }
        try {
            FTPFile currentDir;
            block8: {
                this.ftp.changeWorkingDirectory("");
                currentDir = this.ftp.mlistFile(remoteDir);
                if (currentDir.isFile()) {
                    localDir.createNewFile();
                    CompletableFuture<Void> ftpTask = CompletableFuture.runAsync(() -> {
                        try (FileOutputStream outputStream = new FileOutputStream(localDir);){
                            this.ftp.retrieveFile(remoteDir, outputStream);
                        }
                        catch (Exception e) {
                            Logger.getLogger().devWarn(this.getClass(), "Failed to download file \"" + remoteDir + "\" from FTP(S) server");
                            Logger.getLogger().devWarn("FtpGetFileFolder:getFileFolder", Arrays.toString(e.getStackTrace()));
                        }
                        this.incrementCurrentProgress(currentDir.getSize());
                    });
                    this.ftpTasks.add(ftpTask);
                    try {
                        ftpTask.join();
                    }
                    catch (Exception e) {
                        if (this.cancelled) break block8;
                        Logger.getLogger().warn("Failed to download file \"" + remoteDir + "\" from FTP(S) server", sender);
                        Logger.getLogger().warn(this.getClass(), e);
                    }
                }
            }
            if (currentDir.isDirectory()) {
                this.ftp.mkd(remoteDir);
                localDir.mkdirs();
                this.ftp.changeWorkingDirectory(remoteDir);
                for (FTPFile file : this.ftp.listFiles()) {
                    if (file.getName().equals(".") || file.getName().equals("..")) continue;
                    this.getFileFolder(FtpUtils.resolve(remoteDir, file.getName()), localDir.toPath().resolve(file.getName()).toFile(), sender);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger().warn("Something went wrong when trying to download file/folder from FTP(S) server", sender);
            Logger.getLogger().warn("FtpGetFileFolderTask:getFileFolder", e);
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        for (CompletableFuture<Void> task : this.ftpTasks) {
            task.cancel(true);
        }
    }
}

