/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.googleDrive;

import com.google.api.client.googleapis.media.MediaHttpUploaderProgressListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.common.Scheduler;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.common.BaseAddLocalDirsToZipTask;
import ru.dvdishka.backuper.backend.tasks.googleDrive.GoogleDriveSendFileFolderTask;
import ru.dvdishka.backuper.backend.utils.GoogleDriveUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class GoogleDriveAddLocalDirToZip
extends BaseAddLocalDirsToZipTask {
    private static final String taskName = "GoogleDriveAddLocalDirToZip";
    private static final int STREAM_BUFFER_SIZE = 0x100000;
    private static final int PIPE_BUFFER_SIZE = 0x400000;
    private String parentId;
    private String zipFileName;

    public GoogleDriveAddLocalDirToZip(List<File> sourceDirsToAdd, String parentId, String zipFileName, boolean createRootDirInTargetZIP, boolean forceExcludedDirs, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, sourceDirsToAdd, createRootDirInTargetZIP, forceExcludedDirs, setLocked, permission, sender);
        this.parentId = parentId;
        this.zipFileName = zipFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.setLocked) {
            Backuper.lock(this);
        }
        try (PipedInputStream pipedInputStream = new PipedInputStream(0x400000);
             PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);){
            Logger.getLogger().devLog("GoogleDriveAddLocalDirToZip task has been started");
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            Scheduler.getScheduler().runAsync(Utils.plugin, () -> {
                try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(pipedOutputStream, 0x100000);
                     ZipOutputStream targetZipOutputStream = new ZipOutputStream(bufferedOutputStream);){
                    for (File sourceDirToAdd : this.sourceDirsToAdd) {
                        if (this.cancelled) {
                            break;
                        }
                        if (this.createRootDirInTargetZIP) {
                            File parent = sourceDirToAdd.getParentFile();
                            parent = parent == null ? new File("") : parent;
                            this.addDirToZip(targetZipOutputStream, sourceDirToAdd, parent.toPath());
                            continue;
                        }
                        this.addDirToZip(targetZipOutputStream, sourceDirToAdd, sourceDirToAdd.toPath());
                    }
                }
                catch (Exception e) {
                    Logger.getLogger().warn("GoogleDriveAddLocalDirToZip task failed", this.sender);
                    Logger.getLogger().warn(this.getClass(), e);
                    Backuper.unlock();
                }
            });
            GoogleDriveSendFileFolderTask.GoogleDriveUploadProgressListener progressListener = new GoogleDriveSendFileFolderTask.GoogleDriveUploadProgressListener();
            GoogleDriveUtils.uploadFile(pipedInputStream, this.zipFileName, this.parentId, (MediaHttpUploaderProgressListener)progressListener, this.sender);
            if (this.setLocked) {
                UIUtils.successSound(this.sender);
                Backuper.unlock();
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
            Logger.getLogger().warn("Something went wrong while running GoogleDriveAddLocalDirToZip task", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
        finally {
            Logger.getLogger().devLog("GoogleDriveAddLocalDirToZip task has been finished");
        }
    }

    @Override
    protected int getZipCompressionLevel() {
        return Config.getInstance().getLocalConfig().getZipCompressionLevel();
    }
}

