/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.googleDrive;

import com.google.api.services.drive.model.File;
import java.util.List;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.utils.GoogleDriveUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class GoogleDriveDeleteFileFolderTask
extends Task {
    private static final String taskName = "GoogleDriveDeleteFileFolder";
    private final String driveFileId;

    public GoogleDriveDeleteFileFolderTask(String driveFileId, boolean setLocked, List<Permissions> permissions, CommandSender sender) {
        super(taskName, setLocked, permissions, sender);
        this.driveFileId = driveFileId;
    }

    @Override
    public void run() {
        try {
            if (this.setLocked) {
                Backuper.lock(this);
            }
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            Logger.getLogger().devLog("GoogleDriveDeleteFileFolder task started");
            if (!this.cancelled) {
                this.deleteDir(this.driveFileId);
            }
            if (this.setLocked) {
                Backuper.unlock();
                UIUtils.successSound(this.sender);
            }
            Logger.getLogger().devLog("GoogleDriveDeleteFileFolder task completed");
        }
        catch (Exception e) {
            if (this.setLocked) {
                Backuper.unlock();
                UIUtils.cancelSound(this.sender);
            }
            Logger.getLogger().warn("Something went wrong when trying to execute GoogleDriveDeleteFileFolder task", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
    }

    @Override
    public void prepareTask() {
        this.isTaskPrepared = true;
        this.maxProgress = GoogleDriveUtils.getFileByteSize(this.driveFileId, this.sender);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    private void deleteDir(String currentDriveFileId) {
        if (this.cancelled) {
            return;
        }
        try {
            if (GoogleDriveUtils.isFolder(currentDriveFileId, this.sender)) {
                for (File file : GoogleDriveUtils.ls(currentDriveFileId, this.sender)) {
                    this.deleteDir(file.getId());
                }
                GoogleDriveUtils.deleteFile(currentDriveFileId, this.sender);
            } else {
                long fileSize = GoogleDriveUtils.getFileByteSize(currentDriveFileId, this.sender);
                GoogleDriveUtils.deleteFile(currentDriveFileId, this.sender);
                this.incrementCurrentProgress(fileSize);
            }
        }
        catch (Exception e) {
            Logger.getLogger().warn("Something went while trying to delete file from Google Drive", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
    }
}

